/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.LightColors;
import com.intellij.ui.NewUiValue;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.border.NamedBorderKt;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JBUI {
    public static float pixScale() {
        return JreHiDpiUtil.isJreHiDPIEnabled() ? JBUIScale.sysScale() * JBUIScale.scale(1.0f) : JBUIScale.scale(1.0f);
    }

    public static float pixScale(float f) {
        return JBUI.pixScale() * f;
    }

    public static float pixScale(@Nullable GraphicsConfiguration gc) {
        return JBUIScale.pixScale(gc);
    }

    public static float pixScale(@Nullable Component component) {
        return JBUI.pixScale(component == null ? null : component.getGraphicsConfiguration());
    }

    @Deprecated
    public static float scale(float f) {
        return JBUIScale.scale(f);
    }

    public static int scale(int i) {
        return JBUIScale.scale(i);
    }

    public static int unscale(int i) {
        return Math.round((float)i / JBUIScale.scale(1.0f));
    }

    public static int scaleFontSize(float fontSize) {
        return JBUIScale.scaleFontSize(fontSize);
    }

    @NotNull
    public static JBValue value(float value) {
        return new JBValue.Float(value);
    }

    @NotNull
    public static JBValue uiIntValue(@NotNull String key, int defValue) {
        if (key == null) {
            JBUI.$$$reportNull$$$0(0);
        }
        return new JBValue.UIInteger(key, defValue);
    }

    @NotNull
    public static JBDimension size(int width, int height) {
        return new JBDimension(width, height);
    }

    @NotNull
    public static JBDimension size(int widthAndHeight) {
        return new JBDimension(widthAndHeight, widthAndHeight);
    }

    @NotNull
    public static JBDimension size(Dimension size) {
        JBDimension jBDimension = JBDimension.size(size);
        if (jBDimension == null) {
            JBUI.$$$reportNull$$$0(1);
        }
        return jBDimension;
    }

    @NotNull
    public static JBDimension size(@NonNls @NotNull String propName, @NotNull JBDimension defaultValue) {
        Dimension d;
        if (propName == null) {
            JBUI.$$$reportNull$$$0(2);
        }
        if (defaultValue == null) {
            JBUI.$$$reportNull$$$0(3);
        }
        JBDimension jBDimension = (d = UIManager.getDimension(propName)) != null ? JBDimension.size(d) : defaultValue;
        if (jBDimension == null) {
            JBUI.$$$reportNull$$$0(4);
        }
        return jBDimension;
    }

    @NotNull
    public static JBInsets insets(int top, int left, int bottom, int right) {
        return new JBInsets(top, left, bottom, right);
    }

    @NotNull
    public static JBInsets insets(int all) {
        return new JBInsets(all);
    }

    @NotNull
    public static JBInsets insets(@NonNls @NotNull String propName, @NotNull JBInsets defaultValue) {
        if (propName == null) {
            JBUI.$$$reportNull$$$0(5);
        }
        if (defaultValue == null) {
            JBUI.$$$reportNull$$$0(6);
        }
        JBInsets jBInsets = JBInsets.create(propName, (Insets)defaultValue);
        if (jBInsets == null) {
            JBUI.$$$reportNull$$$0(7);
        }
        return jBInsets;
    }

    @NotNull
    public static JBInsets insets(int topBottom, int leftRight) {
        JBInsets jBInsets = JBInsets.create(topBottom, leftRight);
        if (jBInsets == null) {
            JBUI.$$$reportNull$$$0(8);
        }
        return jBInsets;
    }

    @NotNull
    public static JBInsets emptyInsets() {
        JBInsets jBInsets = JBInsets.emptyInsets();
        if (jBInsets == null) {
            JBUI.$$$reportNull$$$0(9);
        }
        return jBInsets;
    }

    @NotNull
    public static JBInsets insetsTop(int t) {
        return new JBInsets(t, 0, 0, 0);
    }

    @NotNull
    public static JBInsets insetsLeft(int l) {
        return new JBInsets(0, l, 0, 0);
    }

    @NotNull
    public static JBInsets insetsBottom(int b) {
        return new JBInsets(0, 0, b, 0);
    }

    @NotNull
    public static JBInsets insetsRight(int r) {
        return new JBInsets(0, 0, 0, r);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static <T extends JBScalableIcon> T scale(@NotNull T icon) {
        if (icon == null) {
            JBUI.$$$reportNull$$$0(10);
        }
        T t = JBUIScale.scaleIcon(icon);
        if (t == null) {
            JBUI.$$$reportNull$$$0(11);
        }
        return t;
    }

    @NotNull
    public static JBDimension emptySize() {
        return new JBDimension(0, 0);
    }

    @NotNull
    public static JBInsets insets(@NotNull Insets insets) {
        if (insets == null) {
            JBUI.$$$reportNull$$$0(12);
        }
        JBInsets jBInsets = JBInsets.create(insets);
        if (jBInsets == null) {
            JBUI.$$$reportNull$$$0(13);
        }
        return jBInsets;
    }

    @Deprecated(forRemoval=true)
    public static boolean isUsrHiDPI() {
        return JBUIScale.isUsrHiDPI();
    }

    public static boolean isPixHiDPI(@Nullable GraphicsConfiguration gc) {
        return JBUIScale.isHiDPI(JBUI.pixScale(gc));
    }

    public static boolean isPixHiDPI(@Nullable Component comp) {
        return JBUIScale.isHiDPI(JBUI.pixScale(comp));
    }

    public static Border asUIResource(@NotNull Border border) {
        if (border == null) {
            JBUI.$$$reportNull$$$0(14);
        }
        if (border instanceof UIResource) {
            return border;
        }
        return new BorderUIResource(border);
    }

    public static int getInt(@NonNls @NotNull String propertyName, int defaultValue) {
        Object value;
        if (propertyName == null) {
            JBUI.$$$reportNull$$$0(15);
        }
        return (value = UIManager.get(propertyName)) instanceof Integer ? (Integer)value : defaultValue;
    }

    public static float getFloat(@NonNls @NotNull String propertyName, float defaultValue) {
        Object value;
        if (propertyName == null) {
            JBUI.$$$reportNull$$$0(16);
        }
        if ((value = UIManager.get(propertyName)) instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof Double) {
            return ((Double)value).floatValue();
        }
        if (value instanceof String) {
            try {
                return Float.parseFloat((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @NotNull
    private static Icon getIcon(@NonNls @NotNull String propertyName, @NotNull Icon defaultIcon) {
        Icon icon;
        if (propertyName == null) {
            JBUI.$$$reportNull$$$0(17);
        }
        if (defaultIcon == null) {
            JBUI.$$$reportNull$$$0(18);
        }
        Icon icon2 = (icon = UIManager.getIcon(propertyName)) == null ? defaultIcon : icon;
        if (icon2 == null) {
            JBUI.$$$reportNull$$$0(19);
        }
        return icon2;
    }

    @Nullable
    private static Font getFont(@NonNls @NotNull String propertyName) {
        if (propertyName == null) {
            JBUI.$$$reportNull$$$0(20);
        }
        return JBUI.maybeConvertToFont(UIManager.get(propertyName));
    }

    @NotNull
    private static Font getFontWithSizeOffset(@NonNls @NotNull String propertyName, @NotNull JBFont baseFont) {
        if (propertyName == null) {
            JBUI.$$$reportNull$$$0(21);
        }
        if (baseFont == null) {
            JBUI.$$$reportNull$$$0(22);
        }
        JBFont jBFont = baseFont.biggerOn(JBUI.getInt(propertyName, 0));
        if (jBFont == null) {
            JBUI.$$$reportNull$$$0(23);
        }
        return jBFont;
    }

    @Nullable
    private static Font maybeConvertToFont(Object maybeFont) {
        if (maybeFont instanceof Font) {
            Font font = (Font)maybeFont;
            return font;
        }
        if (maybeFont instanceof Supplier) {
            Supplier supplier = (Supplier)maybeFont;
            return JBUI.maybeConvertToFont(supplier.get());
        }
        return null;
    }

    private static boolean isNewUI() {
        return NewUiValue.isEnabled();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 7, 8, 9, 11, 13, 19, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/JBUI";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propName";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "border";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultIcon";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFont";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/JBUI";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "size";
                break;
            }
            case 7: 
            case 8: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "insets";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyInsets";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "scale";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontWithSizeOffset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "uiIntValue";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 19: 
            case 23: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "size";
                break;
            }
            case 5: 
            case 6: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "insets";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "scale";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "asUIResource";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getInt";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFloat";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getFont";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getFontWithSizeOffset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 7, 8, 9, 11, 13, 19, 23 -> new IllegalStateException(string);
        };
    }

    public static final class DialogSizes {
        @NotNull
        public static Dimension small() {
            JBDimension jBDimension = JBUI.size(350, 250);
            if (jBDimension == null) {
                DialogSizes.$$$reportNull$$$0(0);
            }
            return jBDimension;
        }

        @NotNull
        public static Dimension medium() {
            JBDimension jBDimension = JBUI.size(500, 350);
            if (jBDimension == null) {
                DialogSizes.$$$reportNull$$$0(1);
            }
            return jBDimension;
        }

        @NotNull
        public static Dimension large() {
            JBDimension jBDimension = JBUI.size(750, 525);
            if (jBDimension == null) {
                DialogSizes.$$$reportNull$$$0(2);
            }
            return jBDimension;
        }

        @NotNull
        public static Dimension extraLarge() {
            JBDimension jBDimension = JBUI.size(1000, 700);
            if (jBDimension == null) {
                DialogSizes.$$$reportNull$$$0(3);
            }
            return jBDimension;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/util/ui/JBUI$DialogSizes";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "small";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "medium";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "large";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "extraLarge";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static final class CurrentTheme {
        private static final Color DEFAULT_RENDERER_BACKGROUND = new JBColor(0xFFFFFF, 3948353);
        private static final Color DEFAULT_RENDERER_SELECTION_BACKGROUND = new JBColor(3700182, 3106250);
        private static final Color DEFAULT_RENDERER_SELECTION_INACTIVE_BACKGROUND = new JBColor(0xD4D4D4, 862526);
        private static final Color DEFAULT_RENDERER_HOVER_BACKGROUND = new JBColor(15595004, 4606541);
        private static final Color DEFAULT_RENDERER_HOVER_INACTIVE_BACKGROUND = new JBColor(0xF5F5F5, 4606541);
        private static final Color CLEAR = new Color(0, true);

        @ApiStatus.Internal
        public static final class LicenseDialog {
            @NotNull
            private static final Color TERMS_AND_CONDITIONS_COLOR = JBColor.namedColor("LicenseDialog.termsAndConditionsForeground", 8488340, 7304058);
            @NotNull
            private static final Color WAITING_LABEL_COLOR = JBColor.namedColor("LicenseDialog.waitingLabelForeground", 8488340, 7304058);
            @NotNull
            private static final Color SEPARATOR_COLOR = JBColor.namedColor("LicenseDialog.separatorColor", 15461616, 3750720);
            @NotNull
            private static final Color FREE_BADGE_FOREGROUND = JBColor.namedColor("LicenseDialog.freeBadgeForeground", 0xFFFFFF, 1974050);
            @NotNull
            private static final Color FREE_BADGE_BACKGROUND = JBColor.namedColor("LicenseDialog.freeBadgeBackground", 2132540, 5740124);

            @NotNull
            public static Color getTermsAndConditionsForeground() {
                Color color = TERMS_AND_CONDITIONS_COLOR;
                if (color == null) {
                    LicenseDialog.$$$reportNull$$$0(0);
                }
                return color;
            }

            @NotNull
            public static Color getWaitingLabelColor() {
                Color color = WAITING_LABEL_COLOR;
                if (color == null) {
                    LicenseDialog.$$$reportNull$$$0(1);
                }
                return color;
            }

            @NotNull
            public static Color getSeparatorColor() {
                Color color = SEPARATOR_COLOR;
                if (color == null) {
                    LicenseDialog.$$$reportNull$$$0(2);
                }
                return color;
            }

            @NotNull
            public static Color getFreeBadgeForeground() {
                Color color = FREE_BADGE_FOREGROUND;
                if (color == null) {
                    LicenseDialog.$$$reportNull$$$0(3);
                }
                return color;
            }

            @NotNull
            public static Color getFreeBadgeBackground() {
                Color color = FREE_BADGE_BACKGROUND;
                if (color == null) {
                    LicenseDialog.$$$reportNull$$$0(4);
                }
                return color;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$LicenseDialog";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTermsAndConditionsForeground";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getWaitingLabelColor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSeparatorColor";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFreeBadgeForeground";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFreeBadgeBackground";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }

            public static final class LicenseServer {
                @NotNull
                private static final Color SEPARATOR_COLOR = JBColor.namedColor("LicenseDialog.LicenseServer.separatorColor", 13882843, 4408650);

                @NotNull
                public static Color getSeparatorColor() {
                    Color color = SEPARATOR_COLOR;
                    if (color == null) {
                        LicenseServer.$$$reportNull$$$0(0);
                    }
                    return color;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/JBUI$CurrentTheme$LicenseDialog$LicenseServer", "getSeparatorColor"));
                }
            }

            public static final class LicenseList {
                @NotNull
                private static final Color LICENSE_DETAILS_COLOR = JBColor.namedColor("LicenseDialog.LicenseList.licenseDetailsForeground", 13225174, 10330280);
                @NotNull
                private static final Color LICENSE_ID_COLOR = JBColor.namedColor("LicenseDialog.LicenseList.licenseIdForeground", 13882843, 4408650);
                @NotNull
                private static final Color SEPARATOR_COLOR = JBColor.namedColor("LicenseDialog.LicenseList.separatorColor", 13882843, 4408650);

                @NotNull
                public static Color getLicenseDetailsColor() {
                    Color color = LICENSE_DETAILS_COLOR;
                    if (color == null) {
                        LicenseList.$$$reportNull$$$0(0);
                    }
                    return color;
                }

                @NotNull
                public static Color getLicenseIdColor() {
                    Color color = LICENSE_ID_COLOR;
                    if (color == null) {
                        LicenseList.$$$reportNull$$$0(1);
                    }
                    return color;
                }

                @NotNull
                public static Color getSeparatorColor() {
                    Color color = SEPARATOR_COLOR;
                    if (color == null) {
                        LicenseList.$$$reportNull$$$0(2);
                    }
                    return color;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$LicenseDialog$LicenseList";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getLicenseDetailsColor";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getLicenseIdColor";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getSeparatorColor";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            }
        }

        public static final class ManagedIde {
            public static final Color BADGE_BORDER = JBColor.namedColor("ManagedIdeBadgeBorder", CustomFrameDecorations.separatorForeground());
            private static final Color BADGE_BACKGROUND = JBColor.namedColor("ManagedIdeBadgeBackground", CustomFrameDecorations.paneBackground());
            private static final Color BADGE_BACKGROUND_HOVER = JBColor.namedColor("ManagedIdeBadgeBackgroundHover", JBColor.namedColor("MainToolbar.Dropdown.transparentHoverBackground", UIManager.getColor("MainToolbar.Icon.hoverBackground")));
            public static final Color MENU_ITEM_HOVER = JBColor.namedColor("ManagedIdeMenuItemHover", 15461616, 4408650);

            @NotNull
            public static Color getBadgeBackground(boolean hover) {
                Color color = hover ? BADGE_BACKGROUND_HOVER : BADGE_BACKGROUND;
                if (color == null) {
                    ManagedIde.$$$reportNull$$$0(0);
                }
                return color;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/JBUI$CurrentTheme$ManagedIde", "getBadgeBackground"));
            }
        }

        public static final class MainWindow {

            public static final class Tab {
                private static final Color SELECTED_FOREGROUND = JBColor.namedColor("MainWindow.Tab.selectedForeground", 13225174, 13553878);
                private static final Color SELECTED_BACKGROUND = JBColor.namedColor("MainWindow.Tab.selectedBackground", 2566190, 2829616);
                private static final Color SELECTED_INACTIVE_BACKGROUND = JBColor.namedColor("MainWindow.Tab.selectedInactiveBackground", 3684930, 3750720);
                private static final Color FOREGROUND = JBColor.namedColor("MainWindow.Tab.foreground", 11054525, 11843775);
                private static final Color BACKGROUND = JBColor.namedColor("MainWindow.Tab.background", 0, 0x131314);
                private static final Color HOVER_FOREGROUND = JBColor.namedColor("MainWindow.Tab.hoverForeground", 13225174, 13553878);
                private static final Color HOVER_BACKGROUND = JBColor.namedColor("MainWindow.Tab.hoverBackground", 0x171717, 0x1A1A1B);
                public static final Color SEPARATOR = JBColor.namedColor("MainWindow.Tab.separatorColor", 3684930, 2829616);
                public static final Color BORDER = JBColor.namedColor("MainWindow.Tab.borderColor", 3684930, 1974050);

                @NotNull
                public static Color foreground(boolean selection, boolean hovered) {
                    if (selection) {
                        Color color = SELECTED_FOREGROUND;
                        if (color == null) {
                            Tab.$$$reportNull$$$0(0);
                        }
                        return color;
                    }
                    Color color = hovered ? HOVER_FOREGROUND : FOREGROUND;
                    if (color == null) {
                        Tab.$$$reportNull$$$0(1);
                    }
                    return color;
                }

                @NotNull
                public static Color background(boolean selection, boolean inactive, boolean hovered) {
                    if (selection) {
                        Color color = inactive ? SELECTED_INACTIVE_BACKGROUND : SELECTED_BACKGROUND;
                        if (color == null) {
                            Tab.$$$reportNull$$$0(2);
                        }
                        return color;
                    }
                    Color color = hovered ? HOVER_BACKGROUND : BACKGROUND;
                    if (color == null) {
                        Tab.$$$reportNull$$$0(3);
                    }
                    return color;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$MainWindow$Tab";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "foreground";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "background";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            }
        }

        public static final class TrialWidget {

            public static final class Progress {
                public static final Color FOREGROUND = JBColor.namedColor("TrialWidget.Progress.foreground");
                public static final Color BACKGROUND = JBColor.namedColor("TrialWidget.Progress.background");
                public static final Color BORDER_COLOR = JBColor.namedColor("TrialWidget.Progress.borderColor");
                public static final Color HOVER_FOREGROUND = JBColor.namedColor("TrialWidget.Progress.hoverForeground");
                public static final Color HOVER_BACKGROUND = JBColor.namedColor("TrialWidget.Progress.hoverBackground");
                public static final Color HOVER_BORDER_COLOR = JBColor.namedColor("TrialWidget.Progress.hoverBorderColor");
            }

            public static final class Expiring {
                public static final Color FOREGROUND = JBColor.namedColor("TrialWidget.Expiring.foreground");
                public static final Color BACKGROUND = JBColor.namedColor("TrialWidget.Expiring.background");
                public static final Color BORDER_COLOR = JBColor.namedColor("TrialWidget.Expiring.borderColor");
                public static final Color HOVER_FOREGROUND = JBColor.namedColor("TrialWidget.Expiring.hoverForeground");
                public static final Color HOVER_BACKGROUND = JBColor.namedColor("TrialWidget.Expiring.hoverBackground");
                public static final Color HOVER_BORDER_COLOR = JBColor.namedColor("TrialWidget.Expiring.hoverBorderColor");
            }

            public static final class Alert {
                public static final Color FOREGROUND = JBColor.namedColor("TrialWidget.Alert.foreground");
                public static final Color BACKGROUND = JBColor.namedColor("TrialWidget.Alert.background");
                public static final Color BORDER_COLOR = JBColor.namedColor("TrialWidget.Alert.borderColor");
                public static final Color HOVER_FOREGROUND = JBColor.namedColor("TrialWidget.Alert.hoverForeground");
                public static final Color HOVER_BACKGROUND = JBColor.namedColor("TrialWidget.Alert.hoverBackground");
                public static final Color HOVER_BORDER_COLOR = JBColor.namedColor("TrialWidget.Alert.hoverBorderColor");
            }

            public static final class Active {
                public static final Color FOREGROUND = JBColor.namedColor("TrialWidget.Active.foreground");
                public static final Color BACKGROUND = JBColor.namedColor("TrialWidget.Active.background");
                public static final Color BORDER_COLOR = JBColor.namedColor("TrialWidget.Active.borderColor");
                public static final Color HOVER_FOREGROUND = JBColor.namedColor("TrialWidget.Active.hoverForeground");
                public static final Color HOVER_BACKGROUND = JBColor.namedColor("TrialWidget.Active.hoverBackground");
                public static final Color HOVER_BORDER_COLOR = JBColor.namedColor("TrialWidget.Active.hoverBorderColor");
            }

            public static final class Default {
                public static final Color FOREGROUND = JBColor.namedColor("TrialWidget.Default.foreground");
                public static final Color BACKGROUND = JBColor.namedColor("TrialWidget.Default.background");
                public static final Color BORDER_COLOR = JBColor.namedColor("TrialWidget.Default.borderColor");
                public static final Color HOVER_FOREGROUND = JBColor.namedColor("TrialWidget.Default.hoverForeground");
                public static final Color HOVER_BACKGROUND = JBColor.namedColor("TrialWidget.Default.hoverBackground");
                public static final Color HOVER_BORDER_COLOR = JBColor.namedColor("TrialWidget.Default.hoverBorderColor");
            }
        }

        public static final class TitlePane {
            @NotNull
            public static Dimension buttonPreferredSize(float scaleDefaultValues) {
                JBDimension jBDimension = JBUI.size(TitlePane.buttonPreferredSizeKey(), JBUI.size((int)(47.0f * scaleDefaultValues), (int)(28.0f * scaleDefaultValues)));
                if (jBDimension == null) {
                    TitlePane.$$$reportNull$$$0(0);
                }
                return jBDimension;
            }

            @NotNull
            public static String buttonPreferredSizeKey() {
                return "TitlePane.Button.preferredSize";
            }

            public static int dialogButtonPreferredWidth() {
                return JBUI.getInt("TitlePane.Dialog.Button.preferredWidth", 40);
            }

            @NotNull
            public static Insets dialogButtonInsets() {
                JBInsets jBInsets = JBUI.insets("TitlePane.Dialog.Button.insets", JBInsets.emptyInsets());
                if (jBInsets == null) {
                    TitlePane.$$$reportNull$$$0(1);
                }
                return jBInsets;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$TitlePane";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buttonPreferredSize";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "dialogButtonInsets";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class RunWidget {
            public static final Color FOREGROUND = JBColor.namedColor("RunWidget.foreground", Color.WHITE);
            public static final Color ICON_COLOR = JBColor.namedColor("RunWidget.iconColor", Color.WHITE);
            public static final Color RUN_ICON_COLOR = JBColor.namedColor("RunWidget.runIconColor", new Color(6270309));
            public static final Color RUNNING_BACKGROUND = JBColor.namedColor("RunWidget.runningBackground", 0x599E5E);
            public static final Color RUNNING_ICON_COLOR = JBColor.namedColor("RunWidget.runningIconColor", Color.WHITE);
            public static final Color STOP_BACKGROUND = JBColor.namedColor("RunWidget.stopBackground", new Color(13193039));
            public static final Color HOVER_BACKGROUND = JBColor.namedColor("RunWidget.hoverBackground", new Color(0, 0, 0, 25));
            public static final Color PRESSED_BACKGROUND = JBColor.namedColor("RunWidget.pressedBackground", new Color(0, 0, 0, 40));

            public static int toolbarHeight() {
                return JBUI.getInt(RunWidget.toolbarHeightKey(), RunWidget.defaultToolbarHeight());
            }

            @NotNull
            public static String toolbarHeightKey() {
                return "RunWidget.toolbarHeight";
            }

            public static int defaultToolbarHeight() {
                return 30;
            }

            public static int toolbarBorderHeight() {
                return JBUI.getInt(RunWidget.toolbarBorderHeightKey(), RunWidget.defaultToolbarBorderHeight());
            }

            @NotNull
            public static String toolbarBorderHeightKey() {
                return "RunWidget.toolbarBorderHeight";
            }

            public static int defaultToolbarBorderHeight() {
                return 5;
            }

            public static int toolbarBorderDirectionalGap() {
                return JBUI.getInt(RunWidget.toolbarBorderDirectionalGapKey(), RunWidget.defaultToolbarBorderDirectionalGap());
            }

            @NotNull
            public static String toolbarBorderDirectionalGapKey() {
                return "RunWidget.toolbarBorderDirectionalGap";
            }

            public static int defaultToolbarBorderDirectionalGap() {
                return 2;
            }

            public static int actionButtonWidth() {
                return JBUI.getInt(RunWidget.actionButtonWidthKey(), 30);
            }

            @NotNull
            public static String actionButtonWidthKey() {
                return "RunWidget.actionButtonWidth";
            }

            public static Font configurationSelectorFont() {
                return JBUI.getFontWithSizeOffset(RunWidget.configurationSelectorFontSizeOffsetKey(), RunWidget.defaultConfigurationSelectorFont());
            }

            @NotNull
            public static String configurationSelectorFontSizeOffsetKey() {
                return "RunWidget.configurationSelectorFontSizeOffset";
            }

            public static JBFont defaultConfigurationSelectorFont() {
                return JBFont.label();
            }
        }

        public static interface Tree {
            public static final Color BACKGROUND = JBColor.namedColor("Tree.background", DEFAULT_RENDERER_BACKGROUND);
            public static final Color FOREGROUND = JBColor.namedColor("Tree.foreground", Label.foreground(false));
            public static final JBValue ARC = new JBValue.UIInteger("Tree.Selection.arc", 8);

            @NotNull
            public static Color background(boolean selected, boolean focused) {
                Color color = selected ? Selection.background(focused) : BACKGROUND;
                if (color == null) {
                    Tree.$$$reportNull$$$0(0);
                }
                return color;
            }

            @NotNull
            public static Color foreground(boolean selected, boolean focused) {
                Color color = selected ? Selection.foreground(focused) : FOREGROUND;
                if (color == null) {
                    Tree.$$$reportNull$$$0(1);
                }
                return color;
            }

            public static int rowHeight() {
                int defaultHeight = Tree.defaultRowHeight();
                int result = JBUI.getInt(Tree.rowHeightKey(), defaultHeight);
                return result <= 0 ? defaultHeight : result;
            }

            @NotNull
            public static String rowHeightKey() {
                return "Tree.rowHeight";
            }

            public static int defaultRowHeight() {
                return JBUIScale.scale(24);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$Tree";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "background";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "foreground";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }

            public static final class Selection {
                private static final Color BACKGROUND = JBColor.namedColor("Tree.selectionBackground", DEFAULT_RENDERER_SELECTION_BACKGROUND);
                private static final Color FOREGROUND = JBColor.namedColor("Tree.selectionForeground", Label.foreground(true));

                @NotNull
                public static Color background(boolean focused) {
                    Color color = focused ? BACKGROUND : Inactive.BACKGROUND;
                    if (color == null) {
                        Selection.$$$reportNull$$$0(0);
                    }
                    return color;
                }

                @NotNull
                public static Color foreground(boolean focused) {
                    Color color = focused ? FOREGROUND : Inactive.FOREGROUND;
                    if (color == null) {
                        Selection.$$$reportNull$$$0(1);
                    }
                    return color;
                }

                public static boolean forceFocusedSelectionForeground() {
                    return UIManager.getBoolean("Tree.forceFocusedSelectionForeground");
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$Tree$Selection";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "background";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "foreground";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }

                private static interface Inactive {
                    public static final Color BACKGROUND = JBColor.namedColor("Tree.selectionInactiveBackground", DEFAULT_RENDERER_SELECTION_INACTIVE_BACKGROUND);
                    public static final Color FOREGROUND = JBColor.namedColor("Tree.selectionInactiveForeground", Tree.FOREGROUND);
                }
            }

            public static final class Hover {
                private static final Color BACKGROUND = JBColor.namedColor("Tree.hoverBackground", DEFAULT_RENDERER_HOVER_BACKGROUND);

                @NotNull
                public static Color background(boolean focused) {
                    Color color = focused ? BACKGROUND : Inactive.BACKGROUND;
                    if (color == null) {
                        Hover.$$$reportNull$$$0(0);
                    }
                    return color;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/JBUI$CurrentTheme$Tree$Hover", "background"));
                }

                private static interface Inactive {
                    public static final Color BACKGROUND = JBColor.namedColor("Tree.hoverInactiveBackground", DEFAULT_RENDERER_HOVER_INACTIVE_BACKGROUND);
                }
            }
        }

        public static interface Table {
            public static final Color BACKGROUND = JBColor.namedColor("Table.background", DEFAULT_RENDERER_BACKGROUND);
            public static final Color FOREGROUND = JBColor.namedColor("Table.foreground", Label.foreground(false));

            @NotNull
            public static Color background(boolean selected, boolean focused) {
                Color color = selected ? Selection.background(focused) : BACKGROUND;
                if (color == null) {
                    Table.$$$reportNull$$$0(0);
                }
                return color;
            }

            @NotNull
            public static Color foreground(boolean selected, boolean focused) {
                Color color = selected ? Selection.foreground(focused) : FOREGROUND;
                if (color == null) {
                    Table.$$$reportNull$$$0(1);
                }
                return color;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$Table";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "background";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "foreground";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }

            public static final class Selection {
                private static final Color BACKGROUND = JBColor.namedColor("Table.selectionBackground", DEFAULT_RENDERER_SELECTION_BACKGROUND);
                private static final Color FOREGROUND = JBColor.namedColor("Table.selectionForeground", Label.foreground(true));

                @NotNull
                public static Color background(boolean focused) {
                    Color color = focused ? BACKGROUND : Inactive.BACKGROUND;
                    if (color == null) {
                        Selection.$$$reportNull$$$0(0);
                    }
                    return color;
                }

                @NotNull
                public static Color foreground(boolean focused) {
                    Color color = focused ? FOREGROUND : Inactive.FOREGROUND;
                    if (color == null) {
                        Selection.$$$reportNull$$$0(1);
                    }
                    return color;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$Table$Selection";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "background";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "foreground";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }

                private static interface Inactive {
                    public static final Color BACKGROUND = JBColor.namedColor("Table.selectionInactiveBackground", DEFAULT_RENDERER_SELECTION_INACTIVE_BACKGROUND);
                    public static final Color FOREGROUND = JBColor.namedColor("Table.selectionInactiveForeground", Table.FOREGROUND);
                }
            }

            public static final class Hover {
                private static final Color BACKGROUND = JBColor.namedColor("Table.hoverBackground", DEFAULT_RENDERER_HOVER_BACKGROUND);

                @NotNull
                public static Color background(boolean focused) {
                    Color color = focused ? BACKGROUND : Inactive.BACKGROUND;
                    if (color == null) {
                        Hover.$$$reportNull$$$0(0);
                    }
                    return color;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/JBUI$CurrentTheme$Table$Hover", "background"));
                }

                private static interface Inactive {
                    public static final Color BACKGROUND = JBColor.namedColor("Table.hoverInactiveBackground", DEFAULT_RENDERER_HOVER_INACTIVE_BACKGROUND);
                }
            }
        }

        public static interface List {
            public static final Color BACKGROUND = JBColor.namedColor("List.background", DEFAULT_RENDERER_BACKGROUND);
            public static final Color FOREGROUND = JBColor.namedColor("List.foreground", Label.foreground(false));

            @NotNull
            public static Color background(boolean selected, boolean focused) {
                Color color = selected ? Selection.background(focused) : BACKGROUND;
                if (color == null) {
                    List.$$$reportNull$$$0(0);
                }
                return color;
            }

            @NotNull
            public static Color foreground(boolean selected, boolean focused) {
                Color color = selected ? Selection.foreground(focused) : FOREGROUND;
                if (color == null) {
                    List.$$$reportNull$$$0(1);
                }
                return color;
            }

            public static int rowHeight() {
                int defaultHeight = JBUIScale.scale(24);
                int result = JBUI.getInt("List.rowHeight", defaultHeight);
                return result <= 0 ? defaultHeight : result;
            }

            public static int buttonLeftRightInsets() {
                return JBUI.getInt("List.Button.leftRightInset", 8);
            }

            public static Color buttonHoverBackground() {
                return JBColor.namedColor("List.Button.hoverBackground");
            }

            public static Color buttonSeparatorColor() {
                return JBColor.namedColor("List.Button.separatorColor", Popup.BACKGROUND);
            }

            public static int buttonSeparatorInset() {
                return JBUI.getInt("List.Button.separatorInset", 4);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$List";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "background";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "foreground";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }

            public static final class Selection {
                private static final Color BACKGROUND = JBColor.namedColor("List.selectionBackground", DEFAULT_RENDERER_SELECTION_BACKGROUND);
                private static final Color FOREGROUND = JBColor.namedColor("List.selectionForeground", Label.foreground(true));

                @NotNull
                public static Color background(boolean focused) {
                    Color color = focused ? BACKGROUND : Inactive.BACKGROUND;
                    if (color == null) {
                        Selection.$$$reportNull$$$0(0);
                    }
                    return color;
                }

                @NotNull
                public static Color foreground(boolean focused) {
                    Color color = focused ? FOREGROUND : Inactive.FOREGROUND;
                    if (color == null) {
                        Selection.$$$reportNull$$$0(1);
                    }
                    return color;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$List$Selection";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "background";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "foreground";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }

                private static interface Inactive {
                    public static final Color BACKGROUND = JBColor.namedColor("List.selectionInactiveBackground", DEFAULT_RENDERER_SELECTION_INACTIVE_BACKGROUND);
                    public static final Color FOREGROUND = JBColor.namedColor("List.selectionInactiveForeground", List.FOREGROUND);
                }
            }

            public static interface Tag {
                public static final Color BACKGROUND = JBColor.namedColor("List.Tag.background", new JBColor(15461616, 3750720));
                public static final Color FOREGROUND = JBColor.namedColor("List.Tag.foreground", new JBColor(4803415, 11054525));
            }

            public static final class Hover {
                private static final Color BACKGROUND = JBColor.namedColor("List.hoverBackground", DEFAULT_RENDERER_HOVER_BACKGROUND);

                @NotNull
                public static Color background(boolean focused) {
                    Color color = focused ? BACKGROUND : Inactive.BACKGROUND;
                    if (color == null) {
                        Hover.$$$reportNull$$$0(0);
                    }
                    return color;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/JBUI$CurrentTheme$List$Hover", "background"));
                }

                private static interface Inactive {
                    public static final Color BACKGROUND = JBColor.namedColor("List.hoverInactiveBackground", DEFAULT_RENDERER_HOVER_INACTIVE_BACKGROUND);
                }
            }
        }

        public static final class NotificationWarning {
            @NotNull
            public static Color backgroundColor() {
                JBColor jBColor = JBColor.namedColor("Notification.ToolWindow.warningBackground", new JBColor(16381838, 5919265));
                if (jBColor == null) {
                    NotificationWarning.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color foregroundColor() {
                JBColor jBColor = JBColor.namedColor("Notification.ToolWindow.warningForeground", Tooltip.FOREGROUND);
                if (jBColor == null) {
                    NotificationWarning.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Color borderColor() {
                JBColor jBColor = JBColor.namedColor("Notification.ToolWindow.warningBorderColor", new JBColor(12236836, 10919779));
                if (jBColor == null) {
                    NotificationWarning.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$NotificationWarning";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "backgroundColor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "foregroundColor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "borderColor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class NotificationInfo {
            @NotNull
            public static Color backgroundColor() {
                JBColor jBColor = JBColor.namedColor("Notification.ToolWindow.informativeBackground", new JBColor(0xBAEEBA, 3359022));
                if (jBColor == null) {
                    NotificationInfo.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color foregroundColor() {
                JBColor jBColor = JBColor.namedColor("Notification.ToolWindow.informativeForeground", Tooltip.FOREGROUND);
                if (jBColor == null) {
                    NotificationInfo.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Color borderColor() {
                JBColor jBColor = JBColor.namedColor("Notification.ToolWindow.informativeBorderColor", new JBColor(10534813, 8755578));
                if (jBColor == null) {
                    NotificationInfo.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$NotificationInfo";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "backgroundColor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "foregroundColor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "borderColor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class NotificationError {
            @NotNull
            public static Color backgroundColor() {
                JBColor jBColor = JBColor.namedColor("Notification.ToolWindow.errorBackground", new JBColor(0xFFCCCC, 7358277));
                if (jBColor == null) {
                    NotificationError.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color foregroundColor() {
                JBColor jBColor = JBColor.namedColor("Notification.ToolWindow.errorForeground", Tooltip.FOREGROUND);
                if (jBColor == null) {
                    NotificationError.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Color borderColor() {
                JBColor jBColor = JBColor.namedColor("Notification.ToolWindow.errorBorderColor", new JBColor(0xD69696, 0x998A8A));
                if (jBColor == null) {
                    NotificationError.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$NotificationError";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "backgroundColor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "foregroundColor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "borderColor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class NewClassDialog {
            @NotNull
            public static Color searchFieldBackground() {
                JBColor jBColor = JBColor.namedColor("NewClass.SearchField.background", 0xFFFFFF);
                if (jBColor == null) {
                    NewClassDialog.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color panelBackground() {
                JBColor jBColor = JBColor.namedColor("NewClass.Panel.background", 0xF2F2F2);
                if (jBColor == null) {
                    NewClassDialog.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Color bordersColor() {
                JBColor jBColor = JBColor.namedColor("TextField.borderColor", JBColor.namedColor("Component.borderColor", new JBColor(0xBDBDBD, 0x646464)));
                if (jBColor == null) {
                    NewClassDialog.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            public static int fieldsSeparatorWidth() {
                return JBUI.getInt("NewClass.separatorWidth", 10);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$NewClassDialog";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "searchFieldBackground";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "panelBackground";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "bordersColor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class NavBar {
            @NotNull
            public static Insets itemInsets() {
                JBInsets jBInsets = JBUI.insets(NavBar.itemInsetsKey(), NavBar.defaultItemInsets());
                if (jBInsets == null) {
                    NavBar.$$$reportNull$$$0(0);
                }
                return jBInsets;
            }

            @NotNull
            public static JBInsets defaultItemInsets() {
                JBInsets jBInsets = JBUI.insets(4, 2);
                if (jBInsets == null) {
                    NavBar.$$$reportNull$$$0(1);
                }
                return jBInsets;
            }

            @NotNull
            public static String itemInsetsKey() {
                return "NavBar.Breadcrumbs.itemInsets";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$NavBar";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "itemInsets";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "defaultItemInsets";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class Arrow {
            @NotNull
            public static Color foregroundColor(boolean enabled) {
                JBColor jBColor = enabled ? JBColor.namedColor("ComboBox.ArrowButton.iconColor", JBColor.namedColor("ComboBox.darcula.arrowButtonForeground", Gray.x66)) : JBColor.namedColor("ComboBox.ArrowButton.disabledIconColor", JBColor.namedColor("ComboBox.darcula.arrowButtonDisabledForeground", Gray.xAB));
                if (jBColor == null) {
                    Arrow.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color backgroundColor(boolean enabled, boolean editable) {
                Color color = enabled ? (editable ? JBColor.namedColor("ComboBox.ArrowButton.background", JBColor.namedColor("ComboBox.darcula.editable.arrowButtonBackground", Gray.xFC)) : JBColor.namedColor("ComboBox.ArrowButton.nonEditableBackground", JBColor.namedColor("ComboBox.darcula.arrowButtonBackground", Gray.xFC))) : UIUtil.getPanelBackground();
                if (color == null) {
                    Arrow.$$$reportNull$$$0(1);
                }
                return color;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$Arrow";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "foregroundColor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "backgroundColor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static interface ContextHelp {
            @NotNull
            public static final Color FOREGROUND = JBColor.namedColor("Label.infoForeground", new JBColor(Gray.x78, (Color)Gray.x8C));
        }

        public static final class HelpTooltip {
            @NotNull
            public static Insets defaultTextBorderInsets() {
                JBInsets jBInsets = JBUI.insets("HelpTooltip.defaultTextBorderInsets", JBUI.isNewUI() ? JBUI.insets(12, 16, 16, 16) : JBUI.insets(8, 10, 10, 13));
                if (jBInsets == null) {
                    HelpTooltip.$$$reportNull$$$0(0);
                }
                return jBInsets;
            }

            @NotNull
            public static Insets smallTextBorderInsets() {
                JBInsets jBInsets = JBUI.insets("HelpTooltip.smallTextBorderInsets", JBUI.isNewUI() ? JBUI.insets(8, 12, 9, 12) : JBUI.insets(6, 10, 7, 12));
                if (jBInsets == null) {
                    HelpTooltip.$$$reportNull$$$0(1);
                }
                return jBInsets;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$HelpTooltip";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "defaultTextBorderInsets";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "smallTextBorderInsets";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class GotItTooltip {
            public static final JBValue TEXT_INSET = new JBValue.UIInteger("GotItTooltip.textInset", 4);
            public static final JBValue BUTTON_TOP_INSET = new JBValue.UIInteger("GotItTooltip.buttonTopInset", 12);
            public static final JBValue BUTTON_BOTTOM_INSET = new JBValue.UIInteger("GotItTooltip.buttonBottomInset", 6);
            public static final JBValue ICON_INSET = new JBValue.UIInteger("GotItTooltip.iconInset", 6);
            public static final JBValue IMAGE_TOP_INSET = new JBValue.UIInteger("GotItTooltip.imageTopInset", 4);
            public static final JBValue IMAGE_BOTTOM_INSET = new JBValue.UIInteger("GotItTooltip.imageBottomInset", 12);
            public static final JBValue CORNER_RADIUS = new JBValue.UIInteger("GotItTooltip.arc", 8);

            @NotNull
            public static Insets insets() {
                JBInsets jBInsets = JBUI.insets("GotItTooltip.insets", JBUI.insets(7, 8));
                if (jBInsets == null) {
                    GotItTooltip.$$$reportNull$$$0(0);
                }
                return jBInsets;
            }

            @NotNull
            public static Color foreground(boolean useContrastColors) {
                JBColor base = JBColor.namedColor("GotItTooltip.foreground", Tooltip.FOREGROUND);
                if (useContrastColors) {
                    JBColor jBColor = JBColor.namedColor("Tooltip.Learning.foreground", base);
                    if (jBColor == null) {
                        GotItTooltip.$$$reportNull$$$0(1);
                    }
                    return jBColor;
                }
                JBColor jBColor = base;
                if (jBColor == null) {
                    GotItTooltip.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            @NotNull
            public static Color background(boolean useContrastColors) {
                JBColor base = JBColor.namedColor("GotItTooltip.background", Tooltip.BACKGROUND);
                if (useContrastColors) {
                    JBColor jBColor = JBColor.namedColor("Tooltip.Learning.background", base);
                    if (jBColor == null) {
                        GotItTooltip.$$$reportNull$$$0(3);
                    }
                    return jBColor;
                }
                JBColor jBColor = base;
                if (jBColor == null) {
                    GotItTooltip.$$$reportNull$$$0(4);
                }
                return jBColor;
            }

            @NotNull
            public static Color stepForeground(boolean useContrastColors) {
                JBColor base = JBColor.namedColor("GotItTooltip.stepForeground", GotItTooltip.foreground(false));
                if (useContrastColors) {
                    JBColor jBColor = JBColor.namedColor("Tooltip.Learning.stepNumberForeground", base);
                    if (jBColor == null) {
                        GotItTooltip.$$$reportNull$$$0(5);
                    }
                    return jBColor;
                }
                JBColor jBColor = base;
                if (jBColor == null) {
                    GotItTooltip.$$$reportNull$$$0(6);
                }
                return jBColor;
            }

            @NotNull
            public static Color secondaryActionForeground(boolean useContrastColors) {
                JBColor base = JBColor.namedColor("GotItTooltip.secondaryActionForeground", GotItTooltip.foreground(false));
                if (useContrastColors) {
                    JBColor jBColor = JBColor.namedColor("Tooltip.Learning.secondaryActionForeground", base);
                    if (jBColor == null) {
                        GotItTooltip.$$$reportNull$$$0(7);
                    }
                    return jBColor;
                }
                JBColor jBColor = base;
                if (jBColor == null) {
                    GotItTooltip.$$$reportNull$$$0(8);
                }
                return jBColor;
            }

            @NotNull
            public static Color linkUnderline(boolean useContrastColors, boolean isActive, Color defaultActiveColor) {
                if (useContrastColors) {
                    if (isActive) {
                        JBColor jBColor = JBColor.namedColor("Tooltip.Learning.linkUnderlineHoveredColor", defaultActiveColor);
                        if (jBColor == null) {
                            GotItTooltip.$$$reportNull$$$0(9);
                        }
                        return jBColor;
                    }
                    JBColor jBColor = JBColor.namedColor("Tooltip.Learning.linkUnderlineDefaultColor", CLEAR);
                    if (jBColor == null) {
                        GotItTooltip.$$$reportNull$$$0(10);
                    }
                    return jBColor;
                }
                if (isActive) {
                    JBColor jBColor = JBColor.namedColor("GotItTooltip.linkUnderlineHoveredColor", defaultActiveColor);
                    if (jBColor == null) {
                        GotItTooltip.$$$reportNull$$$0(11);
                    }
                    return jBColor;
                }
                JBColor jBColor = JBColor.namedColor("GotItTooltip.linkUnderlineDefaultColor", CLEAR);
                if (jBColor == null) {
                    GotItTooltip.$$$reportNull$$$0(12);
                }
                return jBColor;
            }

            @NotNull
            public static Color headerForeground(boolean useContrastColors) {
                JBColor base = JBColor.namedColor("GotItTooltip.Header.foreground", GotItTooltip.foreground(false));
                if (useContrastColors) {
                    JBColor jBColor = JBColor.namedColor("Tooltip.Learning.Header.foreground", base);
                    if (jBColor == null) {
                        GotItTooltip.$$$reportNull$$$0(13);
                    }
                    return jBColor;
                }
                JBColor jBColor = base;
                if (jBColor == null) {
                    GotItTooltip.$$$reportNull$$$0(14);
                }
                return jBColor;
            }

            @NotNull
            public static Color shortcutForeground(boolean useContrastColors) {
                JBColor base = JBColor.namedColor("GotItTooltip.shortcutForeground", GotItTooltip.foreground(false));
                if (useContrastColors) {
                    JBColor jBColor = JBColor.namedColor("Tooltip.Learning.spanForeground", base);
                    if (jBColor == null) {
                        GotItTooltip.$$$reportNull$$$0(15);
                    }
                    return jBColor;
                }
                JBColor jBColor = base;
                if (jBColor == null) {
                    GotItTooltip.$$$reportNull$$$0(16);
                }
                return jBColor;
            }

            @NotNull
            public static Color shortcutBackground(boolean useContrastColors) {
                JBColor base = JBColor.namedColor("GotItTooltip.shortcutBackground", JBColor.namedColor("Lesson.shortcutBackground", 15134455, 0x333638));
                if (useContrastColors) {
                    JBColor jBColor = JBColor.namedColor("Tooltip.Learning.spanBackground", base);
                    if (jBColor == null) {
                        GotItTooltip.$$$reportNull$$$0(17);
                    }
                    return jBColor;
                }
                JBColor jBColor = base;
                if (jBColor == null) {
                    GotItTooltip.$$$reportNull$$$0(18);
                }
                return jBColor;
            }

            @NotNull
            public static Color shortcutBorder(boolean useContrastColors) {
                if (useContrastColors) {
                    return GotItTooltip.shortcutBackground(useContrastColors);
                }
                JBColor jBColor = JBColor.namedColor("GotItTooltip.shortcutBorderColor", GotItTooltip.shortcutBackground(useContrastColors));
                if (jBColor == null) {
                    GotItTooltip.$$$reportNull$$$0(19);
                }
                return jBColor;
            }

            @NotNull
            public static Color codeForeground(boolean useContrastColors) {
                JBColor base = JBColor.namedColor("GotItTooltip.codeForeground", GotItTooltip.foreground(useContrastColors));
                if (useContrastColors) {
                    JBColor jBColor = JBColor.namedColor("Tooltip.Learning.codeForeground", base);
                    if (jBColor == null) {
                        GotItTooltip.$$$reportNull$$$0(20);
                    }
                    return jBColor;
                }
                JBColor jBColor = base;
                if (jBColor == null) {
                    GotItTooltip.$$$reportNull$$$0(21);
                }
                return jBColor;
            }

            @NotNull
            public static Color codeBackground(boolean useContrastColors) {
                Color base = GotItTooltip.background(useContrastColors);
                if (useContrastColors) {
                    Color color = base;
                    if (color == null) {
                        GotItTooltip.$$$reportNull$$$0(22);
                    }
                    return color;
                }
                JBColor jBColor = JBColor.namedColor("GotItTooltip.codeBackground", base);
                if (jBColor == null) {
                    GotItTooltip.$$$reportNull$$$0(23);
                }
                return jBColor;
            }

            @NotNull
            public static Color codeBorderColor(boolean useContrastColors) {
                JBColor base = JBColor.namedColor("GotItTooltip.codeBorderColor", GotItTooltip.shortcutBackground(useContrastColors));
                if (useContrastColors) {
                    JBColor jBColor = JBColor.namedColor("Tooltip.Learning.codeBorderColor", base);
                    if (jBColor == null) {
                        GotItTooltip.$$$reportNull$$$0(24);
                    }
                    return jBColor;
                }
                JBColor jBColor = base;
                if (jBColor == null) {
                    GotItTooltip.$$$reportNull$$$0(25);
                }
                return jBColor;
            }

            @Nullable
            public static Color iconBorderColor(boolean useContrastColors) {
                JBColor base = useContrastColors ? JBColor.namedColor("Tooltip.Learning.iconBorderColor", CLEAR) : JBColor.namedColor("GotItTooltip.iconBorderColor", CLEAR);
                if (((Color)base).getAlpha() == 0) {
                    return null;
                }
                return base;
            }

            @Nullable
            public static Color iconFillColor(boolean useContrastColors) {
                JBColor base = useContrastColors ? JBColor.namedColor("Tooltip.Learning.iconFillColor", CLEAR) : JBColor.namedColor("GotItTooltip.iconFillColor", CLEAR);
                if (((Color)base).getAlpha() == 0) {
                    return null;
                }
                return base;
            }

            @NotNull
            public static Color linkForeground(boolean useContrastColors) {
                if (useContrastColors) {
                    JBColor jBColor = JBColor.namedColor("Tooltip.Learning.linkForeground", Link.Foreground.ENABLED);
                    if (jBColor == null) {
                        GotItTooltip.$$$reportNull$$$0(26);
                    }
                    return jBColor;
                }
                JBColor jBColor = JBColor.namedColor("GotItTooltip.linkForeground", Link.Foreground.ENABLED);
                if (jBColor == null) {
                    GotItTooltip.$$$reportNull$$$0(27);
                }
                return jBColor;
            }

            @NotNull
            public static Color borderColor(boolean useContrastColors) {
                JBColor base = JBColor.namedColor("GotItTooltip.borderColor", Tooltip.borderColor());
                if (useContrastColors) {
                    JBColor jBColor = JBColor.namedColor("Tooltip.Learning.borderColor", base);
                    if (jBColor == null) {
                        GotItTooltip.$$$reportNull$$$0(28);
                    }
                    return jBColor;
                }
                JBColor jBColor = base;
                if (jBColor == null) {
                    GotItTooltip.$$$reportNull$$$0(29);
                }
                return jBColor;
            }

            @NotNull
            public static Color imageBorderColor(boolean useContrastColors) {
                JBColor jBColor = JBColor.namedColor("GotItTooltip.imageBorderColor", GotItTooltip.background(useContrastColors));
                if (jBColor == null) {
                    GotItTooltip.$$$reportNull$$$0(30);
                }
                return jBColor;
            }

            @NotNull
            public static Color animationBackground(boolean useContrastColors) {
                JBColor jBColor = JBColor.namedColor("GotItTooltip.animationBackground", GotItTooltip.background(useContrastColors));
                if (jBColor == null) {
                    GotItTooltip.$$$reportNull$$$0(31);
                }
                return jBColor;
            }

            @NotNull
            public static Color buttonBackgroundContrast() {
                JBColor jBColor = JBColor.namedColor("Tooltip.Learning.spanBackground", 875709, 151728);
                if (jBColor == null) {
                    GotItTooltip.$$$reportNull$$$0(32);
                }
                return jBColor;
            }

            @NotNull
            public static Color buttonBackgroundContrastOnlyButton() {
                JBColor jBColor = JBColor.namedColor("GotItTooltip.Button.contrastBackground", GotItTooltip.buttonBackgroundContrast());
                if (jBColor == null) {
                    GotItTooltip.$$$reportNull$$$0(33);
                }
                return jBColor;
            }

            @NotNull
            public static Color buttonForeground() {
                JBColor jBColor = JBColor.namedColor("GotItTooltip.Button.foreground", JBColor.namedColor("Button.foreground"));
                if (jBColor == null) {
                    GotItTooltip.$$$reportNull$$$0(34);
                }
                return jBColor;
            }

            @NotNull
            public static Color buttonForegroundContrast() {
                JBColor jBColor = JBColor.namedColor("Tooltip.Learning.spanForeground", 0xF5F5F5);
                if (jBColor == null) {
                    GotItTooltip.$$$reportNull$$$0(35);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$GotItTooltip";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "insets";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "foreground";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "background";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "stepForeground";
                        break;
                    }
                    case 7: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "secondaryActionForeground";
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[1] = "linkUnderline";
                        break;
                    }
                    case 13: 
                    case 14: {
                        objectArray = objectArray2;
                        objectArray2[1] = "headerForeground";
                        break;
                    }
                    case 15: 
                    case 16: {
                        objectArray = objectArray2;
                        objectArray2[1] = "shortcutForeground";
                        break;
                    }
                    case 17: 
                    case 18: {
                        objectArray = objectArray2;
                        objectArray2[1] = "shortcutBackground";
                        break;
                    }
                    case 19: {
                        objectArray = objectArray2;
                        objectArray2[1] = "shortcutBorder";
                        break;
                    }
                    case 20: 
                    case 21: {
                        objectArray = objectArray2;
                        objectArray2[1] = "codeForeground";
                        break;
                    }
                    case 22: 
                    case 23: {
                        objectArray = objectArray2;
                        objectArray2[1] = "codeBackground";
                        break;
                    }
                    case 24: 
                    case 25: {
                        objectArray = objectArray2;
                        objectArray2[1] = "codeBorderColor";
                        break;
                    }
                    case 26: 
                    case 27: {
                        objectArray = objectArray2;
                        objectArray2[1] = "linkForeground";
                        break;
                    }
                    case 28: 
                    case 29: {
                        objectArray = objectArray2;
                        objectArray2[1] = "borderColor";
                        break;
                    }
                    case 30: {
                        objectArray = objectArray2;
                        objectArray2[1] = "imageBorderColor";
                        break;
                    }
                    case 31: {
                        objectArray = objectArray2;
                        objectArray2[1] = "animationBackground";
                        break;
                    }
                    case 32: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buttonBackgroundContrast";
                        break;
                    }
                    case 33: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buttonBackgroundContrastOnlyButton";
                        break;
                    }
                    case 34: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buttonForeground";
                        break;
                    }
                    case 35: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buttonForegroundContrast";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class Tooltip {
            public static final JBValue CORNER_RADIUS = new JBValue.UIInteger("ToolTip.borderCornerRadius", 4);
            @NotNull
            private static final Color SEPARATOR_COLOR = JBColor.namedColor("ToolTip.separatorColor", 0xD1D1D1, 5527128);
            @NotNull
            private static final Color FOREGROUND = JBColor.namedColor("ToolTip.foreground", new JBColor(Gray.x00, (Color)Gray.xBF));
            @NotNull
            private static final Color BACKGROUND = JBColor.namedColor("ToolTip.background", new JBColor(Gray.xF2, new Color(3948353)));
            @NotNull
            private static final Color GRAYED_FOREGROUND = JBColor.namedColor("ToolTip.grayedForeground", new JBColor(JBColor.namedColor("ColorPalette.Gray7", Gray.x90), (Color)JBColor.namedColor("ColorPalette.Gray8", Gray.x90)));
            @NotNull
            private static final Color SHORTCUT_FOREGROUND = JBColor.namedColor("ToolTip.shortcutForeground", new JBColor(0x787878, 0x999999));

            @NotNull
            public static Color foreground() {
                Color color = FOREGROUND;
                if (color == null) {
                    Tooltip.$$$reportNull$$$0(0);
                }
                return color;
            }

            @NotNull
            public static Color background() {
                Color color = BACKGROUND;
                if (color == null) {
                    Tooltip.$$$reportNull$$$0(1);
                }
                return color;
            }

            @NotNull
            public static Color separatorColor() {
                Color color = SEPARATOR_COLOR;
                if (color == null) {
                    Tooltip.$$$reportNull$$$0(2);
                }
                return color;
            }

            @NotNull
            public static Color grayedForeground() {
                Color color = GRAYED_FOREGROUND;
                if (color == null) {
                    Tooltip.$$$reportNull$$$0(3);
                }
                return color;
            }

            @NotNull
            public static Color shortcutForeground() {
                Color color = SHORTCUT_FOREGROUND;
                if (color == null) {
                    Tooltip.$$$reportNull$$$0(4);
                }
                return color;
            }

            @NotNull
            public static Color borderColor() {
                JBColor jBColor = JBColor.namedColor("ToolTip.borderColor", new JBColor(0xADADAD, 6514025));
                if (jBColor == null) {
                    Tooltip.$$$reportNull$$$0(5);
                }
                return jBColor;
            }

            public static Font font() {
                return UIManager.getFont("ToolTip.font");
            }

            private Tooltip() {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$Tooltip";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "foreground";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "background";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "separatorColor";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "grayedForeground";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "shortcutForeground";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "borderColor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }

            public static final class Actions {
                @NotNull
                private static final Color BACKGROUND = JBColor.namedColor("ToolTip.Actions.background", new JBColor(Gray.xEB, new Color(4409162)));

                @NotNull
                public static Color background() {
                    Color color = BACKGROUND;
                    if (color == null) {
                        Actions.$$$reportNull$$$0(0);
                    }
                    return color;
                }

                private Actions() {
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/JBUI$CurrentTheme$Tooltip$Actions", "background"));
                }
            }
        }

        public static final class Link {
            @NotNull
            public static final Color FOCUSED_BORDER_COLOR = JBColor.namedColor("Link.focusedBorderColor", Component.FOCUSED_BORDER_COLOR);

            @Deprecated(forRemoval=true)
            @NotNull
            public static Color linkColor() {
                Color color = Foreground.ENABLED;
                if (color == null) {
                    Link.$$$reportNull$$$0(0);
                }
                return color;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/JBUI$CurrentTheme$Link", "linkColor"));
            }

            public static interface Foreground {
                @NotNull
                public static final Color DISABLED = JBColor.namedColor("Link.disabledForeground", Label.disabledForeground());
                @NotNull
                public static final Color ENABLED = JBColor.namedColor("Link.activeForeground", JBColor.namedColor("link.foreground", 5807606));
                @NotNull
                public static final Color HOVERED = JBColor.namedColor("Link.hoverForeground", JBColor.namedColor("link.hover.foreground", ENABLED));
                @NotNull
                public static final Color PRESSED = JBColor.namedColor("Link.pressedForeground", JBColor.namedColor("link.pressed.foreground", 0xF00000, 12218149));
                @NotNull
                public static final Color VISITED = JBColor.namedColor("Link.visitedForeground", JBColor.namedColor("link.visited.foreground", 0x800080, 9926313));
                @NotNull
                public static final Color SECONDARY = JBColor.namedColor("Link.secondaryForeground", 7839165, 5666464);
            }
        }

        public static interface Window {
            public static Border getBorder(boolean undecoratedWindow) {
                Border result = UIManager.getBorder("Window.border");
                if (result == null && undecoratedWindow && SystemInfo.isUnix && !SystemInfo.isMac && Registry.is((String)"ide.linux.use.undecorated.border")) {
                    result = UIManager.getBorder("Window.undecorated.border");
                }
                return result;
            }
        }

        public static final class VersionControl {

            public static final class CombinedDiff {
                @NotNull
                public static Insets mainToolbarInsets() {
                    JBInsets jBInsets = JBUI.insets(CombinedDiff.mainToolbarInsetsKey(), JBUI.isNewUI() ? JBUI.insets(4, 10) : JBUI.insets(1, 10));
                    if (jBInsets == null) {
                        CombinedDiff.$$$reportNull$$$0(0);
                    }
                    return jBInsets;
                }

                @NotNull
                public static String mainToolbarInsetsKey() {
                    return "CombinedDiff.mainToolbarInsets";
                }

                @NotNull
                public static Insets fileToolbarInsets() {
                    JBInsets jBInsets = JBUI.insets(CombinedDiff.fileToolbarInsetsKey(), JBUI.isNewUI() ? JBUI.insets(12, 10) : JBUI.insets(7, 10));
                    if (jBInsets == null) {
                        CombinedDiff.$$$reportNull$$$0(1);
                    }
                    return jBInsets;
                }

                @NotNull
                public static String fileToolbarInsetsKey() {
                    return "CombinedDiff.fileToolbarInsets";
                }

                public static int leftRightBlockInset() {
                    return JBUI.getInt(CombinedDiff.leftRightBlockInsetKey(), 12);
                }

                @NotNull
                public static String leftRightBlockInsetKey() {
                    return "CombinedDiff.leftRightBlockInset";
                }

                public static int gapBetweenBlocks() {
                    return JBUI.getInt(CombinedDiff.gapBetweenBlocksKey(), 10);
                }

                @NotNull
                public static String gapBetweenBlocksKey() {
                    return "CombinedDiff.gapBetweenBlocks";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$VersionControl$CombinedDiff";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "mainToolbarInsets";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "fileToolbarInsets";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            }

            public static final class Log {
                public static int rowHeight() {
                    return JBUI.getInt(Log.rowHeightKey(), Log.defaultRowHeight());
                }

                @NotNull
                public static String rowHeightKey() {
                    return "VersionControl.Log.Commit.rowHeight";
                }

                public static int defaultRowHeight() {
                    return 26;
                }

                public static int verticalPadding() {
                    return JBUI.getInt(Log.verticalPaddingKey(), Log.defaultVerticalPadding());
                }

                @NotNull
                public static String verticalPaddingKey() {
                    return "VersionControl.Log.Commit.verticalPadding";
                }

                public static int defaultVerticalPadding() {
                    return 7;
                }
            }
        }

        public static final class Validator {
            @NotNull
            public static Color errorBorderColor() {
                JBColor jBColor = JBColor.namedColor("ValidationTooltip.errorBorderColor", 14723241);
                if (jBColor == null) {
                    Validator.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color errorBackgroundColor() {
                JBColor jBColor = JBColor.namedColor("ValidationTooltip.errorBackground", JBColor.namedColor("ValidationTooltip.errorBackgroundColor", 16115431));
                if (jBColor == null) {
                    Validator.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Color warningBorderColor() {
                JBColor jBColor = JBColor.namedColor("ValidationTooltip.warningBorderColor", 14732968);
                if (jBColor == null) {
                    Validator.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            @NotNull
            public static Color warningBackgroundColor() {
                JBColor jBColor = JBColor.namedColor("ValidationTooltip.warningBackground", JBColor.namedColor("ValidationTooltip.warningBackgroundColor", 16117990));
                if (jBColor == null) {
                    Validator.$$$reportNull$$$0(3);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$Validator";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "errorBorderColor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "errorBackgroundColor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "warningBorderColor";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "warningBackgroundColor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class Advertiser {
            public static final JBValue FONT_SIZE_OFFSET = new JBValue.UIInteger("Popup.Advertiser.fontSizeOffset", -2);

            @NotNull
            public static Color foreground() {
                Color foreground = BigPopup.advertiserForeground();
                JBColor jBColor = JBColor.namedColor("Popup.Advertiser.foreground", foreground);
                if (jBColor == null) {
                    Advertiser.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color background() {
                Color background = BigPopup.advertiserBackground();
                JBColor jBColor = JBColor.namedColor("Popup.Advertiser.background", background);
                if (jBColor == null) {
                    Advertiser.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Border border() {
                return new EmptyBorder(Advertiser.borderInsets());
            }

            @NotNull
            private static JBInsets borderInsets() {
                JBInsets jBInsets = JBUI.insets(Advertiser.borderInsetsKey(), JBUI.isNewUI() ? JBUI.insets(6, 20) : JBUI.insets(5, 10, 5, 15));
                if (jBInsets == null) {
                    Advertiser.$$$reportNull$$$0(2);
                }
                return jBInsets;
            }

            @NotNull
            public static String borderInsetsKey() {
                return "Popup.Advertiser.borderInsets";
            }

            @NotNull
            public static Color borderColor() {
                JBColor jBColor = JBColor.namedColor("Popup.Advertiser.borderColor", Gray._135);
                if (jBColor == null) {
                    Advertiser.$$$reportNull$$$0(3);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$Advertiser";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "foreground";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "background";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "borderInsets";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "borderColor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class BigPopup {
            @NotNull
            public static final Color LIST_SETTINGS_BACKGROUND = JBColor.namedColor("SearchEverywhere.List.settingsBackground", LightColors.SLIGHTLY_GRAY);

            @NotNull
            public static Border headerBorder() {
                String key = "SearchEverywhere.Header.insets";
                JBInsets insets = JBUI.insets(key, ComplexPopup.headerInsets());
                if (UIManager.getInsets(key) == null) {
                    return new EmptyBorder(0, insets.left, 0, insets.right);
                }
                return new EmptyBorder(insets);
            }

            @NotNull
            public static Color headerBackground() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.Header.background", 0xF2F2F2);
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Insets tabInsets() {
                JBInsets jBInsets = JBInsets.create(0, 12);
                if (jBInsets == null) {
                    BigPopup.$$$reportNull$$$0(1);
                }
                return jBInsets;
            }

            @NotNull
            public static Color selectedTabColor() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.Tab.selectedBackground", 0xDEDEDE);
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            @NotNull
            public static Color selectedTabTextColor() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.Tab.selectedForeground", 0);
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(3);
                }
                return jBColor;
            }

            @NotNull
            public static Color searchFieldBackground() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.SearchField.background", 0xFFFFFF);
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(4);
                }
                return jBColor;
            }

            @NotNull
            public static Color searchFieldBorderColor() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.SearchField.borderColor", 0xBDBDBD);
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(5);
                }
                return jBColor;
            }

            @NotNull
            public static Insets searchFieldInsets() {
                JBInsets jBInsets = JBUI.insets(0, 6, 0, 5);
                if (jBInsets == null) {
                    BigPopup.$$$reportNull$$$0(6);
                }
                return jBInsets;
            }

            public static int maxListHeight() {
                return JBUIScale.scale(600);
            }

            @NotNull
            public static Color listSeparatorColor() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.List.separatorColor", Gray.xDC);
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(7);
                }
                return jBColor;
            }

            @ApiStatus.Internal
            @NotNull
            public static Color getListSettingsBackground() {
                if (StartupUiUtil.isUnderDarcula() && UIManager.get("SearchEverywhere.List.settingsBackground") == null) {
                    Color color = ColorUtil.brighter(UIUtil.getListBackground(), 1);
                    if (color == null) {
                        BigPopup.$$$reportNull$$$0(8);
                    }
                    return color;
                }
                Color color = LIST_SETTINGS_BACKGROUND;
                if (color == null) {
                    BigPopup.$$$reportNull$$$0(9);
                }
                return color;
            }

            @NotNull
            public static Color listTitleLabelForeground() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.List.separatorForeground", UIUtil.getLabelDisabledForeground());
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(10);
                }
                return jBColor;
            }

            @NotNull
            public static Color searchFieldGrayForeground() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.SearchField.infoForeground", JBColor.GRAY);
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(11);
                }
                return jBColor;
            }

            @NotNull
            public static Color advertiserForeground() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.Advertiser.foreground", JBColor.GRAY);
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(12);
                }
                return jBColor;
            }

            @NotNull
            public static Border advertiserBorder() {
                return new JBEmptyBorder((Insets)JBUI.insets(BigPopup.advertiserBorderInsetsKey(), JBUI.isNewUI() ? JBUI.insets(6, 20) : JBUI.insets(5, 10, 5, 15)));
            }

            @NotNull
            public static String advertiserBorderInsetsKey() {
                return "SearchEverywhere.Advertiser.borderInsets";
            }

            @NotNull
            public static Color advertiserBackground() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.Advertiser.background", 0xF2F2F2);
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(13);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$BigPopup";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "headerBackground";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "tabInsets";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "selectedTabColor";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "selectedTabTextColor";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "searchFieldBackground";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "searchFieldBorderColor";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "searchFieldInsets";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "listSeparatorColor";
                        break;
                    }
                    case 8: 
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getListSettingsBackground";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[1] = "listTitleLabelForeground";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[1] = "searchFieldGrayForeground";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[1] = "advertiserForeground";
                        break;
                    }
                    case 13: {
                        objectArray = objectArray2;
                        objectArray2[1] = "advertiserBackground";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class TabbedPane {
            public static final Color ENABLED_SELECTED_COLOR = JBColor.namedColor("TabbedPane.underlineColor", JBColor.namedColor("TabbedPane.selectedColor", 4228041));
            public static final Color DISABLED_SELECTED_COLOR = JBColor.namedColor("TabbedPane.disabledUnderlineColor", JBColor.namedColor("TabbedPane.selectedDisabledColor", Gray.xAB));
            public static final Color DISABLED_TEXT_COLOR = JBColor.namedColor("TabbedPane.disabledForeground", JBColor.namedColor("TabbedPane.disabledText", Gray.x99));
            public static final Color HOVER_COLOR = JBColor.namedColor("TabbedPane.hoverColor", Gray.xD9);
            public static final Color FOCUS_COLOR = JBColor.namedColor("TabbedPane.focusColor", 14345453);
            public static final JBValue TAB_HEIGHT = new JBValue.UIInteger(TabbedPane.tabHeightKey(), 32);
            public static final JBValue SELECTION_HEIGHT = new JBValue.UIInteger("TabbedPane.tabSelectionHeight", 3);
            public static final JBValue SELECTION_ARC = new JBValue.UIInteger("TabbedPane.tabSelectionArc", 0);

            @NotNull
            public static String tabHeightKey() {
                return "TabbedPane.tabHeight";
            }
        }

        public static final class Focus {
            private static final Color GRAPHITE_COLOR = new JBColor(new Color(-2137417827, true), new Color(6776937));

            @NotNull
            public static Color focusColor() {
                Color color = UIUtil.isGraphite() ? GRAPHITE_COLOR : JBColor.namedColor("Component.focusColor", JBColor.namedColor("Focus.borderColor", 9089771));
                if (color == null) {
                    Focus.$$$reportNull$$$0(0);
                }
                return color;
            }

            @NotNull
            public static Color defaultButtonColor() {
                return StartupUiUtil.isUnderDarcula() ? JBColor.namedColor("Button.default.focusColor", JBColor.namedColor("Focus.defaultButtonBorderColor", 9946099)) : Focus.focusColor();
            }

            @NotNull
            public static Color errorColor(boolean active) {
                JBColor jBColor = active ? JBColor.namedColor("Component.errorFocusColor", JBColor.namedColor("Focus.activeErrorBorderColor", 15023693)) : JBColor.namedColor("Component.inactiveErrorFocusColor", JBColor.namedColor("Focus.inactiveErrorBorderColor", 0xEBBCBC));
                if (jBColor == null) {
                    Focus.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Color warningColor(boolean active) {
                JBColor jBColor = active ? JBColor.namedColor("Component.warningFocusColor", JBColor.namedColor("Focus.activeWarningBorderColor", 14853434)) : JBColor.namedColor("Component.inactiveWarningFocusColor", JBColor.namedColor("Focus.inactiveWarningBorderColor", 16765829));
                if (jBColor == null) {
                    Focus.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$Focus";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "focusColor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "errorColor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "warningColor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class Separator {
            private Separator() {
            }

            @NotNull
            public static Color color() {
                JBColor jBColor = JBColor.namedColor("Separator.separatorColor", new JBColor(0xCDCDCD, 0x515151));
                if (jBColor == null) {
                    Separator.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/JBUI$CurrentTheme$Separator", "color"));
            }
        }

        public static final class PopupMenu {

            public static final class Selection {
                public static final JBValue ARC = new JBValue.UIInteger("PopupMenu.Selection.arc", 8);

                @NotNull
                public static JBInsets innerInsets() {
                    JBInsets jBInsets = JBUI.insets("PopupMenu.Selection.innerInsets", JBUI.isNewUI() ? JBUI.insets(0, 6) : JBUI.insets(2, 10));
                    if (jBInsets == null) {
                        Selection.$$$reportNull$$$0(0);
                    }
                    return jBInsets;
                }

                @NotNull
                public static JBInsets outerInsets() {
                    JBInsets jBInsets = JBUI.insets("PopupMenu.Selection.outerInsets", JBUI.insets(1, 7));
                    if (jBInsets == null) {
                        Selection.$$$reportNull$$$0(1);
                    }
                    return jBInsets;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$PopupMenu$Selection";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "innerInsets";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "outerInsets";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            }
        }

        public static final class Menu {

            public static final class Selection {
                public static final JBValue ARC = new JBValue.UIInteger("Menu.Selection.arc", 8);

                @NotNull
                public static JBInsets innerInsets() {
                    JBInsets jBInsets = JBUI.insets("Menu.Selection.innerInsets", JBUI.isNewUI() ? JBUI.insets(0, 6) : JBUI.insets(2));
                    if (jBInsets == null) {
                        Selection.$$$reportNull$$$0(0);
                    }
                    return jBInsets;
                }

                @NotNull
                public static JBInsets outerInsets() {
                    JBInsets jBInsets = JBUI.insets("Menu.Selection.outerInsets", JBUI.insets(1, 4));
                    if (jBInsets == null) {
                        Selection.$$$reportNull$$$0(1);
                    }
                    return jBInsets;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$Menu$Selection";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "innerInsets";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "outerInsets";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            }
        }

        public static final class Popup {
            public static final Color BACKGROUND = JBColor.namedColor("Popup.background", List.BACKGROUND);
            public static final float DEFAULT_HINT_OPACITY = 0.55f;

            public static int bodyBottomInsetNoAd() {
                return JBUI.getInt("Popup.Body.bottomInsetNoAd", 8);
            }

            public static int bodyBottomInsetBeforeAd() {
                return JBUI.getInt("Popup.Body.bottomInsetBeforeAd", 8);
            }

            public static int bodyTopInsetNoHeader() {
                return JBUI.getInt("Popup.Body.topInsetNoHeader", 8);
            }

            public static Color headerBackground(boolean active) {
                return active ? JBColor.namedColor("Popup.Header.activeBackground", 0xE6E6E6) : JBColor.namedColor("Popup.Header.inactiveBackground", 0xEDEDED);
            }

            public static Color headerForeground(boolean active) {
                return active ? JBColor.namedColor("Popup.Header.activeForeground", UIUtil.getLabelForeground()) : JBColor.namedColor("Popup.Header.inactiveForeground", UIUtil.getLabelDisabledForeground());
            }

            @NotNull
            public static Insets headerInsets() {
                JBInsets jBInsets = JBUI.insets(Popup.headerInsetsKey(), JBUI.insets(12, 10, 10, 10));
                if (jBInsets == null) {
                    Popup.$$$reportNull$$$0(0);
                }
                return jBInsets;
            }

            @NotNull
            public static String headerInsetsKey() {
                return "Popup.Header.insets";
            }

            public static int headerHeight(boolean hasControls) {
                return hasControls ? JBUIScale.scale(28) : JBUIScale.scale(24);
            }

            public static Color borderColor(boolean active) {
                return active ? JBColor.namedColor("Popup.borderColor", JBColor.namedColor("Popup.Border.color", 0x808080)) : JBColor.namedColor("Popup.inactiveBorderColor", JBColor.namedColor("Popup.inactiveBorderColor", 0xAAAAAA));
            }

            public static float borderWidth() {
                return JBUI.getFloat("Popup.borderWidth", 1.0f);
            }

            public static Insets searchFieldBorderInsets() {
                return JBUI.insets("Popup.SearchField.borderInsets", JBUI.insets(4, 12));
            }

            public static Insets searchFieldInputInsets() {
                return JBUI.insets("Popup.SearchField.inputInsets", JBUI.insets(4, 8, 8, 2));
            }

            public static Color toolbarPanelColor() {
                return JBColor.namedColor("Popup.Toolbar.background", 0xF7F7F7);
            }

            public static Color toolbarBorderColor() {
                return JBColor.namedColor("Popup.Toolbar.borderColor", JBColor.namedColor("Popup.Toolbar.Border.color", 0xF7F7F7));
            }

            public static int toolbarHeight() {
                return JBUIScale.scale(28);
            }

            public static Color separatorColor() {
                return JBColor.namedColor("Popup.separatorColor", new JBColor(Color.gray.brighter(), (Color)Gray.x51));
            }

            public static Insets separatorInsets() {
                return JBUI.insets("Popup.separatorInsets", JBUI.insets(4, 8));
            }

            public static Insets separatorLabelInsets() {
                return JBUI.insets("Popup.separatorLabelInsets", JBUI.insets(3, 16));
            }

            public static Color separatorTextColor() {
                return JBColor.namedColor("Popup.separatorForeground", Color.gray);
            }

            public static int minimumHintWidth() {
                return JBUIScale.scale(170);
            }

            public static Color mnemonicForeground() {
                return JBColor.namedColor("Popup.mnemonicForeground", ActionsList.MNEMONIC_FOREGROUND);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/JBUI$CurrentTheme$Popup", "headerInsets"));
            }

            public static final class Selection {
                public static final JBValue ARC = new JBValue.UIInteger("Popup.Selection.arc", 8);
                public static final JBValue LEFT_RIGHT_INSET = new JBValue.UIInteger("Popup.Selection.leftRightInset", 8);

                @NotNull
                public static Insets innerInsets() {
                    JBInsets result = JBUI.insets("Popup.Selection.innerInsets", JBUI.insets(0, 8));
                    result.top = 0;
                    result.bottom = 0;
                    JBInsets jBInsets = result;
                    if (jBInsets == null) {
                        Selection.$$$reportNull$$$0(0);
                    }
                    return jBInsets;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/JBUI$CurrentTheme$Popup$Selection", "innerInsets"));
                }
            }
        }

        public static final class ComplexPopup {
            public static final Color HEADER_BACKGROUND = JBColor.namedColor("ComplexPopup.Header.background", Popup.BACKGROUND);
            public static final int TEXT_FIELD_SEPARATOR_HEIGHT = 1;

            public static JBInsets headerInsets() {
                return JBUI.insets(ComplexPopup.headerInsetsKey(), JBUI.insets(13, 20, 11, 15));
            }

            @NotNull
            public static String headerInsetsKey() {
                return "ComplexPopup.Header.insets";
            }

            public static JBInsets textFieldBorderInsets() {
                return JBUI.insets("ComplexPopup.TextField.borderInsets", JBUI.insets(0, 12));
            }

            public static JBInsets textFieldInputInsets() {
                return JBUI.insets(ComplexPopup.textFieldInputInsetsKey(), JBUI.insets(6, 2));
            }

            @NotNull
            public static String textFieldInputInsetsKey() {
                return "ComplexPopup.TextField.inputInsets";
            }

            public static JBInsets innerBorderInsets() {
                return JBUI.insets(ComplexPopup.innerBorderInsetsKey(), JBUI.insets(6, 3, 6, ComplexPopup.headerInsets().getUnscaled().right - ComplexPopup.textFieldBorderInsets().getUnscaled().right));
            }

            @NotNull
            public static String innerBorderInsetsKey() {
                return "ComplexPopup.innerBorderInsets";
            }
        }

        public static final class FindPopup {
            @NotNull
            public static Insets scopesPanelInsets() {
                JBInsets jBInsets = JBUI.insets(FindPopup.scopesPanelInsetsKey(), JBUI.isNewUI() ? JBUI.insets(4, 20) : JBUI.insets(3, 5));
                if (jBInsets == null) {
                    FindPopup.$$$reportNull$$$0(0);
                }
                return jBInsets;
            }

            @NotNull
            public static String scopesPanelInsetsKey() {
                return "FindPopup.scopesPanelInsets";
            }

            @NotNull
            public static Insets bottomPanelInsets() {
                JBInsets jBInsets = JBUI.insets(FindPopup.bottomPanelInsetsKey(), JBUI.isNewUI() ? JBUI.insets(5, 18) : JBUI.insets(5));
                if (jBInsets == null) {
                    FindPopup.$$$reportNull$$$0(1);
                }
                return jBInsets;
            }

            @NotNull
            public static String bottomPanelInsetsKey() {
                return "FindPopup.bottomPanelInsets";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$FindPopup";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "scopesPanelInsets";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "bottomPanelInsets";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class CompletionPopup {
            @NotNull
            public static Insets selectionInnerInsets() {
                JBInsets jBInsets = JBUI.insets(CompletionPopup.selectionInnerInsetsKey(), JBUI.insets(2));
                if (jBInsets == null) {
                    CompletionPopup.$$$reportNull$$$0(0);
                }
                return jBInsets;
            }

            @NotNull
            public static String selectionInnerInsetsKey() {
                return "CompletionPopup.selectionInnerInsets";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/JBUI$CurrentTheme$CompletionPopup", "selectionInnerInsets"));
            }

            public static final class Advertiser {
                @NotNull
                public static Color background() {
                    JBColor jBColor = JBColor.namedColor("CompletionPopup.Advertiser.background", com.intellij.util.ui.JBUI$CurrentTheme$Advertiser.background());
                    if (jBColor == null) {
                        Advertiser.$$$reportNull$$$0(0);
                    }
                    return jBColor;
                }

                @NotNull
                public static Color foreground() {
                    JBColor jBColor = JBColor.namedColor("CompletionPopup.Advertiser.foreground", com.intellij.util.ui.JBUI$CurrentTheme$Advertiser.foreground());
                    if (jBColor == null) {
                        Advertiser.$$$reportNull$$$0(1);
                    }
                    return jBColor;
                }

                public static int fontSizeOffset() {
                    return JBUI.getInt("CompletionPopup.Advertiser.fontSizeOffset", com.intellij.util.ui.JBUI$CurrentTheme$Advertiser.FONT_SIZE_OFFSET.get());
                }

                @NotNull
                public static Border border() {
                    return new EmptyBorder(JBUI.insets(Advertiser.borderInsetsKey(), JBUI.isNewUI() ? JBUI.insets(4, 12, 3, 8) : com.intellij.util.ui.JBUI$CurrentTheme$Advertiser.borderInsets()));
                }

                @NotNull
                public static String borderInsetsKey() {
                    return "CompletionPopup.Advertiser.borderInsets";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$CompletionPopup$Advertiser";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "background";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "foreground";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            }
        }

        public static final class Label {
            @NotNull
            public static Color foreground(boolean selected) {
                JBColor jBColor = selected ? JBColor.namedColor("Label.selectedForeground", 0xFFFFFF) : JBColor.namedColor("Label.foreground", 0);
                if (jBColor == null) {
                    Label.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color foreground() {
                return Label.foreground(false);
            }

            @NotNull
            public static Color disabledForeground(boolean selected) {
                JBColor jBColor = selected ? JBColor.namedColor("Label.selectedDisabledForeground", 0x999999) : JBColor.namedColor("Label.disabledForeground", JBColor.namedColor("Label.disabledText", 0x999999));
                if (jBColor == null) {
                    Label.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Color disabledForeground() {
                return Label.disabledForeground(false);
            }

            @NotNull
            public static Color errorForeground() {
                Color color = NamedColorUtil.getErrorForeground();
                if (color == null) {
                    Label.$$$reportNull$$$0(2);
                }
                return color;
            }

            @NotNull
            public static Color warningForeground() {
                JBColor jBColor = JBColor.namedColor("Label.warningForeground", 10774276, 12228434);
                if (jBColor == null) {
                    Label.$$$reportNull$$$0(3);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$Label";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "foreground";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "disabledForeground";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "errorForeground";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "warningForeground";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class MainToolbar {
            @NotNull
            public static Color borderColor() {
                JBColor jBColor = JBColor.namedColor("MainToolbar.borderColor", JBColor.border());
                if (jBColor == null) {
                    MainToolbar.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/JBUI$CurrentTheme$MainToolbar", "borderColor"));
            }

            public static final class Button {
                @NotNull
                public static JBValue hoverArc() {
                    return new JBValue.UIInteger("MainToolbar.Button.arc", 12);
                }
            }

            public static final class SplitDropdown {
                @Deprecated
                @NotNull
                public static Insets borderInsets() {
                    JBInsets jBInsets = JBUI.insets("MainToolbar.SplitDropdown.borderInsets", JBUI.isNewUI() ? JBUI.insets(5, 5, 5, 3) : JBUI.insets(3, 5));
                    if (jBInsets == null) {
                        SplitDropdown.$$$reportNull$$$0(0);
                    }
                    return jBInsets;
                }

                @NotNull
                public static Insets separatorMargin() {
                    JBInsets jBInsets = JBUI.insets("MainToolbar.SplitDropdown.separatorMargin", JBUI.insets(5, 3));
                    if (jBInsets == null) {
                        SplitDropdown.$$$reportNull$$$0(1);
                    }
                    return jBInsets;
                }

                @NotNull
                public static Insets leftPartMargin() {
                    JBInsets jBInsets = JBUI.insets("MainToolbar.SplitDropdown.leftPartMargin", JBUI.insets(3, 7));
                    if (jBInsets == null) {
                        SplitDropdown.$$$reportNull$$$0(2);
                    }
                    return jBInsets;
                }

                @NotNull
                public static Insets rightPartMargin() {
                    JBInsets jBInsets = JBUI.insets("MainToolbar.SplitDropdown.rightPartMargin", JBUI.insets(3));
                    if (jBInsets == null) {
                        SplitDropdown.$$$reportNull$$$0(3);
                    }
                    return jBInsets;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$MainToolbar$SplitDropdown";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "borderInsets";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "separatorMargin";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "leftPartMargin";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "rightPartMargin";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            }

            public static final class Dropdown {
                @Deprecated
                @NotNull
                public static Insets borderInsets() {
                    JBInsets jBInsets = JBUI.insets("MainToolbar.Dropdown.borderInsets", JBUI.isNewUI() ? JBUI.insets(5, 10, 5, 6) : JBUI.insets(3, 5));
                    if (jBInsets == null) {
                        Dropdown.$$$reportNull$$$0(0);
                    }
                    return jBInsets;
                }

                @NotNull
                public static Insets margin() {
                    return Dropdown.borderInsets();
                }

                @NotNull
                public static JBValue hoverArc() {
                    return new JBValue.UIInteger("MainToolbar.Dropdown.arc", 12);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/JBUI$CurrentTheme$MainToolbar$Dropdown", "borderInsets"));
                }
            }
        }

        public static final class FloatingToolbar {
            public static final float DEFAULT_BACKGROUND_ALPHA = 0.55f;
            public static final float TRANSLUCENT_BACKGROUND_ALPHA = 0.9f;
        }

        public static final class Toolbar {
            public static final Color SEPARATOR_COLOR = JBColor.namedColor("ToolBar.separatorColor", CustomFrameDecorations.separatorForeground());

            public static Insets toolbarButtonInsets(boolean isMainToolbar) {
                return isMainToolbar ? Toolbar.mainToolbarButtonInsets() : Toolbar.toolbarButtonInsets();
            }

            public static Insets toolbarButtonInsets() {
                return JBUI.insets("Toolbar.Button.buttonInsets", JBInsets.create(1, 2));
            }

            @Nullable
            public static Insets verticalToolbarInsets() {
                return JBUI.isNewUI() ? JBUI.insets(Toolbar.verticalInsetsKey(), JBUI.insets(5, 7)) : UIManager.getInsets(Toolbar.verticalInsetsKey());
            }

            @NotNull
            public static String verticalInsetsKey() {
                return "ToolBar.verticalToolbarInsets";
            }

            @Nullable
            public static Insets horizontalToolbarInsets() {
                return JBUI.isNewUI() ? JBUI.insets(Toolbar.horizontalInsetsKey(), JBUI.insets(5, 7)) : UIManager.getInsets(Toolbar.horizontalInsetsKey());
            }

            @NotNull
            public static String horizontalInsetsKey() {
                return "ToolBar.horizontalToolbarInsets";
            }

            public static Insets mainToolbarButtonInsets() {
                return JBUI.insets(Toolbar.mainToolbarButtonInsetsKey(), JBUI.isNewUI() ? JBUI.emptyInsets() : JBUI.insets(1, 2));
            }

            @NotNull
            public static String mainToolbarButtonInsetsKey() {
                return "MainToolbar.Icon.insets";
            }

            @NotNull
            public static Dimension experimentalToolbarButtonSize() {
                JBDimension jBDimension = JBUI.size(Toolbar.experimentalToolbarButtonSizeKey(), Toolbar.defaultExperimentalToolbarButtonSize());
                if (jBDimension == null) {
                    Toolbar.$$$reportNull$$$0(0);
                }
                return jBDimension;
            }

            @NotNull
            public static String experimentalToolbarButtonSizeKey() {
                return "MainToolbar.Button.size";
            }

            @NotNull
            public static JBDimension defaultExperimentalToolbarButtonSize() {
                JBDimension jBDimension = JBUI.size(30, 30);
                if (jBDimension == null) {
                    Toolbar.$$$reportNull$$$0(1);
                }
                return jBDimension;
            }

            public static int experimentalToolbarButtonIconSize() {
                return JBUI.getInt(Toolbar.experimentalToolbarButtonIconSizeKey(), Toolbar.defaultExperimentalToolbarButtonIconSize());
            }

            @NotNull
            public static String experimentalToolbarButtonIconSizeKey() {
                return "MainToolbar.Button.iconSize";
            }

            public static int recentProjectAvatarIconSize() {
                return JBUI.getInt(Toolbar.recentProjectAvatarIconSizeKey(), Toolbar.experimentalToolbarButtonIconSize());
            }

            @NotNull
            public static String recentProjectAvatarIconSizeKey() {
                return "RecentProject.Avatar.iconSize";
            }

            public static int defaultExperimentalToolbarButtonIconSize() {
                return 20;
            }

            @NotNull
            public static Font experimentalToolbarFont() {
                Font font = JBUI.getFontWithSizeOffset(Toolbar.experimentalToolbarFontSizeOffsetKey(), Toolbar.defaultExperimentalToolbarFont());
                if (font == null) {
                    Toolbar.$$$reportNull$$$0(2);
                }
                return font;
            }

            @NotNull
            public static String experimentalToolbarFontSizeOffsetKey() {
                return "MainToolbar.fontSizeOffset";
            }

            @NotNull
            public static JBFont defaultExperimentalToolbarFont() {
                JBFont jBFont = JBFont.label();
                if (jBFont == null) {
                    Toolbar.$$$reportNull$$$0(3);
                }
                return jBFont;
            }

            public static int burgerMenuButtonIconSize() {
                return 20;
            }

            @NotNull
            public static Dimension stripeToolbarButtonSize() {
                JBDimension jBDimension = JBUI.size(Toolbar.stripeToolbarButtonSizeKey(), Toolbar.defaultStripeToolbarButtonSize());
                if (jBDimension == null) {
                    Toolbar.$$$reportNull$$$0(4);
                }
                return jBDimension;
            }

            @NotNull
            public static String stripeToolbarButtonSizeKey() {
                return "StripeToolbar.Button.size";
            }

            @NotNull
            public static JBDimension defaultStripeToolbarButtonSize() {
                JBDimension jBDimension = JBUI.size(40, 40);
                if (jBDimension == null) {
                    Toolbar.$$$reportNull$$$0(5);
                }
                return jBDimension;
            }

            public static int stripeToolbarButtonIconSize() {
                return JBUI.getInt(Toolbar.stripeToolbarButtonIconSizeKey(), Toolbar.defaultStripeToolbarButtonIconSize());
            }

            @NotNull
            public static String stripeToolbarButtonIconSizeKey() {
                return "StripeToolbar.Button.iconSize";
            }

            public static int defaultStripeToolbarButtonIconSize() {
                return 20;
            }

            @NotNull
            public static Insets stripeToolbarButtonIconPadding(boolean left, boolean showNames) {
                JBInsets jBInsets = JBUI.insets(Toolbar.stripeToolbarButtonIconPaddingKey(left, showNames), Toolbar.defaultStripeToolbarButtonIconPadding());
                if (jBInsets == null) {
                    Toolbar.$$$reportNull$$$0(6);
                }
                return jBInsets;
            }

            @NotNull
            private static String stripeToolbarButtonIconPaddingKey(boolean left, boolean showNames) {
                String string = "StripeToolbar.Button." + (left ? "left" : "right") + "StripeIcon" + (showNames ? "WithName" : "") + ".padding";
                if (string == null) {
                    Toolbar.$$$reportNull$$$0(7);
                }
                return string;
            }

            @NotNull
            private static JBInsets defaultStripeToolbarButtonIconPadding() {
                JBInsets jBInsets = JBUI.insets(5);
                if (jBInsets == null) {
                    Toolbar.$$$reportNull$$$0(8);
                }
                return jBInsets;
            }

            public static int stripeToolbarTextOffset(boolean left) {
                return JBUI.getInt(Toolbar.stripeToolbarTextOffsetKey(left), 0);
            }

            @NotNull
            private static String stripeToolbarTextOffsetKey(boolean left) {
                String string = "StripeToolbar.Button." + (left ? "left" : "right") + "StripeTextOffset";
                if (string == null) {
                    Toolbar.$$$reportNull$$$0(9);
                }
                return string;
            }

            @NotNull
            public static JBValue stripeButtonArc(boolean compact) {
                return new JBValue.UIInteger("Button.ToolWindow.arc", compact ? 8 : 12);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$Toolbar";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "experimentalToolbarButtonSize";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "defaultExperimentalToolbarButtonSize";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "experimentalToolbarFont";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "defaultExperimentalToolbarFont";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "stripeToolbarButtonSize";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "defaultStripeToolbarButtonSize";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "stripeToolbarButtonIconPadding";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "stripeToolbarButtonIconPaddingKey";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "defaultStripeToolbarButtonIconPadding";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "stripeToolbarTextOffsetKey";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class ToolWindow {
            @NotNull
            public static Color background() {
                JBColor jBColor = JBColor.namedColor("ToolWindow.background", JBColor.PanelBackground);
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color stripeBackground() {
                JBColor jBColor = JBColor.namedColor("ToolWindow.Stripe.background", ToolWindow.background());
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Color borderColor() {
                JBColor jBColor = JBColor.namedColor("ToolWindow.Stripe.borderColor", JBColor.border());
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            @NotNull
            public static Color mainBorderColor() {
                JBColor jBColor = JBColor.namedColor("ToolWindow.borderColor", JBColor.border());
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(3);
                }
                return jBColor;
            }

            @NotNull
            public static Color underlinedTabForeground() {
                JBColor jBColor = JBColor.namedColor("ToolWindow.HeaderTab.underlinedTabForeground", DefaultTabs.underlinedTabForeground());
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(4);
                }
                return jBColor;
            }

            @NotNull
            public static Color hoverBackground() {
                JBColor jBColor = JBColor.namedColor("ToolWindow.HeaderTab.hoverBackground", DefaultTabs.hoverBackground());
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(5);
                }
                return jBColor;
            }

            @NotNull
            public static Color inactiveUnderlineColor() {
                JBColor jBColor = JBColor.namedColor("ToolWindow.HeaderTab.inactiveUnderlineColor", DefaultTabs.inactiveUnderlineColor());
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(6);
                }
                return jBColor;
            }

            @NotNull
            public static Color underlineColor() {
                JBColor jBColor = JBColor.namedColor("ToolWindow.HeaderTab.underlineColor", DefaultTabs.underlineColor());
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(7);
                }
                return jBColor;
            }

            public static Color underlinedTabBackground() {
                return UIManager.getColor("ToolWindow.HeaderTab.underlinedTabBackground");
            }

            public static Color hoverInactiveBackground() {
                return JBColor.namedColor("ToolWindow.HeaderTab.hoverInactiveBackground", ToolWindow.hoverBackground());
            }

            public static Color underlinedTabInactiveBackground() {
                return UIManager.getColor("ToolWindow.HeaderTab.underlinedTabInactiveBackground");
            }

            @NotNull
            public static Color underlinedTabInactiveForeground() {
                JBColor jBColor = JBColor.namedColor("ToolWindow.HeaderTab.underlinedTabInactiveForeground", ToolWindow.underlinedTabForeground());
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(8);
                }
                return jBColor;
            }

            public static int headerTabUnderlineArc() {
                return JBUI.getInt("ToolWindow.HeaderTab.underlineArc", 4);
            }

            public static JBInsets headerTabLeftRightInsets() {
                return JBUI.insets("ToolWindow.HeaderTab.leftRightInsets", JBUI.isNewUI() ? JBUI.insets(0, 12) : JBUI.insets(0, 8));
            }

            @NotNull
            public static Color stripeSeparatorColor(boolean dnd) {
                JBColor jBColor = dnd ? JBColor.namedColor("ToolWindow.Stripe.DragAndDrop.separatorColor", 4226034, 5540599) : JBColor.namedColor("ToolWindow.Stripe.separatorColor", 13225174, 4408650);
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(9);
                }
                return jBColor;
            }

            @NotNull
            public static Color headerBackground(boolean active) {
                return active ? ToolWindow.headerActiveBackground() : ToolWindow.headerBackground();
            }

            @NotNull
            public static Color headerBackground() {
                JBColor jBColor = JBColor.namedColor("ToolWindow.Header.inactiveBackground", JBColor.namedColor("ToolWindow.header.background", 0xECECEC));
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(10);
                }
                return jBColor;
            }

            @NotNull
            public static Color headerBorderBackground() {
                JBColor jBColor = JBColor.namedColor("ToolWindow.Header.borderColor", DefaultTabs.borderColor());
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(11);
                }
                return jBColor;
            }

            @NotNull
            public static Color headerActiveBackground() {
                JBColor jBColor = JBColor.namedColor("ToolWindow.Header.background", JBColor.namedColor("ToolWindow.header.active.background", 14870252));
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(12);
                }
                return jBColor;
            }

            public static int headerHeight() {
                return JBUI.getInt(ToolWindow.headerHeightKey(), ToolWindow.defaultHeaderHeight());
            }

            @NotNull
            public static String headerHeightKey() {
                return "ToolWindow.Header.height";
            }

            public static int defaultHeaderHeight() {
                return 41;
            }

            public static JBInsets headerLabelLeftRightInsets() {
                return JBUI.insets("ToolWindow.Header.labelLeftRightInsets", JBUI.insets(0, 12, 0, 16));
            }

            public static JBInsets headerToolbarLeftRightInsets() {
                return JBUI.insets("ToolWindow.Header.toolbarLeftRightInsets", JBUI.insets(0, 12, 0, 8));
            }

            public static int underlineHeight() {
                return JBUI.uiIntValue("ToolWindow.HeaderTab.underlineHeight", Math.round(DefaultTabs.UNDERLINE_HEIGHT.getUnscaled())).get();
            }

            @NotNull
            public static Font headerFont() {
                Font font = JBUI.getFontWithSizeOffset(ToolWindow.headerFontSizeOffsetKey(), ToolWindow.defaultHeaderFont());
                if (font == null) {
                    ToolWindow.$$$reportNull$$$0(13);
                }
                return font;
            }

            @NotNull
            public static String headerFontSizeOffsetKey() {
                return "ToolWindow.Header.fontSizeOffset";
            }

            @NotNull
            public static JBFont defaultHeaderFont() {
                JBFont jBFont = JBFont.label();
                if (jBFont == null) {
                    ToolWindow.$$$reportNull$$$0(14);
                }
                return jBFont;
            }

            public static float overrideHeaderFontSizeOffset() {
                Object offset = UIManager.get("ToolWindow.Header.font.size.offset");
                if (offset instanceof Integer) {
                    return ((Integer)offset).floatValue();
                }
                return 0.0f;
            }

            @NotNull
            public static Icon closeTabIcon(boolean hovered) {
                Icon icon = hovered ? JBUI.getIcon("ToolWindow.header.closeButton.hovered.icon", AllIcons.Actions.CloseHovered) : JBUI.getIcon("ToolWindow.header.closeButton.icon", AllIcons.Actions.Close);
                if (icon == null) {
                    ToolWindow.$$$reportNull$$$0(15);
                }
                return icon;
            }

            @NotNull
            public static Icon comboTabIcon(boolean hovered) {
                Icon icon = hovered ? JBUI.getIcon("ToolWindow.header.comboButton.hovered.icon", AllIcons.General.ArrowDown) : JBUI.getIcon("ToolWindow.header.comboButton.icon", AllIcons.General.ArrowDown);
                if (icon == null) {
                    ToolWindow.$$$reportNull$$$0(16);
                }
                return icon;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$ToolWindow";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "background";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "stripeBackground";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "borderColor";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "mainBorderColor";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "underlinedTabForeground";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "hoverBackground";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "inactiveUnderlineColor";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "underlineColor";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "underlinedTabInactiveForeground";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "stripeSeparatorColor";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[1] = "headerBackground";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[1] = "headerBorderBackground";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[1] = "headerActiveBackground";
                        break;
                    }
                    case 13: {
                        objectArray = objectArray2;
                        objectArray2[1] = "headerFont";
                        break;
                    }
                    case 14: {
                        objectArray = objectArray2;
                        objectArray2[1] = "defaultHeaderFont";
                        break;
                    }
                    case 15: {
                        objectArray = objectArray2;
                        objectArray2[1] = "closeTabIcon";
                        break;
                    }
                    case 16: {
                        objectArray = objectArray2;
                        objectArray2[1] = "comboTabIcon";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }

            public static interface DragAndDrop {
                public static final Color STRIPE_BACKGROUND = JBColor.namedColor("ToolWindow.Button.DragAndDrop.stripeBackground", DragAndDrop.Area.BACKGROUND);
                public static final Color BUTTON_DROP_BACKGROUND = JBColor.namedColor("ToolWindow.Button.DragAndDrop.buttonDropBackground", DragAndDrop.Area.BACKGROUND);
                public static final Color BUTTON_FLOATING_BACKGROUND = JBColor.namedColor("ToolWindow.Button.DragAndDrop.buttonFloatingBackground", ActionButton.pressedBackground());
                public static final Color BUTTON_DROP_BORDER = JBColor.namedColor("ToolWindow.Button.DragAndDrop.buttonDropBorderColor", new JBColor(4226034, 5540599));
                public static final Color AREA_BACKGROUND = JBColor.namedColor("ToolWindow.DragAndDrop.areaBackground", new JBColor(10534392, 3566287));
            }
        }

        public static final class TextField {
            @NotNull
            public static Dimension minimumSize() {
                JBDimension jBDimension = JBUI.size("TextField.minimumSize", JBUI.size(49, 24));
                if (jBDimension == null) {
                    TextField.$$$reportNull$$$0(0);
                }
                return jBDimension;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/JBUI$CurrentTheme$TextField", "minimumSize"));
            }
        }

        public static final class StatusBar {
            public static final Color BACKGROUND = JBColor.namedColor("StatusBar.background", JBColor.PanelBackground);
            public static final Color BORDER_COLOR = JBColor.namedColor("StatusBar.borderColor", Gray.x91);

            @Deprecated
            public static Color hoverBackground() {
                return Widget.HOVER_BACKGROUND;
            }

            @NotNull
            public static Insets hoverInsets() {
                JBInsets jBInsets = JBUI.insets("StatusBar.Widget.hoverInsets", JBUI.insets(3, 4, 1, 4));
                if (jBInsets == null) {
                    StatusBar.$$$reportNull$$$0(0);
                }
                return jBInsets;
            }

            @NotNull
            public static Font font() {
                Font font = JBUI.getFontWithSizeOffset(StatusBar.fontSizeOffsetKey(), StatusBar.defaultFont());
                if (font == null) {
                    StatusBar.$$$reportNull$$$0(1);
                }
                return font;
            }

            @NotNull
            public static String fontSizeOffsetKey() {
                return "StatusBar.fontSizeOffset";
            }

            @NotNull
            public static JBFont defaultFont() {
                JBFont jBFont = JBFont.label();
                if (jBFont == null) {
                    StatusBar.$$$reportNull$$$0(2);
                }
                return jBFont;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$StatusBar";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "hoverInsets";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "font";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "defaultFont";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }

            public static interface Widget {
                public static final Color FOREGROUND = JBColor.namedColor("StatusBar.Widget.foreground", UIUtil.getLabelForeground());
                public static final Color HOVER_FOREGROUND = JBColor.namedColor("StatusBar.Widget.hoverForeground", UIUtil.getLabelForeground());
                public static final Color HOVER_BACKGROUND = JBColor.namedColor("StatusBar.Widget.hoverBackground", ActionButton.hoverBackground());
                public static final Color PRESSED_FOREGROUND = JBColor.namedColor("StatusBar.Widget.pressedForeground", UIUtil.getLabelForeground());
                public static final Color PRESSED_BACKGROUND = JBColor.namedColor("StatusBar.Widget.pressedBackground", ActionButton.pressedBackground());

                public static Border iconBorder() {
                    return NamedBorderKt.withName(new JBEmptyBorder((Insets)JBUI.insets(Widget.insetsKey(), JBUI.isNewUI() ? JBUI.insets(6, 8) : JBUI.insets(0, 4))), Widget.iconBorderName());
                }

                @NotNull
                public static String iconBorderName() {
                    return "StatusBar.Widget.iconBorder";
                }

                public static Border border() {
                    return NamedBorderKt.withName(new JBEmptyBorder((Insets)JBUI.insets(Widget.insetsKey(), JBUI.isNewUI() ? JBUI.insets(6, 8) : JBUI.insets(0, 6))), Widget.borderName());
                }

                @NotNull
                public static String borderName() {
                    return "StatusBar.Widget.border";
                }

                @NotNull
                public static String insetsKey() {
                    return "StatusBar.Widget.widgetInsets";
                }
            }

            public static interface Breadcrumbs {
                public static final Color FOREGROUND = JBColor.namedColor("StatusBar.Breadcrumbs.foreground", Widget.FOREGROUND);
                public static final Color HOVER_FOREGROUND = JBColor.namedColor("StatusBar.Breadcrumbs.hoverForeground", UIUtil.getLabelForeground());
                public static final Color HOVER_BACKGROUND = JBColor.namedColor("StatusBar.Breadcrumbs.hoverBackground", ActionButton.hoverBackground());
                public static final Color SELECTION_FOREGROUND = JBColor.namedColor("StatusBar.Breadcrumbs.selectionForeground", List.Selection.foreground(true));
                public static final Color SELECTION_BACKGROUND = JBColor.namedColor("StatusBar.Breadcrumbs.selectionBackground", List.Selection.background(true));
                public static final Color SELECTION_INACTIVE_FOREGROUND = JBColor.namedColor("StatusBar.Breadcrumbs.selectionInactiveForeground", List.Selection.foreground(false));
                public static final Color SELECTION_INACTIVE_BACKGROUND = JBColor.namedColor("StatusBar.Breadcrumbs.selectionInactiveBackground", List.Selection.background(false));
                public static final Color FLOATING_BACKGROUND = JBColor.namedColor("StatusBar.Breadcrumbs.floatingBackground", List.BACKGROUND);
                public static final Color FLOATING_FOREGROUND = JBColor.namedColor("StatusBar.Breadcrumbs.floatingForeground", UIUtil.getLabelForeground());
                public static final JBValue CHEVRON_INSET = new JBValue.UIInteger("StatusBar.Breadcrumbs.chevronInset", 0);

                public static Insets floatingBorderInsets() {
                    return JBUI.insets("StatusBar.Breadcrumbs.floatingToolbarInsets", JBUI.isNewUI() ? JBUI.insets(8, 12) : JBUI.emptyInsets());
                }

                @NotNull
                public static Insets navBarInsets() {
                    JBInsets jBInsets = JBUI.insets(Breadcrumbs.navBarInsetsKey(), Breadcrumbs.defaultNavBarInsets());
                    if (jBInsets == null) {
                        Breadcrumbs.$$$reportNull$$$0(0);
                    }
                    return jBInsets;
                }

                @NotNull
                public static JBInsets defaultNavBarInsets() {
                    JBInsets jBInsets = JBUI.insets(3, 0, 4, 4);
                    if (jBInsets == null) {
                        Breadcrumbs.$$$reportNull$$$0(1);
                    }
                    return jBInsets;
                }

                @NotNull
                public static JBInsets itemInsets() {
                    JBInsets jBInsets = JBUI.insets("StatusBar.Breadcrumbs.itemInsets", JBUI.isNewUI() ? JBUI.emptyInsets() : JBUI.insets(2, 0));
                    if (jBInsets == null) {
                        Breadcrumbs.$$$reportNull$$$0(2);
                    }
                    return jBInsets;
                }

                @NotNull
                public static String navBarInsetsKey() {
                    return "StatusBar.Breadcrumbs.navBarInsets";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$StatusBar$Breadcrumbs";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "navBarInsets";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "defaultNavBarInsets";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "itemInsets";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            }
        }

        public static final class Spinner {
            @NotNull
            public static Dimension minimumSize() {
                JBDimension jBDimension = JBUI.size("Spinner.minimumSize", JBUI.size(72, 0));
                if (jBDimension == null) {
                    Spinner.$$$reportNull$$$0(0);
                }
                return jBDimension;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/JBUI$CurrentTheme$Spinner", "minimumSize"));
            }
        }

        public static final class ProgressBar {
            public static final Color PROGRESS = JBColor.namedColor("ProgressBar.progressColor", new JBColor(0x808080, 0xA0A0A0));
            public static final Color INDETERMINATE_START = JBColor.namedColor("ProgressBar.indeterminateStartColor", new JBColor(0xC4C4C4, 0x696969));
            public static final Color INDETERMINATE_END = JBColor.namedColor("ProgressBar.indeterminateEndColor", new JBColor(0x808080, 0x838383));
            public static final Color PASSED = JBColor.namedColor("ProgressBar.passedColor", new JBColor(5613418, 5144658));
            public static final Color WARNING = JBColor.namedColor("ProgressBar.warningColor", new JBColor(15771442, 14263107));
            public static final Color FAILED = JBColor.namedColor("ProgressBar.failedColor", new JBColor(15030117, 10243662));
            public static final Color PASSED_END = JBColor.namedColor("ProgressBar.passedEndColor", new JBColor(8317093, 6145167));
            public static final Color WARNING_END = JBColor.namedColor("ProgressBar.warningEndColor", new JBColor(15389345, 15389345));
            public static final Color FAILED_END = JBColor.namedColor("ProgressBar.failedEndColor", new JBColor(16486281, 16032416));
            public static final Color TRACK = JBColor.namedColor("ProgressBar.trackColor", new JBColor(5613418, 5144658));
        }

        public static interface Notification {
            public static final Color FOREGROUND = JBColor.namedColor("Notification.foreground", Label.foreground());
            public static final Color BACKGROUND = JBColor.namedColor("Notification.background", 16775377, 1914967);
            public static final Color ICON_HOVER_BACKGROUND = JBColor.namedColor("Notification.iconHoverBackground", ActionButton.hoverBorder());

            public static interface Error {
                public static final Color FOREGROUND = JBColor.namedColor("Notification.errorForeground", FOREGROUND);
                public static final Color BACKGROUND = JBColor.namedColor("Notification.errorBackground", 16115431, 5848385);
                public static final Color BORDER_COLOR = JBColor.namedColor("Notification.errorBorderColor", 14723241, 7554379);
            }
        }

        public static interface InlineBanner {
            public static final Color HOVER_BACKGROUND = JBColor.namedColor("InlineBanner.hoverBackground", ActionButton.hoverBorder());
            public static final Color PRESSED_BACKGROUND = JBColor.namedColor("InlineBanner.pressedBackground", ActionButton.pressedBackground());
        }

        public static interface IconBadge {
            public static final Color NEW_UI = JBColor.namedColor("IconBadge.newUiBackground", 9394917, 9394917);
            public static final Color ERROR = JBColor.namedColor("IconBadge.errorBackground", 15030117, 14376028);
            public static final Color WARNING = JBColor.namedColor("IconBadge.warningBackground", 0xFFAF0F, 15910236);
            public static final Color INFORMATION = JBColor.namedColor("IconBadge.infoBackground", 5803251, 5540599);
            public static final Color SUCCESS = JBColor.namedColor("IconBadge.successBackground", 5613418, 6270309);
        }

        public static interface DragAndDrop {
            public static final Color BORDER_COLOR = JBColor.namedColor("DragAndDrop.borderColor", 2520511, 3106250);
            public static final Color ROW_BACKGROUND = JBColor.namedColor("DragAndDrop.rowBackground", 645250854, 795200051);

            public static interface Area {
                public static final Color FOREGROUND = JBColor.namedColor("DragAndDrop.areaForeground", 0x787878, 0xBABABA);
                public static final Color BACKGROUND = JBColor.namedColor("DragAndDrop.areaBackground", 4029900, 4213335);
            }
        }

        public static interface Editor {
            public static final Color BORDER_COLOR = JBColor.namedColor("Editor.Toolbar.borderColor", JBColor.border());

            public static interface Gutter {
                public static int emptyAnnotationAreaWidth() {
                    return JBUI.getInt(Gutter.emptyAnnotationAreaWidthKey(), Gutter.defaultEmptyAnnotationAreaWidth());
                }

                @NotNull
                public static String emptyAnnotationAreaWidthKey() {
                    return "Editor.Gutter.emptyAnnotationAreaWidth";
                }

                public static int defaultEmptyAnnotationAreaWidth() {
                    return 4;
                }

                public static int gapAfterVcsMarkersWidth() {
                    return JBUI.getInt(Gutter.gapAfterVcsMarkersWidthKey(), Gutter.defaultGapAfterVcsMarkersWidth());
                }

                @NotNull
                public static String gapAfterVcsMarkersWidthKey() {
                    return "Editor.Gutter.gapAfterVcsMarkersWidth";
                }

                public static int defaultGapAfterVcsMarkersWidth() {
                    return 4;
                }

                public static int gapAfterLineNumbersWidth() {
                    return JBUI.getInt(Gutter.gapAfterLineNumbersWidthKey(), Gutter.defaultGapAfterLineNumbersWidth());
                }

                @NotNull
                public static String gapAfterLineNumbersWidthKey() {
                    return "Editor.Gutter.gapAfterLineNumbersWidth";
                }

                public static int defaultGapAfterLineNumbersWidth() {
                    return 4;
                }

                public static int gapAfterIconsWidth() {
                    return JBUI.getInt(Gutter.gapAfterIconsWidthKey(), Gutter.defaultGapAfterIconsWidth());
                }

                @NotNull
                public static String gapAfterIconsWidthKey() {
                    return "Editor.Gutter.gapAfterIconsWidth";
                }

                public static int defaultGapAfterIconsWidth() {
                    return 4;
                }
            }

            public static interface Notification {
                @NotNull
                public static JBInsets borderInsets() {
                    JBInsets jBInsets = JBUI.insets(Notification.borderInsetsKey(), JBUI.insets(10, 12));
                    if (jBInsets == null) {
                        Notification.$$$reportNull$$$0(0);
                    }
                    return jBInsets;
                }

                @NotNull
                public static String borderInsetsKey() {
                    return "Editor.Notification.borderInsets";
                }

                @NotNull
                public static JBInsets borderInsetsWithoutStatus() {
                    JBInsets jBInsets = JBUI.insets(Notification.borderInsetsKeyWithoutStatus(), JBUI.insets(Notification.borderInsetsKey(), JBUI.isNewUI() ? JBInsets.create(9, 16) : JBInsets.create(5, 10)));
                    if (jBInsets == null) {
                        Notification.$$$reportNull$$$0(1);
                    }
                    return jBInsets;
                }

                @NotNull
                public static String borderInsetsKeyWithoutStatus() {
                    return "Editor.Notification.WithoutStatus.borderInsets";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$Editor$Notification";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "borderInsets";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "borderInsetsWithoutStatus";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            }

            public static interface Tooltip {
                public static final Color BACKGROUND = JBColor.namedColor("Editor.ToolTip.background", com.intellij.util.ui.JBUI$CurrentTheme$Tooltip.BACKGROUND);
                public static final Color FOREGROUND = JBColor.namedColor("Editor.ToolTip.foreground", com.intellij.util.ui.JBUI$CurrentTheme$Tooltip.FOREGROUND);
                public static final Color BORDER = JBColor.namedColor("Editor.ToolTip.border", 13225174, 4408650);
                public static final Color ERROR_BACKGROUND = JBColor.namedColor("Editor.ToolTip.errorBackground", 0, 0);
                public static final Color ERROR_BORDER = JBColor.namedColor("Editor.ToolTip.errorBorder", 0, 0);
                public static final Color SUCCESS_BACKGROUND = JBColor.namedColor("Editor.ToolTip.successBackground", 15924467, 2438695);
                public static final Color SUCCESS_BORDER = JBColor.namedColor("Editor.ToolTip.successBorder", 11525048, 3625529);
                public static final Color WARNING_BACKGROUND = JBColor.namedColor("Editor.ToolTip.warningBackground", 16774878, 0x3D3223);
                public static final Color WARNING_BORDER = JBColor.namedColor("Editor.ToolTip.warningBorder", 16700023, 6180147);
                public static final Color ICON_HOVER_BACKGROUND = JBColor.namedColor("Editor.ToolTip.iconHoverBackground", ActionButton.hoverBorder());
                public static final Color SELECTION_BACKGROUND = JBColor.namedColor("Editor.ToolTip.selectionBackground", 15461616, 2829616);
            }

            public static interface SearchReplaceModePanel {
                @NotNull
                public static Insets borderInsets() {
                    JBInsets jBInsets = JBUI.insets(SearchReplaceModePanel.borderInsetsKey(), JBUI.insets(7, 3));
                    if (jBInsets == null) {
                        SearchReplaceModePanel.$$$reportNull$$$0(0);
                    }
                    return jBInsets;
                }

                @NotNull
                public static String borderInsetsKey() {
                    return "Editor.SearchReplaceModePanel.borderInsets";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/JBUI$CurrentTheme$Editor$SearchReplaceModePanel", "borderInsets"));
                }
            }

            public static interface ReplaceToolbar {
                @NotNull
                public static Insets borderInsets() {
                    JBInsets jBInsets = JBUI.insets(ReplaceToolbar.borderInsetsKey(), JBUI.isNewUI() ? JBUI.insetsTop(10) : JBUI.insetsTop(3));
                    if (jBInsets == null) {
                        ReplaceToolbar.$$$reportNull$$$0(0);
                    }
                    return jBInsets;
                }

                @NotNull
                public static String borderInsetsKey() {
                    return "Editor.ReplaceToolbar.borderInsets";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/JBUI$CurrentTheme$Editor$ReplaceToolbar", "borderInsets"));
                }
            }

            public static interface SearchToolbar {
                @NotNull
                public static Insets borderInsets() {
                    JBInsets jBInsets = JBUI.insets(SearchToolbar.borderInsetsKey(), JBUI.isNewUI() ? JBUI.insetsTop(3) : JBUI.emptyInsets());
                    if (jBInsets == null) {
                        SearchToolbar.$$$reportNull$$$0(0);
                    }
                    return jBInsets;
                }

                @NotNull
                public static String borderInsetsKey() {
                    return "Editor.SearchToolbar.borderInsets";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/JBUI$CurrentTheme$Editor$SearchToolbar", "borderInsets"));
                }
            }

            public static interface SearchField {
                @NotNull
                public static Insets borderInsets() {
                    JBInsets jBInsets = JBUI.insets(SearchField.borderInsetsKey(), JBUI.isNewUI() ? JBUI.insets(7, 10, 7, 8) : JBUI.insets(SystemInfo.isLinux ? 2 : 1));
                    if (jBInsets == null) {
                        SearchField.$$$reportNull$$$0(0);
                    }
                    return jBInsets;
                }

                @NotNull
                public static String borderInsetsKey() {
                    return "Editor.SearchField.borderInsets";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/JBUI$CurrentTheme$Editor$SearchField", "borderInsets"));
                }
            }
        }

        public static final class EditorTabs {
            @NotNull
            public static Color underlineColor() {
                JBColor jBColor = JBColor.namedColor("EditorTabs.underlineColor", DefaultTabs.underlineColor());
                if (jBColor == null) {
                    EditorTabs.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            public static int underlineHeight() {
                return JBUI.uiIntValue(EditorTabs.underlineHeightKey(), Math.round(DefaultTabs.UNDERLINE_HEIGHT.getUnscaled())).get();
            }

            public static String underlineHeightKey() {
                return "EditorTabs.underlineHeight";
            }

            public static int underlineArc() {
                return JBUI.getInt("EditorTabs.underlineArc", 0);
            }

            @NotNull
            public static Color inactiveUnderlineColor() {
                JBColor jBColor = JBColor.namedColor("EditorTabs.inactiveUnderlineColor", DefaultTabs.inactiveUnderlineColor());
                if (jBColor == null) {
                    EditorTabs.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            public static Color underlinedTabBackground() {
                return UIManager.getColor("EditorTabs.underlinedTabBackground");
            }

            public static Insets tabInsets() {
                return JBUI.insets(EditorTabs.tabInsetsKey(), JBUI.isNewUI() ? JBUI.insets(-7, 8) : JBUI.insets(0, 4));
            }

            public static String tabInsetsKey() {
                return "EditorTabs.tabInsets";
            }

            public static Insets verticalTabInsets() {
                return JBUI.insets(EditorTabs.verticalTabInsetsKey(), JBUI.isNewUI() ? JBUI.insets(-2, 8) : JBUI.insets(0, 4));
            }

            public static String verticalTabInsetsKey() {
                return "EditorTabs.verticalTabInsets";
            }

            public static Insets tabContentInsets(@Nullable Boolean actionsOnTheRight) {
                if (actionsOnTheRight == null) {
                    return JBUI.insets(EditorTabs.tabContentInsetsActionsNoneKey(), JBUI.isNewUI() ? JBUI.insetsLeft(4) : JBUI.insets(0, 4));
                }
                if (actionsOnTheRight.booleanValue()) {
                    return JBUI.insets(EditorTabs.tabContentInsetsActionsRightKey(), JBUI.isNewUI() ? JBUI.insets(0, 4, 0, 6) : JBUI.insets(0, 4, 0, 2));
                }
                return JBUI.insets(EditorTabs.tabContentInsetsActionsLeftKey(), JBUI.isNewUI() ? JBUI.insetsLeft(6) : JBUI.insets(0, 6, 0, 4));
            }

            public static String tabContentInsetsActionsRightKey() {
                return "EditorTabs.tabContentActionsRightInsets";
            }

            public static String tabContentInsetsActionsLeftKey() {
                return "EditorTabs.tabContentActionsLeftInsets";
            }

            public static String tabContentInsetsActionsNoneKey() {
                return "EditorTabs.tabContentActionsNoneInsets";
            }

            @NotNull
            public static Color borderColor() {
                JBColor jBColor = JBColor.namedColor("EditorTabs.borderColor", DefaultTabs.borderColor());
                if (jBColor == null) {
                    EditorTabs.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            @NotNull
            public static Color background() {
                JBColor jBColor = JBColor.namedColor("EditorTabs.background", DefaultTabs.background());
                if (jBColor == null) {
                    EditorTabs.$$$reportNull$$$0(3);
                }
                return jBColor;
            }

            @NotNull
            public static Color hoverBackground() {
                JBColor jBColor = JBColor.namedColor("EditorTabs.hoverBackground", DefaultTabs.hoverBackground());
                if (jBColor == null) {
                    EditorTabs.$$$reportNull$$$0(4);
                }
                return jBColor;
            }

            @NotNull
            public static Color hoverBackground(boolean selected, boolean active) {
                String key = selected ? (active ? "EditorTabs.hoverSelectedBackground" : "EditorTabs.hoverSelectedInactiveBackground") : (active ? "EditorTabs.hoverBackground" : "EditorTabs.hoverInactiveBackground");
                JBColor jBColor = JBColor.namedColor(key, selected ? Gray.TRANSPARENT : DefaultTabs.hoverBackground());
                if (jBColor == null) {
                    EditorTabs.$$$reportNull$$$0(5);
                }
                return jBColor;
            }

            @NotNull
            public static Color inactiveColoredFileBackground() {
                JBColor jBColor = JBColor.namedColor("EditorTabs.inactiveColoredFileBackground", DefaultTabs.inactiveColoredTabBackground());
                if (jBColor == null) {
                    EditorTabs.$$$reportNull$$$0(6);
                }
                return jBColor;
            }

            @NotNull
            public static Color underlinedTabForeground() {
                JBColor jBColor = JBColor.namedColor("EditorTabs.underlinedTabForeground", DefaultTabs.underlinedTabForeground());
                if (jBColor == null) {
                    EditorTabs.$$$reportNull$$$0(7);
                }
                return jBColor;
            }

            @NotNull
            public static Font font() {
                Font font = JBUI.getFontWithSizeOffset(EditorTabs.fontSizeOffsetKey(), EditorTabs.defaultFont());
                if (font == null) {
                    EditorTabs.$$$reportNull$$$0(8);
                }
                return font;
            }

            public static String fontSizeOffsetKey() {
                return "EditorTabs.fontSizeOffset";
            }

            @NotNull
            public static JBFont defaultFont() {
                JBFont jBFont = JBFont.label();
                if (jBFont == null) {
                    EditorTabs.$$$reportNull$$$0(9);
                }
                return jBFont;
            }

            public static float unselectedAlpha() {
                return JBUI.getFloat("EditorTabs.unselectedAlpha", 1.0f);
            }

            public static float unselectedBlend() {
                return JBUI.getFloat("EditorTabs.unselectedBlend", 1.0f);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$EditorTabs";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "underlineColor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "inactiveUnderlineColor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "borderColor";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "background";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "hoverBackground";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "inactiveColoredFileBackground";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "underlinedTabForeground";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "font";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "defaultFont";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class DebuggerTabs {
            public static int underlineHeight() {
                return JBUI.uiIntValue("DebuggerTabs.underlineHeight", 2).get();
            }

            public static Color underlinedTabBackground() {
                return UIManager.getColor("DebuggerTabs.underlinedTabBackground");
            }

            public static String tabHeightKey() {
                return "DebuggerTabs.tabHeight";
            }

            public static int tabHeight() {
                return JBUI.getInt(DebuggerTabs.tabHeightKey(), 35);
            }

            @NotNull
            public static Font font() {
                Font font = JBUI.getFontWithSizeOffset(DebuggerTabs.fontSizeOffsetKey(), JBFont.label());
                if (font == null) {
                    DebuggerTabs.$$$reportNull$$$0(0);
                }
                return font;
            }

            public static String fontSizeOffsetKey() {
                return "DebuggerTabs.fontSizeOffset";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/JBUI$CurrentTheme$DebuggerTabs", "font"));
            }
        }

        public static final class DefaultTabs {
            public static final JBValue.UIInteger UNDERLINE_HEIGHT = new JBValue.UIInteger("DefaultTabs.underlineHeight", 3);

            @NotNull
            public static Color underlineColor() {
                JBColor jBColor = JBColor.namedColor("DefaultTabs.underlineColor", new JBColor(4228041, 4884679));
                if (jBColor == null) {
                    DefaultTabs.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @Deprecated(forRemoval=true)
            public static int underlineHeight() {
                return UNDERLINE_HEIGHT.get();
            }

            @NotNull
            public static Color inactiveUnderlineColor() {
                JBColor jBColor = JBColor.namedColor("DefaultTabs.inactiveUnderlineColor", new JBColor(10266552, 7633536));
                if (jBColor == null) {
                    DefaultTabs.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Color borderColor() {
                JBColor jBColor = JBColor.namedColor("DefaultTabs.borderColor", JBColor.border());
                if (jBColor == null) {
                    DefaultTabs.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            @NotNull
            public static Color background() {
                JBColor jBColor = JBColor.namedColor("DefaultTabs.background", new JBColor(0xECECEC, 3948353));
                if (jBColor == null) {
                    DefaultTabs.$$$reportNull$$$0(3);
                }
                return jBColor;
            }

            @NotNull
            public static Color hoverBackground() {
                JBColor jBColor = JBColor.namedColor("DefaultTabs.hoverBackground", new JBColor(ColorUtil.withAlpha(Color.BLACK, 0.1), ColorUtil.withAlpha(Color.BLACK, 0.35)));
                if (jBColor == null) {
                    DefaultTabs.$$$reportNull$$$0(4);
                }
                return jBColor;
            }

            public static Color underlinedTabBackground() {
                return UIManager.getColor("DefaultTabs.underlinedTabBackground");
            }

            @NotNull
            public static Color underlinedTabForeground() {
                JBColor jBColor = JBColor.namedColor("DefaultTabs.underlinedTabForeground", UIUtil.getLabelForeground());
                if (jBColor == null) {
                    DefaultTabs.$$$reportNull$$$0(5);
                }
                return jBColor;
            }

            @NotNull
            public static Color inactiveColoredTabBackground() {
                JBColor jBColor = JBColor.namedColor("DefaultTabs.inactiveColoredTabBackground", new JBColor(ColorUtil.withAlpha(Color.BLACK, 0.07), ColorUtil.withAlpha(new Color(3948353), 0.6)));
                if (jBColor == null) {
                    DefaultTabs.$$$reportNull$$$0(6);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$DefaultTabs";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "underlineColor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "inactiveUnderlineColor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "borderColor";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "background";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "hoverBackground";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "underlinedTabForeground";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "inactiveColoredTabBackground";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class CustomFrameDecorations {
            @NotNull
            public static Color separatorForeground() {
                Color color = Separator.color();
                if (color == null) {
                    CustomFrameDecorations.$$$reportNull$$$0(0);
                }
                return color;
            }

            @NotNull
            public static Color titlePaneButtonHoverBackground() {
                JBColor jBColor = JBColor.namedColor("TitlePane.Button.hoverBackground", new JBColor(ColorUtil.withAlpha(Color.BLACK, 0.1), ColorUtil.withAlpha(Color.WHITE, 0.1)));
                if (jBColor == null) {
                    CustomFrameDecorations.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Color titlePaneButtonPressBackground() {
                return CustomFrameDecorations.titlePaneButtonHoverBackground();
            }

            @NotNull
            public static Color titlePaneInactiveBackground() {
                JBColor jBColor = JBColor.namedColor("TitlePane.inactiveBackground", CustomFrameDecorations.titlePaneBackground());
                if (jBColor == null) {
                    CustomFrameDecorations.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            @NotNull
            public static Color titlePaneBackground(boolean active) {
                return active ? CustomFrameDecorations.titlePaneBackground() : CustomFrameDecorations.titlePaneInactiveBackground();
            }

            @NotNull
            public static Color titlePaneBackground() {
                JBColor jBColor = JBColor.namedColor("TitlePane.background", CustomFrameDecorations.paneBackground());
                if (jBColor == null) {
                    CustomFrameDecorations.$$$reportNull$$$0(3);
                }
                return jBColor;
            }

            @NotNull
            public static Color mainToolbarBackground(boolean active) {
                JBColor activeBG = JBColor.namedColor("MainToolbar.background", CustomFrameDecorations.titlePaneBackground());
                if (active) {
                    JBColor jBColor = activeBG;
                    if (jBColor == null) {
                        CustomFrameDecorations.$$$reportNull$$$0(4);
                    }
                    return jBColor;
                }
                JBColor jBColor = JBColor.namedColor("MainToolbar.inactiveBackground", activeBG);
                if (jBColor == null) {
                    CustomFrameDecorations.$$$reportNull$$$0(5);
                }
                return jBColor;
            }

            @NotNull
            public static Color titlePaneInfoForeground() {
                JBColor jBColor = JBColor.namedColor("TitlePane.infoForeground", new JBColor(0x616161, 0x919191));
                if (jBColor == null) {
                    CustomFrameDecorations.$$$reportNull$$$0(6);
                }
                return jBColor;
            }

            @NotNull
            public static Color titlePaneInactiveInfoForeground() {
                JBColor jBColor = JBColor.namedColor("TitlePane.inactiveInfoForeground", new JBColor(0xA6A6A6, 0x737373));
                if (jBColor == null) {
                    CustomFrameDecorations.$$$reportNull$$$0(7);
                }
                return jBColor;
            }

            @NotNull
            public static Color paneBackground() {
                JBColor jBColor = JBColor.namedColor("Panel.background", Gray.xCD);
                if (jBColor == null) {
                    CustomFrameDecorations.$$$reportNull$$$0(8);
                }
                return jBColor;
            }

            public static int menuPopupMinWidth() {
                return JBUI.scale(180);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$CustomFrameDecorations";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "separatorForeground";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "titlePaneButtonHoverBackground";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "titlePaneInactiveBackground";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "titlePaneBackground";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "mainToolbarBackground";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "titlePaneInfoForeground";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "titlePaneInactiveInfoForeground";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "paneBackground";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static interface SegmentedButton {
            public static final Color SELECTED_START_BORDER_COLOR = JBColor.namedColor("SegmentedButton.selectedStartBorderColor", Gray.xBF);
            public static final Color SELECTED_END_BORDER_COLOR = JBColor.namedColor("SegmentedButton.selectedEndBorderColor", Gray.xB8);
            public static final Color SELECTED_BUTTON_COLOR = JBColor.namedColor("SegmentedButton.selectedButtonColor", 0x555A5C);
            public static final Color FOCUSED_SELECTED_BUTTON_COLOR = JBColor.namedColor("SegmentedButton.focusedSelectedButtonColor", 14345453);
        }

        public static interface SearchOption {
            public static final JBColor BUTTON_SELECTED_BACKGROUND = JBColor.namedColor("SearchOption.selectedBackground", 14345453, 6054244);
            public static final JBColor BUTTON_SELECTED_PRESSED_BACKGROUND = JBColor.namedColor("SearchOption.selectedPressedBackground", ActionButton.pressedBackground());
            public static final JBColor BUTTON_SELECTED_HOVERED_BACKGROUND = JBColor.namedColor("SearchOption.selectedHoveredBackground", ActionButton.pressedBackground());
        }

        public static final class ComboBox {
            @NotNull
            public static Dimension minimumSize() {
                JBDimension jBDimension = JBUI.size("ComboBox.minimumSize", JBUI.size(49, 24));
                if (jBDimension == null) {
                    ComboBox.$$$reportNull$$$0(0);
                }
                return jBDimension;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/JBUI$CurrentTheme$ComboBox", "minimumSize"));
            }
        }

        public static final class Button {
            @NotNull
            public static Color buttonColorStart() {
                JBColor jBColor = JBColor.namedColor("Button.startBackground", JBColor.namedColor("Button.darcula.startColor", 0x555A5C));
                if (jBColor == null) {
                    Button.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color buttonColorEnd() {
                JBColor jBColor = JBColor.namedColor("Button.endBackground", JBColor.namedColor("Button.darcula.endColor", 4277832));
                if (jBColor == null) {
                    Button.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Color buttonForeground() {
                JBColor jBColor = JBColor.namedColor("Button.foreground", 0, 14672357);
                if (jBColor == null) {
                    Button.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            @NotNull
            public static Color buttonLoadingForeground() {
                JBColor jBColor = JBColor.namedColor("Button.loadingForeground", 8488340, 8817297);
                if (jBColor == null) {
                    Button.$$$reportNull$$$0(3);
                }
                return jBColor;
            }

            @NotNull
            public static Color defaultButtonColorStart() {
                JBColor jBColor = JBColor.namedColor("Button.default.startBackground", JBColor.namedColor("Button.darcula.defaultStartColor", 3690347));
                if (jBColor == null) {
                    Button.$$$reportNull$$$0(4);
                }
                return jBColor;
            }

            @NotNull
            public static Color defaultButtonColorEnd() {
                JBColor jBColor = JBColor.namedColor("Button.default.endBackground", JBColor.namedColor("Button.darcula.defaultEndColor", 2306371));
                if (jBColor == null) {
                    Button.$$$reportNull$$$0(5);
                }
                return jBColor;
            }

            @NotNull
            public static Color defaultButtonForeground() {
                JBColor jBColor = JBColor.namedColor("Button.default.foreground", 0xFFFFFF, 0xFFFFFF);
                if (jBColor == null) {
                    Button.$$$reportNull$$$0(6);
                }
                return jBColor;
            }

            @NotNull
            public static Color defaultButtonLoadingForeground() {
                JBColor jBColor = JBColor.namedColor("Button.default.loadingForeground", 13882843, 13553878);
                if (jBColor == null) {
                    Button.$$$reportNull$$$0(7);
                }
                return jBColor;
            }

            @NotNull
            public static Color focusBorderColor(boolean isDefaultButton) {
                JBColor jBColor = isDefaultButton ? JBColor.namedColor("Button.default.focusedBorderColor", JBColor.namedColor("Button.darcula.defaultFocusedOutlineColor", 8892378)) : JBColor.namedColor("Button.focusedBorderColor", JBColor.namedColor("Button.darcula.focusedOutlineColor", 8892378));
                if (jBColor == null) {
                    Button.$$$reportNull$$$0(8);
                }
                return jBColor;
            }

            @NotNull
            public static Color buttonOutlineColorStart(boolean isDefaultButton) {
                JBColor jBColor = isDefaultButton ? JBColor.namedColor("Button.default.startBorderColor", JBColor.namedColor("Button.darcula.outlineDefaultStartColor", Gray.xBF)) : JBColor.namedColor("Button.startBorderColor", JBColor.namedColor("Button.darcula.outlineStartColor", Gray.xBF));
                if (jBColor == null) {
                    Button.$$$reportNull$$$0(9);
                }
                return jBColor;
            }

            @NotNull
            public static Color buttonOutlineColorEnd(boolean isDefaultButton) {
                JBColor jBColor = isDefaultButton ? JBColor.namedColor("Button.default.endBorderColor", JBColor.namedColor("Button.darcula.outlineDefaultEndColor", Gray.xB8)) : JBColor.namedColor("Button.endBorderColor", JBColor.namedColor("Button.darcula.outlineEndColor", Gray.xB8));
                if (jBColor == null) {
                    Button.$$$reportNull$$$0(10);
                }
                return jBColor;
            }

            @NotNull
            public static Color disabledOutlineColor() {
                JBColor jBColor = JBColor.namedColor("Button.disabledBorderColor", JBColor.namedColor("Button.darcula.disabledOutlineColor", Gray.xCF));
                if (jBColor == null) {
                    Button.$$$reportNull$$$0(11);
                }
                return jBColor;
            }

            @NotNull
            public static Dimension minimumSize() {
                JBDimension jBDimension = JBUI.size("Button.minimumSize", JBUI.size(72, 24));
                if (jBDimension == null) {
                    Button.$$$reportNull$$$0(12);
                }
                return jBDimension;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$Button";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buttonColorStart";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buttonColorEnd";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buttonForeground";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buttonLoadingForeground";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "defaultButtonColorStart";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "defaultButtonColorEnd";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "defaultButtonForeground";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "defaultButtonLoadingForeground";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "focusBorderColor";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buttonOutlineColorStart";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buttonOutlineColorEnd";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[1] = "disabledOutlineColor";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[1] = "minimumSize";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }

            public static final class Split {

                public static final class Default {
                    @NotNull
                    public static final Color SEPARATOR_COLOR = JBColor.namedColor("Button.Split.default.separatorColor", 8957431, 8629500);
                    @NotNull
                    public static final Color ICON_COLOR = JBColor.namedColor("Button.Split.default.iconColor", 0xFFFFFF);
                }
            }
        }

        public static final class Banner {
            public static final Color INFO_BACKGROUND = JBColor.namedColor("Banner.infoBackground", 16120062, 2437709);
            public static final Color INFO_BORDER_COLOR = JBColor.namedColor("Banner.infoBorderColor", 12769020, 3494799);
            public static final Color SUCCESS_BACKGROUND = JBColor.namedColor("Banner.successBackground", 15924467, 2438695);
            public static final Color SUCCESS_BORDER_COLOR = JBColor.namedColor("Banner.successBorderColor", 0xC5E5CC, 3625529);
            public static final Color WARNING_BACKGROUND = JBColor.namedColor("Banner.warningBackground", 16775915, 0x3D3223);
            public static final Color WARNING_BORDER_COLOR = JBColor.namedColor("Banner.warningBorderColor", 16700023, 6180147);
            public static final Color ERROR_BACKGROUND = JBColor.namedColor("Banner.errorBackground", 0xFFF7F7, 4204841);
            public static final Color ERROR_BORDER_COLOR = JBColor.namedColor("Banner.errorBorderColor", 16438488, 6174776);
            public static final Color FOREGROUND = JBColor.namedColor("Banner.foreground", 0, 14672357);
        }

        public static final class ActionsList {
            public static final Color MNEMONIC_FOREGROUND = JBColor.namedColor("Component.infoForeground", new JBColor(Gray.x99, (Color)Gray.x78));

            @NotNull
            public static Insets numberMnemonicInsets() {
                JBInsets jBInsets = JBUI.insets("ActionsList.mnemonicsBorderInsets", JBUI.insets(0, 8, 1, 6));
                if (jBInsets == null) {
                    ActionsList.$$$reportNull$$$0(0);
                }
                return jBInsets;
            }

            @NotNull
            public static Insets mnemonicInsets() {
                JBInsets jBInsets = JBUI.insets("ActionsList.mnemonicsInsets", JBUI.insetsRight(8));
                if (jBInsets == null) {
                    ActionsList.$$$reportNull$$$0(1);
                }
                return jBInsets;
            }

            @NotNull
            public static Insets cellPadding() {
                JBInsets jBInsets = JBUI.insets("ActionsList.cellBorderInsets", JBUI.insets(1, 12));
                if (jBInsets == null) {
                    ActionsList.$$$reportNull$$$0(2);
                }
                return jBInsets;
            }

            public static int elementIconGap() {
                return new JBValue.UIInteger("ActionsList.icon.gap", 6).get();
            }

            public static int mnemonicIconGap() {
                return new JBValue.UIInteger("ActionsList.mnemonic.icon.gap", 6).get();
            }

            @NotNull
            public static Font applyStylesForNumberMnemonic(Font font) {
                if (SystemInfoRt.isWindows) {
                    HashMap attributes = new HashMap(font.getAttributes());
                    attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                    Font font2 = font.deriveFont(attributes);
                    if (font2 == null) {
                        ActionsList.$$$reportNull$$$0(3);
                    }
                    return font2;
                }
                Font font3 = font;
                if (font3 == null) {
                    ActionsList.$$$reportNull$$$0(4);
                }
                return font3;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$ActionsList";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "numberMnemonicInsets";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "mnemonicInsets";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cellPadding";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "applyStylesForNumberMnemonic";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class ActionButton {
            public static final Color SEPARATOR_COLOR = JBColor.namedColor("ActionButton.separatorColor", CustomFrameDecorations.separatorForeground());

            @NotNull
            public static Color pressedBackground() {
                JBColor jBColor = JBColor.namedColor("ActionButton.pressedBackground", Gray.xCF);
                if (jBColor == null) {
                    ActionButton.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color pressedBorder() {
                JBColor jBColor = JBColor.namedColor("ActionButton.pressedBorderColor", Gray.xCF);
                if (jBColor == null) {
                    ActionButton.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Color focusedBorder() {
                JBColor jBColor = JBColor.namedColor("ActionButton.focusedBorderColor", new JBColor(6469854, 6204624));
                if (jBColor == null) {
                    ActionButton.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            @NotNull
            public static Color hoverBackground() {
                JBColor jBColor = JBColor.namedColor("ActionButton.hoverBackground", Gray.xDF);
                if (jBColor == null) {
                    ActionButton.$$$reportNull$$$0(3);
                }
                return jBColor;
            }

            @NotNull
            public static Color hoverBorder() {
                JBColor jBColor = JBColor.namedColor("ActionButton.hoverBorderColor", Gray.xDF);
                if (jBColor == null) {
                    ActionButton.$$$reportNull$$$0(4);
                }
                return jBColor;
            }

            @NotNull
            public static Color hoverSeparatorColor() {
                JBColor jBColor = JBColor.namedColor("ActionButton.hoverSeparatorColor", new JBColor(Gray.xB3, (Color)Gray.x6B));
                if (jBColor == null) {
                    ActionButton.$$$reportNull$$$0(5);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$ActionButton";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "pressedBackground";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "pressedBorder";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "focusedBorder";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "hoverBackground";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "hoverBorder";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "hoverSeparatorColor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static final class Component {
            public static final Color FOCUSED_BORDER_COLOR = JBColor.namedColor("Component.focusedBorderColor", 8892378, 4615572);
            public static final JBValue ARROW_AREA_WIDTH = new JBValue.UIInteger("Component.arrowAreaWidth", 23);
        }
    }

    public static final class Panels {
        @NotNull
        public static BorderLayoutPanel simplePanel() {
            return new BorderLayoutPanel();
        }

        @NotNull
        public static BorderLayoutPanel simplePanel(Component comp) {
            BorderLayoutPanel borderLayoutPanel = Panels.simplePanel().addToCenter(comp);
            if (borderLayoutPanel == null) {
                Panels.$$$reportNull$$$0(0);
            }
            return borderLayoutPanel;
        }

        @NotNull
        public static BorderLayoutPanel simplePanel(int hgap, int vgap) {
            return new BorderLayoutPanel(hgap, vgap);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/JBUI$Panels", "simplePanel"));
        }
    }

    public static final class Borders {
        @NotNull
        public static JBEmptyBorder empty(int top, int left, int bottom, int right) {
            if (top == 0 && left == 0 && bottom == 0 && right == 0) {
                JBEmptyBorder jBEmptyBorder = JBEmptyBorder.SHARED_EMPTY_INSTANCE;
                if (jBEmptyBorder == null) {
                    Borders.$$$reportNull$$$0(0);
                }
                return jBEmptyBorder;
            }
            return new JBEmptyBorder(top, left, bottom, right);
        }

        @NotNull
        public static JBEmptyBorder empty(int topAndBottom, int leftAndRight) {
            return Borders.empty(topAndBottom, leftAndRight, topAndBottom, leftAndRight);
        }

        @NotNull
        public static JBEmptyBorder emptyTop(int offset) {
            return Borders.empty(offset, 0, 0, 0);
        }

        @NotNull
        public static JBEmptyBorder emptyLeft(int offset) {
            return Borders.empty(0, offset, 0, 0);
        }

        @NotNull
        public static JBEmptyBorder emptyBottom(int offset) {
            return Borders.empty(0, 0, offset, 0);
        }

        @NotNull
        public static JBEmptyBorder emptyRight(int offset) {
            return Borders.empty(0, 0, 0, offset);
        }

        @NotNull
        public static JBEmptyBorder empty() {
            return Borders.empty(0, 0, 0, 0);
        }

        @NotNull
        public static Border empty(int offsets) {
            return Borders.empty(offsets, offsets, offsets, offsets);
        }

        @NotNull
        public static Border empty(@NotNull Insets insets) {
            if (insets == null) {
                Borders.$$$reportNull$$$0(1);
            }
            if (JBInsets.isZero(insets)) {
                JBEmptyBorder jBEmptyBorder = JBEmptyBorder.SHARED_EMPTY_INSTANCE;
                if (jBEmptyBorder == null) {
                    Borders.$$$reportNull$$$0(2);
                }
                return jBEmptyBorder;
            }
            return new JBEmptyBorder(insets);
        }

        @NotNull
        public static Border customLine(Color color, int top, int left, int bottom, int right) {
            return new CustomLineBorder(color, new JBInsets(top, left, bottom, right));
        }

        @NotNull
        public static Border customLine(Color color, int thickness) {
            return Borders.customLine(color, thickness, thickness, thickness, thickness);
        }

        @NotNull
        public static Border customLine(Color color) {
            return Borders.customLine(color, 1);
        }

        @NotNull
        public static Border customLineTop(Color color) {
            return Borders.customLine(color, 1, 0, 0, 0);
        }

        @NotNull
        public static Border customLineLeft(Color color) {
            return Borders.customLine(color, 0, 1, 0, 0);
        }

        @NotNull
        public static Border customLineRight(Color color) {
            return Borders.customLine(color, 0, 0, 0, 1);
        }

        @NotNull
        public static Border customLineBottom(Color color) {
            return Borders.customLine(color, 0, 0, 1, 0);
        }

        @Nullable
        public static Border compound(@Nullable Border outside, @Nullable Border inside) {
            return inside == null ? outside : (outside == null ? inside : new CompoundBorder(outside, inside));
        }

        @Nullable
        public static Border compound(Border ... borders) {
            if (borders == null) {
                Borders.$$$reportNull$$$0(3);
            }
            Border result = null;
            for (Border border : borders) {
                if (border == null) continue;
                result = result == null ? border : new CompoundBorder(result, border);
            }
            return result;
        }

        @NotNull
        public static Border merge(@Nullable Border source, @NotNull Border extra, boolean extraIsOutside) {
            if (extra == null) {
                Borders.$$$reportNull$$$0(4);
            }
            if (source == null) {
                Border border = extra;
                if (border == null) {
                    Borders.$$$reportNull$$$0(5);
                }
                return border;
            }
            return new CompoundBorder(extraIsOutside ? extra : source, extraIsOutside ? source : extra);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/ui/JBUI$Borders";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "insets";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "borders";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extra";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "empty";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/ui/JBUI$Borders";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "merge";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "empty";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "compound";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "merge";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    public static final class Fonts {
        @NotNull
        public static JBFont label() {
            JBFont jBFont = JBFont.label();
            if (jBFont == null) {
                Fonts.$$$reportNull$$$0(0);
            }
            return jBFont;
        }

        @NotNull
        public static JBFont label(float size) {
            JBFont jBFont = JBFont.label().deriveFont(JBUIScale.scale(size));
            if (jBFont == null) {
                Fonts.$$$reportNull$$$0(1);
            }
            return jBFont;
        }

        @NotNull
        public static JBFont smallFont() {
            JBFont jBFont = JBFont.label().deriveFont(UIUtil.getFontSize(UIUtil.FontSize.SMALL));
            if (jBFont == null) {
                Fonts.$$$reportNull$$$0(2);
            }
            return jBFont;
        }

        @NotNull
        public static JBFont miniFont() {
            JBFont jBFont = JBFont.label().deriveFont(UIUtil.getFontSize(UIUtil.FontSize.MINI));
            if (jBFont == null) {
                Fonts.$$$reportNull$$$0(3);
            }
            return jBFont;
        }

        @NotNull
        public static JBFont create(@NonNls String fontFamily, int size) {
            JBFont jBFont = JBFont.create(new Font(fontFamily, 0, size));
            if (jBFont == null) {
                Fonts.$$$reportNull$$$0(4);
            }
            return jBFont;
        }

        @NotNull
        public static JBFont toolbarFont() {
            JBFont jBFont = SystemInfoRt.isMac ? Fonts.smallFont() : JBFont.label();
            if (jBFont == null) {
                Fonts.$$$reportNull$$$0(5);
            }
            return jBFont;
        }

        @NotNull
        public static JBFont toolbarSmallComboBoxFont() {
            return Fonts.label(11.0f);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/util/ui/JBUI$Fonts";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "label";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "smallFont";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "miniFont";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toolbarFont";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

