/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.Access;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import org.jetbrains.annotations.NotNull;

final class ByteArrayAccess
implements Access<byte[]> {
    private static final VarHandle LONG_HANDLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle INT_HANDLE = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
    @NotNull
    static final ByteArrayAccess INSTANCE = new ByteArrayAccess();

    private ByteArrayAccess() {
    }

    public long i64(byte[] input, int offset) {
        return LONG_HANDLE.get(input, offset);
    }

    public int i32(byte[] input, int offset) {
        return INT_HANDLE.get(input, offset);
    }

    public int i8(byte[] input, int offset) {
        return input[offset];
    }
}

