/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.AsyncLogKt;
import com.intellij.openapi.diagnostic.IdeaLogRecordFormatter;
import com.intellij.openapi.diagnostic.InMemoryHandler;
import com.intellij.openapi.diagnostic.LogEvent;
import com.intellij.openapi.diagnostic.LogLevel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RollingFileHandler;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public class JulLogger
extends Logger {
    public static final long LOG_FILE_SIZE_LIMIT = Long.getLong("idea.log.limit", 10000000L);
    public static final int LOG_FILE_COUNT = Integer.getInteger("idea.log.count", 12);
    private static final boolean CLEANER_DELAYED;
    private final java.util.logging.Logger myLogger;

    public JulLogger(java.util.logging.Logger delegate) {
        this.myLogger = delegate;
    }

    @VisibleForTesting
    @NotNull
    public final String getLoggerName() {
        String string = this.myLogger.getName();
        if (string == null) {
            JulLogger.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected final void logSevere(@NotNull String msg) {
        if (msg == null) {
            JulLogger.$$$reportNull$$$0(1);
        }
        this.logSevere(msg, null);
    }

    protected final void logSevere(@NotNull String msg, @Nullable Throwable t) {
        if (msg == null) {
            JulLogger.$$$reportNull$$$0(2);
        }
        AsyncLogKt.log(new LogEvent(this.myLogger, LogLevel.ERROR, msg, t));
    }

    @Override
    public boolean isTraceEnabled() {
        return this.myLogger.isLoggable(Level.FINER);
    }

    @Override
    public void trace(String message) {
        AsyncLogKt.log(new LogEvent(this.myLogger, LogLevel.TRACE, message, null));
    }

    @Override
    public void trace(@Nullable Throwable t) {
        AsyncLogKt.log(new LogEvent(this.myLogger, LogLevel.TRACE, "", t));
    }

    @Override
    public boolean isDebugEnabled() {
        return this.myLogger.isLoggable(Level.FINE);
    }

    @Override
    public void debug(String message, @Nullable Throwable t) {
        AsyncLogKt.log(new LogEvent(this.myLogger, LogLevel.DEBUG, message, t));
    }

    @Override
    public void info(String message, @Nullable Throwable t) {
        AsyncLogKt.log(new LogEvent(this.myLogger, LogLevel.INFO, message, t));
    }

    @Override
    public void warn(String message, @Nullable Throwable t) {
        AsyncLogKt.log(new LogEvent(this.myLogger, LogLevel.WARNING, message, t));
    }

    @Override
    public void error(String message, @Nullable Throwable t, String ... details) {
        if (details == null) {
            JulLogger.$$$reportNull$$$0(3);
        }
        String fullMessage = details.length > 0 ? message + "\nDetails: " + String.join((CharSequence)"\n", details) : message;
        AsyncLogKt.log(new LogEvent(this.myLogger, LogLevel.ERROR, fullMessage, t));
    }

    @Override
    public void setLevel(@NotNull LogLevel level) {
        if (level == null) {
            JulLogger.$$$reportNull$$$0(4);
        }
        this.myLogger.setLevel(level.getLevel());
    }

    public static void clearHandlers() {
        JulLogger.clearHandlers(java.util.logging.Logger.getLogger(""));
    }

    public static void clearHandlers(java.util.logging.Logger logger) {
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
        }
    }

    @ApiStatus.Internal
    public static void configureLogFileAndConsole(@NotNull Path logFilePath, boolean appendToFile, boolean enableConsoleLogger, boolean showDateInConsole, @Nullable Runnable onRotate, @Nullable Filter filter, @Nullable Path inMemoryLogPath) {
        if (logFilePath == null) {
            JulLogger.$$$reportNull$$$0(5);
        }
        java.util.logging.Logger rootLogger = java.util.logging.Logger.getLogger("");
        IdeaLogRecordFormatter layout = new IdeaLogRecordFormatter();
        rootLogger.addHandler(JulLogger.configureFileHandler(logFilePath, appendToFile, onRotate, LOG_FILE_SIZE_LIMIT, LOG_FILE_COUNT, layout, filter));
        if (enableConsoleLogger) {
            rootLogger.addHandler(JulLogger.configureConsoleHandler(showDateInConsole, layout, filter));
        }
        if (inMemoryLogPath != null) {
            rootLogger.addHandler(JulLogger.configureInMemoryHandler(inMemoryLogPath));
        }
    }

    private static Handler configureConsoleHandler(boolean showDateInConsole, IdeaLogRecordFormatter layout, @Nullable Filter filter) {
        OptimizedConsoleHandler consoleHandler = new OptimizedConsoleHandler();
        consoleHandler.setFormatter(new IdeaLogRecordFormatter(showDateInConsole, layout));
        consoleHandler.setLevel(Level.WARNING);
        if (filter != null) {
            consoleHandler.setFilter(filter);
        }
        return consoleHandler;
    }

    private static InMemoryHandler configureInMemoryHandler(Path logFilePath) {
        InMemoryHandler inMemoryHandler = new InMemoryHandler(logFilePath);
        inMemoryHandler.setFormatter(new IdeaLogRecordFormatter());
        inMemoryHandler.setLevel(Level.FINEST);
        return inMemoryHandler;
    }

    /*
     * WARNING - void declaration
     */
    private static RollingFileHandler configureFileHandler(@NotNull Path logFilePath, boolean appendToFile, @Nullable Runnable onRotate, long limit, int count, IdeaLogRecordFormatter layout, @Nullable Filter filter) {
        void filter2;
        if (logFilePath == null) {
            JulLogger.$$$reportNull$$$0(6);
        }
        RollingFileHandler fileHandler = new RollingFileHandler(logFilePath, limit, count, appendToFile, onRotate);
        fileHandler.setFormatter(layout);
        fileHandler.setLevel(Level.FINEST);
        if (filter2 != null) {
            fileHandler.setFilter((Filter)filter2);
        }
        return fileHandler;
    }

    public static Filter createFilter(@NotNull List<String> classesToFilter) {
        if (classesToFilter == null) {
            JulLogger.$$$reportNull$$$0(7);
        }
        return record -> {
            String loggerName = record.getLoggerName();
            boolean isFiltered = ContainerUtil.exists(classesToFilter, loggerName::startsWith);
            return !isFiltered || record.getLevel().intValue() > Level.FINE.intValue();
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean delayCleanerUntilIdeShutdownActivitiesFinished() throws Exception {
        Class<?> logManagerCleanerClass = Class.forName("java.util.logging.LogManager$Cleaner");
        Class<?> appShutdownHooks = Class.forName("java.lang.ApplicationShutdownHooks");
        Field hooksField = appShutdownHooks.getDeclaredField("hooks");
        hooksField.setAccessible(true);
        IdentityHashMap hooks = (IdentityHashMap)hooksField.get(null);
        Class<?> clazz = appShutdownHooks;
        synchronized (clazz) {
            for (Object o : hooks.keySet()) {
                if (!(o instanceof Thread) || !logManagerCleanerClass.isAssignableFrom(o.getClass())) continue;
                Thread logCloseThread = (Thread)o;
                ShutDownTracker.getInstance().registerShutdownTask(() -> {
                    AsyncLogKt.shutdownLogProcessing();
                    logCloseThread.run();
                });
                hooks.remove(o);
                return true;
            }
        }
        return false;
    }

    @TestOnly
    public static boolean isJulLoggerCleanerDelayed() {
        return CLEANER_DELAYED;
    }

    static {
        boolean delayed = false;
        try {
            delayed = JulLogger.delayCleanerUntilIdeShutdownActivitiesFinished();
        }
        catch (Exception e) {
            System.err.println("Be careful, logger will be shut down earlier than application: " + e.getMessage());
        }
        CLEANER_DELAYED = delayed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diagnostic/JulLogger";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logFilePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesToFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggerName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diagnostic/JulLogger";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "logSevere";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setLevel";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "configureLogFileAndConsole";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "configureFileHandler";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFilter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class OptimizedConsoleHandler
    extends ConsoleHandler {
        private OptimizedConsoleHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            if (this.isLoggable(record)) {
                super.publish(record);
            }
        }
    }
}

