/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class LowMemoryWatcherManager {
    private static final Logger LOG = Logger.getInstance(LowMemoryWatcherManager.class);
    private static final String MAJOR_GC_PATTERN = "g1 old generation";
    private static final long MIN_MEMORY_MARGIN = 0x500000L;
    private static final float MEMORY_NOTIFICATION_THRESHOLD = SystemProperties.getFloatProperty((String)"low.memory.watcher.notification.threshold", (float)0.95f);
    private static final boolean USE_EXPONENTIALLY_SMOOTHING_GC_TRACKING = SystemProperties.getBooleanProperty((String)"LowMemoryWatcherManager.USE_EXPONENTIALLY_SMOOTHING_GC_TRACKING", (boolean)true);
    private static final long WINDOW_SIZE_MS = SystemProperties.getLongProperty((String)"LowMemoryWatcherManager.WINDOW_SIZE_MS", (long)TimeUnit.SECONDS.toMillis(90L));
    private static final double GC_LOAD_THRESHOLD = SystemProperties.getFloatProperty((String)"LowMemoryWatcherManager.GC_LOAD_THRESHOLD", (float)0.15f);
    private static final long REGULAR_TRACKER_UPDATE_PERIOD_MS = SystemProperties.getLongProperty((String)"LowMemoryWatcherManager.REGULAR_TRACKER_UPDATE_PERIOD_MS", (long)TimeUnit.SECONDS.toMillis(15L));
    private static final boolean NOTIFY_LISTENERS_SYNCHRONOUSLY = SystemProperties.getBooleanProperty((String)"low.memory.watcher.sync", (boolean)false);
    private static final long THROTTLING_PERIOD_MS = SystemProperties.getLongProperty((String)"LowMemoryWatcherManager.THROTTLING_PERIOD_MS", (long)300L);
    private final CopyOnWriteArraySet<Listener> listeners;
    private final ExecutorService listenersNotificationPool;
    private final Future<?> memoryPoolMXBeansInitializationFuture;
    private final Object broadcastingLock;
    private Future<?> eventBroadcastingTaskSubmitted;
    private LowMemoryEvent eventToBroadcast;
    private boolean eventSent;
    private Future<?> periodicGcTimeTrackingFuture;
    private final GcTracker gcTracker;
    private final AtomicInteger idCounter;
    private final NotificationListener mxLowMemoryListener;

    public LowMemoryWatcherManager(@NotNull ExecutorService backendExecutorService) {
        if (backendExecutorService == null) {
            LowMemoryWatcherManager.$$$reportNull$$$0(0);
        }
        this.listeners = new CopyOnWriteArraySet();
        this.broadcastingLock = new Object();
        this.eventToBroadcast = null;
        this.eventSent = true;
        this.idCounter = new AtomicInteger();
        this.mxLowMemoryListener = new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object __) {
                boolean memoryThreshold = "java.management.memory.threshold.exceeded".equals(notification.getType());
                boolean memoryCollectionThreshold = "java.management.memory.collection.threshold.exceeded".equals(notification.getType());
                if (memoryThreshold || memoryCollectionThreshold) {
                    boolean gcOverloaded;
                    long accumulatedGcTime = LowMemoryWatcherManager.fetchMajorGcDurationAccumulated();
                    double gcLoadScore = LowMemoryWatcherManager.this.gcTracker.gcLoadScore(System.currentTimeMillis(), accumulatedGcTime);
                    boolean bl = gcOverloaded = gcLoadScore > GC_LOAD_THRESHOLD && memoryCollectionThreshold;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("LowMemoryNotification{gcTime: " + accumulatedGcTime + "ms, GC load: " + gcLoadScore + "}{threshold: " + memoryThreshold + ", collectionThreshold: " + memoryCollectionThreshold + "} -> " + (gcOverloaded ? "overloaded" : "not overloaded"));
                    }
                    LowMemoryWatcherManager.this.notifyListeners(LowMemoryWatcherManager.this.lowMemoryEvent(accumulatedGcTime, memoryThreshold, memoryCollectionThreshold, gcLoadScore, gcOverloaded));
                }
            }
        };
        long gcDurationMs = LowMemoryWatcherManager.fetchMajorGcDurationAccumulated();
        if (USE_EXPONENTIALLY_SMOOTHING_GC_TRACKING) {
            LOG.info("Use ExponentiallySmoothingTracker(" + WINDOW_SIZE_MS + " ms)");
            this.gcTracker = new ExponentiallySmoothingTracker(gcDurationMs, System.currentTimeMillis(), WINDOW_SIZE_MS);
        } else {
            LOG.info("Use WindowedSumTracker(" + WINDOW_SIZE_MS + " ms)");
            this.gcTracker = new WindowedSumTracker(gcDurationMs, System.currentTimeMillis(), WINDOW_SIZE_MS);
        }
        this.listenersNotificationPool = NOTIFY_LISTENERS_SYNCHRONOUSLY ? ConcurrencyUtil.newSameThreadExecutorService() : SequentialTaskExecutor.createSequentialApplicationPoolExecutor("LowMemoryWatcherManager", backendExecutorService);
        this.memoryPoolMXBeansInitializationFuture = this.initializeMXBeanListenersLater(backendExecutorService);
        this.addListener(event -> {
            if (event.memoryThresholdBreached || event.memoryThresholdBreachedAfterGC) {
                LowMemoryWatcher.onLowMemorySignalReceived(event.gcOverloaded);
            }
        });
    }

    @NotNull
    private Future<?> initializeMXBeanListenersLater(final @NotNull ExecutorService backendExecutorService) {
        if (backendExecutorService == null) {
            LowMemoryWatcherManager.$$$reportNull$$$0(1);
        }
        Future<?> future = backendExecutorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block8: {
                    try {
                        for (MemoryPoolMXBean bean : ManagementFactory.getMemoryPoolMXBeans()) {
                            if (bean.getType() != MemoryType.HEAP || !bean.isCollectionUsageThresholdSupported() || !bean.isUsageThresholdSupported()) continue;
                            long maxPoolCapacity = bean.getUsage().getMax();
                            long threshold = Math.min((long)((float)maxPoolCapacity * MEMORY_NOTIFICATION_THRESHOLD), maxPoolCapacity - 0x500000L);
                            LOG.info("Subscribing to MemoryPool[" + bean.getName() + "]{max: " + maxPoolCapacity + ", threshold: " + threshold + " (" + MEMORY_NOTIFICATION_THRESHOLD + " * max)}");
                            if (threshold <= 0L) continue;
                            bean.setUsageThreshold(threshold);
                            bean.setCollectionUsageThreshold(threshold);
                        }
                        ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).addNotificationListener(LowMemoryWatcherManager.this.mxLowMemoryListener, null, null);
                        if (REGULAR_TRACKER_UPDATE_PERIOD_MS > 0L) {
                            if (backendExecutorService instanceof ScheduledExecutorService) {
                                ScheduledExecutorService scheduler = (ScheduledExecutorService)backendExecutorService;
                                LOG.info("Schedule GC-time updating: each " + REGULAR_TRACKER_UPDATE_PERIOD_MS + "ms");
                                Object object = LowMemoryWatcherManager.this.broadcastingLock;
                                synchronized (object) {
                                    LowMemoryWatcherManager.this.periodicGcTimeTrackingFuture = scheduler.scheduleWithFixedDelay(() -> {
                                        long accumulatedGcTime = LowMemoryWatcherManager.fetchMajorGcDurationAccumulated();
                                        double gcLoadScore = LowMemoryWatcherManager.this.gcTracker.gcLoadScore(System.currentTimeMillis(), accumulatedGcTime);
                                        LowMemoryWatcherManager.this.notifyListeners(LowMemoryWatcherManager.this.lowMemoryEvent(accumulatedGcTime, false, false, gcLoadScore, false));
                                    }, REGULAR_TRACKER_UPDATE_PERIOD_MS, REGULAR_TRACKER_UPDATE_PERIOD_MS, TimeUnit.MILLISECONDS);
                                    break block8;
                                }
                            }
                            LOG.info("Skip regular GC time updating because " + backendExecutorService + "is not a ScheduledExecutorService");
                            break block8;
                        }
                        LOG.info("Regular GC time updating disabled (updatePeriod=" + REGULAR_TRACKER_UPDATE_PERIOD_MS + " < 0)");
                    }
                    catch (Throwable e) {
                        LOG.info("Errors initializing LowMemoryWatcher", e);
                    }
                }
            }

            public String toString() {
                return "initializeMXBeanListeners runnable";
            }
        });
        if (future == null) {
            LowMemoryWatcherManager.$$$reportNull$$$0(2);
        }
        return future;
    }

    public void addListener(@NotNull Listener listener) {
        if (listener == null) {
            LowMemoryWatcherManager.$$$reportNull$$$0(3);
        }
        this.listeners.add(listener);
    }

    public void removeListener(@NotNull Listener listener) {
        if (listener == null) {
            LowMemoryWatcherManager.$$$reportNull$$$0(4);
        }
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(@NotNull LowMemoryEvent newEvent) {
        if (newEvent == null) {
            LowMemoryWatcherManager.$$$reportNull$$$0(5);
        }
        Object object = this.broadcastingLock;
        synchronized (object) {
            int newEventPriority = LowMemoryEvent.priorityOf(newEvent);
            int currentEventPriority = LowMemoryEvent.priorityOf(this.eventToBroadcast);
            if (this.eventSent) {
                boolean throttlingPeriodElapsed;
                long elapsedSinceLastEventMs = LowMemoryEvent.elapsedSinceMs(newEvent, this.eventToBroadcast);
                boolean bl = throttlingPeriodElapsed = elapsedSinceLastEventMs >= THROTTLING_PERIOD_MS;
                if (newEventPriority > currentEventPriority || throttlingPeriodElapsed) {
                    this.eventToBroadcast = newEvent;
                    this.eventSent = false;
                    this.eventBroadcastingTaskSubmitted = this.listenersNotificationPool.submit(() -> {
                        LowMemoryEvent eventToBroadcast;
                        Iterator<Listener> iterator2 = this.broadcastingLock;
                        synchronized (iterator2) {
                            if (this.eventToBroadcast == null || this.eventSent) {
                                return;
                            }
                            eventToBroadcast = this.eventToBroadcast;
                            this.eventSent = true;
                        }
                        for (Listener listener : this.listeners) {
                            listener.memoryStatus(eventToBroadcast);
                        }
                    });
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(newEvent + " submitted");
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug(newEvent + " is throttled out (" + elapsedSinceLastEventMs + "ms since last issued event)");
                }
            } else if (newEventPriority >= currentEventPriority) {
                this.eventToBroadcast = newEvent;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(newEvent + " replaced the older event");
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(newEvent + " is skipped (older " + this.eventToBroadcast + " is more important)");
            }
        }
    }

    private static long fetchMajorGcDurationAccumulated() {
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!gc.getName().toLowerCase().contains(MAJOR_GC_PATTERN)) continue;
            return gc.getCollectionTime();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Future<?> broadcastingTaskSubmitted;
        LowMemoryWatcher.stopAll();
        try {
            this.memoryPoolMXBeansInitializationFuture.get();
            ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).removeNotificationListener(this.mxLowMemoryListener);
        }
        catch (Exception e) {
            LOG.error(e);
        }
        Object object = this.broadcastingLock;
        synchronized (object) {
            if (this.periodicGcTimeTrackingFuture != null) {
                this.periodicGcTimeTrackingFuture.cancel(false);
                this.periodicGcTimeTrackingFuture = null;
            }
            broadcastingTaskSubmitted = this.eventBroadcastingTaskSubmitted;
            this.eventBroadcastingTaskSubmitted = null;
        }
        if (broadcastingTaskSubmitted != null) {
            try {
                broadcastingTaskSubmitted.get();
            }
            catch (Exception e) {
                LOG.error("Can't wait eventBroadcastingTaskSubmitted", e);
            }
        }
    }

    @NotNull
    private LowMemoryEvent lowMemoryEvent(long accumulatedGcTime, boolean memoryThresholdBreached, boolean memoryThresholdBreachedAfterGC, double gcLoadScore, boolean gcOverloaded) {
        return new LowMemoryEvent(this.idCounter.incrementAndGet(), System.currentTimeMillis(), accumulatedGcTime, memoryThresholdBreached, memoryThresholdBreachedAfterGC, gcLoadScore, gcOverloaded);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backendExecutorService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/LowMemoryWatcherManager";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/LowMemoryWatcherManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "initializeMXBeanListenersLater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initializeMXBeanListenersLater";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "notifyListeners";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Internal
    public static class LowMemoryEvent {
        public final long id;
        public final long timestampMs;
        public final long accumulatedGcTimeMs;
        public final boolean memoryThresholdBreached;
        public final boolean memoryThresholdBreachedAfterGC;
        public final double gcLoadScore;
        public final boolean gcOverloaded;

        private LowMemoryEvent(long id, long timestampMs, long accumulatedGcTimeMs, boolean memoryThresholdBreached, boolean memoryThresholdBreachedAfterGC, double gcLoadScore, boolean gcOverloaded) {
            this.id = id;
            this.timestampMs = timestampMs;
            this.accumulatedGcTimeMs = accumulatedGcTimeMs;
            this.memoryThresholdBreached = memoryThresholdBreached;
            this.memoryThresholdBreachedAfterGC = memoryThresholdBreachedAfterGC;
            this.gcLoadScore = gcLoadScore;
            this.gcOverloaded = gcOverloaded;
        }

        public String toString() {
            return "LowMemoryEvent{#" + this.id + ", timestampMs=" + this.timestampMs + ", accumulatedGcTimeMs=" + this.accumulatedGcTimeMs + ", memoryThresholdBreached=" + this.memoryThresholdBreached + ", memoryThresholdBreachedAfterGC=" + this.memoryThresholdBreachedAfterGC + ", gcLoad=" + this.gcLoadScore + ", gcOverloaded=" + this.gcOverloaded + '}';
        }

        private static long elapsedSinceMs(@NotNull LowMemoryEvent newEvent, @Nullable LowMemoryEvent oldEvent) {
            if (newEvent == null) {
                LowMemoryEvent.$$$reportNull$$$0(0);
            }
            if (oldEvent == null) {
                return newEvent.timestampMs;
            }
            return newEvent.timestampMs - oldEvent.timestampMs;
        }

        private static int priorityOf(@Nullable LowMemoryEvent event) {
            if (event == null) {
                return 0;
            }
            if (!event.gcOverloaded) {
                return 1;
            }
            return 2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newEvent", "com/intellij/openapi/util/LowMemoryWatcherManager$LowMemoryEvent", "elapsedSinceMs"));
        }
    }

    @ApiStatus.Internal
    @VisibleForTesting
    public static interface GcTracker {
        public double gcLoadScore(long var1, long var3);

        public void reset();
    }

    @ApiStatus.Internal
    @VisibleForTesting
    public static class ExponentiallySmoothingTracker
    implements GcTracker {
        private final long windowSizeMs;
        private long previousAccumulatedGcDurationMs;
        private long previousUpdateTimestampMs;
        private double ema;

        public ExponentiallySmoothingTracker(long initialGcDurationMs, long initialTimeMs, long windowSizeMs) {
            this.windowSizeMs = windowSizeMs;
            this.previousAccumulatedGcDurationMs = initialGcDurationMs;
            this.ema = initialGcDurationMs;
            this.previousUpdateTimestampMs = initialTimeMs;
        }

        @Override
        public synchronized double gcLoadScore(long currentTimeMs, long accumulatedGcDurationMs) {
            long gcDurationInLastMs = accumulatedGcDurationMs - this.previousAccumulatedGcDurationMs;
            if (gcDurationInLastMs >= 0L) {
                long sinceLastUpdateMs = currentTimeMs - this.previousUpdateTimestampMs;
                double decayFactor1_2 = Math.exp(-1.0 * (double)sinceLastUpdateMs / (double)this.windowSizeMs / 2.0);
                this.ema = (this.ema * decayFactor1_2 + (double)gcDurationInLastMs) * decayFactor1_2;
            }
            this.previousUpdateTimestampMs = currentTimeMs;
            this.previousAccumulatedGcDurationMs = accumulatedGcDurationMs;
            return this.ema / (double)this.windowSizeMs;
        }

        @Override
        public synchronized void reset() {
            this.ema = 0.0;
        }
    }

    @ApiStatus.Internal
    @VisibleForTesting
    public static class WindowedSumTracker
    implements GcTracker {
        private final long windowSizeMs;
        private long previousAccumulatedGcDurationMs;
        private long previousUpdateTimestampMs;
        private final Queue<GcPeriod> gcDurations = new LinkedList<GcPeriod>();

        public WindowedSumTracker(long initialGcDurationMs, long initialTimestampMs, long windowSizeMs) {
            this.previousAccumulatedGcDurationMs = initialGcDurationMs;
            this.windowSizeMs = windowSizeMs;
            this.previousUpdateTimestampMs = initialTimestampMs;
        }

        @Override
        public synchronized double gcLoadScore(long currentTimeMs, long accumulatedGcDurationMs) {
            if (this.previousUpdateTimestampMs < currentTimeMs - this.windowSizeMs) {
                this.previousUpdateTimestampMs = currentTimeMs;
                this.previousAccumulatedGcDurationMs = accumulatedGcDurationMs;
                this.gcDurations.clear();
                return 0.0;
            }
            long gcDurationDeltaMs = accumulatedGcDurationMs - this.previousAccumulatedGcDurationMs;
            this.previousAccumulatedGcDurationMs = accumulatedGcDurationMs;
            this.previousUpdateTimestampMs = currentTimeMs;
            if (gcDurationDeltaMs > 0L) {
                this.gcDurations.offer(new GcPeriod(currentTimeMs, gcDurationDeltaMs));
            }
            while (!this.gcDurations.isEmpty() && this.gcDurations.peek().timestamp < currentTimeMs - this.windowSizeMs) {
                this.gcDurations.poll();
            }
            long gcDurationInWindow = this.gcDurations.stream().mapToLong(period -> period.gcDurationMs).sum();
            return (double)gcDurationInWindow * 1.0 / (double)this.windowSizeMs;
        }

        @Override
        public synchronized void reset() {
            this.gcDurations.clear();
        }

        private static class GcPeriod {
            final long timestamp;
            final long gcDurationMs;

            GcPeriod(long timestamp, long gcDurationMs) {
                this.timestamp = timestamp;
                this.gcDurationMs = gcDurationMs;
            }
        }
    }

    @ApiStatus.Internal
    public static interface Listener {
        public void memoryStatus(@NotNull LowMemoryEvent var1);
    }
}

