/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.system.OS;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EnvironmentUtil {
    private static final String DESKTOP_STARTUP_ID = "DESKTOP_STARTUP_ID";
    private static final String MAC_OS_LOCALE_PATH = "/usr/share/locale";
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final String DISABLE_OMZ_AUTO_UPDATE = "DISABLE_AUTO_UPDATE";
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final String BASH_EXECUTABLE_NAME = "bash";
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final String SHELL_VARIABLE_NAME = "SHELL";
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final String SHELL_LOGIN_ARGUMENT = "-l";
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final String SHELL_COMMAND_ARGUMENT = "-c";
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final String SHELL_SOURCE_COMMAND = "source";
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final String SHELL_ENV_COMMAND = "/usr/bin/env";
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final String ENV_ZERO_ARGUMENT = "-0";
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final String MacOS_LOADER_BINARY = "printenv";
    private static final AtomicReference<CompletableDeferred<Map<String, String>>> ourEnvGetter = new AtomicReference();
    private static final Pattern pattern = Pattern.compile("\\$(.*?)\\$");

    private EnvironmentUtil() {
    }

    @NotNull
    public static Map<String, String> getEnvironmentMap() {
        Map<String, String> map;
        CompletableDeferred<Map<String, String>> getter = ourEnvGetter.get();
        if (getter == null && !ourEnvGetter.compareAndSet(null, getter = CompletableDeferredKt.CompletableDeferred(EnvironmentUtil.getSystemEnv()))) {
            getter = ourEnvGetter.get();
        }
        try {
            Map<String, String> result;
            Map<String, String> map2 = result = getter.isCompleted() ? (Map<String, String>)getter.getCompleted() : (Map)FutureKt.asCompletableFuture((Deferred)getter).join();
            if (result.isEmpty()) {
                result = EnvironmentUtil.getSystemEnv();
                ourEnvGetter.set((CompletableDeferred<Map<String, String>>)CompletableDeferredKt.CompletableDeferred(result));
            }
            map = result;
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
        if (map == null) {
            EnvironmentUtil.$$$reportNull$$$0(0);
        }
        return map;
    }

    @ApiStatus.Internal
    public static void setEnvironmentLoader(@NotNull CompletableDeferred<Map<String, String>> loader) {
        if (loader == null) {
            EnvironmentUtil.$$$reportNull$$$0(1);
        }
        ourEnvGetter.set(loader);
    }

    private static Map<String, String> getSystemEnv() {
        if (OS.CURRENT == OS.Windows) {
            return Collections.unmodifiableMap(CollectionFactory.createCaseInsensitiveStringMap(System.getenv()));
        }
        if (OS.isGenericUnix()) {
            Map<String, String> env = System.getenv();
            if (env.containsKey(DESKTOP_STARTUP_ID)) {
                env = new HashMap<String, String>(env);
                env.remove(DESKTOP_STARTUP_ID);
                env = Collections.unmodifiableMap(env);
            }
            return env;
        }
        return System.getenv();
    }

    @Nullable
    public static String getValue(@NotNull String name) {
        if (name == null) {
            EnvironmentUtil.$$$reportNull$$$0(2);
        }
        return EnvironmentUtil.getEnvironmentMap().get(name);
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isValidName(@Nullable String name) {
        return name != null && !name.isEmpty() && name.indexOf(0) == -1 && name.indexOf(61, OS.CURRENT == OS.Windows ? 1 : 0) == -1;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isValidValue(@Nullable String value) {
        return value != null && value.indexOf(0) == -1;
    }

    @NotNull
    public static Map<String, String> parseEnv(String @NotNull [] lines) {
        if (lines == null) {
            EnvironmentUtil.$$$reportNull$$$0(3);
        }
        HashSet<String> toIgnore = new HashSet<String>(Arrays.asList("_", "PWD", "SHLVL"));
        Map<String, String> env = System.getenv();
        HashMap<String, String> newEnv = new HashMap<String, String>();
        for (String line : lines) {
            if (line.isEmpty()) continue;
            int pos = line.indexOf(61);
            if (pos <= 0) {
                throw new IllegalArgumentException("malformed: '" + line + "'");
            }
            String name = line.substring(0, pos);
            if (!toIgnore.contains(name)) {
                newEnv.put(name, line.substring(pos + 1));
                continue;
            }
            if (!env.containsKey(name)) continue;
            newEnv.put(name, env.get(name));
        }
        HashMap<String, String> hashMap = newEnv;
        if (hashMap == null) {
            EnvironmentUtil.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    private static boolean checkIfLocaleAvailable(String candidateLanguageTerritory) {
        return ContainerUtil.exists(Locale.getAvailableLocales(), l -> Objects.equals(l.toString(), candidateLanguageTerritory)) && (OS.CURRENT != OS.macOS || Files.exists(Paths.get(MAC_OS_LOCALE_PATH, candidateLanguageTerritory), new LinkOption[0]));
    }

    @NotNull
    public static String setLocaleEnv(@NotNull Map<String, String> env, @NotNull Charset charset) {
        String languageTerritoryFromLocale;
        if (env == null) {
            EnvironmentUtil.$$$reportNull$$$0(5);
        }
        if (charset == null) {
            EnvironmentUtil.$$$reportNull$$$0(6);
        }
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String languageTerritory = "en_US";
        if (!language.isEmpty() && !country.isEmpty() && EnvironmentUtil.checkIfLocaleAvailable(languageTerritoryFromLocale = language + '_' + country)) {
            languageTerritory = languageTerritoryFromLocale;
        }
        String result = languageTerritory + '.' + charset.name();
        env.put("LC_CTYPE", result);
        String string = result;
        if (string == null) {
            EnvironmentUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static void inlineParentOccurrences(@NotNull Map<String, String> envs) {
        if (envs == null) {
            EnvironmentUtil.$$$reportNull$$$0(8);
        }
        EnvironmentUtil.inlineParentOccurrences(envs, EnvironmentUtil.getEnvironmentMap());
    }

    public static void inlineParentOccurrences(@NotNull Map<String, String> envs, @NotNull Map<String, String> parentEnv) {
        if (envs == null) {
            EnvironmentUtil.$$$reportNull$$$0(9);
        }
        if (parentEnv == null) {
            EnvironmentUtil.$$$reportNull$$$0(10);
        }
        Comparator keyComparator = SystemInfoRt.isWindows ? String.CASE_INSENSITIVE_ORDER : Comparator.naturalOrder();
        TreeMap lookup = new TreeMap(keyComparator);
        lookup.putAll(envs);
        lookup.putAll(parentEnv);
        for (Map.Entry<String, String> entry : envs.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) continue;
            Matcher matcher = pattern.matcher(value);
            while (matcher.find()) {
                String group = matcher.group(1);
                String expanded = (String)lookup.get(group);
                if (expanded == null) continue;
                value = value.replace("$" + group + "$", expanded);
            }
            envs.put(key, value);
            lookup.put(key, value);
        }
    }

    public static boolean containsEnvKeySubstitution(String envKey, String val) {
        return ArrayUtil.find((Object[])val.split(File.pathSeparator), (Object)("$" + envKey + "$")) != -1;
    }

    @ApiStatus.Internal
    public static void appendSearchPath(@NotNull Map<String, String> env, @NotNull String envName, @NotNull String pathToAppend) {
        String currentPath;
        if (env == null) {
            EnvironmentUtil.$$$reportNull$$$0(11);
        }
        if (envName == null) {
            EnvironmentUtil.$$$reportNull$$$0(12);
        }
        if (pathToAppend == null) {
            EnvironmentUtil.$$$reportNull$$$0(13);
        }
        String newPath = (currentPath = env.get(envName)) != null ? currentPath + File.pathSeparator + pathToAppend : pathToAppend;
        env.put(envName, newPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/EnvironmentUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentEnv";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToAppend";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironmentMap";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/EnvironmentUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseEnv";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "setLocaleEnv";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setEnvironmentLoader";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseEnv";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setLocaleEnv";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "inlineParentOccurrences";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "appendSearchPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

