/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.BundleBaseKt;
import com.intellij.openapi.util.SystemInfoRt;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0007J:\u0010\u000f\u001a\u00070\u0007\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0017H\u0007\u00a2\u0006\u0002\u0010\u0018J6\u0010\u0019\u001a\u00070\u0007\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0017\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\u001aJK\u0010\u001b\u001a\u00070\u0007\u00a2\u0006\u0002\b\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00072\r\u0010\u001c\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\u00102\u0016\u0010\u0016\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0017\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0007J\u001d\u0010\u001f\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0007H\u0007J)\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00072\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0017\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010$J\u001e\u0010%\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\u00102\r\u0010#\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\u0010H\u0007J\u001e\u0010&\u001a\u00020\r2\u0014\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010(H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/BundleBase;", "", "<init>", "()V", "MNEMONIC", "", "MNEMONIC_STRING", "", "Lcom/intellij/openapi/util/NlsSafe;", "SHOW_LOCALIZED_MESSAGES", "", "L10N_MARKER", "assertOnMissedKeys", "", "doAssert", "partialMessage", "Lorg/jetbrains/annotations/Nls;", "bundle", "Ljava/util/ResourceBundle;", "key", "unassignedParams", "", "params", "", "(Ljava/util/ResourceBundle;Ljava/lang/String;I[Ljava/lang/Object;)Ljava/lang/String;", "message", "(Ljava/util/ResourceBundle;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "messageOrDefault", "defaultValue", "(Ljava/util/ResourceBundle;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "getDefaultMessage", "appendLocalizationSuffix", "result", "suffixToAppend", "format", "value", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "replaceMnemonicAmpersand", "setTranslationConsumer", "consumer", "Ljava/util/function/BiConsumer;", "intellij.platform.util"})
public final class BundleBase {
    @NotNull
    public static final BundleBase INSTANCE = new BundleBase();
    public static final char MNEMONIC = '\u001b';
    @NotNull
    public static final String MNEMONIC_STRING = "\u001b";
    @JvmField
    @ApiStatus.Internal
    public static final boolean SHOW_LOCALIZED_MESSAGES = Boolean.getBoolean("idea.l10n");
    @NotNull
    public static final String L10N_MARKER = "\ud83d\udd05";

    private BundleBase() {
    }

    @ApiStatus.Internal
    public final void assertOnMissedKeys(boolean doAssert) {
        BundleBaseKt.access$setAssertOnMissedKeys$p(doAssert);
    }

    @JvmStatic
    @NotNull
    public static final String partialMessage(@NotNull ResourceBundle bundle, @NotNull String key, int unassignedParams, @NotNull Object[] params) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (!(unassignedParams > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Object[] objectArray = Arrays.copyOf(params, params.length + unassignedParams);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        Object[] newParams = objectArray;
        String prefix = "#$$$TemplateParameter$$$#";
        String suffix = "#$$$/TemplateParameter$$$#";
        for (int i = 0; i < unassignedParams; ++i) {
            newParams[i + params.length] = prefix + i + suffix;
        }
        Object[] objectArray2 = newParams;
        String message = BundleBase.message(bundle, key, Arrays.copyOf(objectArray2, objectArray2.length));
        return StringsKt.replace$default((String)StringsKt.replace$default((String)BundleBaseKt.access$quotePattern(message), (String)prefix, (String)"{", (boolean)false, (int)4, null), (String)suffix, (String)"}", (boolean)false, (int)4, null);
    }

    @JvmStatic
    @NotNull
    public static final String message(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return BundleBaseKt.messageOrDefault(bundle, key, null, params);
    }

    @JvmStatic
    @NotNull
    public static final String messageOrDefault(@Nullable ResourceBundle bundle, @NotNull String key, @Nullable String defaultValue, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (bundle == null) {
            String string = defaultValue;
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
        return BundleBaseKt.messageOrDefault(bundle, key, defaultValue, params);
    }

    @JvmStatic
    @NotNull
    public static final String getDefaultMessage(@NotNull ResourceBundle bundle, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            Field field = ResourceBundle.class.getDeclaredField("parent");
            field.setAccessible(true);
            Object parentBundle = field.get(bundle);
            if (parentBundle instanceof ResourceBundle) {
                String string = ((ResourceBundle)parentBundle).getString(key);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                return string;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            BundleBaseKt.access$getLOG().warn("Cannot fetch default message with 'idea.l10n.english' enabled, by key '" + key + '\'');
        }
        return "undefined";
    }

    @ApiStatus.Internal
    @NotNull
    public final String appendLocalizationSuffix(@NotNull String result, @NotNull String suffixToAppend) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)suffixToAppend, (String)"suffixToAppend");
        for (String suffix : BundleBaseKt.access$getSUFFIXES$p()) {
            if (!StringsKt.endsWith$default((String)result, (String)suffix, (boolean)false, (int)2, null)) continue;
            return StringsKt.dropLast((String)result, (int)suffix.length()) + L10N_MARKER + suffix;
        }
        return result + suffixToAppend;
    }

    @JvmStatic
    @Contract(pure=true)
    @NotNull
    public static final String format(@NotNull String value, Object ... params) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (!(params.length == 0) && StringsKt.contains$default((CharSequence)value, (char)'{', (boolean)false, (int)2, null)) {
            String string2 = MessageFormat.format(value, Arrays.copyOf(params, params.length));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        } else {
            string = value;
        }
        return string;
    }

    @JvmStatic
    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static final String replaceMnemonicAmpersand(@Nullable String value) {
        if (value == null || !StringsKt.contains$default((CharSequence)value, (char)'&', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)value, (char)'\u001b', (boolean)false, (int)2, null)) {
            return value;
        }
        StringBuilder builder = new StringBuilder();
        boolean macMnemonic = StringsKt.contains$default((CharSequence)value, (CharSequence)"&&", (boolean)false, (int)2, null);
        boolean mnemonicAdded = false;
        block4: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\\': {
                    Comparable<StringBuilder> comparable;
                    if (i < value.length() - 1 && value.charAt(i + 1) == '&') {
                        builder.append('&');
                        comparable = i++;
                        continue block4;
                    }
                    comparable = builder.append(c);
                    continue block4;
                }
                case '&': {
                    if (i < value.length() - 1 && value.charAt(i + 1) == '&') {
                        if (SystemInfoRt.isMac && !mnemonicAdded) {
                            mnemonicAdded = true;
                            builder.append('\u001b');
                        }
                        ++i;
                    } else if (!(SystemInfoRt.isMac && macMnemonic || mnemonicAdded)) {
                        mnemonicAdded = true;
                        builder.append('\u001b');
                    }
                    Comparable<StringBuilder> comparable = Unit.INSTANCE;
                    continue block4;
                }
                default: {
                    Comparable<StringBuilder> comparable = builder.append(c);
                }
            }
        }
        return builder.toString();
    }

    @JvmStatic
    @TestOnly
    public static final void setTranslationConsumer(@Nullable BiConsumer<String, String> consumer) {
        BundleBaseKt.access$setTranslationConsumer$p(consumer);
    }
}

