/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.serialization.MutableAccessor;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.BeanBindingKt;
import com.intellij.util.xmlb.Converter;
import com.intellij.util.xmlb.XmlSerializerImpl;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007H\u0000\u001a \u0010\b\u001a\u0004\u0018\u00010\u00012\b\u0010\t\u001a\u0004\u0018\u00010\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0000\u001a\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0003H\u0000\u001a<\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00112\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007H\u0000\u001a\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u00012\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0000\u00a8\u0006\u0013"}, d2={"toJson", "Lkotlinx/serialization/json/JsonElement;", "bean", "", "accessor", "Lcom/intellij/util/xmlb/Accessor;", "converter", "Lcom/intellij/util/xmlb/Converter;", "valueToJson", "value", "", "valueClass", "Ljava/lang/Class;", "primitiveToJsonElement", "setFromJson", "", "data", "Lcom/intellij/serialization/MutableAccessor;", "fromJsonPrimitive", "intellij.platform.util"})
@SourceDebugExtension(value={"SMAP\nJsonHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonHelper.kt\ncom/intellij/util/xmlb/JsonHelperKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1#2:74\n*E\n"})
public final class JsonHelperKt {
    @NotNull
    public static final JsonElement toJson(@NotNull Object bean, @NotNull Accessor accessor, @Nullable Converter<Object> converter) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
        Object object = accessor.read(bean);
        if (object == null) {
            return (JsonElement)JsonNull.INSTANCE;
        }
        Object value = object;
        if (converter == null) {
            return JsonHelperKt.primitiveToJsonElement(value);
        }
        String string = converter.toString(value);
        if (string == null) {
            return (JsonElement)JsonNull.INSTANCE;
        }
        return (JsonElement)JsonElementKt.JsonPrimitive((String)string);
    }

    @Nullable
    public static final JsonElement valueToJson(@Nullable String value, @NotNull Class<?> valueClass) {
        Intrinsics.checkNotNullParameter(valueClass, (String)"valueClass");
        try {
            return value == null ? (JsonElement)JsonNull.INSTANCE : (valueClass == Integer.TYPE || valueClass == Integer.TYPE || valueClass == Integer.class ? (JsonElement)JsonElementKt.JsonPrimitive((Number)Integer.parseInt(value)) : (valueClass == Boolean.TYPE || valueClass == Boolean.TYPE || valueClass == Boolean.class ? (JsonElement)JsonElementKt.JsonPrimitive((Boolean)Boolean.parseBoolean(value)) : (valueClass == Double.TYPE || valueClass == Double.TYPE || valueClass == Double.class ? (JsonElement)JsonElementKt.JsonPrimitive((Number)Double.parseDouble(value)) : (valueClass == Float.TYPE || valueClass == Float.TYPE || valueClass == Float.class ? (JsonElement)JsonElementKt.JsonPrimitive((Number)Float.valueOf(Float.parseFloat(value))) : (valueClass == Long.TYPE || valueClass == Long.TYPE || valueClass == Long.class || Date.class.isAssignableFrom(valueClass) ? (JsonElement)JsonElementKt.JsonPrimitive((Number)Long.parseLong(value)) : (valueClass == Short.TYPE || valueClass == Short.TYPE || valueClass == Short.class ? (JsonElement)JsonElementKt.JsonPrimitive((Number)Short.parseShort(value)) : (JsonElement)JsonElementKt.JsonPrimitive((String)value)))))));
        }
        catch (NumberFormatException ignore) {
            return null;
        }
    }

    @NotNull
    public static final JsonElement primitiveToJsonElement(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        return object instanceof Date ? (JsonElement)JsonElementKt.JsonPrimitive((Number)((Date)value).getTime()) : (object instanceof Number ? (JsonElement)JsonElementKt.JsonPrimitive((Number)((Number)value)) : (object instanceof Boolean ? (JsonElement)JsonElementKt.JsonPrimitive((Boolean)((Boolean)value)) : (object instanceof String ? (JsonElement)JsonElementKt.JsonPrimitive((String)JDOMUtil.removeControlChars((String)value)) : (JsonElement)JsonElementKt.JsonPrimitive((String)value.toString()))));
    }

    public static final void setFromJson(@NotNull Object bean, @NotNull JsonElement data, @NotNull MutableAccessor accessor, @NotNull Class<?> valueClass, @Nullable Converter<Object> converter) {
        String string;
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
        Intrinsics.checkNotNullParameter(valueClass, (String)"valueClass");
        if (data == JsonNull.INSTANCE) {
            string = null;
        } else if (data instanceof JsonPrimitive) {
            string = ((JsonPrimitive)data).getContent();
        } else {
            BeanBindingKt.LOG.warn("JsonPrimitive is expected but got " + data);
            return;
        }
        String s = string;
        if (converter == null) {
            XmlSerializerImpl.doSet(bean, s, accessor, valueClass);
        } else {
            Object object;
            MutableAccessor mutableAccessor = accessor;
            Object object2 = bean;
            String string2 = s;
            if (string2 != null) {
                String string3 = string2;
                Object object3 = object2;
                MutableAccessor mutableAccessor2 = mutableAccessor;
                boolean bl = false;
                Object object4 = converter.fromString(s);
                mutableAccessor = mutableAccessor2;
                object2 = object3;
                object = object4;
            } else {
                object = null;
            }
            mutableAccessor.set(object2, object);
        }
    }

    @Nullable
    public static final Object fromJsonPrimitive(@NotNull JsonElement data, @NotNull Class<?> valueClass) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(valueClass, (String)"valueClass");
        return data instanceof JsonNull ? null : XmlSerializerImpl.convert(JsonElementKt.getJsonPrimitive((JsonElement)data).getContent(), valueClass);
    }
}

