/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.BundleBase;
import com.intellij.GetPolicy;
import com.intellij.IntelliJResourceBundle;
import com.intellij.openapi.application.DevTimeClassLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.text.OrdinalFormat;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0015\u0010\u000f\u001a\u00070\b\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0002\u001a;\u0010\u0012\u001a\u00070\b\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u000b\u0010\u0016\u001a\u00070\b\u00a2\u0006\u0002\b\u00132\u0012\u0010\u0017\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0018\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\u0010\u0019\u001aE\u0010\u001a\u001a\u00070\b\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\b2\r\u0010\u001c\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b\u00132\u0012\u0010\u0017\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0018\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\u0010\u001d\u001a@\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\b2\r\u0010\u001c\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b\u00132\u0012\u0010\u0017\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0018\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010\u001d\u001a\u001f\u0010\u001f\u001a\u00070\b\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u001b\u001a\u00020\bH\u0000\u001a\u0010\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"H\u0002\u001a*\u0010#\u001a\u00020\b2\b\b\u0001\u0010\u0016\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020%H\u0000\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\"\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "assertOnMissedKeys", "", "SUFFIXES", "", "", "[Ljava/lang/String;", "translationConsumer", "Ljava/util/function/BiConsumer;", "SHOW_DEFAULT_MESSAGES", "getPolicy", "Lcom/intellij/GetPolicy;", "quotePattern", "Lcom/intellij/openapi/util/NlsSafe;", "message", "postprocessValue", "Lorg/jetbrains/annotations/Nls;", "bundle", "Ljava/util/ResourceBundle;", "value", "params", "", "(Ljava/util/ResourceBundle;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "messageOrDefault", "key", "defaultValue", "(Ljava/util/ResourceBundle;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "messageOrDefaultForJdkBundle", "useDefaultValue", "isDevelopmentTime", "bundleClassLoader", "Ljava/lang/ClassLoader;", "postProcessResolvedValue", "resourceFound", "Lcom/intellij/IntelliJResourceBundle;", "intellij.platform.util"})
@SourceDebugExtension(value={"SMAP\nBundleBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BundleBase.kt\ncom/intellij/BundleBaseKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,318:1\n13#2:319\n*S KotlinDebug\n*F\n+ 1 BundleBase.kt\ncom/intellij/BundleBaseKt\n*L\n26#1:319\n*E\n"})
public final class BundleBaseKt {
    private static boolean assertOnMissedKeys;
    @NotNull
    private static final String[] SUFFIXES;
    @Nullable
    private static volatile BiConsumer<String, String> translationConsumer;
    private static final boolean SHOW_DEFAULT_MESSAGES;
    @NotNull
    private static final GetPolicy getPolicy;

    private static final Logger getLOG() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BundleBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    private static final String quotePattern(String message) {
        boolean inQuotes = false;
        StringBuilder sb = new StringBuilder(message.length() + 5);
        int n = message.length();
        for (int i = 0; i < n; ++i) {
            boolean needToQuote;
            char c = message.charAt(i);
            boolean bl = needToQuote = c == '{' || c == '}';
            if (needToQuote != inQuotes) {
                inQuotes = needToQuote;
                sb.append('\'');
            }
            StringBuilder stringBuilder = c == '\'' ? sb.append("''") : sb.append(c);
        }
        if (inQuotes) {
            sb.append('\'');
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String postprocessValue(@NotNull ResourceBundle bundle, @NotNull String value, @Nullable Object[] params) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = BundleBase.replaceMnemonicAmpersand(value);
        Intrinsics.checkNotNull((Object)string);
        String value2 = string;
        Object[] objectArray = params;
        if (objectArray == null || objectArray.length == 0 || !StringsKt.contains$default((CharSequence)value2, (char)'{', (boolean)false, (int)2, null)) {
            return value2;
        }
        Locale locale = bundle.getLocale();
        try {
            MessageFormat format = locale == null ? new MessageFormat(value2) : new MessageFormat(value2, locale);
            OrdinalFormat.apply((MessageFormat)format);
            String string2 = format.format(params);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return "!invalid format: `" + value2 + "`!";
        }
    }

    @NotNull
    public static final String messageOrDefault(@NotNull ResourceBundle bundle, @NotNull String key, @Nullable String defaultValue, @Nullable Object[] params) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!(bundle instanceof IntelliJResourceBundle) || ((IntelliJResourceBundle)bundle).getParent() != null) {
            return BundleBaseKt.messageOrDefaultForJdkBundle(bundle, key, defaultValue, params);
        }
        return ((IntelliJResourceBundle)bundle).getMessage(key, defaultValue, params);
    }

    private static final String messageOrDefaultForJdkBundle(ResourceBundle bundle, String key, String defaultValue, Object[] params) {
        String result;
        boolean resourceFound;
        block3: {
            String string;
            resourceFound = true;
            try {
                string = bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                resourceFound = false;
                String string2 = defaultValue;
                if (string2 == null) {
                    string2 = BundleBaseKt.useDefaultValue(bundle, key);
                }
                string = string2;
            }
            String value = string;
            Intrinsics.checkNotNull((Object)value);
            result = BundleBaseKt.postprocessValue(bundle, value, params);
            BiConsumer<String, String> biConsumer = translationConsumer;
            if (biConsumer == null) break block3;
            biConsumer.accept(key, result);
        }
        return !resourceFound ? result : (getPolicy == GetPolicy.APPEND_KEY ? BundleBase.INSTANCE.appendLocalizationSuffix(result, SHOW_DEFAULT_MESSAGES ? " (" + key + '=' + BundleBase.getDefaultMessage(bundle, key) + ')' : " (" + key + ')') : (SHOW_DEFAULT_MESSAGES ? BundleBase.INSTANCE.appendLocalizationSuffix(result, " (" + BundleBase.getDefaultMessage(bundle, key) + ')') : (BundleBase.SHOW_LOCALIZED_MESSAGES ? BundleBase.INSTANCE.appendLocalizationSuffix(result, "\ud83d\udd05") : result)));
    }

    @NotNull
    public static final String useDefaultValue(@NotNull ResourceBundle bundle, @NlsSafe @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (assertOnMissedKeys) {
            ClassLoader classLoader = bundle.getClass().getClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
            if (!BundleBaseKt.isDevelopmentTime(classLoader)) {
                BundleBaseKt.getLOG().error('\'' + key + "' is not found (baseBundleName=" + bundle.getBaseBundleName() + ", bundle=" + bundle + ')');
            }
        }
        return '!' + key + '!';
    }

    private static final boolean isDevelopmentTime(ClassLoader bundleClassLoader) {
        return bundleClassLoader instanceof DevTimeClassLoader || Thread.currentThread().getContextClassLoader() instanceof DevTimeClassLoader;
    }

    @NotNull
    public static final String postProcessResolvedValue(@NlsSafe @NotNull String value, @NotNull String key, boolean resourceFound, @NotNull IntelliJResourceBundle bundle) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        BiConsumer<String, String> biConsumer = translationConsumer;
        if (biConsumer != null) {
            biConsumer.accept(key, value);
        }
        if (!resourceFound) {
            string = value;
        } else if (getPolicy == GetPolicy.ONLY_KEY) {
            StringBuilder stringBuilder = new StringBuilder().append("|b|");
            String string2 = bundle.getBaseBundleName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getBaseBundleName(...)");
            string = stringBuilder.append(StringsKt.replace$default((String)string2, (char)'/', (char)'.', (boolean)false, (int)4, null)).append("|k|").append(key).append('|').append(value).toString();
        } else {
            string = getPolicy == GetPolicy.APPEND_KEY ? BundleBase.INSTANCE.appendLocalizationSuffix(value, SHOW_DEFAULT_MESSAGES ? " (" + key + '=' + BundleBase.getDefaultMessage(bundle, key) + ')' : " (" + key + ')') : (SHOW_DEFAULT_MESSAGES ? BundleBase.INSTANCE.appendLocalizationSuffix(value, " (" + BundleBase.getDefaultMessage(bundle, key) + ')') : (BundleBase.SHOW_LOCALIZED_MESSAGES ? BundleBase.INSTANCE.appendLocalizationSuffix(value, "\ud83d\udd05") : value));
        }
        return string;
    }

    public static final /* synthetic */ void access$setAssertOnMissedKeys$p(boolean bl) {
        assertOnMissedKeys = bl;
    }

    public static final /* synthetic */ String access$quotePattern(String message) {
        return BundleBaseKt.quotePattern(message);
    }

    public static final /* synthetic */ Logger access$getLOG() {
        return BundleBaseKt.getLOG();
    }

    public static final /* synthetic */ String[] access$getSUFFIXES$p() {
        return SUFFIXES;
    }

    public static final /* synthetic */ void access$setTranslationConsumer$p(BiConsumer biConsumer) {
        translationConsumer = biConsumer;
    }

    static {
        String[] stringArray = new String[]{"</body></html>", "</html>"};
        SUFFIXES = stringArray;
        SHOW_DEFAULT_MESSAGES = Boolean.getBoolean("idea.l10n.english");
        String it = System.getProperty("idea.l10n.keys");
        boolean bl = false;
        String string = it;
        getPolicy = Intrinsics.areEqual((Object)string, (Object)"only") ? GetPolicy.ONLY_KEY : (Intrinsics.areEqual((Object)string, (Object)"true") ? GetPolicy.APPEND_KEY : GetPolicy.VALUE);
    }
}

