/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.ChecksumInputStream;
import com.intellij.util.io.ChecksumOutputStream;
import com.intellij.util.io.CorruptionException;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.EndOfLog;
import com.intellij.util.io.UnsyncByteArrayOutputStream;
import com.intellij.util.io.WalOpCode;
import com.intellij.util.io.WriteAheadLogKt;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Checksum;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\u000e\u001a\u00020\u000fH\u0096\u0080\u0004J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/intellij/util/io/WalRecord;", "", "opCode", "Lcom/intellij/util/io/WalOpCode;", "checksum", "", "payload", "Lcom/intellij/openapi/util/io/ByteArraySequence;", "<init>", "(Lcom/intellij/util/io/WalOpCode;JLcom/intellij/openapi/util/io/ByteArraySequence;)V", "getOpCode", "()Lcom/intellij/util/io/WalOpCode;", "getPayload", "()Lcom/intellij/openapi/util/io/ByteArraySequence;", "toString", "", "write", "", "target", "Lcom/intellij/util/io/DataOutputStream;", "Companion", "intellij.platform.util"})
final class WalRecord {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WalOpCode opCode;
    private final long checksum;
    @NotNull
    private final ByteArraySequence payload;

    public WalRecord(@NotNull WalOpCode opCode, long checksum, @NotNull ByteArraySequence payload) {
        Intrinsics.checkNotNullParameter((Object)((Object)opCode), (String)"opCode");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        this.opCode = opCode;
        this.checksum = checksum;
        this.payload = payload;
    }

    @NotNull
    public final WalOpCode getOpCode() {
        return this.opCode;
    }

    @NotNull
    public final ByteArraySequence getPayload() {
        return this.payload;
    }

    @NotNull
    public String toString() {
        return "record(" + (Object)((Object)this.opCode) + ", checksum = " + this.checksum + ", len = " + this.payload.length() + ", payload = " + StringUtil.toHexString(this.payload.toBytes()) + ')';
    }

    public final void write(@NotNull DataOutputStream target) throws IOException {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        target.writeByte(this.opCode.getCode$intellij_platform_util());
        DataInputOutputUtil.writeLONG(target, this.checksum);
        DataInputOutputUtil.writeINT(target, this.payload.getLength());
        target.write(this.payload.getInternalBuffer(), this.payload.getOffset(), this.payload.getLength());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/util/io/WalRecord$Companion;", "", "<init>", "()V", "writeRecord", "Lcom/intellij/util/io/WalRecord;", "opCode", "Lcom/intellij/util/io/WalOpCode;", "writer", "Lkotlin/Function1;", "Lcom/intellij/util/io/DataOutputStream;", "", "read", "input", "Ljava/io/DataInputStream;", "intellij.platform.util"})
    @SourceDebugExtension(value={"SMAP\nwriteAheadLog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 writeAheadLog.kt\ncom/intellij/util/io/WalRecord$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,517:1\n1#2:518\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final WalRecord writeRecord(@NotNull WalOpCode opCode, @NotNull Function1<? super DataOutputStream, Unit> writer) throws IOException {
            Intrinsics.checkNotNullParameter((Object)((Object)opCode), (String)"opCode");
            Intrinsics.checkNotNullParameter(writer, (String)"writer");
            UnsyncByteArrayOutputStream baos = new UnsyncByteArrayOutputStream();
            ChecksumOutputStream cos = new ChecksumOutputStream((OutputStream)baos, (Function0<? extends Checksum>)WriteAheadLogKt.access$getChecksumGen$p());
            Closeable closeable = new DataOutputStream(cos);
            Throwable throwable = null;
            try {
                DataOutputStream it = (DataOutputStream)closeable;
                boolean bl = false;
                writer.invoke((Object)it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            long l = cos.checksum();
            ByteArraySequence byteArraySequence = baos.toByteArraySequence();
            Intrinsics.checkNotNullExpressionValue((Object)byteArraySequence, (String)"toByteArraySequence(...)");
            return new WalRecord(opCode, l, byteArraySequence);
        }

        @NotNull
        public final WalRecord read(@NotNull DataInputStream input) throws IOException {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            byte code = 0;
            try {
                code = input.readByte();
            }
            catch (EOFException e) {
                throw new EndOfLog();
            }
            if (code >= WalOpCode.Companion.getSize()) {
                throw new CorruptionException("no opcode present for code " + code);
            }
            long checksum = DataInputOutputUtil.readLONG(input);
            int payloadLength = DataInputOutputUtil.readINT(input);
            ChecksumInputStream cis = new ChecksumInputStream((InputStream)input, (Function0<? extends Checksum>)WriteAheadLogKt.access$getChecksumGen$p());
            byte[] byArray = StreamUtil.readBytes(cis, payloadLength);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readBytes(...)");
            byte[] data = byArray;
            long actualChecksum = cis.checksum();
            if (actualChecksum != checksum) {
                throw new CorruptionException("checksum is wrong for log record: expected = " + checksum + " but actual = " + actualChecksum);
            }
            return new WalRecord(WalOpCode.values()[code], checksum, new ByteArraySequence(data));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

