// Copyright 2000-2024 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package com.intellij.util.xmlb.annotations;

import com.intellij.util.xmlb.Constants;
import org.jetbrains.annotations.NonNls;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @deprecated Use {@link XCollection}
 */
@Deprecated
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.FIELD, ElementType.METHOD})
public @interface AbstractCollection {
  /**
   * @return whether all collection items should be surrounded with a single tag
   */
  boolean surroundWithTag() default true;

  /**
   * Due to historical reasons, even LinkedHashSet will be sorted according to the natural ordering of its elements.
   */
  boolean sortOrderedSet() default true;

  @NonNls String elementTag() default Constants.OPTION;
  @NonNls String elementValueAttribute() default Constants.VALUE;

  Class[] elementTypes() default {};
}
