/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SystemProperties;
import java.util.Comparator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OSAgnosticPathUtil {
    public static final Comparator<String> COMPARATOR = (path1, path2) -> {
        if (Strings.areSameInstance((String)path1, (String)path2)) {
            return 0;
        }
        if (path1 == null) {
            return -1;
        }
        if (path2 == null) {
            return 1;
        }
        int length1 = path1.length();
        int length2 = path2.length();
        boolean ignoreCase = !SystemInfoRt.isFileSystemCaseSensitive;
        for (int pos = 0; pos < length1 && pos < length2; ++pos) {
            char ch2;
            char ch1 = path1.charAt(pos);
            if (ch1 == (ch2 = path2.charAt(pos))) continue;
            if (ch1 == '/') {
                if (ch2 == '\\') continue;
                return -1;
            }
            if (ch1 == '\\') {
                if (ch2 == '/') continue;
                return -1;
            }
            if (ch2 == '/' || ch2 == '\\') {
                return 1;
            }
            int diff = StringUtil.compare(ch1, ch2, ignoreCase);
            if (diff == 0) continue;
            return diff;
        }
        return Integer.compare(length1, length2);
    };

    private OSAgnosticPathUtil() {
    }

    public static boolean isAbsolute(@NotNull String path) {
        if (path == null) {
            OSAgnosticPathUtil.$$$reportNull$$$0(0);
        }
        return path.startsWith("/") || OSAgnosticPathUtil.isAbsoluteDosPath(path) || OSAgnosticPathUtil.isUncPath(path);
    }

    public static boolean isAbsoluteDosPath(@NotNull String path) {
        if (path == null) {
            OSAgnosticPathUtil.$$$reportNull$$$0(1);
        }
        return path.length() > 2 && OSAgnosticPathUtil.startsWithWindowsDrive(path) && PathUtilRt.isSeparator((char)path.charAt(2));
    }

    public static boolean startsWithWindowsDrive(@NotNull String path) {
        if (path == null) {
            OSAgnosticPathUtil.$$$reportNull$$$0(2);
        }
        return path.length() >= 2 && path.charAt(1) == ':' && OSAgnosticPathUtil.isDriveLetter(path.charAt(0));
    }

    public static boolean isUncPath(@NotNull String path) {
        if (path == null) {
            OSAgnosticPathUtil.$$$reportNull$$$0(3);
        }
        if (!PathUtilRt.startsWithSeparatorSeparator((CharSequence)path)) {
            return false;
        }
        int slashIndex = OSAgnosticPathUtil.nextSeparatorIndex(path, 2);
        return PathUtilRt.isWindowsUNCRoot((CharSequence)path, (int)(slashIndex == -1 ? path.length() : slashIndex));
    }

    public static boolean startsWith(@NotNull String path, @NotNull String prefix) {
        char next;
        if (path == null) {
            OSAgnosticPathUtil.$$$reportNull$$$0(4);
        }
        if (prefix == null) {
            OSAgnosticPathUtil.$$$reportNull$$$0(5);
        }
        int pathLength = path.length();
        int prefixLength = prefix.length();
        if (prefixLength == 0) {
            return true;
        }
        if (prefixLength > pathLength) {
            return false;
        }
        boolean ignoreCase = !SystemInfoRt.isFileSystemCaseSensitive;
        for (int pos = 0; pos < pathLength && pos < prefixLength; ++pos) {
            char ch2;
            char ch1 = path.charAt(pos);
            if (ch1 == (ch2 = prefix.charAt(pos))) continue;
            if (ch1 == '/') {
                if (ch2 == '\\') continue;
                return false;
            }
            if (ch1 == '\\') {
                if (ch2 == '/') continue;
                return false;
            }
            if (ch2 == '/' || ch2 == '\\') {
                return false;
            }
            if (StringUtil.compare(ch1, ch2, ignoreCase) == 0) continue;
            return false;
        }
        if (pathLength == prefixLength) {
            return true;
        }
        char lastPrefixChar = prefix.charAt(prefixLength - 1);
        int slashOrSeparatorIdx = prefixLength;
        if (lastPrefixChar == '/' || lastPrefixChar == '\\') {
            slashOrSeparatorIdx = prefixLength - 1;
        }
        return (next = path.charAt(slashOrSeparatorIdx)) == '/' || next == '\\';
    }

    @Nullable
    public static String getParent(@NotNull String path) {
        int length;
        int lastSeparator;
        if (path == null) {
            OSAgnosticPathUtil.$$$reportNull$$$0(6);
        }
        if ((lastSeparator = PathUtilRt.lastSeparatorIndex((CharSequence)path, (int)((length = path.length()) - 1))) < 0) {
            return null;
        }
        if (lastSeparator == length - 1) {
            lastSeparator = PathUtilRt.lastSeparatorIndex((CharSequence)path, (int)(length - 2));
        }
        if (lastSeparator < 0) {
            return null;
        }
        if (PathUtilRt.startsWithSeparatorSeparator((CharSequence)path)) {
            int prevSeparator;
            int slashIndex = OSAgnosticPathUtil.nextSeparatorIndex(path, 2);
            if (lastSeparator > 1 && slashIndex != -1 && slashIndex <= lastSeparator && PathUtilRt.isWindowsUNCRoot((CharSequence)path, (int)slashIndex) && (prevSeparator = PathUtilRt.lastSeparatorIndex((CharSequence)path, (int)(lastSeparator - 1))) > 1) {
                return path.substring(0, lastSeparator);
            }
            return null;
        }
        if (lastSeparator == 2 && OSAgnosticPathUtil.startsWithWindowsDrive(path)) {
            return path.substring(0, 3);
        }
        return path.substring(0, lastSeparator == 0 ? 1 : lastSeparator);
    }

    private static int nextSeparatorIndex(String s, int start) {
        for (int i = start; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!PathUtilRt.isSeparator((char)c)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isDriveLetter(char c) {
        return 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z';
    }

    @Contract(pure=true)
    @NotNull
    public static String expandUserHome(@NotNull String path) {
        if (path == null) {
            OSAgnosticPathUtil.$$$reportNull$$$0(7);
        }
        if (path.equals("~")) {
            String string = SystemProperties.getUserHome();
            if (string == null) {
                OSAgnosticPathUtil.$$$reportNull$$$0(8);
            }
            return string;
        }
        if (path.startsWith("~/") || path.startsWith("~\\")) {
            String string = SystemProperties.getUserHome() + path.substring(1);
            if (string == null) {
                OSAgnosticPathUtil.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            OSAgnosticPathUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/io/OSAgnosticPathUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/io/OSAgnosticPathUtil";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "expandUserHome";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAbsolute";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAbsoluteDosPath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "startsWithWindowsDrive";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUncPath";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "expandUserHome";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

