/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.SingletonIteratorBase;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SmartHashSet<T>
extends AbstractSet<T> {
    private Object theElement;

    public SmartHashSet() {
    }

    public SmartHashSet(int initialCapacity, float loadFactor) {
    }

    public SmartHashSet(int initialCapacity) {
    }

    public SmartHashSet(@NotNull @NotNull Collection<? extends @NotNull T> collection) {
        if (collection == null) {
            SmartHashSet.$$$reportNull$$$0(0);
        }
        if (collection.size() == 1) {
            T element = collection.iterator().next();
            if (element == null) {
                throw new IllegalArgumentException("Null elements are not permitted but got: " + collection);
            }
            this.theElement = element;
        } else if (!collection.isEmpty()) {
            this.theElement = new MySet<T>(collection);
        }
    }

    @Override
    public boolean contains(@NotNull Object obj) {
        Object element;
        if (obj == null) {
            SmartHashSet.$$$reportNull$$$0(1);
        }
        if ((element = this.theElement) == null) {
            return false;
        }
        MySet<T> hashSet = this.asHashSet(element);
        if (hashSet == null) {
            return Objects.equals(obj, element);
        }
        return hashSet.contains(obj);
    }

    @Override
    public boolean add(@NotNull T obj) {
        Object element;
        if (obj == null) {
            SmartHashSet.$$$reportNull$$$0(2);
        }
        if ((element = this.theElement) == null) {
            this.theElement = obj;
            return true;
        }
        MySet<T> hashSet = this.asHashSet(element);
        if (hashSet == null) {
            if (Objects.equals(obj, element)) {
                return false;
            }
            this.theElement = new MySet<Object>(element, obj);
            return true;
        }
        return hashSet.add(obj);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Set)) {
            return false;
        }
        Object element = this.theElement;
        if (element == null) {
            return ((Set)other).isEmpty();
        }
        MySet<T> hashSet = this.asHashSet(element);
        if (hashSet != null) {
            return other.equals(hashSet);
        }
        return ((Set)other).size() == 1 && Objects.equals(((Set)other).iterator().next(), element);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.theElement);
    }

    @Override
    public void clear() {
        this.theElement = null;
    }

    @Override
    public int size() {
        Object element = this.theElement;
        if (element == null) {
            return 0;
        }
        MySet<T> hashSet = this.asHashSet(element);
        return hashSet == null ? 1 : hashSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.theElement == null;
    }

    @Override
    public boolean remove(@NotNull Object obj) {
        Object element;
        if (obj == null) {
            SmartHashSet.$$$reportNull$$$0(3);
        }
        if ((element = this.theElement) == null) {
            return false;
        }
        MySet<T> hashSet = this.asHashSet(element);
        if (hashSet != null) {
            boolean removed = hashSet.remove(obj);
            if (removed) {
                if (hashSet.isEmpty()) {
                    this.theElement = null;
                } else if (hashSet.size() == 1) {
                    this.theElement = hashSet.iterator().next();
                }
            }
            return removed;
        }
        if (Objects.equals(obj, element)) {
            this.theElement = null;
            return true;
        }
        return false;
    }

    @Nullable
    private MySet<T> asHashSet(Object element) {
        if (element instanceof MySet) {
            MySet set = (MySet)element;
            assert (set.size() > 1) : set;
            return set;
        }
        return null;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        final Object element = this.theElement;
        if (element == null) {
            Iterator iterator2 = Collections.emptyIterator();
            if (iterator2 == null) {
                SmartHashSet.$$$reportNull$$$0(4);
            }
            return iterator2;
        }
        final MySet<T> hashSet = this.asHashSet(element);
        if (hashSet != null) {
            return new Iterator<T>(){
                private final Iterator<T> hashIterator;
                {
                    this.hashIterator = hashSet.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.hashIterator.hasNext();
                }

                @Override
                public T next() {
                    return this.hashIterator.next();
                }

                @Override
                public void remove() {
                    this.hashIterator.remove();
                    if (hashSet.isEmpty()) {
                        SmartHashSet.this.theElement = null;
                    } else if (hashSet.size() == 1) {
                        SmartHashSet.this.theElement = hashSet.iterator().next();
                    }
                }
            };
        }
        return new SingletonIteratorBase<T>(){

            @Override
            protected void checkCoModification() {
                if (SmartHashSet.this.theElement == null) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            protected T getElement() {
                return element;
            }

            @Override
            public void remove() {
                this.checkCoModification();
                SmartHashSet.this.clear();
            }
        };
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        Object element = this.theElement;
        if (element == null) {
            return;
        }
        MySet<? super T> hashSet = this.asHashSet(element);
        if (hashSet != null) {
            hashSet.forEach(action);
        } else {
            action.accept(element);
        }
    }

    @Override
    public Object @NotNull [] toArray() {
        Object element = this.theElement;
        if (element == null) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                SmartHashSet.$$$reportNull$$$0(5);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        MySet<T> hashSet = this.asHashSet(element);
        if (hashSet != null) {
            Object[] objectArray = hashSet.toArray();
            if (objectArray == null) {
                SmartHashSet.$$$reportNull$$$0(6);
            }
            return objectArray;
        }
        Object[] objectArray = new Object[]{element};
        if (objectArray == null) {
            SmartHashSet.$$$reportNull$$$0(7);
        }
        return objectArray;
    }

    @Override
    public <O> O @NotNull [] toArray(O @NotNull [] a) {
        Object element;
        if (a == null) {
            SmartHashSet.$$$reportNull$$$0(8);
        }
        if ((element = this.theElement) == null) {
            if (a.length != 0) {
                a[0] = null;
            }
            if (a == null) {
                SmartHashSet.$$$reportNull$$$0(9);
            }
            return a;
        }
        MySet<O> hashSet = this.asHashSet(element);
        if (hashSet != null) {
            O[] OArray = hashSet.toArray(a);
            if (OArray == null) {
                SmartHashSet.$$$reportNull$$$0(10);
            }
            return OArray;
        }
        if (a.length == 0) {
            a = ArrayUtil.newArray((Class)ArrayUtil.getComponentType((Object[])a), (int)1);
        }
        a[0] = element;
        if (a.length > 1) {
            a[1] = null;
        }
        if (a == null) {
            SmartHashSet.$$$reportNull$$$0(11);
        }
        return a;
    }

    @Override
    @NotNull
    public Stream<T> stream() {
        Object element = this.theElement;
        if (element == null) {
            Stream stream = Stream.empty();
            if (stream == null) {
                SmartHashSet.$$$reportNull$$$0(12);
            }
            return stream;
        }
        MySet<T> hashSet = this.asHashSet(element);
        if (hashSet != null) {
            Stream stream = hashSet.stream();
            if (stream == null) {
                SmartHashSet.$$$reportNull$$$0(13);
            }
            return stream;
        }
        Stream<Object> stream = Stream.of(element);
        if (stream == null) {
            SmartHashSet.$$$reportNull$$$0(14);
        }
        return stream;
    }

    @Override
    @NotNull
    public Spliterator<T> spliterator() {
        Object element = this.theElement;
        if (element == null) {
            Spliterator spliterator = Spliterators.emptySpliterator();
            if (spliterator == null) {
                SmartHashSet.$$$reportNull$$$0(15);
            }
            return spliterator;
        }
        MySet<T> hashSet = this.asHashSet(element);
        if (hashSet != null) {
            Spliterator spliterator = hashSet.spliterator();
            if (spliterator == null) {
                SmartHashSet.$$$reportNull$$$0(16);
            }
            return spliterator;
        }
        Spliterator spliterator = Stream.of(element).spliterator();
        if (spliterator == null) {
            SmartHashSet.$$$reportNull$$$0(17);
        }
        return spliterator;
    }

    @Override
    public String toString() {
        Object element = this.theElement;
        if (element == null) {
            return "[]";
        }
        MySet<T> hashSet = this.asHashSet(element);
        if (hashSet != null) {
            return hashSet.toString();
        }
        return "[" + element + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/SmartHashSet";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/SmartHashSet";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "stream";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "spliterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MySet<T>
    extends HashSet<T> {
        MySet(@NotNull Collection<? extends T> collection) {
            if (collection == null) {
                MySet.$$$reportNull$$$0(0);
            }
            super(collection);
        }

        MySet(@NotNull T element1, @NotNull T element2) {
            if (element1 == null) {
                MySet.$$$reportNull$$$0(1);
            }
            if (element2 == null) {
                MySet.$$$reportNull$$$0(2);
            }
            this.add(element1);
            this.add(element2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "collection";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element2";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/containers/SmartHashSet$MySet";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

