/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.AbstractBundleKt;
import com.intellij.BundleBase;
import com.intellij.BundleBaseKt;
import com.intellij.IntelliJResourceControl;
import com.intellij.MissingResourceBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.DefaultBundleService;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 12\u00020\u0001:\u00011B\"\b\u0016\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0016\b\u0015\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\u0007\u0010\tJ7\u0010\u0012\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00132\u000b\u0010\u0014\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001H\u0017\u00a2\u0006\u0002\u0010\u0017J?\u0010\u0018\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00132\u000b\u0010\u0014\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\u001bJ8\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001d2\u000b\u0010\u0014\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\u001eJ5\u0010\u001f\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00132\u000b\u0010\u0014\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0016\"\u00020\u0001H\u0016\u00a2\u0006\u0002\u0010\u0017JH\u0010 \u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00132\u000b\u0010\u0014\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\r\u0010!\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00132\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010\"J\u0013\u0010#\u001a\u00020$2\u000b\u0010\u0014\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006J\b\u0010%\u001a\u00020\fH\u0007J\u0010\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020\u000fH\u0007J$\u0010'\u001a\u0004\u0018\u00010\f2\u0006\u0010(\u001a\u00020$2\u0006\u0010&\u001a\u00020\u000f2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0015J%\u0010)\u001a\u00020\f2\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,H\u0014J-\u0010)\u001a\u00020\f2\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0005J\b\u0010/\u001a\u000200H\u0007R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u00020\u000f8\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/AbstractBundle;", "", "bundleClass", "Ljava/lang/Class;", "pathToBundle", "", "Lorg/jetbrains/annotations/NonNls;", "<init>", "(Ljava/lang/Class;Ljava/lang/String;)V", "(Ljava/lang/String;)V", "bundle", "Ljava/lang/ref/Reference;", "Ljava/util/ResourceBundle;", "defaultBundle", "bundleClassLoader", "Ljava/lang/ClassLoader;", "getBundleClassLoader", "()Ljava/lang/ClassLoader;", "getMessage", "Lorg/jetbrains/annotations/Nls;", "key", "params", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "getPartialMessage", "unassignedParams", "", "(Ljava/lang/String;I[Ljava/lang/Object;)Ljava/lang/String;", "getLazyMessage", "Ljava/util/function/Supplier;", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/util/function/Supplier;", "messageOrNull", "messageOrDefault", "defaultValue", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "containsKey", "", "getResourceBundle", "classLoader", "getBundle", "isDefault", "findBundle", "loader", "control", "Ljava/util/ResourceBundle$Control;", "locale", "Ljava/util/Locale;", "clearLocaleCache", "", "Companion", "intellij.platform.util"})
@SourceDebugExtension(value={"SMAP\nAbstractBundle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractBundle.kt\ncom/intellij/AbstractBundle\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,233:1\n13#2:234\n*S KotlinDebug\n*F\n+ 1 AbstractBundle.kt\ncom/intellij/AbstractBundle\n*L\n164#1:234\n*E\n"})
public class AbstractBundle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Reference<ResourceBundle> bundle;
    @Nullable
    private Reference<ResourceBundle> defaultBundle;
    @NotNull
    private final ClassLoader bundleClassLoader;
    @NotNull
    private final String pathToBundle;

    @ApiStatus.Internal
    @NotNull
    protected final ClassLoader getBundleClassLoader() {
        return this.bundleClassLoader;
    }

    public AbstractBundle(@NotNull Class<?> bundleClass, @NotNull String pathToBundle) {
        Intrinsics.checkNotNullParameter(bundleClass, (String)"bundleClass");
        Intrinsics.checkNotNullParameter((Object)pathToBundle, (String)"pathToBundle");
        this.pathToBundle = pathToBundle;
        ClassLoader classLoader = bundleClass.getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
        this.bundleClassLoader = classLoader;
    }

    @ApiStatus.Obsolete
    protected AbstractBundle(@NotNull String pathToBundle) {
        Intrinsics.checkNotNullParameter((Object)pathToBundle, (String)"pathToBundle");
        this.pathToBundle = pathToBundle;
        ClassLoader classLoader = this.getClass().getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
        this.bundleClassLoader = classLoader;
    }

    @Contract(pure=true)
    @NotNull
    public String getMessage(@NotNull String key, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return BundleBaseKt.messageOrDefault(this.getResourceBundle(this.bundleClassLoader), key, null, params);
    }

    @Contract(pure=true)
    @NotNull
    public final String getPartialMessage(@NotNull String key, int unassignedParams, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return BundleBase.partialMessage(this.getResourceBundle(this.bundleClassLoader), key, unassignedParams, params);
    }

    @NotNull
    public Supplier<String> getLazyMessage(@NotNull String key, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Object[] actualParams = params.length == 0 ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : params;
        return () -> AbstractBundle.getLazyMessage$lambda$0(this, key, actualParams);
    }

    @Nullable
    public String messageOrNull(@NotNull String key, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return Companion.messageOrNull(this.getResourceBundle(), key, Arrays.copyOf(params, params.length));
    }

    @Nullable
    public String messageOrDefault(@NotNull String key, @Nullable String defaultValue, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return Companion.messageOrDefault(this.getResourceBundle(), key, defaultValue, Arrays.copyOf(params, params.length));
    }

    public final boolean containsKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getResourceBundle().containsKey(key);
    }

    @ApiStatus.Internal
    @NotNull
    public final ResourceBundle getResourceBundle() {
        return this.getResourceBundle(this.bundleClassLoader);
    }

    @ApiStatus.Internal
    @NotNull
    public final ResourceBundle getResourceBundle(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        boolean isDefault = DefaultBundleService.isDefaultBundle();
        ResourceBundle bundle = this.getBundle(isDefault, classLoader, this.pathToBundle);
        if (bundle == null) {
            bundle = Companion.resolveResourceBundleWithFallback(classLoader, this.pathToBundle, (Function0<? extends ResourceBundle>)((Function0)() -> AbstractBundle.getResourceBundle$lambda$0(this, classLoader)), (Function1<? super MissingResourceException, Unit>)((Function1)AbstractBundle::getResourceBundle$lambda$1));
            SoftReference<ResourceBundle> ref = new SoftReference<ResourceBundle>(bundle);
            if (isDefault) {
                this.defaultBundle = ref;
            } else {
                this.bundle = ref;
            }
        }
        return bundle;
    }

    @ApiStatus.Internal
    @Nullable
    protected ResourceBundle getBundle(boolean isDefault, @NotNull ClassLoader classLoader, @Nullable String pathToBundle) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Reference<ResourceBundle> reference = isDefault ? this.defaultBundle : this.bundle;
        return reference != null ? reference.get() : null;
    }

    @NotNull
    protected ResourceBundle findBundle(@NotNull String pathToBundle, @NotNull ClassLoader loader, @NotNull ResourceBundle.Control control) {
        Intrinsics.checkNotNullParameter((Object)pathToBundle, (String)"pathToBundle");
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        Intrinsics.checkNotNullParameter((Object)control, (String)"control");
        ResourceBundle resourceBundle = ResourceBundle.getBundle(pathToBundle, Locale.getDefault(), loader, control);
        Intrinsics.checkNotNullExpressionValue((Object)resourceBundle, (String)"getBundle(...)");
        return resourceBundle;
    }

    @ApiStatus.Internal
    @NotNull
    protected final ResourceBundle findBundle(@NotNull String pathToBundle, @NotNull ClassLoader loader, @NotNull ResourceBundle.Control control, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)pathToBundle, (String)"pathToBundle");
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        Intrinsics.checkNotNullParameter((Object)control, (String)"control");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        ResourceBundle resourceBundle = ResourceBundle.getBundle(pathToBundle, locale, loader, control);
        Intrinsics.checkNotNullExpressionValue((Object)resourceBundle, (String)"getBundle(...)");
        return resourceBundle;
    }

    @Deprecated(message="This method is no longer required.\n    The Locale cache now gets cleared automatically after the initialization of the language plugin.")
    public final void clearLocaleCache() {
        block0: {
            Reference<ResourceBundle> reference = this.bundle;
            if (reference == null) break block0;
            reference.clear();
        }
    }

    private static final String getLazyMessage$lambda$0(AbstractBundle this$0, String $key, Object[] $actualParams) {
        return this$0.getMessage($key, Arrays.copyOf($actualParams, $actualParams.length));
    }

    private static final ResourceBundle getResourceBundle$lambda$0(AbstractBundle this$0, ClassLoader $classLoader) {
        return this$0.findBundle(this$0.pathToBundle, $classLoader, IntelliJResourceControl.INSTANCE);
    }

    private static final Unit getResourceBundle$lambda$1(MissingResourceException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AbstractBundle.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.error(e);
        return Unit.INSTANCE;
    }

    @JvmStatic
    @Contract(value="null, _, _, _ -> param3")
    @Nullable
    public static final String messageOrDefault(@Nullable ResourceBundle bundle, @NotNull String key, @Nullable String defaultValue, Object ... params) {
        return Companion.messageOrDefault(bundle, key, defaultValue, params);
    }

    @JvmStatic
    @NotNull
    public static final String message(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
        return Companion.message(bundle, key, params);
    }

    @JvmStatic
    @Nullable
    public static final String messageOrNull(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
        return Companion.messageOrNull(bundle, key, params);
    }

    @JvmStatic
    @Deprecated(message="do not use, for compatibility only")
    @ApiStatus.Internal
    @NotNull
    public static final ResourceBundle resolveBundle(@NotNull ClassLoader loader, @NotNull Locale locale, @NotNull String pathToBundle) {
        return Companion.resolveBundle(loader, locale, pathToBundle);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007JR\u0010\u0006\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u000b\u0010\u000b\u001a\u00070\u0007\u00a2\u0006\u0002\b\f2\r\u0010\r\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b2\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\u0010J?\u0010\u0011\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\t\u001a\u00020\n2\u000b\u0010\u000b\u001a\u00070\u0007\u00a2\u0006\u0002\b\f2\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\u0012J=\u0010\u0013\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\t\u001a\u00020\n2\u000b\u0010\u000b\u001a\u00070\u0007\u00a2\u0006\u0002\b\f2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000f\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\u0012J:\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bH\u0007J \u0010\u001e\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0007H\u0007\u00a8\u0006!"}, d2={"Lcom/intellij/AbstractBundle$Companion;", "", "<init>", "()V", "getControl", "Ljava/util/ResourceBundle$Control;", "messageOrDefault", "", "Lorg/jetbrains/annotations/Nls;", "bundle", "Ljava/util/ResourceBundle;", "key", "Lorg/jetbrains/annotations/NonNls;", "defaultValue", "params", "", "(Ljava/util/ResourceBundle;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "message", "(Ljava/util/ResourceBundle;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "messageOrNull", "resolveResourceBundleWithFallback", "loader", "Ljava/lang/ClassLoader;", "pathToBundle", "firstTry", "Lkotlin/Function0;", "errorReporter", "Lkotlin/Function1;", "Ljava/util/MissingResourceException;", "", "resolveBundle", "locale", "Ljava/util/Locale;", "intellij.platform.util"})
    @SourceDebugExtension(value={"SMAP\nAbstractBundle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractBundle.kt\ncom/intellij/AbstractBundle$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,233:1\n13#2:234\n*S KotlinDebug\n*F\n+ 1 AbstractBundle.kt\ncom/intellij/AbstractBundle$Companion\n*L\n89#1:234\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @ApiStatus.Internal
        @NotNull
        public final ResourceBundle.Control getControl() {
            return IntelliJResourceControl.INSTANCE;
        }

        @JvmStatic
        @Contract(value="null, _, _, _ -> param3")
        @Nullable
        public final String messageOrDefault(@Nullable ResourceBundle bundle, @NotNull String key, @Nullable String defaultValue, Object ... params) {
            String string;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            if (bundle == null) {
                string = defaultValue;
            } else if (!bundle.containsKey(key)) {
                String string2 = defaultValue;
                if (string2 == null) {
                    string2 = BundleBaseKt.useDefaultValue(bundle, key);
                }
                string = BundleBaseKt.postprocessValue(bundle, string2, params);
            } else {
                string = BundleBaseKt.messageOrDefault(bundle, key, defaultValue, params);
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public final String message(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            return BundleBaseKt.messageOrDefault(bundle, key, null, params);
        }

        @JvmStatic
        @Nullable
        public final String messageOrNull(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            String value = this.messageOrDefault(bundle, key, key, Arrays.copyOf(params, params.length));
            return Intrinsics.areEqual((Object)key, (Object)value) ? null : value;
        }

        @ApiStatus.Internal
        @NotNull
        public final ResourceBundle resolveResourceBundleWithFallback(@NotNull ClassLoader loader, @NotNull String pathToBundle, @NotNull Function0<? extends ResourceBundle> firstTry, @NotNull Function1<? super MissingResourceException, Unit> errorReporter) {
            Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
            Intrinsics.checkNotNullParameter((Object)pathToBundle, (String)"pathToBundle");
            Intrinsics.checkNotNullParameter(firstTry, (String)"firstTry");
            Intrinsics.checkNotNullParameter(errorReporter, (String)"errorReporter");
            try {
                return (ResourceBundle)firstTry.invoke();
            }
            catch (MissingResourceException missingResourceException) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(AbstractBundle.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("Cannot load resource bundle from *.properties file, falling back to slow class loading: " + pathToBundle);
                try {
                    ResourceBundle.clearCache(loader);
                    ResourceBundle resourceBundle = ResourceBundle.getBundle(pathToBundle, Locale.getDefault(), loader);
                    Intrinsics.checkNotNullExpressionValue((Object)resourceBundle, (String)"getBundle(...)");
                    return resourceBundle;
                }
                catch (MissingResourceException e) {
                    errorReporter.invoke((Object)e);
                    return new MissingResourceBundle(pathToBundle);
                }
            }
        }

        @JvmStatic
        @Deprecated(message="do not use, for compatibility only")
        @ApiStatus.Internal
        @NotNull
        public final ResourceBundle resolveBundle(@NotNull ClassLoader loader, @NotNull Locale locale, @NotNull String pathToBundle) {
            Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            Intrinsics.checkNotNullParameter((Object)pathToBundle, (String)"pathToBundle");
            return AbstractBundleKt._doResolveBundle(loader, locale, pathToBundle);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

