/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.InstalledThreadContext;
import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.util.IntelliJCoroutinesFacade;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.Propagation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Deprecated;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.ContinuationInterceptor;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineId;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.ThreadContextElement;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0086\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\u001a#\u0010\b\u001a\u0004\u0018\u00010\t2\u0016\u0010\n\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000bH\u0082\b\u001a\n\u0010\f\u001a\u0004\u0018\u00010\tH\u0007\u001a\n\u0010\r\u001a\u0004\u0018\u00010\tH\u0007\u001a\u0006\u0010\u000e\u001a\u00020\t\u001a\b\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\b\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\b\u0010\u0016\u001a\u00020\u0010H\u0000\u001a\b\u0010\u0017\u001a\u00020\u0018H\u0007\u001a\u001f\u0010\u0017\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001b\u00a2\u0006\u0002\u0010\u001c\u001a1\u0010\u001d\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u001e\u001a\u00020\t2\b\b\u0002\u0010\u001f\u001a\u00020\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001b\u00a2\u0006\u0002\u0010 \u001a\u001a\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\t2\b\b\u0002\u0010\u001f\u001a\u00020\u0014H\u0007\u001a\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\tH\u0002\u001a\n\u0010$\u001a\u0004\u0018\u00010\tH\u0007\u001a\u0010\u0010%\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\tH\u0007\u001a?\u0010&\u001a\u00020\u0018\"\u0004\b\u0000\u0010\u00192\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H\u00190\u00072!\u0010(\u001a\u001d\u0012\u0013\u0012\u0011H\u0019\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(+\u0012\u0004\u0012\u0002H\u00190\u000bH\u0007\u001a\u0018\u0010,\u001a\u00060-j\u0002`.2\n\u0010/\u001a\u00060-j\u0002`.H\u0007\u001a\"\u0010,\u001a\b\u0012\u0004\u0012\u0002H\u001900\"\u0004\b\u0000\u0010\u00192\f\u00101\u001a\b\u0012\u0004\u0012\u0002H\u001900H\u0007\u001a\"\u0010,\u001a\b\u0012\u0004\u0012\u0002H\u001902\"\u0004\b\u0000\u0010\u00192\f\u00103\u001a\b\u0012\u0004\u0012\u0002H\u001902H\u0007\u001a4\u0010,\u001a\u000e\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u0002H504\"\u0004\b\u0000\u0010\u0019\"\u0004\b\u0001\u001052\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u0002H504H\u0007\u001a\"\u0010,\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001b\"\u0004\b\u0000\u0010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001bH\u0007\u001a\"\u00107\u001a\b\u0012\u0004\u0012\u0002H\u001908\"\u0004\b\u0000\u0010\u00192\f\u00109\u001a\b\u0012\u0004\u0012\u0002H\u001908H\u0007\u001a\"\u0010,\u001a\b\u0012\u0004\u0012\u0002H;0:\"\u0004\b\u0000\u0010;2\f\u0010<\u001a\b\u0012\u0004\u0012\u0002H;0:H\u0007\u001a\b\u0010=\u001a\u00020\u0014H\u0002\u001a\b\u0010>\u001a\u00020?H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"category", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "INITIAL_THREAD_CONTEXT", "Lcom/intellij/concurrency/InstalledThreadContext;", "tlCoroutineContext", "Ljava/lang/ThreadLocal;", "currentThreadContextOrFallback", "Lkotlin/coroutines/CoroutineContext;", "getter", "Lkotlin/Function1;", "currentThreadOverriddenContextOrNull", "currentThreadContextOrNull", "currentThreadContext", "checkContextInstalled", "", "VIOLATORS", "", "isKnownViolator", "", "shouldWarnAccidentalCancellation", "warnAccidentalCancellation", "resetThreadContext", "Lcom/intellij/openapi/application/AccessToken;", "T", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "installThreadContext", "coroutineContext", "replace", "(Lkotlin/coroutines/CoroutineContext;ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "applyThreadContextElements", "context", "tlTemporaryContext", "currentTemporaryThreadContextOrNull", "installTemporaryThreadContext", "withThreadLocal", "variable", "update", "Lkotlin/ParameterName;", "name", "value", "captureThreadContext", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "runnable", "Ljava/util/function/Supplier;", "s", "Ljava/util/function/Consumer;", "c", "Ljava/util/function/Function;", "U", "f", "captureThreadContextProcessor", "Lcom/intellij/util/Processor;", "processor", "Ljava/util/concurrent/Callable;", "V", "callable", "isStacktraceLoggingEnabled", "tracingHint", "", "intellij.platform.util"})
@JvmName(name="ThreadContext")
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nthreadContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 threadContext.kt\ncom/intellij/concurrency/ThreadContext\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,517:1\n101#1,7:518\n101#1,7:525\n11705#2:532\n12052#2,3:533\n1807#3,3:536\n*S KotlinDebug\n*F\n+ 1 threadContext.kt\ncom/intellij/concurrency/ThreadContext\n*L\n118#1:518,7\n132#1:525,7\n224#1:532\n224#1:533,3\n225#1:536,3\n*E\n"})
public final class ThreadContext {
    @NotNull
    private static final String category = "#com.intellij.concurrency";
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final InstalledThreadContext INITIAL_THREAD_CONTEXT;
    @NotNull
    private static final ThreadLocal<InstalledThreadContext> tlCoroutineContext;
    @NotNull
    private static final List<String> VIOLATORS;
    private static final boolean shouldWarnAccidentalCancellation;
    @NotNull
    private static final ThreadLocal<CoroutineContext> tlTemporaryContext;

    private static final CoroutineContext currentThreadContextOrFallback(Function1<? super CoroutineContext, ? extends CoroutineContext> getter) {
        boolean $i$f$currentThreadContextOrFallback = false;
        CoroutineContext suspendingContext = IntelliJCoroutinesFacade.INSTANCE.currentThreadCoroutineContext();
        InstalledThreadContext installedThreadContext = tlCoroutineContext.get();
        CoroutineContext snapshot = installedThreadContext.component1();
        CoroutineContext overridingContext = installedThreadContext.component2();
        if (suspendingContext == snapshot) {
            return overridingContext;
        }
        return (CoroutineContext)getter.invoke((Object)suspendingContext);
    }

    @ApiStatus.Internal
    @Nullable
    public static final CoroutineContext currentThreadOverriddenContextOrNull() {
        return tlCoroutineContext.get().getContext();
    }

    @ApiStatus.Internal
    @Nullable
    public static final CoroutineContext currentThreadContextOrNull() {
        Object object;
        boolean $i$f$currentThreadContextOrFallback = false;
        CoroutineContext suspendingContext$iv = IntelliJCoroutinesFacade.INSTANCE.currentThreadCoroutineContext();
        InstalledThreadContext installedThreadContext = tlCoroutineContext.get();
        CoroutineContext snapshot$iv = installedThreadContext.component1();
        CoroutineContext overridingContext$iv = installedThreadContext.component2();
        if (suspendingContext$iv == snapshot$iv) {
            object = overridingContext$iv;
        } else {
            CoroutineContext it = suspendingContext$iv;
            boolean bl = false;
            CoroutineContext coroutineContext = it;
            object = coroutineContext != null ? coroutineContext.minusKey((CoroutineContext.Key)ContinuationInterceptor.Key) : null;
        }
        return object;
    }

    @NotNull
    public static final CoroutineContext currentThreadContext() {
        ThreadContext.checkContextInstalled();
        CoroutineContext coroutineContext = ThreadContext.currentThreadContextOrNull();
        if (coroutineContext == null) {
            coroutineContext = (CoroutineContext)EmptyCoroutineContext.INSTANCE;
        }
        return coroutineContext;
    }

    private static final void checkContextInstalled() {
        if (Propagation.isCheckContextAssertions() && LoadingState.APP_STARTED.isOccurred()) {
            CoroutineContext coroutineContext;
            boolean $i$f$currentThreadContextOrFallback = false;
            CoroutineContext suspendingContext$iv = IntelliJCoroutinesFacade.INSTANCE.currentThreadCoroutineContext();
            InstalledThreadContext installedThreadContext = tlCoroutineContext.get();
            CoroutineContext snapshot$iv = installedThreadContext.component1();
            CoroutineContext overridingContext$iv = installedThreadContext.component2();
            if (suspendingContext$iv == snapshot$iv) {
                coroutineContext = overridingContext$iv;
            } else {
                CoroutineContext it = suspendingContext$iv;
                boolean bl = false;
                coroutineContext = it;
            }
            if (coroutineContext == null && !ThreadContext.isKnownViolator()) {
                LOG.warn("Missing thread context", new Throwable());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isKnownViolator() {
        boolean bl;
        block8: {
            void $this$mapTo$iv$iv;
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
            Object[] $this$map$iv = stackTraceElementArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                StackTraceElement stackTraceElement = (StackTraceElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getClassName() + '.' + it.getMethodName());
            }
            List stackTrace = (List)destination$iv$iv;
            Iterable $this$any$iv = VIOLATORS;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl3;
                    block7: {
                        String badTrace = (String)element$iv;
                        boolean bl4 = false;
                        Iterable $this$any$iv2 = stackTrace;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                String it = (String)element$iv2;
                                boolean bl5 = false;
                                if (!StringsKt.startsWith$default((String)it, (String)badTrace, (boolean)false, (int)2, null)) continue;
                                bl3 = true;
                                break block7;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final void warnAccidentalCancellation() {
        if (!shouldWarnAccidentalCancellation) {
            return;
        }
        if (Cancellation.isInNonCancelableSection()) {
            return;
        }
        CoroutineContext kotlinCoroutineContext = IntelliJCoroutinesFacade.INSTANCE.currentThreadCoroutineContext();
        CoroutineContext snapshot = tlCoroutineContext.get().component1();
        if (snapshot == kotlinCoroutineContext) {
            return;
        }
        CoroutineContext coroutineContext = kotlinCoroutineContext;
        boolean bl = coroutineContext != null && (coroutineContext = (Job)coroutineContext.get((CoroutineContext.Key)Job.Key)) != null ? !coroutineContext.isActive() : false;
        if (bl) {
            LOG.warn("Detected a cancellation in an implicit non-cancellable section.\nThe code executing here will be aborted because of cancellation.\nIf this behavior is unexpected, please consult the documentation for com.intellij.concurrency.ThreadContext.warnAccidentalCancellation.", new Throwable("Querying stacktrace"));
        }
    }

    @Deprecated(message="Use resetThreadContext", replaceWith=@ReplaceWith(expression="resetThreadContext(action)", imports={}))
    @NotNull
    public static final AccessToken resetThreadContext() {
        return ThreadContext.withThreadLocal(tlCoroutineContext, ThreadContext::resetThreadContext$lambda$0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T resetThreadContext(@NotNull Function0<? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        AutoCloseable autoCloseable = ThreadContext.resetThreadContext();
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            object = action.invoke();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T installThreadContext(@NotNull CoroutineContext coroutineContext, boolean replace, @NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        AutoCloseable autoCloseable = ThreadContext.installThreadContext(coroutineContext, replace);
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            Object object = action.invoke();
            return (T)object;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ Object installThreadContext$default(CoroutineContext coroutineContext, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return ThreadContext.installThreadContext(coroutineContext, bl, function0);
    }

    @Deprecated(message="Use higher-order function for installation of thread context")
    @NotNull
    public static final AccessToken installThreadContext(@NotNull CoroutineContext coroutineContext, boolean replace) {
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        AccessToken applyToken = ThreadContext.applyThreadContextElements(coroutineContext);
        AccessToken tlToken = ThreadContext.withThreadLocal(tlCoroutineContext, arg_0 -> ThreadContext.installThreadContext$lambda$1(replace, coroutineContext, arg_0));
        return new AccessToken(tlToken, applyToken){
            final /* synthetic */ AccessToken $tlToken;
            final /* synthetic */ AccessToken $applyToken;
            {
                this.$tlToken = $tlToken;
                this.$applyToken = $applyToken;
            }

            public void finish() {
                this.$tlToken.finish();
                this.$applyToken.finish();
            }
        };
    }

    public static /* synthetic */ AccessToken installThreadContext$default(CoroutineContext coroutineContext, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return ThreadContext.installThreadContext(coroutineContext, bl);
    }

    private static final AccessToken applyThreadContextElements(CoroutineContext context) {
        List threadLocalValues = (List)new SmartList();
        context.fold((Object)Unit.INSTANCE, (arg_0, arg_1) -> ThreadContext.applyThreadContextElements$lambda$0(threadLocalValues, context, arg_0, arg_1));
        return new AccessToken(threadLocalValues, context){
            final /* synthetic */ List<Pair<ThreadContextElement<?>, Object>> $threadLocalValues;
            final /* synthetic */ CoroutineContext $context;
            {
                this.$threadLocalValues = $threadLocalValues;
                this.$context = $context;
            }

            public void finish() {
                for (Pair pair : CollectionsKt.asReversedMutable(this.$threadLocalValues)) {
                    ThreadContextElement elem = (ThreadContextElement)pair.component1();
                    Object previousValue = pair.component2();
                    elem.restoreThreadContext(this.$context, previousValue);
                }
            }
        };
    }

    @ApiStatus.Internal
    @Nullable
    public static final CoroutineContext currentTemporaryThreadContextOrNull() {
        return tlTemporaryContext.get();
    }

    @ApiStatus.Internal
    @NotNull
    public static final AccessToken installTemporaryThreadContext(@NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        return ThreadContext.withThreadLocal(tlTemporaryContext, arg_0 -> ThreadContext.installTemporaryThreadContext$lambda$0(coroutineContext, arg_0));
    }

    @ApiStatus.Internal
    @NotNull
    public static final <T> AccessToken withThreadLocal(@NotNull ThreadLocal<T> variable, @NotNull Function1<? super T, ? extends T> update) {
        Intrinsics.checkNotNullParameter(variable, (String)"variable");
        Intrinsics.checkNotNullParameter(update, (String)"update");
        T previousValue = variable.get();
        Object newValue = update.invoke(previousValue);
        if (newValue == previousValue) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            Intrinsics.checkNotNullExpressionValue((Object)accessToken, (String)"EMPTY_ACCESS_TOKEN");
            return accessToken;
        }
        variable.set(newValue);
        return new AccessToken(variable, previousValue, newValue){
            final /* synthetic */ ThreadLocal<T> $variable;
            final /* synthetic */ T $previousValue;
            final /* synthetic */ T $newValue;
            {
                this.$variable = $variable;
                this.$previousValue = $previousValue;
                this.$newValue = $newValue;
            }

            public void finish() {
                T currentValue = this.$variable.get();
                this.$variable.set(this.$previousValue);
                boolean bl = currentValue == this.$newValue;
                T t = this.$newValue;
                if (!bl) {
                    boolean bl2 = false;
                    String string = "Value was not reset correctly. Expected: " + t + ", actual: " + currentValue;
                    throw new IllegalStateException(string.toString());
                }
            }
        };
    }

    @ApiStatus.Internal
    @NotNull
    public static final Runnable captureThreadContext(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        return Propagation.captureRunnableThreadContext(runnable);
    }

    @ApiStatus.Internal
    @NotNull
    public static final <T> Supplier<T> captureThreadContext(@NotNull Supplier<T> s) {
        Intrinsics.checkNotNullParameter(s, (String)"s");
        Callable<Object> c = Propagation.captureCallableThreadContext(s::get);
        return c::call;
    }

    @ApiStatus.Internal
    @NotNull
    public static final <T> Consumer<T> captureThreadContext(@NotNull Consumer<T> c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        Function<Object, Unit> f = Propagation.capturePropagationContext(p0$p0 -> {
            c.accept(p0$p0);
            return Unit.INSTANCE;
        });
        return p0$p0 -> f.apply(p0$p0);
    }

    @ApiStatus.Internal
    @NotNull
    public static final <T, U> Function<T, U> captureThreadContext(@NotNull Function<T, U> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        return Propagation.capturePropagationContext(f);
    }

    @ApiStatus.Internal
    @NotNull
    public static final <T> Function0<T> captureThreadContext(@NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Callable<Object> c = Propagation.captureCallableThreadContext(() -> ThreadContext.captureThreadContext$lambda$0(action));
        return new Function0<T>(c){

            public final T invoke() {
                return (T)((Callable)this.receiver).call();
            }
        };
    }

    @ApiStatus.Internal
    @NotNull
    public static final <T> Processor<T> captureThreadContextProcessor(@NotNull Processor<T> processor) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Function<Object, Boolean> c = ThreadContext.captureThreadContext(arg_0 -> ThreadContext.captureThreadContextProcessor$lambda$0(processor, arg_0));
        return arg_0 -> ThreadContext.captureThreadContextProcessor$lambda$1(c, arg_0);
    }

    @ApiStatus.Internal
    @NotNull
    public static final <V> Callable<V> captureThreadContext(@NotNull Callable<V> callable) {
        Intrinsics.checkNotNullParameter(callable, (String)"callable");
        return Propagation.captureCallableThreadContext(callable);
    }

    private static final boolean isStacktraceLoggingEnabled() {
        return LOG.isTraceEnabled();
    }

    private static final Throwable tracingHint() {
        return new Throwable("To enable stack trace recording set log category '#com.intellij.concurrency' to 'trace'");
    }

    private static final InstalledThreadContext tlCoroutineContext$lambda$0() {
        return INITIAL_THREAD_CONTEXT;
    }

    private static final InstalledThreadContext resetThreadContext$lambda$0(InstalledThreadContext installedThreadContext) {
        Intrinsics.checkNotNullParameter((Object)installedThreadContext, (String)"<unused var>");
        CoroutineContext currentSnapshot = IntelliJCoroutinesFacade.INSTANCE.currentThreadCoroutineContext();
        return new InstalledThreadContext(currentSnapshot, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final InstalledThreadContext installThreadContext$lambda$1(boolean $replace, CoroutineContext $coroutineContext, InstalledThreadContext previousContext) {
        Intrinsics.checkNotNullParameter((Object)previousContext, (String)"previousContext");
        CoroutineContext currentSnapshot = IntelliJCoroutinesFacade.INSTANCE.currentThreadCoroutineContext();
        if (!$replace && previousContext.getSnapshot() == currentSnapshot && previousContext.getContext() != null) {
            void $this$installThreadContext_u24lambda_u241_u240;
            Throwable throwable;
            Throwable throwable2 = throwable = new Throwable("Thread context was already set: " + previousContext + ". \n Most likely, you are using 'runBlocking' instead of 'runBlockingCancellable' somewhere in the asynchronous stack. \nAlso, if you have any kind of manual event queue draining/pumping/flushing/etc \nyou have to wrap the loop with `resetThreadContext().use { // your queue draining code }`. \nSee usages of resetThreadContext().");
            Logger logger = LOG;
            boolean bl = false;
            Throwable throwable3 = previousContext.getCreationTrace();
            if (throwable3 == null) {
                throwable3 = ThreadContext.tracingHint();
            }
            ExceptionsKt.addSuppressed((Throwable)$this$installThreadContext_u24lambda_u241_u240, (Throwable)throwable3);
            logger.error(throwable);
        }
        return new InstalledThreadContext(currentSnapshot, $coroutineContext);
    }

    private static final Unit applyThreadContextElements$lambda$0(List $threadLocalValues, CoroutineContext $context, Unit unit, CoroutineContext.Element elem) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
        if (elem instanceof ThreadContextElement && !(elem instanceof CoroutineId)) {
            $threadLocalValues.add(TuplesKt.to((Object)elem, (Object)((ThreadContextElement)elem).updateThreadContext($context)));
        }
        return Unit.INSTANCE;
    }

    private static final CoroutineContext installTemporaryThreadContext$lambda$0(CoroutineContext $coroutineContext, CoroutineContext coroutineContext) {
        return $coroutineContext;
    }

    private static final Object captureThreadContext$lambda$0(Function0 $tmp0) {
        return $tmp0.invoke();
    }

    private static final Boolean captureThreadContextProcessor$lambda$0(Processor $processor, Object it) {
        return $processor.process(it);
    }

    private static final boolean captureThreadContextProcessor$lambda$1(Function $c, Object it) {
        Object r = $c.apply(it);
        Intrinsics.checkNotNullExpressionValue(r, (String)"apply(...)");
        return (Boolean)r;
    }

    public static final /* synthetic */ boolean access$isStacktraceLoggingEnabled() {
        return ThreadContext.isStacktraceLoggingEnabled();
    }

    static {
        Logger logger = Logger.getInstance(category);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        INITIAL_THREAD_CONTEXT = new InstalledThreadContext(null, null);
        ThreadLocal<InstalledThreadContext> threadLocal = ThreadLocal.withInitial(ThreadContext::tlCoroutineContext$lambda$0);
        Intrinsics.checkNotNullExpressionValue(threadLocal, (String)"withInitial(...)");
        tlCoroutineContext = threadLocal;
        Object[] objectArray = new String[]{"com.intellij.diagnostic", "com.intellij.openapi.wm.impl", "com.intellij.model.SideEffectGuard", "com.intellij.openapi.editor.impl", "com.intellij.ui.components", "com.intellij.openapi.progress.util", "com.intellij.openapi.application.impl.NonBlockingReadActionImpl$Submission.reschedule", "com.intellij.openapi.keymap.impl.SystemShortcuts", "com.intellij.ide.IdeKeyboardFocusManager", "com.intellij.execution.process.ProcessIOExecutorService", "com.intellij.util.animation", "com.intellij.util.ui", "com.intellij.ide.ui.popup", "com.intellij.ui", "org.jetbrains.io", "com.intellij.javascript.polySymbols.nodejs.WebTypesNpmLoader", "com.intellij.tasks", "com.intellij.util.concurrency.Invoker", "com.intellij.openapi.application.constraints", "com.intellij.openapi.actionSystem", "org.jetbrains.idea.maven.server", "com.intellij.internal.statistic", "com.intellij.openapi.diagnostic.Logger", "com.intellij.openapi.extensions.impl.ExtensionPointImpl.getExtensionList", "com.intellij.openapi.extensions.impl.ExtensionPointImpl.getExtensions", "com.intellij.serviceContainer.LazyExtensionInstance.createInstance", "com.intellij.ui.icons", "com.intellij.ui.tree", "com.intellij.openapi.project.SmartModeScheduler.onStateChanged", "javax.swing.JComponent.paint", "com.intellij.openapi.application.impl.LaterInvocator.leaveModal", "com.intellij.openapi.application.impl.LaterInvocator.invokeAndWait", "com.intellij.util.animation.JBAnimator.animate", "com.intellij.util.messages.impl.SimpleMessageBusConnectionImpl.disconnect", "com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl.scheduleUpdateRunnable", "com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl.stopProcess", "com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl", "com.intellij.openapi.wm.impl.WindowCloseListener.windowClosing", "com.intellij.ide.ApplicationActivationStateManager.updateState", "com.intellij.openapi.util.io.GentleFlusherBase"};
        VIOLATORS = CollectionsKt.listOf((Object[])objectArray);
        shouldWarnAccidentalCancellation = SystemProperties.getBooleanProperty((String)"ide.warn.accidental.cancellation", (boolean)false);
        tlTemporaryContext = new ThreadLocal();
    }
}

