/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.util.io.NioFiles;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/diagnostic/OldAttachmentPruner;", "", "baseDir", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "counter", "Ljava/util/concurrent/atomic/AtomicInteger;", "pruneOldAttachmentGroups", "", "collectAttachmentGroups", "", "intellij.platform.util"})
@SourceDebugExtension(value={"SMAP\nAttachmentHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttachmentHandler.kt\ncom/intellij/openapi/diagnostic/OldAttachmentPruner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,279:1\n1021#2,2:280\n*S KotlinDebug\n*F\n+ 1 AttachmentHandler.kt\ncom/intellij/openapi/diagnostic/OldAttachmentPruner\n*L\n245#1:280,2\n*E\n"})
final class OldAttachmentPruner {
    @NotNull
    private final Path baseDir;
    @NotNull
    private final AtomicInteger counter;

    public OldAttachmentPruner(@NotNull Path baseDir) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        this.baseDir = baseDir;
        this.counter = new AtomicInteger(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pruneOldAttachmentGroups() {
        int recentlyReported = this.counter.incrementAndGet();
        if (recentlyReported * 2 < 100) {
            return;
        }
        AtomicInteger atomicInteger = this.counter;
        synchronized (atomicInteger) {
            boolean bl = false;
            if (this.counter.get() * 2 < 100) {
                return;
            }
            List<Path> entries = this.collectAttachmentGroups();
            int toDeleteCount = entries.size() - 100;
            if (toDeleteCount <= 0) {
                return;
            }
            List<Path> $this$sortBy$iv = entries;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Path it = (Path)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)((Object)it.getFileName()).toString());
                        it = (Path)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((Object)it.getFileName()).toString())));
                    }
                });
            }
            try {
                int n = 0;
                while (n < toDeleteCount) {
                    int i = n++;
                    boolean bl2 = false;
                    NioFiles.deleteRecursively(entries.get(i));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.counter.set(0);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Path> collectAttachmentGroups() {
        List list;
        try {
            List list2;
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.baseDir, arg_0 -> OldAttachmentPruner.collectAttachmentGroups$lambda$1(OldAttachmentPruner::collectAttachmentGroups$lambda$0, arg_0));
            Closeable closeable = directoryStream;
            Throwable throwable = null;
            try {
                DirectoryStream ds = (DirectoryStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)ds);
                list2 = CollectionsKt.toMutableList((Iterable)ds);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            list = list2;
        }
        catch (IOException iOException) {
            list = new ArrayList();
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean collectAttachmentGroups$lambda$0(Path path) {
        if (!Files.isDirectory(path, new LinkOption[0])) return false;
        Intrinsics.checkNotNull((Object)path);
        if (!StringsKt.startsWith$default((String)PathsKt.getName((Path)path), (String)"attachments-", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private static final boolean collectAttachmentGroups$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

