/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.concurrency.SchedulingWrapper;
import java.util.Objects;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class AppDelayQueue
extends DelayQueue<SchedulingWrapper.MyScheduledFutureTask<?>> {
    private static final Logger LOG = Logger.getInstance(AppDelayQueue.class);
    private final TransferThread transferThread = new TransferThread();
    private final AtomicReference<Throwable> shutdownTrace = new AtomicReference();
    private volatile SchedulingWrapper.MyScheduledFutureTask<Void> myPoisonPill;

    AppDelayQueue() {
        this.transferThread.setDaemon(true);
        this.transferThread.start();
    }

    void shutdown(@NotNull SchedulingWrapper schedulingWrapper) {
        if (schedulingWrapper == null) {
            AppDelayQueue.$$$reportNull$$$0(0);
        }
        SchedulingWrapper schedulingWrapper2 = schedulingWrapper;
        Objects.requireNonNull(schedulingWrapper2);
        this.myPoisonPill = new SchedulingWrapper.MyScheduledFutureTask<Void>(schedulingWrapper2, EmptyRunnable.getInstance(), null, 0L){
            {
                SchedulingWrapper schedulingWrapper = x0;
                Objects.requireNonNull(schedulingWrapper);
                super(schedulingWrapper, r, result, ns);
            }

            @Override
            public void executeMeInBackendExecutor() {
                this.set(null);
                throw new ShutdownException();
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public String toString() {
                return "poison pill";
            }
        };
        Throwable throwable = this.shutdownTrace.getAndSet(new Throwable());
        if (throwable != null) {
            throw new IllegalStateException("Already shutdown", throwable);
        }
        super.offer(this.myPoisonPill);
    }

    /*
     * WARNING - void declaration
     */
    boolean awaitTermination(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException {
        void unit;
        if (timeUnit == null) {
            AppDelayQueue.$$$reportNull$$$0(1);
        }
        assert (Thread.currentThread() != this.transferThread);
        if (this.shutdownTrace.get() == null) {
            throw new IllegalStateException("must call shutdown before");
        }
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        try {
            this.myPoisonPill.get(timeout, (TimeUnit)unit);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            return false;
        }
        this.transferThread.join(TimeUnit.NANOSECONDS.toMillis(Math.max(1L, deadline - System.nanoTime())));
        return !this.transferThread.isAlive();
    }

    @Override
    public boolean offer(@NotNull SchedulingWrapper.MyScheduledFutureTask<?> task) {
        Throwable throwable;
        if (task == null) {
            AppDelayQueue.$$$reportNull$$$0(2);
        }
        if ((throwable = this.shutdownTrace.get()) != null) {
            throw new IllegalStateException("Already shutdown", throwable);
        }
        return super.offer(task);
    }

    @NotNull
    Thread getThread() {
        TransferThread transferThread = this.transferThread;
        if (transferThread == null) {
            AppDelayQueue.$$$reportNull$$$0(3);
        }
        return transferThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schedulingWrapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/concurrency/AppDelayQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/concurrency/AppDelayQueue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shutdown";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "awaitTermination";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "offer";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class TransferThread
    extends Thread {
        private TransferThread() {
            super("Periodic tasks thread");
        }

        @Override
        public void run() {
            while (true) {
                SchedulingWrapper.MyScheduledFutureTask task;
                try {
                    task = (SchedulingWrapper.MyScheduledFutureTask)AppDelayQueue.this.take();
                }
                catch (InterruptedException e) {
                    if (AppDelayQueue.this.shutdownTrace.get() != null) break;
                    LOG.error(e);
                    break;
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Took " + BoundedTaskExecutor.info(task));
                }
                try {
                    task.executeMeInBackendExecutor();
                    continue;
                }
                catch (ShutdownException e) {
                }
                catch (Throwable e) {
                    try {
                        LOG.error("Error executing " + task, e);
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                break;
            }
            LOG.debug("AppDelayQueue.TransferrerThread Stopped");
        }
    }

    private static class ShutdownException
    extends RuntimeException {
        private ShutdownException() {
        }
    }
}

