/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.indexing.impl.ChangeTrackingValueContainer;
import com.intellij.util.indexing.impl.MapIndexStorageCache;
import com.intellij.util.indexing.impl.MapIndexStorageCacheProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BiConsumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016Jn\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r0\u000b\"\b\b\u0000\u0010\f*\u00020\u000e\"\u0004\b\u0001\u0010\r2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u0002H\f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\r0\u00110\u00102\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u0002H\f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\r0\u00110\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\f0\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/util/indexing/impl/MRUIndexStorageCacheProvider;", "Lcom/intellij/util/indexing/impl/MapIndexStorageCacheProvider;", "<init>", "()V", "totalReads", "Ljava/util/concurrent/atomic/AtomicLong;", "totalUncachedReads", "totalEvicted", "", "totalReadsUncached", "createCache", "Lcom/intellij/util/indexing/impl/MapIndexStorageCache;", "Key", "Value", "", "valueReader", "Ljava/util/function/Function;", "Lcom/intellij/util/indexing/impl/ChangeTrackingValueContainer;", "evictedValuesPersister", "Ljava/util/function/BiConsumer;", "hashingStrategy", "Lcom/intellij/util/containers/hash/EqualityPolicy;", "cacheSizeHint", "", "MRUCache", "intellij.platform.util"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMapIndexStorageCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapIndexStorageCache.kt\ncom/intellij/util/indexing/impl/MRUIndexStorageCacheProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,367:1\n23#2:368\n*S KotlinDebug\n*F\n+ 1 MapIndexStorageCache.kt\ncom/intellij/util/indexing/impl/MRUIndexStorageCacheProvider\n*L\n265#1:368\n*E\n"})
public final class MRUIndexStorageCacheProvider
implements MapIndexStorageCacheProvider {
    @NotNull
    private final AtomicLong totalReads;
    @NotNull
    private final AtomicLong totalUncachedReads;
    @NotNull
    private final AtomicLong totalEvicted;

    public MRUIndexStorageCacheProvider() {
        MRUIndexStorageCacheProvider $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(MRUIndexStorageCacheProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("MRU cache will be used for indexes");
        this.totalReads = new AtomicLong();
        this.totalUncachedReads = new AtomicLong();
        this.totalEvicted = new AtomicLong();
    }

    @Override
    public long totalReads() {
        return this.totalReads.get();
    }

    @Override
    public long totalReadsUncached() {
        return this.totalUncachedReads.get();
    }

    @Override
    public long totalEvicted() {
        return this.totalEvicted.get();
    }

    @Override
    @NotNull
    public <Key, Value> MapIndexStorageCache<Key, Value> createCache(@NotNull Function<Key, ChangeTrackingValueContainer<Value>> valueReader, @NotNull BiConsumer<Key, ChangeTrackingValueContainer<Value>> evictedValuesPersister, @NotNull EqualityPolicy<Key> hashingStrategy, int cacheSizeHint) {
        Intrinsics.checkNotNullParameter(valueReader, (String)"valueReader");
        Intrinsics.checkNotNullParameter(evictedValuesPersister, (String)"evictedValuesPersister");
        Intrinsics.checkNotNullParameter(hashingStrategy, (String)"hashingStrategy");
        MRUCache<Object, ChangeTrackingValueContainer> cache2 = new MRUCache<Object, ChangeTrackingValueContainer>(arg_0 -> MRUIndexStorageCacheProvider.createCache$lambda$0(this, valueReader, arg_0), (arg_0, arg_1) -> MRUIndexStorageCacheProvider.createCache$lambda$1(this, evictedValuesPersister, arg_0, arg_1), hashingStrategy, cacheSizeHint * 5 / 4);
        return new MapIndexStorageCache<Key, Value>(this, cache2){
            final /* synthetic */ MRUIndexStorageCacheProvider this$0;
            final /* synthetic */ MRUCache<Key, ChangeTrackingValueContainer<Value>> $cache;
            {
                this.this$0 = $receiver;
                this.$cache = $cache;
            }

            public ChangeTrackingValueContainer<Value> read(Key key) {
                Intrinsics.checkNotNullParameter(key, (String)"key");
                MRUIndexStorageCacheProvider.access$getTotalReads$p(this.this$0).incrementAndGet();
                ChangeTrackingValueContainer<Value> changeTrackingValueContainer = this.$cache.get(key);
                Intrinsics.checkNotNullExpressionValue(changeTrackingValueContainer, (String)"get(...)");
                return changeTrackingValueContainer;
            }

            public ChangeTrackingValueContainer<Value> readIfCached(Key key) {
                Intrinsics.checkNotNullParameter(key, (String)"key");
                MRUIndexStorageCacheProvider.access$getTotalReads$p(this.this$0).incrementAndGet();
                return this.$cache.getIfCached(key);
            }

            public Collection<ChangeTrackingValueContainer<Value>> getCachedValues() {
                return this.$cache.values();
            }

            public void invalidateAll() {
                this.$cache.invalidateAll();
            }
        };
    }

    private static final ChangeTrackingValueContainer createCache$lambda$0(MRUIndexStorageCacheProvider this$0, Function $valueReader, Object key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this$0.totalUncachedReads.incrementAndGet();
        return (ChangeTrackingValueContainer)$valueReader.apply(key);
    }

    private static final void createCache$lambda$1(MRUIndexStorageCacheProvider this$0, BiConsumer $evictedValuesPersister, Object key, ChangeTrackingValueContainer value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this$0.totalEvicted.incrementAndGet();
        $evictedValuesPersister.accept(key, value);
    }

    public static final /* synthetic */ AtomicLong access$getTotalReads$p(MRUIndexStorageCacheProvider $this) {
        return $this.totalReads;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u00020\u0002:\u0001\u001fBE\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0013\u0010\u0017\u001a\u00028\u00012\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00010\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u0014\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/util/indexing/impl/MRUIndexStorageCacheProvider$MRUCache;", "Key", "", "Value", "valueReader", "Ljava/util/function/Function;", "evictedValuesPersister", "Ljava/util/function/BiConsumer;", "hashingStrategy", "Lcom/intellij/util/containers/hash/EqualityPolicy;", "cacheSize", "", "<init>", "(Ljava/util/function/Function;Ljava/util/function/BiConsumer;Lcom/intellij/util/containers/hash/EqualityPolicy;I)V", "getValueReader", "()Ljava/util/function/Function;", "getEvictedValuesPersister", "()Ljava/util/function/BiConsumer;", "getHashingStrategy", "()Lcom/intellij/util/containers/hash/EqualityPolicy;", "table", "Ljava/util/concurrent/atomic/AtomicReferenceArray;", "Lcom/intellij/util/indexing/impl/MRUIndexStorageCacheProvider$MRUCache$CacheEntry;", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "getIfCached", "values", "", "invalidateAll", "", "CacheEntry", "intellij.platform.util"})
    @SourceDebugExtension(value={"SMAP\nMapIndexStorageCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapIndexStorageCache.kt\ncom/intellij/util/indexing/impl/MRUIndexStorageCacheProvider$MRUCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,367:1\n1#2:368\n*E\n"})
    private static final class MRUCache<Key, Value> {
        @NotNull
        private final Function<Key, Value> valueReader;
        @NotNull
        private final BiConsumer<Key, Value> evictedValuesPersister;
        @NotNull
        private final EqualityPolicy<Key> hashingStrategy;
        @NotNull
        private final AtomicReferenceArray<CacheEntry<Key, Value>> table;

        public MRUCache(@NotNull Function<Key, Value> valueReader, @NotNull BiConsumer<Key, Value> evictedValuesPersister, @NotNull EqualityPolicy<Key> hashingStrategy, int cacheSize) {
            Intrinsics.checkNotNullParameter(valueReader, (String)"valueReader");
            Intrinsics.checkNotNullParameter(evictedValuesPersister, (String)"evictedValuesPersister");
            Intrinsics.checkNotNullParameter(hashingStrategy, (String)"hashingStrategy");
            this.valueReader = valueReader;
            this.evictedValuesPersister = evictedValuesPersister;
            this.hashingStrategy = hashingStrategy;
            this.table = new AtomicReferenceArray(cacheSize);
        }

        @NotNull
        public final Function<Key, Value> getValueReader() {
            return this.valueReader;
        }

        @NotNull
        public final BiConsumer<Key, Value> getEvictedValuesPersister() {
            return this.evictedValuesPersister;
        }

        @NotNull
        public final EqualityPolicy<Key> getHashingStrategy() {
            return this.hashingStrategy;
        }

        public final Value get(@NotNull Key key) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            int hash = this.hashingStrategy.getHashCode(key);
            int index = Math.abs(hash % this.table.length());
            CacheEntry<Key, Value> entry = this.table.get(index);
            if (entry != null && this.hashingStrategy.isEqual(entry.getKey(), key)) {
                return entry.getValue();
            }
            Value value = this.valueReader.apply(key);
            this.table.set(index, new CacheEntry<Key, Value>(key, value));
            if (entry != null) {
                this.evictedValuesPersister.accept(entry.getKey(), entry.getValue());
            }
            return value;
        }

        @Nullable
        public final Value getIfCached(@NotNull Key key) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            int hash = this.hashingStrategy.getHashCode(key);
            int index = Math.abs(hash % this.table.length());
            CacheEntry<Key, Value> entry = this.table.get(index);
            if (entry != null && this.hashingStrategy.isEqual(entry.getKey(), key)) {
                return entry.getValue();
            }
            return null;
        }

        @NotNull
        public final Collection<Value> values() {
            List values = new ArrayList();
            int n = this.table.length();
            for (int i = 0; i < n; ++i) {
                CacheEntry<Key, Value> it;
                if (this.table.get(i) == null) continue;
                boolean bl = false;
                values.add(it.getValue());
            }
            return values;
        }

        public final void invalidateAll() {
            int n = this.table.length();
            for (int i = 0; i < n; ++i) {
                if (this.table.get(i) != null) {
                    CacheEntry<Key, Value> entry;
                    boolean bl = false;
                    this.evictedValuesPersister.accept(entry.getKey(), entry.getValue());
                }
                this.table.set(i, null);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u0002*\u0004\b\u0003\u0010\u00032\u00020\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00028\u0002\u0012\u0006\u0010\u0005\u001a\u00028\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00028\u0002H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\r\u001a\u00028\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ.\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00002\b\b\u0002\u0010\u0004\u001a\u00028\u00022\b\b\u0002\u0010\u0005\u001a\u00028\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004J\n\u0010\u0015\u001a\u00020\u0016H\u00d6\u0081\u0004R\u0013\u0010\u0004\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0005\u001a\u00028\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/intellij/util/indexing/impl/MRUIndexStorageCacheProvider$MRUCache$CacheEntry;", "K", "", "V", "key", "value", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;)V", "getKey", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getValue", "component1", "component2", "copy", "(Ljava/lang/Object;Ljava/lang/Object;)Lcom/intellij/util/indexing/impl/MRUIndexStorageCacheProvider$MRUCache$CacheEntry;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.util"})
        private static final class CacheEntry<K, V> {
            @NotNull
            private final K key;
            private final V value;

            public CacheEntry(@NotNull K key, V value) {
                Intrinsics.checkNotNullParameter(key, (String)"key");
                this.key = key;
                this.value = value;
            }

            @NotNull
            public final K getKey() {
                return this.key;
            }

            public final V getValue() {
                return this.value;
            }

            @NotNull
            public final K component1() {
                return this.key;
            }

            public final V component2() {
                return this.value;
            }

            @NotNull
            public final CacheEntry<K, V> copy(@NotNull K key, V value) {
                Intrinsics.checkNotNullParameter(key, (String)"key");
                return new CacheEntry<K, V>(key, value);
            }

            public static /* synthetic */ CacheEntry copy$default(CacheEntry cacheEntry, Object object, Object object2, int n, Object object3) {
                if ((n & 1) != 0) {
                    object = cacheEntry.key;
                }
                if ((n & 2) != 0) {
                    object2 = cacheEntry.value;
                }
                return cacheEntry.copy(object, object2);
            }

            @NotNull
            public String toString() {
                return "CacheEntry(key=" + this.key + ", value=" + this.value + ')';
            }

            public int hashCode() {
                int result = this.key.hashCode();
                result = result * 31 + (this.value == null ? 0 : this.value.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CacheEntry)) {
                    return false;
                }
                CacheEntry cacheEntry = (CacheEntry)other;
                if (!Intrinsics.areEqual(this.key, cacheEntry.key)) {
                    return false;
                }
                return Intrinsics.areEqual(this.value, cacheEntry.value);
            }
        }
    }
}

