/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryKeyDescriptor;
import com.intellij.openapi.util.registry.RegistryValue$asBooleanFlow$;
import com.intellij.openapi.util.registry.RegistryValue$asDoubleFlow$;
import com.intellij.openapi.util.registry.RegistryValue$asIntegerFlow$;
import com.intellij.openapi.util.registry.RegistryValueKt;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.util.registry.RegistryValueSource;
import com.intellij.openapi.util.registry.ValueWithSource;
import com.intellij.ui.ColorHexUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.MissingResourceException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 Q2\u00020\u0001:\u0001QB(\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007J\r\u0010 \u001a\u00070\u0005\u00a2\u0006\u0002\b!H\u0016J\b\u0010\"\u001a\u00020\u0013H\u0016J\u0006\u0010#\u001a\u00020\u0018J\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050&J\u001a\u0010*\u001a\u00020,2\b\u0010'\u001a\u0004\u0018\u00010\u00052\u0006\u0010-\u001a\u00020\u001fH\u0007J\u000e\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\u0005J\u0006\u00100\u001a\u00020\u001bJ\b\u00101\u001a\u00020\u001bH\u0002J\u0012\u00102\u001a\u0004\u0018\u0001032\b\u00104\u001a\u0004\u0018\u000103J\b\u00107\u001a\u00020\u0013H\u0016J\b\u00108\u001a\u00020\u0013H\u0016J\u0017\u0010;\u001a\u0004\u0018\u00010\u00052\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0002J\u0017\u0010<\u001a\u0004\u0018\u00010\u00052\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0007J\u0015\u0010=\u001a\u00020\u00052\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0002J\u0015\u0010>\u001a\u00020,2\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0002J\u000e\u0010?\u001a\u00020,2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010?\u001a\u00020,2\u0006\u0010\u0012\u001a\u00020\u0018J\u0010\u0010?\u001a\u00020,2\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u0018\u0010?\u001a\u00020,2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u001fH\u0017J\u0016\u0010?\u001a\u00020,2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010@\u001a\u00020AJ\u0016\u0010?\u001a\u00020,2\u0006\u0010\u0012\u001a\u00020\u00182\u0006\u0010@\u001a\u00020AJ\u0018\u0010?\u001a\u00020,2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010@\u001a\u00020AH\u0007J\u0006\u0010B\u001a\u00020,J\u0016\u0010C\u001a\u00020,2\u0006\u0010D\u001a\u00020\u000f2\u0006\u0010E\u001a\u00020AJ\u0016\u0010C\u001a\u00020,2\u0006\u0010D\u001a\u00020\u000f2\u0006\u0010F\u001a\u00020GJ\u000e\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00050IH\u0007J\u000e\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00130IH\u0007J\u000e\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00180IH\u0007J\u000e\u0010L\u001a\b\u0012\u0004\u0012\u00020\u001b0IH\u0007J\r\u0010M\u001a\u00020,H\u0000\u00a2\u0006\u0002\bNJ\b\u0010P\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0011\u0010$\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0015R2\u0010(\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b!2\r\u0010'\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b!8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010\f\"\u0004\b*\u0010+R\u0019\u00105\u001a\u00070\u0005\u00a2\u0006\u0002\b!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010\fR\u0013\u00109\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\fR\u0014\u0010O\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bO\u0010\u0015\u00a8\u0006R"}, d2={"Lcom/intellij/openapi/util/registry/RegistryValue;", "", "registry", "Lcom/intellij/openapi/util/registry/Registry;", "key", "", "Lorg/jetbrains/annotations/NonNls;", "keyDescriptor", "Lcom/intellij/openapi/util/registry/RegistryKeyDescriptor;", "<init>", "(Lcom/intellij/openapi/util/registry/Registry;Ljava/lang/String;Lcom/intellij/openapi/util/registry/RegistryKeyDescriptor;)V", "getKey", "()Ljava/lang/String;", "listeners", "", "Lcom/intellij/openapi/util/registry/RegistryValueListener;", "flow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "value", "", "isChangedSinceAppStart", "()Z", "stringCachedValue", "intCachedValue", "", "Ljava/lang/Integer;", "doubleCachedValue", "", "booleanCachedValue", "Ljava/lang/Boolean;", "getSource", "Lcom/intellij/openapi/util/registry/RegistryValueSource;", "asString", "Lcom/intellij/openapi/util/NlsSafe;", "asBoolean", "asInteger", "isMultiValue", "asOptions", "", "selected", "selectedOption", "getSelectedOption", "setSelectedOption", "(Ljava/lang/String;)V", "", "source", "isOptionEnabled", "option", "asDouble", "computeDouble", "asColor", "Ljava/awt/Color;", "defaultValue", "description", "getDescription", "isRestartRequired", "isChangedFromDefault", "pluginId", "getPluginId", "getAsValue", "resolveNotRequiredValue", "resolveRequiredValue", "checkIsLoaded", "setValue", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "resetToDefault", "addListener", "listener", "parent", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "asStringFlow", "Lkotlinx/coroutines/flow/Flow;", "asBooleanFlow", "asIntegerFlow", "asDoubleFlow", "resetCache", "resetCache$intellij_platform_util", "isBoolean", "toString", "Companion", "intellij.platform.util"})
@SourceDebugExtension(value={"SMAP\nRegistryValue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegistryValue.kt\ncom/intellij/openapi/util/registry/RegistryValue\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Transform.kt\nkotlinx/coroutines/flow/FlowKt__TransformKt\n+ 5 Emitters.kt\nkotlinx/coroutines/flow/FlowKt__EmittersKt\n+ 6 SafeCollector.common.kt\nkotlinx/coroutines/flow/internal/SafeCollector_commonKt\n*L\n1#1,370:1\n739#2,9:371\n739#2,9:380\n1#3:389\n49#4:390\n51#4:394\n49#4:395\n51#4:399\n49#4:400\n51#4:404\n46#5:391\n51#5:393\n46#5:396\n51#5:398\n46#5:401\n51#5:403\n105#6:392\n105#6:397\n105#6:402\n*S KotlinDebug\n*F\n+ 1 RegistryValue.kt\ncom/intellij/openapi/util/registry/RegistryValue\n*L\n99#1:371,9\n165#1:380,9\n336#1:390\n336#1:394\n344#1:395\n344#1:399\n352#1:400\n352#1:404\n336#1:391\n336#1:393\n344#1:396\n344#1:398\n352#1:401\n352#1:403\n336#1:392\n344#1:397\n352#1:402\n*E\n"})
public class RegistryValue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Registry registry;
    @NotNull
    private final String key;
    @Nullable
    private final RegistryKeyDescriptor keyDescriptor;
    @NotNull
    private final List<RegistryValueListener> listeners;
    @Nullable
    private final MutableSharedFlow<String> flow;
    private boolean isChangedSinceAppStart;
    @Nullable
    private String stringCachedValue;
    @Nullable
    private Integer intCachedValue;
    private double doubleCachedValue;
    @Nullable
    private Boolean booleanCachedValue;
    @NotNull
    private static final String NO_COROUTINES_DIAGNOSTIC = "There is no kotlinx.coroutines library in this environment";

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public RegistryValue(@NotNull Registry registry, @NotNull String key, @Nullable RegistryKeyDescriptor keyDescriptor) {
        BufferOverflow bufferOverflow;
        RegistryValue registryValue;
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.registry = registry;
        this.key = key;
        this.keyDescriptor = keyDescriptor;
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"createLockFreeCopyOnWriteList(...)");
        this.listeners = list;
        RegistryValue registryValue2 = this;
        try {
            registryValue = registryValue2;
            bufferOverflow = BufferOverflow.DROP_OLDEST;
            bufferOverflow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, (BufferOverflow)bufferOverflow, (int)1, null);
        }
        catch (Throwable throwable) {
            void e;
            registryValue = registryValue2;
            void var6_7 = e;
            if (!(var6_7 instanceof ClassNotFoundException) && !(var6_7 instanceof NoClassDefFoundError)) {
                throw e;
            }
            bufferOverflow = null;
        }
        registryValue.flow = bufferOverflow;
        this.doubleCachedValue = Double.NaN;
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    public final boolean isChangedSinceAppStart() {
        return this.isChangedSinceAppStart;
    }

    @ApiStatus.Experimental
    @Nullable
    public final RegistryValueSource getSource() {
        ValueWithSource valueWithSource = this.registry.getStoredProperties().get(this.key);
        return valueWithSource != null ? valueWithSource.getSource() : null;
    }

    @NotNull
    public String asString() {
        String result = this.stringCachedValue;
        if (result == null) {
            this.stringCachedValue = result = this.resolveRequiredValue(this.key);
        }
        return result;
    }

    public boolean asBoolean() {
        Boolean result = this.booleanCachedValue;
        if (result == null) {
            this.booleanCachedValue = result = Boolean.valueOf(Boolean.parseBoolean(this.resolveRequiredValue(this.key)));
        }
        return result;
    }

    public final int asInteger() {
        Integer result = this.intCachedValue;
        if (result == null) {
            Integer n;
            try {
                n = Integer.parseInt(this.resolveRequiredValue(this.key));
            }
            catch (NumberFormatException numberFormatException) {
                n = Integer.parseInt(this.registry.getBundleValue$intellij_platform_util(this.key, this.keyDescriptor));
            }
            this.intCachedValue = result = n;
        }
        return result;
    }

    public final boolean isMultiValue() {
        return this.getSelectedOption() != null;
    }

    @NotNull
    public final List<String> asOptions() {
        String value = this.registry.getBundleValue$intellij_platform_util(this.key, this.keyDescriptor);
        if (StringsKt.startsWith$default((CharSequence)value, (char)'[', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)value, (char)']', (boolean)false, (int)2, null)) {
            List list;
            String string = value.substring(1, value.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String[] stringArray = new String[]{"|"};
            List $this$dropLastWhile$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            return list;
        }
        return CollectionsKt.emptyList();
    }

    @Nullable
    public final String getSelectedOption() {
        String value = this.asString();
        int length = value.length();
        if (length < 3 || value.charAt(0) != '[' || value.charAt(length - 1) != ']') {
            return null;
        }
        int pos = 1;
        while (pos < length) {
            int end = StringsKt.indexOf$default((CharSequence)value, (char)'|', (int)pos, (boolean)false, (int)4, null);
            if (end == -1) {
                end = length - 1;
            }
            if (value.charAt(end - 1) == '*') {
                String string = value.substring(pos, end - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return string;
            }
            pos = end + 1;
        }
        return null;
    }

    public final void setSelectedOption(@Nullable String selected) {
        this.setSelectedOption(selected, RegistryValueSource.SYSTEM);
    }

    @ApiStatus.Experimental
    public final void setSelectedOption(@Nullable String selected, @NotNull RegistryValueSource source) {
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        List options = CollectionsKt.toMutableList((Collection)this.asOptions());
        Iterator iterator2 = ((Iterable)options).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            String option = (String)iterator2.next();
            char[] cArray = new char[]{'*'};
            String v = StringsKt.trimEnd((String)option, (char[])cArray);
            options.set(i, v);
            if (!Intrinsics.areEqual((Object)v, (Object)selected)) continue;
            options.set(i, v + '*');
        }
        this.setValue('[' + CollectionsKt.joinToString$default((Iterable)options, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null) + ']', source);
    }

    public final boolean isOptionEnabled(@NotNull String option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return Intrinsics.areEqual((Object)this.getSelectedOption(), (Object)option);
    }

    public final double asDouble() {
        double result = this.doubleCachedValue;
        if (Double.isNaN(result)) {
            this.doubleCachedValue = result = this.computeDouble();
        }
        return result;
    }

    private final double computeDouble() {
        double d;
        Object object = this.resolveNotRequiredValue(this.key);
        if (object != null && (object = StringsKt.toDoubleOrNull((String)object)) != null) {
            d = (Double)object;
        } else {
            Object object2 = this.keyDescriptor;
            if (object2 != null && (object2 = ((RegistryKeyDescriptor)object2).getDefaultValue()) != null) {
                d = Double.parseDouble((String)object2);
            } else {
                String string = this.registry.getBundleValueOrNull(this.key);
                Double d2 = string != null ? Double.valueOf(Double.parseDouble(string)) : null;
                d = d2 != null ? d2 : 0.0;
            }
        }
        return d;
    }

    @Nullable
    public final Color asColor(@Nullable Color defaultValue) {
        List rgb;
        List list;
        String string = this.getAsValue(this.key);
        if (string == null) {
            return defaultValue;
        }
        String s = string;
        Color color = ColorHexUtil.fromHex(s, null);
        if (color != null && (StringsKt.endsWith$default((String)this.key, (String)".color", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)this.key, (String)".color.dark", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)this.key, (String)".color.light", (boolean)false, (int)2, null))) {
            return color;
        }
        char[] cArray = new char[]{','};
        List $this$dropLastWhile$iv = StringsKt.split$default((CharSequence)s, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = rgb = CollectionsKt.emptyList();
        }
        if (rgb.size() == 3) {
            try {
                return new Color(Integer.parseInt((String)rgb.get(0)), Integer.parseInt((String)rgb.get(1)), Integer.parseInt((String)rgb.get(2)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @NotNull
    public String getDescription() {
        Object object = this.keyDescriptor;
        if ((object == null || (object = ((RegistryKeyDescriptor)object).getDescription()) == null) && (object = this.resolveNotRequiredValue(this.key + ".description")) == null) {
            object = "";
        }
        return object;
    }

    public boolean isRestartRequired() {
        if (this.keyDescriptor == null) {
            return Boolean.parseBoolean(this.resolveNotRequiredValue(this.key + ".restartRequired"));
        }
        return this.keyDescriptor.isRestartRequired();
    }

    public boolean isChangedFromDefault() {
        String string = this.stringCachedValue;
        if (string == null) {
            string = this.resolveNotRequiredValue(this.key);
        }
        return !Intrinsics.areEqual((Object)string, (Object)this.registry.getBundleValueOrNull(this.key));
    }

    @Nullable
    public final String getPluginId() {
        RegistryKeyDescriptor registryKeyDescriptor = this.keyDescriptor;
        return registryKeyDescriptor != null ? registryKeyDescriptor.getPluginId() : null;
    }

    private final String getAsValue(String key) {
        String string;
        if (this.stringCachedValue == null) {
            this.stringCachedValue = this.resolveNotRequiredValue(key);
        }
        String string2 = this.stringCachedValue;
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            string = ((CharSequence)it).length() > 0 ? string3 : null;
        } else {
            string = null;
        }
        return string;
    }

    @ApiStatus.Internal
    @Nullable
    public final String resolveNotRequiredValue(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ValueWithSource valueWithSource = this.registry.getStoredProperties().get(key);
        if (valueWithSource != null) {
            ValueWithSource it = valueWithSource;
            boolean bl = false;
            return it.getValue();
        }
        String string = System.getProperty(key);
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        this.checkIsLoaded(key);
        return this.registry.getBundleValueOrNull(key);
    }

    private final String resolveRequiredValue(String key) throws MissingResourceException {
        ValueWithSource valueWithSource = this.registry.getStoredProperties().get(key);
        if (valueWithSource != null) {
            ValueWithSource it = valueWithSource;
            boolean bl = false;
            return it.getValue();
        }
        String string = System.getProperty(key);
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        this.checkIsLoaded(key);
        return this.registry.getBundleValue$intellij_platform_util(key, this.keyDescriptor);
    }

    private final void checkIsLoaded(String key) {
        if (this.registry.isLoaded()) {
            return;
        }
        String message = "Attempt to load key '" + key + "' for not yet loaded registry";
        if (Disposer.isDebugMode()) {
            RegistryValueKt.access$getLOG$p().error(message + ". Use system properties instead of registry values to configure behaviour at early startup stages.");
        } else {
            RegistryValueKt.access$getLOG$p().warn(message);
        }
    }

    public final void setValue(boolean value) {
        this.setValue(String.valueOf(value));
    }

    public final void setValue(int value) {
        this.setValue(String.valueOf(value));
    }

    public void setValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setValue(value, RegistryValueSource.SYSTEM);
    }

    @ApiStatus.Experimental
    public void setValue(@NotNull String value, @NotNull RegistryValueSource source) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        RegistryValueListener globalValueChangeListener = this.registry.getValueChangeListener();
        globalValueChangeListener.beforeValueChanged(this);
        for (RegistryValueListener each : this.listeners) {
            each.beforeValueChanged(this);
        }
        this.resetCache$intellij_platform_util();
        this.registry.getStoredProperties().put(this.key, new ValueWithSource(value, source));
        RegistryValueKt.access$getLOG$p().info("Registry value '" + this.key + "' has changed to '" + value + "' by " + source.name());
        if (RegistryValueKt.access$getLOG$p().isDebugEnabled()) {
            RegistryValueKt.access$getLOG$p().debug("Registry change stacktrace", new Throwable());
        }
        globalValueChangeListener.afterValueChanged(this);
        for (RegistryValueListener listener : this.listeners) {
            listener.afterValueChanged(this);
        }
        MutableSharedFlow<String> mutableSharedFlow = this.flow;
        if (mutableSharedFlow != null) {
            mutableSharedFlow.tryEmit((Object)value);
        }
        if (!this.isRestartRequired() && Intrinsics.areEqual((Object)this.resolveNotRequiredValue(this.key), (Object)this.registry.getBundleValueOrNull(this.key))) {
            this.registry.getStoredProperties().remove(this.key);
        }
        this.isChangedSinceAppStart = true;
    }

    public final void setValue(boolean value, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        boolean prev = this.asBoolean();
        this.setValue(value);
        Disposer.register(parentDisposable, () -> RegistryValue.setValue$lambda$0(this, prev));
    }

    public final void setValue(int value, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        int prev = this.asInteger();
        this.setValue(value);
        Disposer.register(parentDisposable, () -> RegistryValue.setValue$lambda$1(this, prev));
    }

    @TestOnly
    public final void setValue(@NotNull String value, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        String string = this.stringCachedValue;
        if (string == null) {
            string = this.resolveRequiredValue(this.key);
        }
        String prev = string;
        this.setValue(value);
        Disposer.register(parentDisposable, () -> RegistryValue.setValue$lambda$2(this, prev));
    }

    public final void resetToDefault() {
        String value = this.registry.getBundleValueOrNull(this.key);
        if (value == null) {
            this.registry.getStoredProperties().remove(this.key);
        } else {
            this.setValue(value);
        }
    }

    public final void addListener(@NotNull RegistryValueListener listener, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.listeners.add(listener);
        Disposer.register(parent, () -> RegistryValue.addListener$lambda$0(this, listener));
    }

    public final void addListener(@NotNull RegistryValueListener listener, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.listeners.add(listener);
        CoroutineContext.Element element = coroutineScope.getCoroutineContext().get((CoroutineContext.Key)Job.Key);
        Intrinsics.checkNotNull((Object)element);
        ((Job)element).invokeOnCompletion(arg_0 -> RegistryValue.addListener$lambda$1(this, listener, arg_0));
    }

    @ApiStatus.Experimental
    @NotNull
    public final Flow<String> asStringFlow() {
        MutableSharedFlow<String> mutableSharedFlow = this.flow;
        if (mutableSharedFlow == null) {
            boolean bl = false;
            String string = NO_COROUTINES_DIAGNOSTIC;
            throw new IllegalArgumentException(string.toString());
        }
        return FlowKt.distinctUntilChanged((Flow)((Flow)mutableSharedFlow));
    }

    @ApiStatus.Experimental
    @NotNull
    public final Flow<Boolean> asBooleanFlow() {
        MutableSharedFlow<String> mutableSharedFlow = this.flow;
        if (mutableSharedFlow == null) {
            boolean $i$a$-requireNotNull-RegistryValue$asBooleanFlow$22 = false;
            String $i$a$-requireNotNull-RegistryValue$asBooleanFlow$22 = NO_COROUTINES_DIAGNOSTIC;
            throw new IllegalArgumentException($i$a$-requireNotNull-RegistryValue$asBooleanFlow$22.toString());
        }
        Flow $this$map$iv = (Flow)mutableSharedFlow;
        boolean $i$f$map = false;
        Flow $this$unsafeTransform$iv$iv = $this$map$iv;
        boolean $i$f$unsafeTransform = false;
        boolean $i$f$unsafeFlow = false;
        return FlowKt.distinctUntilChanged((Flow)((Flow)new Flow<Boolean>($this$unsafeTransform$iv$iv){
            final /* synthetic */ Flow $this_unsafeTransform$inlined;
            {
                this.$this_unsafeTransform$inlined = flow;
            }

            public Object collect(FlowCollector collector, Continuation $completion) {
                Continuation continuation = $completion;
                FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                boolean bl = false;
                Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240){
                    final /* synthetic */ FlowCollector $this_unsafeFlow;
                    {
                        this.$this_unsafeFlow = $receiver;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object emit(Object value, Continuation $completion) {
                        if (!($completion instanceof asBooleanFlow$$inlined$map$1$2$1)) ** GOTO lbl-1000
                        var3_3 = $completion;
                        if ((var3_3.label & -2147483648) != 0) {
                            var3_3.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, $completion){
                                /* synthetic */ Object result;
                                int label;
                                Object L$0;
                                final /* synthetic */ asBooleanFlow$$inlined$map$1$2 this$0;
                                Object L$1;
                                Object L$2;
                                Object L$3;
                                int I$0;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return this.this$0.emit(null, (Continuation)this);
                                }
                            };
                        }
                        $result = $continuation.result;
                        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                var6_6 = $continuation;
                                var7_8 = value;
                                $this$map_u24lambda_u245 = this.$this_unsafeFlow;
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = 0;
                                var10_14 = $this$map_u24lambda_u245;
                                var11_15 = (Continuation)$continuation;
                                it = (String)value;
                                $i$a$-map-RegistryValue$asBooleanFlow$2 = false;
                                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)value);
                                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$completion);
                                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)value);
                                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$map_u24lambda_u245);
                                $continuation.I$0 = $i$a$-unsafeTransform-FlowKt__TransformKt$map$1;
                                $continuation.label = 1;
                                v0 = var10_14.emit((Object)Boxing.boxBoolean((boolean)Boolean.parseBoolean(it)), (Continuation)$continuation);
                                if (v0 == var5_5) {
                                    return var5_5;
                                }
                                ** GOTO lbl39
                            }
                            case 1: {
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = $continuation.I$0;
                                $this$map_u24lambda_u245 = (FlowCollector)$continuation.L$3;
                                value = $continuation.L$2;
                                $completion = $continuation.L$1;
                                value = $continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl39:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        }));
    }

    @ApiStatus.Experimental
    @NotNull
    public final Flow<Integer> asIntegerFlow() {
        MutableSharedFlow<String> mutableSharedFlow = this.flow;
        if (mutableSharedFlow == null) {
            boolean $i$a$-requireNotNull-RegistryValue$asIntegerFlow$22 = false;
            String $i$a$-requireNotNull-RegistryValue$asIntegerFlow$22 = NO_COROUTINES_DIAGNOSTIC;
            throw new IllegalArgumentException($i$a$-requireNotNull-RegistryValue$asIntegerFlow$22.toString());
        }
        Flow $this$map$iv = (Flow)mutableSharedFlow;
        boolean $i$f$map = false;
        Flow $this$unsafeTransform$iv$iv = $this$map$iv;
        boolean $i$f$unsafeTransform = false;
        boolean $i$f$unsafeFlow = false;
        return FlowKt.distinctUntilChanged((Flow)((Flow)new Flow<Integer>($this$unsafeTransform$iv$iv){
            final /* synthetic */ Flow $this_unsafeTransform$inlined;
            {
                this.$this_unsafeTransform$inlined = flow;
            }

            public Object collect(FlowCollector collector, Continuation $completion) {
                Continuation continuation = $completion;
                FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                boolean bl = false;
                Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240){
                    final /* synthetic */ FlowCollector $this_unsafeFlow;
                    {
                        this.$this_unsafeFlow = $receiver;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object emit(Object value, Continuation $completion) {
                        if (!($completion instanceof asIntegerFlow$$inlined$map$1$2$1)) ** GOTO lbl-1000
                        var3_3 = $completion;
                        if ((var3_3.label & -2147483648) != 0) {
                            var3_3.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, $completion){
                                /* synthetic */ Object result;
                                int label;
                                Object L$0;
                                final /* synthetic */ asIntegerFlow$$inlined$map$1$2 this$0;
                                Object L$1;
                                Object L$2;
                                Object L$3;
                                int I$0;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return this.this$0.emit(null, (Continuation)this);
                                }
                            };
                        }
                        $result = $continuation.result;
                        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                var6_6 = $continuation;
                                var7_8 = value;
                                $this$map_u24lambda_u245 = this.$this_unsafeFlow;
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = 0;
                                var10_14 = $this$map_u24lambda_u245;
                                var11_15 = (Continuation)$continuation;
                                it = (String)value;
                                $i$a$-map-RegistryValue$asIntegerFlow$2 = false;
                                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)value);
                                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$completion);
                                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)value);
                                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$map_u24lambda_u245);
                                $continuation.I$0 = $i$a$-unsafeTransform-FlowKt__TransformKt$map$1;
                                $continuation.label = 1;
                                v0 = var10_14.emit((Object)Boxing.boxInt((int)Integer.parseInt(it)), (Continuation)$continuation);
                                if (v0 == var5_5) {
                                    return var5_5;
                                }
                                ** GOTO lbl39
                            }
                            case 1: {
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = $continuation.I$0;
                                $this$map_u24lambda_u245 = (FlowCollector)$continuation.L$3;
                                value = $continuation.L$2;
                                $completion = $continuation.L$1;
                                value = $continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl39:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        }));
    }

    @ApiStatus.Experimental
    @NotNull
    public final Flow<Double> asDoubleFlow() {
        MutableSharedFlow<String> mutableSharedFlow = this.flow;
        if (mutableSharedFlow == null) {
            boolean $i$a$-requireNotNull-RegistryValue$asDoubleFlow$22 = false;
            String $i$a$-requireNotNull-RegistryValue$asDoubleFlow$22 = NO_COROUTINES_DIAGNOSTIC;
            throw new IllegalArgumentException($i$a$-requireNotNull-RegistryValue$asDoubleFlow$22.toString());
        }
        Flow $this$map$iv = (Flow)mutableSharedFlow;
        boolean $i$f$map = false;
        Flow $this$unsafeTransform$iv$iv = $this$map$iv;
        boolean $i$f$unsafeTransform = false;
        boolean $i$f$unsafeFlow = false;
        return FlowKt.distinctUntilChanged((Flow)((Flow)new Flow<Double>($this$unsafeTransform$iv$iv){
            final /* synthetic */ Flow $this_unsafeTransform$inlined;
            {
                this.$this_unsafeTransform$inlined = flow;
            }

            public Object collect(FlowCollector collector, Continuation $completion) {
                Continuation continuation = $completion;
                FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                boolean bl = false;
                Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240){
                    final /* synthetic */ FlowCollector $this_unsafeFlow;
                    {
                        this.$this_unsafeFlow = $receiver;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object emit(Object value, Continuation $completion) {
                        if (!($completion instanceof asDoubleFlow$$inlined$map$1$2$1)) ** GOTO lbl-1000
                        var3_3 = $completion;
                        if ((var3_3.label & -2147483648) != 0) {
                            var3_3.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, $completion){
                                /* synthetic */ Object result;
                                int label;
                                Object L$0;
                                final /* synthetic */ asDoubleFlow$$inlined$map$1$2 this$0;
                                Object L$1;
                                Object L$2;
                                Object L$3;
                                int I$0;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return this.this$0.emit(null, (Continuation)this);
                                }
                            };
                        }
                        $result = $continuation.result;
                        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                var6_6 = $continuation;
                                var7_8 = value;
                                $this$map_u24lambda_u245 = this.$this_unsafeFlow;
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = 0;
                                var10_14 = $this$map_u24lambda_u245;
                                var11_15 = (Continuation)$continuation;
                                it = (String)value;
                                $i$a$-map-RegistryValue$asDoubleFlow$2 = false;
                                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)value);
                                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$completion);
                                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)value);
                                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$map_u24lambda_u245);
                                $continuation.I$0 = $i$a$-unsafeTransform-FlowKt__TransformKt$map$1;
                                $continuation.label = 1;
                                v0 = var10_14.emit((Object)Boxing.boxDouble((double)Double.parseDouble(it)), (Continuation)$continuation);
                                if (v0 == var5_5) {
                                    return var5_5;
                                }
                                ** GOTO lbl39
                            }
                            case 1: {
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = $continuation.I$0;
                                $this$map_u24lambda_u245 = (FlowCollector)$continuation.L$3;
                                value = $continuation.L$2;
                                $completion = $continuation.L$1;
                                value = $continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl39:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        }));
    }

    public final void resetCache$intellij_platform_util() {
        this.stringCachedValue = null;
        this.intCachedValue = null;
        this.doubleCachedValue = Double.NaN;
        this.booleanCachedValue = null;
    }

    public boolean isBoolean() {
        return RegistryValueKt.access$isBoolean(this.asString());
    }

    @NotNull
    public String toString() {
        return this.key + '=' + this.asString();
    }

    private static final void setValue$lambda$0(RegistryValue this$0, boolean $prev) {
        this$0.setValue($prev);
    }

    private static final void setValue$lambda$1(RegistryValue this$0, int $prev) {
        this$0.setValue($prev);
    }

    private static final void setValue$lambda$2(RegistryValue this$0, String $prev) {
        this$0.setValue($prev);
    }

    private static final void addListener$lambda$0(RegistryValue this$0, RegistryValueListener $listener) {
        this$0.listeners.remove($listener);
    }

    private static final Unit addListener$lambda$1(RegistryValue this$0, RegistryValueListener $listener, Throwable it) {
        this$0.listeners.remove($listener);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/util/registry/RegistryValue$Companion;", "", "<init>", "()V", "NO_COROUTINES_DIAGNOSTIC", "", "intellij.platform.util"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

