/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNullByDefault;

@ApiStatus.Experimental
@NotNullByDefault
public final class MarkupText {
    private static final MarkupText EMPTY = new MarkupText(Collections.emptyList());
    private final List<Fragment> fragments;

    private MarkupText(List<Fragment> fragments) {
        this.fragments = fragments;
    }

    public List<Fragment> fragments() {
        return this.fragments;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MarkupText that = (MarkupText)obj;
        return Objects.equals(this.fragments, that.fragments);
    }

    public int hashCode() {
        return this.fragments.hashCode();
    }

    public String toString() {
        return StringUtil.join(this.fragments, "");
    }

    public HtmlChunk toHtmlChunk() {
        HtmlBuilder builder = new HtmlBuilder();
        this.fragments.forEach(fragment -> builder.append(fragment.toHtmlChunk()));
        return builder.toFragment();
    }

    @Nls
    public String toText() {
        return StringUtil.join(this.fragments, Fragment::text, "");
    }

    public boolean isEmpty() {
        return this.fragments.isEmpty();
    }

    public int length() {
        return this.fragments.stream().mapToInt(f -> ((Fragment)f).text.length()).sum();
    }

    public MarkupText concat(MarkupText other) {
        if (this.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        return new MarkupTextBuilder().append(this).append(other).build();
    }

    public MarkupText concat(@Nls String text, Kind kind) {
        if (text.isEmpty()) {
            return this;
        }
        return new MarkupTextBuilder().append(this).append(text, kind).build();
    }

    public MarkupText highlightRange(int fromInclusive, int toExclusive, Kind kind) {
        if (fromInclusive > toExclusive || fromInclusive < 0) {
            throw new IllegalArgumentException("Invalid range: " + fromInclusive + ".." + toExclusive);
        }
        if (fromInclusive == toExclusive || this.isEmpty()) {
            return this;
        }
        MarkupTextBuilder newFragments = new MarkupTextBuilder();
        int start = 0;
        @Nls StringBuilder sb = new StringBuilder();
        for (Fragment fragment : this.fragments) {
            int end = start + fragment.text.length();
            if (end <= fromInclusive || start >= toExclusive) {
                newFragments.append(fragment);
            } else if (start < fromInclusive) {
                newFragments.append(fragment.text.substring(0, fromInclusive - start), fragment.kind);
                if (end >= toExclusive) {
                    sb.append(fragment.text, fromInclusive - start, toExclusive - start);
                    newFragments.append(sb.toString(), kind);
                    sb.setLength(0);
                    newFragments.append(fragment.text.substring(toExclusive - start), fragment.kind);
                } else {
                    sb.append(fragment.text.substring(fromInclusive - start));
                }
            } else if (end >= toExclusive) {
                sb.append(fragment.text, 0, toExclusive - start);
                newFragments.append(sb.toString(), kind);
                sb.setLength(0);
                newFragments.append(fragment.text.substring(toExclusive - start), fragment.kind);
            } else {
                sb.append(fragment.text);
            }
            start = end;
        }
        if (start < fromInclusive || start < toExclusive) {
            throw new IllegalArgumentException("Invalid range: " + fromInclusive + ".." + toExclusive + " for " + this + " (length=" + start + ")");
        }
        if (sb.length() > 0) {
            newFragments.append(sb.toString(), kind);
        }
        return newFragments.build();
    }

    public MarkupText highlightAll(Kind kind) {
        String text;
        if (this.isEmpty()) {
            return this;
        }
        if (this.fragments.size() == 1) {
            Fragment fragment2 = this.fragments.get(0);
            if (fragment2.kind == kind) {
                return this;
            }
            text = fragment2.text;
        } else {
            text = StringUtil.join(this.fragments, fragment -> ((Fragment)fragment).text, "");
        }
        return new MarkupText(Collections.singletonList(new Fragment(text, kind)));
    }

    public static MarkupText plainText(@Nls String text) {
        if (text.isEmpty()) {
            return EMPTY;
        }
        return new MarkupText(Collections.singletonList(new Fragment(text, Kind.NORMAL)));
    }

    public static MarkupTextBuilder builder() {
        return new MarkupTextBuilder();
    }

    public static MarkupText empty() {
        return EMPTY;
    }

    public static final class MarkupTextBuilder {
        private final List<Fragment> fragments = new ArrayList<Fragment>();

        private MarkupTextBuilder() {
        }

        public MarkupTextBuilder append(@Nls String text) {
            return this.append(text, Kind.NORMAL);
        }

        public MarkupTextBuilder append(@Nls String text, Kind kind) {
            if (text.isEmpty()) {
                return this;
            }
            return this.append(new Fragment(text, kind));
        }

        public MarkupTextBuilder append(Fragment fragment) {
            Fragment last;
            if (fragment.text.isEmpty()) {
                return this;
            }
            if (!this.fragments.isEmpty() && (last = this.fragments.get(this.fragments.size() - 1)).kind == fragment.kind) {
                this.fragments.remove(this.fragments.size() - 1);
                fragment = new Fragment(last.text + fragment.text, fragment.kind);
            }
            this.fragments.add(fragment);
            return this;
        }

        public MarkupTextBuilder append(MarkupText other) {
            other.fragments.forEach(this::append);
            return this;
        }

        public MarkupText build() {
            if (this.fragments.isEmpty()) {
                return EMPTY;
            }
            return new MarkupText(Collections.unmodifiableList(new ArrayList<Fragment>(this.fragments)));
        }
    }

    public static enum Kind {
        NORMAL,
        EMPHASIZED,
        STRONG,
        UNDERLINED,
        ERROR,
        STRIKEOUT,
        GRAYED;

    }

    public static final class Fragment {
        @Nls
        private final String text;
        private final Kind kind;

        public Fragment(@Nls String text, Kind kind) {
            this.text = text;
            this.kind = kind;
        }

        @Nls
        public String text() {
            return this.text;
        }

        public Kind kind() {
            return this.kind;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Fragment that = (Fragment)obj;
            return Objects.equals(this.text, that.text) && Objects.equals((Object)this.kind, (Object)that.kind);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.text, this.kind});
        }

        public HtmlChunk toHtmlChunk() {
            switch (this.kind.ordinal()) {
                case 0: {
                    return HtmlChunk.text(this.text);
                }
                case 1: {
                    return HtmlChunk.text(this.text).italic();
                }
                case 2: {
                    return HtmlChunk.text(this.text).bold();
                }
                case 3: {
                    return HtmlChunk.text(this.text).wrapWith("u");
                }
                case 4: {
                    return HtmlChunk.text(this.text).wrapWith(HtmlChunk.span().setClass("error"));
                }
                case 5: {
                    return HtmlChunk.text(this.text).wrapWith("s");
                }
                case 6: {
                    return HtmlChunk.text(this.text).wrapWith(HtmlChunk.span().setClass("grayed"));
                }
            }
            throw new InternalError();
        }

        public String toString() {
            switch (this.kind.ordinal()) {
                case 0: {
                    return this.text;
                }
                case 1: {
                    return "*" + this.text + "*";
                }
                case 2: {
                    return "**" + this.text + "**";
                }
                case 3: {
                    return "_" + this.text + "_";
                }
                case 4: {
                    return "!!!" + this.text + "!!!";
                }
                case 5: {
                    return "~~" + this.text + "~~";
                }
                case 6: {
                    return "[" + this.text + "]";
                }
            }
            throw new InternalError();
        }
    }
}

