/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.LowMemoryWatcherManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.concurrency.AppDelayQueue;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.concurrency.CountingThreadFactory;
import com.intellij.util.concurrency.Propagation;
import com.intellij.util.concurrency.SchedulingWrapper;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class AppScheduledExecutorService
extends SchedulingWrapper {
    public static final String POOLED_THREAD_PREFIX = "ApplicationImpl pooled thread ";
    @NotNull
    private final String myName;
    private final LowMemoryWatcherManager myLowMemoryWatcherManager;

    @NotNull
    static ScheduledExecutorService getInstance() {
        AppScheduledExecutorService appScheduledExecutorService = Holder.INSTANCE;
        if (appScheduledExecutorService == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(0);
        }
        return appScheduledExecutorService;
    }

    /*
     * WARNING - void declaration
     */
    private AppScheduledExecutorService(@NotNull String name, long keepAliveTime, @NotNull TimeUnit unit, boolean bl) {
        void initLowMemoryWatcherManager;
        if (name == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(1);
        }
        if (unit == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(2);
        }
        super(new BackendThreadPoolExecutor(new MyThreadFactory(), keepAliveTime, unit), new AppDelayQueue());
        this.myName = name;
        this.myLowMemoryWatcherManager = initLowMemoryWatcherManager != false ? new LowMemoryWatcherManager(this) : null;
    }

    private MyThreadFactory getCountingThreadFactory() {
        return (MyThreadFactory)((BackendThreadPoolExecutor)this.backendExecutorService).getThreadFactory();
    }

    public LowMemoryWatcherManager getLowMemoryWatcherManager() {
        return this.myLowMemoryWatcherManager;
    }

    public void setNewThreadListener(@NotNull BiConsumer<? super Thread, ? super Runnable> threadListener) {
        if (threadListener == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(3);
        }
        this.getCountingThreadFactory().setNewThreadListener(threadListener);
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        return AppScheduledExecutorService.notAllowedMethodCall();
    }

    @Override
    public void shutdown() {
        AppScheduledExecutorService.notAllowedMethodCall();
    }

    @NotNull
    public static List<Runnable> notAllowedMethodCall() {
        throw new IncorrectOperationException("You must not call this method on the global app pool");
    }

    @Override
    void onDelayQueuePurgedOnShutdown() {
        ((BackendThreadPoolExecutor)this.backendExecutorService).superShutdown();
    }

    void shutdownAppScheduledExecutorService() {
        if (this.myLowMemoryWatcherManager != null) {
            this.myLowMemoryWatcherManager.shutdown();
        }
        this.doShutdown(true);
        this.delayQueue.shutdown(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException {
        void unit;
        long deadline;
        if (timeUnit == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(4);
        }
        if (!this.delayQueue.awaitTermination((deadline = System.nanoTime() + unit.toNanos(timeout)) - System.nanoTime(), TimeUnit.NANOSECONDS)) {
            return false;
        }
        return super.awaitTermination(deadline - System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    @TestOnly
    @NotNull
    public String statistics() {
        String string = this.myName + " threads created counter = " + this.getCountingThreadFactory().counter;
        if (string == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(5);
        }
        return string;
    }

    @TestOnly
    public String dumpQueue() {
        return this.delayQueue.toString();
    }

    public int getBackendPoolExecutorSize() {
        return ((BackendThreadPoolExecutor)this.backendExecutorService).getPoolSize();
    }

    @NotNull
    public static Thread getPeriodicTasksThread() {
        Thread thread = Holder.INSTANCE.delayQueue.getThread();
        if (thread == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(6);
        }
        return thread;
    }

    @NotNull
    public static Runnable capturePropagationAndCancellationContext(@NotNull Runnable command) {
        if (command == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(7);
        }
        if (!AppExecutorUtil.propagateContext()) {
            Runnable runnable = command;
            if (runnable == null) {
                AppScheduledExecutorService.$$$reportNull$$$0(8);
            }
            return runnable;
        }
        Runnable runnable = Propagation.capturePropagationContext(command, false);
        if (runnable == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(9);
        }
        return runnable;
    }

    @NotNull
    public static Runnable captureContextCancellationForRunnableThatDoesNotOutliveContextScope(@NotNull Runnable r) {
        if (r == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(10);
        }
        Runnable runnable = Propagation.capturePropagationContext(r, true);
        if (runnable == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(11);
        }
        return runnable;
    }

    @NotNull
    public static <T> FutureTask<T> capturePropagationAndCancellationContext(@NotNull Callable<T> callable) {
        if (callable == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(12);
        }
        if (!AppExecutorUtil.propagateContext()) {
            return new FutureTask<T>(callable);
        }
        FutureTask<T> futureTask = Propagation.capturePropagationContext(callable);
        if (futureTask == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(13);
        }
        return futureTask;
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public void waitUntilAllTasksAreTransferredInTests(long timeout, @NotNull TimeUnit timeUnit) throws TimeoutException {
        void timeUnit2;
        if (timeUnit == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(14);
        }
        AppDelayQueue delayQueue = this.getDelayQueue();
        long deadline = System.nanoTime() + timeUnit2.toNanos(timeout);
        while (!delayQueue.isEmpty()) {
            ArrayList unprocessedTasks;
            Thread.yield();
            if (System.nanoTime() <= deadline || (unprocessedTasks = new ArrayList(delayQueue)).isEmpty()) continue;
            throw new TimeoutException("Not transferred after 20 seconds: " + ContainerUtil.map(unprocessedTasks, info -> BoundedTaskExecutor.info(info)) + ";\n" + unprocessedTasks);
        }
    }

    @TestOnly
    public void setBackendThreadPoolExecutorKeepAliveTimeInTests(int i, TimeUnit unit) {
        ((BackendThreadPoolExecutor)this.backendExecutorService).superSetKeepAliveTime(i, unit);
    }

    @TestOnly
    public void setBackendThreadPoolCorePoolSizeAndPrestartCoreThreadInTests(int size) {
        ((BackendThreadPoolExecutor)this.backendExecutorService).superSetCorePoolSize(size);
        ((ThreadPoolExecutor)this.backendExecutorService).prestartCoreThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public static void withTemporaryAppScheduledServiceInTests(@NotNull String name, @NotNull ThrowableConsumer<? super AppScheduledExecutorService, Throwable> consumer) throws Throwable {
        if (name == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(15);
        }
        if (consumer == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(16);
        }
        AppScheduledExecutorService service = new AppScheduledExecutorService(name, 10L, TimeUnit.MINUTES, false);
        try {
            consumer.consume((Object)service);
        }
        finally {
            service.shutdownAppScheduledExecutorService();
            boolean terminated = service.awaitTermination(20L, TimeUnit.SECONDS);
            assert (terminated);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/concurrency/AppScheduledExecutorService";
                break;
            }
            case 1: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadListener";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeUnit";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/concurrency/AppScheduledExecutorService";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "statistics";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPeriodicTasksThread";
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "capturePropagationAndCancellationContext";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "captureContextCancellationForRunnableThatDoesNotOutliveContextScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setNewThreadListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "awaitTermination";
                break;
            }
            case 7: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "capturePropagationAndCancellationContext";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "captureContextCancellationForRunnableThatDoesNotOutliveContextScope";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "waitUntilAllTasksAreTransferredInTests";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "withTemporaryAppScheduledServiceInTests";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Holder {
        private static final AppScheduledExecutorService INSTANCE = new AppScheduledExecutorService("Global instance", 1L, TimeUnit.MINUTES, true);

        private Holder() {
        }
    }

    private static final class BackendThreadPoolExecutor
    extends ThreadPoolExecutor {
        /*
         * WARNING - void declaration
         */
        BackendThreadPoolExecutor(@NotNull ThreadFactory factory, long keepAliveTime, @NotNull TimeUnit timeUnit) {
            void unit;
            if (factory == null) {
                BackendThreadPoolExecutor.$$$reportNull$$$0(0);
            }
            if (timeUnit == null) {
                BackendThreadPoolExecutor.$$$reportNull$$$0(1);
            }
            super(1, Integer.MAX_VALUE, keepAliveTime, (TimeUnit)unit, new SynchronousQueue<Runnable>(), factory);
        }

        @Override
        public void execute(@NotNull Runnable command) {
            if (command == null) {
                BackendThreadPoolExecutor.$$$reportNull$$$0(2);
            }
            super.execute(AppScheduledExecutorService.capturePropagationAndCancellationContext(command));
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
            return this.newTaskFor(Executors.callable(runnable, value));
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
            return AppScheduledExecutorService.capturePropagationAndCancellationContext(callable);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            if (t != null && !(t instanceof ProcessCanceledException)) {
                Logger.getInstance(SchedulingWrapper.class).error("Worker exited due to exception", t);
            }
        }

        private void superShutdown() {
            super.shutdown();
        }

        @Override
        public void shutdown() {
            AppScheduledExecutorService.notAllowedMethodCall();
        }

        @Override
        @NotNull
        public List<Runnable> shutdownNow() {
            List<Runnable> list = AppScheduledExecutorService.notAllowedMethodCall();
            if (list == null) {
                BackendThreadPoolExecutor.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        public void setCorePoolSize(int corePoolSize) {
            AppScheduledExecutorService.notAllowedMethodCall();
        }

        private void superSetCorePoolSize(int corePoolSize) {
            super.setCorePoolSize(corePoolSize);
        }

        @Override
        public void allowCoreThreadTimeOut(boolean value) {
            AppScheduledExecutorService.notAllowedMethodCall();
        }

        @Override
        public void setMaximumPoolSize(int maximumPoolSize) {
            AppScheduledExecutorService.notAllowedMethodCall();
        }

        @Override
        public void setKeepAliveTime(long time, TimeUnit unit) {
            AppScheduledExecutorService.notAllowedMethodCall();
        }

        private void superSetKeepAliveTime(long time, TimeUnit unit) {
            super.setKeepAliveTime(time, unit);
        }

        @Override
        public void setThreadFactory(@NotNull ThreadFactory threadFactory) {
            if (threadFactory == null) {
                BackendThreadPoolExecutor.$$$reportNull$$$0(4);
            }
            AppScheduledExecutorService.notAllowedMethodCall();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unit";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/concurrency/AppScheduledExecutorService$BackendThreadPoolExecutor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "threadFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/concurrency/AppScheduledExecutorService$BackendThreadPoolExecutor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "shutdownNow";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setThreadFactory";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class MyThreadFactory
    extends CountingThreadFactory {
        private BiConsumer<? super Thread, ? super Runnable> newThreadListener;
        private final ThreadFactory myThreadFactory = Executors.privilegedThreadFactory();

        private MyThreadFactory() {
        }

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            if (r == null) {
                MyThreadFactory.$$$reportNull$$$0(0);
            }
            Thread thread = this.myThreadFactory.newThread(r);
            thread.setName(AppScheduledExecutorService.POOLED_THREAD_PREFIX + this.counter.incrementAndGet());
            thread.setPriority(4);
            BiConsumer<? super Thread, ? super Runnable> listener = this.newThreadListener;
            if (listener != null) {
                listener.accept(thread, r);
            }
            Thread thread2 = thread;
            if (thread2 == null) {
                MyThreadFactory.$$$reportNull$$$0(1);
            }
            return thread2;
        }

        void setNewThreadListener(@NotNull BiConsumer<? super Thread, ? super Runnable> threadListener) {
            if (threadListener == null) {
                MyThreadFactory.$$$reportNull$$$0(2);
            }
            if (this.newThreadListener != null) {
                throw new IllegalStateException("Listener was already set: " + this.newThreadListener);
            }
            this.newThreadListener = threadListener;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/concurrency/AppScheduledExecutorService$MyThreadFactory";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "threadListener";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/concurrency/AppScheduledExecutorService$MyThreadFactory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "newThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "newThread";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setNewThreadListener";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

