/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.SystemProperties;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseInputStreamReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseOutputReader
extends BaseDataReader {
    protected final Reader myReader;
    private final Options myOptions;
    private final char[] myInputBuffer;
    private final StringBuilder myLineBuffer;
    private boolean myCarry;

    public BaseOutputReader(@NotNull InputStream inputStream, @Nullable Charset charset) {
        if (inputStream == null) {
            BaseOutputReader.$$$reportNull$$$0(0);
        }
        this(BaseOutputReader.createInputStreamReader(inputStream, charset));
    }

    public BaseOutputReader(@NotNull InputStream inputStream, @Nullable Charset charset, @NotNull Options options) {
        if (inputStream == null) {
            BaseOutputReader.$$$reportNull$$$0(1);
        }
        if (options == null) {
            BaseOutputReader.$$$reportNull$$$0(2);
        }
        this(BaseOutputReader.createInputStreamReader(inputStream, charset), options);
    }

    public BaseOutputReader(@NotNull Reader reader) {
        if (reader == null) {
            BaseOutputReader.$$$reportNull$$$0(3);
        }
        this(reader, new Options());
    }

    public BaseOutputReader(@NotNull Reader reader, @NotNull Options options) {
        if (reader == null) {
            BaseOutputReader.$$$reportNull$$$0(4);
        }
        if (options == null) {
            BaseOutputReader.$$$reportNull$$$0(5);
        }
        super(options.policy());
        this.myInputBuffer = new char[8192];
        this.myLineBuffer = new StringBuilder();
        if (options.policy() == BaseDataReader.SleepingPolicy.BLOCKING && !(reader instanceof BaseInputStreamReader)) {
            throw new IllegalArgumentException("Blocking policy can be used only with BaseInputStreamReader, that doesn't lock on close");
        }
        this.myReader = reader;
        this.myOptions = options;
    }

    private static Reader createInputStreamReader(@NotNull InputStream stream, @Nullable Charset charset) {
        if (stream == null) {
            BaseOutputReader.$$$reportNull$$$0(6);
        }
        return charset == null ? new BaseInputStreamReader(stream) : new BaseInputStreamReader(stream, charset);
    }

    @Override
    protected final boolean readAvailableNonBlocking() throws IOException {
        boolean read = false;
        try {
            int n;
            while (this.myReader.ready() && (n = this.myReader.read(this.myInputBuffer)) >= 0) {
                if (n <= 0) continue;
                read = true;
                this.processInput(this.myInputBuffer, this.myLineBuffer, n);
            }
        }
        finally {
            if (this.myCarry) {
                this.myLineBuffer.append('\r');
                this.myCarry = false;
            }
            if (this.myLineBuffer.length() > 0 && this.myOptions.sendIncompleteLines()) {
                this.sendText(this.myLineBuffer);
            }
        }
        return read;
    }

    @Override
    protected final boolean readAvailableBlocking() throws IOException {
        boolean read = false;
        try {
            int n;
            while ((n = this.myReader.read(this.myInputBuffer)) >= 0) {
                if (n <= 0) continue;
                read = true;
                this.processInput(this.myInputBuffer, this.myLineBuffer, n);
            }
        }
        finally {
            if (this.myCarry) {
                this.myLineBuffer.append('\r');
                this.myCarry = false;
            }
            if (this.myLineBuffer.length() > 0) {
                this.sendText(this.myLineBuffer);
            }
        }
        return read;
    }

    @Override
    protected void flush() {
        if (this.myLineBuffer.length() > 0) {
            this.sendText(this.myLineBuffer);
        }
    }

    private void processInput(char[] buffer, StringBuilder line, int n) {
        if (this.myOptions.splitToLines()) {
            for (int i = 0; i < n; ++i) {
                char c;
                if (i == 0 && this.myCarry) {
                    c = '\r';
                    --i;
                    this.myCarry = false;
                } else {
                    c = buffer[i];
                }
                if (c == '\r') {
                    if (i + 1 == n) {
                        this.myCarry = true;
                        continue;
                    }
                    if (buffer[i + 1] == '\n') continue;
                }
                if (c != '\n' || this.myOptions.sendIncompleteLines() || this.myOptions.withSeparators()) {
                    line.append(c);
                }
                if (c != 10) continue;
                this.sendText(line);
            }
            if (line.length() > 0 && this.myOptions.sendIncompleteLines()) {
                this.sendText(line);
            }
        } else {
            this.onTextAvailable(new String(buffer, 0, n));
        }
    }

    private void sendText(@NotNull StringBuilder line) {
        if (line == null) {
            BaseOutputReader.$$$reportNull$$$0(7);
        }
        String text = line.toString();
        line.setLength(0);
        this.onTextAvailable(text);
    }

    @Override
    protected void close() throws IOException {
        this.myReader.close();
    }

    protected abstract void onTextAvailable(@NotNull String var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/BaseOutputReader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createInputStreamReader";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "sendText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Options {
        public static final Options BLOCKING = Options.withPolicy(BaseDataReader.SleepingPolicy.BLOCKING);
        public static final Options NON_BLOCKING = Options.withPolicy(BaseDataReader.SleepingPolicy.NON_BLOCKING);

        public BaseDataReader.SleepingPolicy policy() {
            return null;
        }

        public boolean splitToLines() {
            return true;
        }

        public boolean sendIncompleteLines() {
            return true;
        }

        public boolean withSeparators() {
            return true;
        }

        public static Options withPolicy(final BaseDataReader.SleepingPolicy policy) {
            return new Options(){

                @Override
                public BaseDataReader.SleepingPolicy policy() {
                    return policy;
                }
            };
        }

        public static Options forMostlySilentProcess() {
            if (SystemProperties.getBooleanProperty((String)"output.reader.blocking.mode.for.mostly.silent.processes", (boolean)true) || Boolean.getBoolean("output.reader.blocking.mode")) {
                return BLOCKING;
            }
            return NON_BLOCKING;
        }

        @NotNull
        public static Options forTerminalPtyProcess() {
            return new Options(){

                @Override
                public BaseDataReader.SleepingPolicy policy() {
                    return BaseDataReader.SleepingPolicy.BLOCKING;
                }

                @Override
                public boolean splitToLines() {
                    return false;
                }
            };
        }
    }
}

