/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.stats;

import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentMapImpl;
import com.intellij.util.io.stats.PersistentEnumeratorStatistics;
import com.intellij.util.io.stats.PersistentHashMapStatistics;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u000e\u0010\r\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u001a\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\tJ\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00140\u0013J\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00160\u0013R\"\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/util/io/stats/StorageStatsRegistrar;", "", "<init>", "()V", "maps", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/nio/file/Path;", "Lcom/intellij/util/io/PersistentMapImpl;", "enumerators", "Lcom/intellij/util/io/PersistentBTreeEnumerator;", "registerMap", "", "path", "map", "unregisterMap", "registerEnumerator", "enumerator", "unregisterEnumerator", "dumpStatsForOpenMaps", "", "Lcom/intellij/util/io/stats/PersistentHashMapStatistics;", "dumpStatsForOpenEnumerators", "Lcom/intellij/util/io/stats/PersistentEnumeratorStatistics;", "intellij.platform.util"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nstatistics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 statistics.kt\ncom/intellij/util/io/stats/StorageStatsRegistrar\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n463#2:94\n413#2:95\n463#2:100\n413#2:101\n1252#3,4:96\n1252#3,4:102\n*S KotlinDebug\n*F\n+ 1 statistics.kt\ncom/intellij/util/io/stats/StorageStatsRegistrar\n*L\n32#1:94\n32#1:95\n33#1:100\n33#1:101\n32#1:96,4\n33#1:102,4\n*E\n"})
public final class StorageStatsRegistrar {
    @NotNull
    public static final StorageStatsRegistrar INSTANCE = new StorageStatsRegistrar();
    @NotNull
    private static final ConcurrentHashMap<Path, PersistentMapImpl<?, ?>> maps = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<Path, PersistentBTreeEnumerator<?>> enumerators = new ConcurrentHashMap();

    private StorageStatsRegistrar() {
    }

    public final void registerMap(@NotNull Path path, @NotNull PersistentMapImpl<?, ?> map2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        Path path2 = path.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
        maps.put(path2, map2);
    }

    public final void unregisterMap(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = path.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
        maps.remove(path2);
    }

    public final void registerEnumerator(@NotNull Path path, @NotNull PersistentBTreeEnumerator<?> enumerator) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(enumerator, (String)"enumerator");
        Path path2 = path.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
        enumerators.put(path2, enumerator);
    }

    public final void unregisterEnumerator(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = path.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
        enumerators.remove(path2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Path, PersistentHashMapStatistics> dumpStatsForOpenMaps() {
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Map $this$mapValues$iv = maps;
        boolean $i$f$mapValues = false;
        Map map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            PersistentHashMapStatistics persistentHashMapStatistics = ((PersistentMapImpl)it.getValue()).getStatistics();
            map4.put(k, persistentHashMapStatistics);
        }
        return destination$iv$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Path, PersistentEnumeratorStatistics> dumpStatsForOpenEnumerators() {
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Map $this$mapValues$iv = enumerators;
        boolean $i$f$mapValues = false;
        Map map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            PersistentEnumeratorStatistics persistentEnumeratorStatistics = ((PersistentBTreeEnumerator)it.getValue()).getStatistics();
            map4.put(k, persistentEnumeratorStatistics);
        }
        return destination$iv$iv$iv;
    }
}

