/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.serialization.MutableAccessor;
import com.intellij.util.ThreeState;
import com.intellij.util.xml.dom.XmlElement;
import com.intellij.util.xmlb.BeanBindingKt;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.DomAdapter;
import com.intellij.util.xmlb.JdomAdapter;
import com.intellij.util.xmlb.NestedBinding;
import com.intellij.util.xmlb.RootBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.Serializer;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.intellij.util.xmlb.XmlDomAdapter;
import com.intellij.util.xmlb.annotations.Property;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0013\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J'\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0016\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001cJ0\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0016\u0018\u00010\"2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001c\u0010#\u001a\u0004\u0018\u00010\u00182\b\u0010$\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001f\u001a\u00020\u0016H\u0016J\u001c\u0010%\u001a\u0004\u0018\u00010 2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J \u0010%\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010&\u001a\u00020 2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\"\u0010%\u001a\u0004\u0018\u00010 2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u001c2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ&\u0010(\u001a\u0004\u0018\u00010 2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010)\u001a\u0004\u0018\u00010 2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J6\u0010*\u001a\u0004\u0018\u00010 2\u0006\u0010+\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010,\u001a\u0004\u0018\u00010 2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010-\u001a\u00020\u001cH\u0007J7\u0010.\u001a\u00020\u0018\"\b\b\u0000\u0010/*\u00020\u00182\b\u00100\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001f\u001a\u0002H/2\f\u00101\u001a\b\u0012\u0004\u0012\u0002H/02H\u0017\u00a2\u0006\u0002\u00103J\u0016\u00104\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 J5\u00104\u001a\u00020\u0010\"\b\b\u0000\u0010/*\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u0002H/2\f\u00101\u001a\b\u0012\u0004\u0012\u0002H/02H\u0007\u00a2\u0006\u0002\u00105J\u0018\u00104\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u000206H\u0007J\b\u00107\u001a\u00020\u0018H\u0016J\u001e\u00108\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u00182\u0006\u00109\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020:J!\u0010;\u001a\b\u0012\u0004\u0012\u00020\b0<2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\b0>H\u0000\u00a2\u0006\u0002\b?J\u0014\u0010@\u001a\u00020\u00102\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\b0<J-\u0010B\u001a\u00020\u001c\"\b\b\u0000\u0010/*\u00020\u00182\u0006\u0010\u001f\u001a\u0002H/2\f\u00101\u001a\b\u0012\u0004\u0012\u0002H/02H\u0017\u00a2\u0006\u0002\u0010CJ\b\u0010D\u001a\u00020\bH\u0016J&\u0010E\u001a\u0004\u0018\u00010 2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010)\u001a\u0004\u0018\u00010 2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007R\u0014\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0012\u0010\r\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/intellij/util/xmlb/BeanBinding;", "Lcom/intellij/util/xmlb/Binding;", "Lcom/intellij/util/xmlb/RootBinding;", "beanClass", "Ljava/lang/Class;", "<init>", "(Ljava/lang/Class;)V", "tagName", "", "bindings", "", "Lcom/intellij/util/xmlb/NestedBinding;", "[Lcom/intellij/util/xmlb/NestedBinding;", "compareByFields", "Lcom/intellij/util/ThreeState;", "init", "", "originalType", "Ljava/lang/reflect/Type;", "serializer", "Lcom/intellij/util/xmlb/Serializer;", "toJson", "Lkotlinx/serialization/json/JsonElement;", "bean", "", "filter", "Lcom/intellij/util/xmlb/SerializationFilter;", "includeClassDiscriminator", "", "toJson$intellij_platform_util", "deserializeToJson", "element", "Lorg/jdom/Element;", "serializeToJsonImpl", "", "fromJson", "currentValue", "serialize", "parent", "createElementIfEmpty", "serializeProperties", "preCreatedElement", "serializeProperty", "binding", "parentElement", "isFilterPropertyItself", "deserialize", "T", "context", "adapter", "Lcom/intellij/util/xmlb/DomAdapter;", "(Ljava/lang/Object;Ljava/lang/Object;Lcom/intellij/util/xmlb/DomAdapter;)Ljava/lang/Object;", "deserializeInto", "(Ljava/lang/Object;Ljava/lang/Object;Lcom/intellij/util/xmlb/DomAdapter;)V", "Lcom/intellij/util/xml/dom/XmlElement;", "newInstance", "equalByFields", "defaultValue", "Lcom/intellij/util/xmlb/SkipDefaultsSerializationFilter;", "computeBindingWeights", "Lit/unimi/dsi/fastutil/objects/Object2FloatMap;", "accessorNameTracker", "", "computeBindingWeights$intellij_platform_util", "sortBindings", "weights", "isBoundTo", "(Ljava/lang/Object;Lcom/intellij/util/xmlb/DomAdapter;)Z", "toString", "serializeInto", "intellij.platform.util"})
@SourceDebugExtension(value={"SMAP\nBeanBinding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BeanBinding.kt\ncom/intellij/util/xmlb/BeanBinding\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,812:1\n1#2:813\n*E\n"})
public class BeanBinding
implements Binding,
RootBinding {
    @JvmField
    @NotNull
    public final Class<?> beanClass;
    @JvmField
    @NotNull
    public final String tagName;
    @ApiStatus.Internal
    @JvmField
    @Nullable
    public NestedBinding[] bindings;
    @JvmField
    @NotNull
    public ThreeState compareByFields;

    public BeanBinding(@NotNull Class<?> beanClass) {
        boolean bl;
        Intrinsics.checkNotNullParameter(beanClass, (String)"beanClass");
        this.beanClass = beanClass;
        this.compareByFields = ThreeState.UNSURE;
        boolean bl2 = bl = !this.beanClass.isArray();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-BeanBinding$42 = false;
            String $i$a$-assert-BeanBinding$42 = "Bean is an array: " + this.beanClass;
            throw new AssertionError((Object)$i$a$-assert-BeanBinding$42);
        }
        boolean bl3 = bl = !this.beanClass.isPrimitive();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-BeanBinding$52 = false;
            String $i$a$-assert-BeanBinding$52 = "Bean is primitive type: " + this.beanClass;
            throw new AssertionError((Object)$i$a$-assert-BeanBinding$52);
        }
        this.tagName = BeanBindingKt.access$getTagName(this.beanClass);
        boolean bl4 = bl = !StringsKt.isBlank((CharSequence)this.tagName);
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string = "Bean name is empty: " + this.beanClass;
            throw new AssertionError((Object)string);
        }
    }

    @Override
    public final synchronized void init(@NotNull Type originalType, @NotNull Serializer serializer2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)originalType, (String)"originalType");
        Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
        boolean bl2 = bl = this.bindings == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        List<MutableAccessor> accessors = BeanBindingKt.access$getPROPERTY_COLLECTOR$p().collect(this.beanClass);
        if (accessors.isEmpty()) {
            this.bindings = BeanBindingKt.access$getEMPTY_BINDINGS$p();
        } else {
            Object object = this.beanClass.getAnnotation(Property.class);
            if (object == null || (object = object.style()) == null) {
                object = Property.Style.OPTION_TAG;
            }
            Object propertyStyle = object;
            int n = 0;
            int n2 = accessors.size();
            NestedBinding[] nestedBindingArray = new NestedBinding[n2];
            while (n < n2) {
                int n3 = n++;
                NestedBinding binding = BeanBindingKt.access$createBinding(accessors.get(n3), serializer2, (Property.Style)((Object)propertyStyle));
                binding.init(originalType, serializer2);
                nestedBindingArray[n3] = binding;
            }
            NestedBinding[] result = nestedBindingArray;
            this.bindings = result;
        }
    }

    @Override
    @Nullable
    public JsonElement toJson(@NotNull Object bean, @Nullable SerializationFilter filter) {
        JsonElement jsonElement;
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Map<String, JsonElement> map2 = this.serializeToJsonImpl(bean, filter, false);
        if (map2 == null) {
            Map map3 = Collections.emptyMap();
            Intrinsics.checkNotNullExpressionValue(map3, (String)"emptyMap(...)");
            jsonElement = (JsonElement)new JsonObject(map3);
        } else {
            jsonElement = (JsonElement)new JsonObject(map2);
        }
        return jsonElement;
    }

    @NotNull
    public final JsonElement toJson$intellij_platform_util(@NotNull Object bean, @Nullable SerializationFilter filter, boolean includeClassDiscriminator) {
        JsonElement jsonElement;
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Map<String, JsonElement> map2 = this.serializeToJsonImpl(bean, filter, includeClassDiscriminator);
        if (map2 == null) {
            Map map3 = includeClassDiscriminator ? Collections.singletonMap("_class", JsonElementKt.JsonPrimitive((String)this.tagName)) : Collections.emptyMap();
            Intrinsics.checkNotNull(map3);
            jsonElement = (JsonElement)new JsonObject(map3);
        } else {
            jsonElement = (JsonElement)new JsonObject(map2);
        }
        return jsonElement;
    }

    @Override
    @NotNull
    public JsonElement deserializeToJson(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNull((Object)this.bindings);
        return BeanBindingKt.access$deserializeBeanXmlToJson(element, this.bindings, this.tagName, false);
    }

    @NotNull
    public final JsonElement deserializeToJson(@NotNull Element element, boolean includeClassDiscriminator) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNull((Object)this.bindings);
        return BeanBindingKt.access$deserializeBeanXmlToJson(element, this.bindings, this.tagName, includeClassDiscriminator);
    }

    private final Map<String, JsonElement> serializeToJsonImpl(Object bean, SerializationFilter filter, boolean includeClassDiscriminator) {
        Map map2;
        String[] keys = null;
        JsonElement[] values = null;
        Intrinsics.checkNotNull((Object)this.bindings);
        NestedBinding[] bindings = this.bindings;
        int index = 0;
        int extraSize = includeClassDiscriminator ? 1 : 0;
        int n = bindings.length;
        for (int i = 0; i < n; ++i) {
            JsonElement jsonElement;
            NestedBinding binding = bindings[i];
            if (BeanBindingKt.isPropertySkipped(filter, binding, this, bean, true)) continue;
            if (keys == null) {
                keys = new String[bindings.length + extraSize];
                values = new JsonElement[bindings.length + extraSize];
                if (includeClassDiscriminator) {
                    keys[index] = "_class";
                    values[index] = JsonElementKt.JsonPrimitive((String)this.tagName);
                    ++index;
                }
            }
            if ((jsonElement = binding.toJson(bean, filter)) == null) continue;
            keys[index] = BeanBindingKt.normalizePropertyNameForKotlinx(binding);
            Intrinsics.checkNotNull((Object)values);
            values[index] = jsonElement;
            ++index;
        }
        if (keys == null) {
            map2 = null;
        } else {
            Intrinsics.checkNotNull(values);
            map2 = (Map)new Object2ObjectArrayMap(keys, values, index);
        }
        return map2;
    }

    @Override
    @Nullable
    public Object fromJson(@Nullable Object currentValue, @NotNull JsonElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element == JsonNull.INSTANCE) {
            return null;
        }
        Object result = this.newInstance();
        if (!(element instanceof JsonObject)) {
            BeanBindingKt.LOG.warn("JsonObject is expected but got " + element);
            return result;
        }
        Intrinsics.checkNotNull((Object)this.bindings);
        for (NestedBinding binding : this.bindings) {
            JsonElement value;
            String key = BeanBindingKt.normalizePropertyNameForKotlinx(binding);
            if ((JsonElement)((JsonObject)element).get((Object)key) == null) continue;
            binding.setFromJson(result, value);
        }
        return result;
    }

    @Override
    @Nullable
    public Element serialize(@NotNull Object bean, @Nullable SerializationFilter filter) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        return this.serializeProperties(bean, null, filter);
    }

    @Override
    public final void serialize(@NotNull Object bean, @NotNull Element parent, @Nullable SerializationFilter filter) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Element element = new Element(true, this.tagName, Namespace.NO_NAMESPACE);
        this.serializeProperties(bean, element, filter);
        parent.addContent(element);
    }

    @Nullable
    public final Element serialize(@NotNull Object bean, boolean createElementIfEmpty, @Nullable SerializationFilter filter) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        return this.serializeProperties(bean, createElementIfEmpty ? new Element(this.tagName) : null, filter);
    }

    @Nullable
    public Element serializeProperties(@NotNull Object bean, @Nullable Element preCreatedElement, @Nullable SerializationFilter filter) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Element element = preCreatedElement;
        Intrinsics.checkNotNull((Object)this.bindings);
        for (NestedBinding binding : this.bindings) {
            element = this.serializeProperty(binding, bean, element, filter, true);
        }
        return element;
    }

    @ApiStatus.Internal
    @Nullable
    public final Element serializeProperty(@NotNull NestedBinding binding, @NotNull Object bean, @Nullable Element parentElement, @Nullable SerializationFilter filter, boolean isFilterPropertyItself) {
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        if (BeanBindingKt.isPropertySkipped(filter, binding, this, bean, isFilterPropertyItself)) {
            return parentElement;
        }
        Element element = parentElement;
        if (element == null) {
            element = new Element(this.tagName);
        }
        Element element2 = element;
        binding.serialize(bean, element2, filter);
        return element2;
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public <T> Object deserialize(@Nullable Object context, @NotNull T element, @NotNull DomAdapter<T> adapter) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        Object instance = this.newInstance();
        this.deserializeInto(instance, element, adapter);
        return instance;
    }

    public final void deserializeInto(@NotNull Object bean, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNull((Object)this.bindings);
        NestedBinding[] nestedBindingArray = this.bindings;
        BeanBindingKt.deserializeJdomIntoBean(bean, element, nestedBindingArray, null);
    }

    @ApiStatus.Internal
    public final <T> void deserializeInto(@NotNull Object bean, @NotNull T element, @NotNull DomAdapter<T> adapter) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter(element, (String)"element");
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        DomAdapter<T> domAdapter = adapter;
        if (Intrinsics.areEqual(domAdapter, (Object)JdomAdapter.INSTANCE)) {
            Element element2 = (Element)element;
            Intrinsics.checkNotNull((Object)this.bindings);
            NestedBinding[] nestedBindingArray = this.bindings;
            BeanBindingKt.deserializeJdomIntoBean(bean, element2, nestedBindingArray, null);
        } else if (Intrinsics.areEqual(domAdapter, (Object)XmlDomAdapter.INSTANCE)) {
            XmlElement xmlElement = (XmlElement)element;
            Intrinsics.checkNotNull((Object)this.bindings);
            BeanBindingKt.access$deserializeBeanInto(bean, xmlElement, this.bindings);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @ApiStatus.Internal
    public final void deserializeInto(@NotNull Object bean, @NotNull XmlElement element) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNull((Object)this.bindings);
        BeanBindingKt.access$deserializeBeanInto(bean, element, this.bindings);
    }

    @NotNull
    public Object newInstance() {
        try {
            Constructor<?> constructor = this.beanClass.getDeclaredConstructor(new Class[0]);
            try {
                constructor.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            Object obj = constructor.newInstance(new Object[0]);
            Intrinsics.checkNotNullExpressionValue(obj, (String)"newInstance(...)");
            return obj;
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getTargetException();
            if (throwable == null) {
                throwable = e;
            }
            throw throwable;
        }
    }

    public final boolean equalByFields(@NotNull Object currentValue, @NotNull Object defaultValue, @NotNull SkipDefaultsSerializationFilter filter) {
        Intrinsics.checkNotNullParameter((Object)currentValue, (String)"currentValue");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intrinsics.checkNotNull((Object)this.bindings);
        for (NestedBinding binding : this.bindings) {
            MutableAccessor accessor = binding.getAccessor();
            if (filter.equal(binding, accessor.read(currentValue), accessor.read(defaultValue))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final Object2FloatMap<String> computeBindingWeights$intellij_platform_util(@NotNull Set<String> accessorNameTracker) {
        Intrinsics.checkNotNullParameter(accessorNameTracker, (String)"accessorNameTracker");
        Object2FloatOpenHashMap weights = new Object2FloatOpenHashMap(accessorNameTracker.size());
        float weight = 0.0f;
        Intrinsics.checkNotNull((Object)this.bindings);
        float step = (float)this.bindings.length / (float)accessorNameTracker.size();
        for (String name : accessorNameTracker) {
            weights.put((Object)name, weight);
            weight += step;
        }
        weight = 0.0f;
        Intrinsics.checkNotNull((Object)this.bindings);
        for (NestedBinding binding : this.bindings) {
            String name;
            Intrinsics.checkNotNullExpressionValue((Object)binding.getAccessor().getName(), (String)"getName(...)");
            if (!weights.containsKey((Object)name)) {
                weights.put((Object)name, weight);
            }
            float f = weight;
            weight = f + 1.0f;
        }
        return (Object2FloatMap)weights;
    }

    public final void sortBindings(@NotNull Object2FloatMap<String> weights) {
        Intrinsics.checkNotNullParameter(weights, (String)"weights");
        Intrinsics.checkNotNull((Object)this.bindings);
        Arrays.sort(this.bindings, (arg_0, arg_1) -> BeanBinding.sortBindings$lambda$1((arg_0, arg_1) -> BeanBinding.sortBindings$lambda$0(weights, arg_0, arg_1), arg_0, arg_1));
    }

    @Override
    @ApiStatus.Internal
    public <T> boolean isBoundTo(@NotNull T element, @NotNull DomAdapter<T> adapter) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        return Intrinsics.areEqual((Object)adapter.getName(element), (Object)this.tagName);
    }

    @NotNull
    public String toString() {
        return "BeanBinding(" + this.beanClass.getName() + ", tagName=" + this.tagName + ')';
    }

    @Deprecated(message="Don't use internal API", replaceWith=@ReplaceWith(expression="", imports={}))
    @ApiStatus.Internal
    @ApiStatus.ScheduledForRemoval
    @Nullable
    public final Element serializeInto(@NotNull Object bean, @Nullable Element preCreatedElement, @Nullable SerializationFilter filter) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        return this.serializeProperties(bean, preCreatedElement, filter);
    }

    private static final int sortBindings$lambda$0(Object2FloatMap $weights, NestedBinding o1, NestedBinding o2) {
        String string = o1.getAccessor().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String n1 = string;
        String string2 = o2.getAccessor().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String n2 = string2;
        float w1 = $weights.getFloat((Object)n1);
        float w2 = $weights.getFloat((Object)n2);
        return (int)(w1 - w2);
    }

    private static final int sortBindings$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }
}

