/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.serialization.SerializationException;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.JdomAdapter;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XmlSerializer {
    private XmlSerializer() {
    }

    public static Element serialize(@NotNull Object object) throws SerializationException {
        if (object == null) {
            XmlSerializer.$$$reportNull$$$0(0);
        }
        return XmlSerializer.serialize(object, null);
    }

    @NotNull
    public static Element serialize(@NotNull Object object, @Nullable SerializationFilter filter) throws SerializationException {
        if (object == null) {
            XmlSerializer.$$$reportNull$$$0(1);
        }
        Element element = XmlSerializerImpl.serialize(object, filter);
        if (element == null) {
            XmlSerializer.$$$reportNull$$$0(2);
        }
        return element;
    }

    @NotNull
    public static <T> T deserialize(Document document, Class<T> aClass) throws SerializationException {
        return XmlSerializer.deserialize(document.getRootElement(), aClass);
    }

    @NotNull
    public static <T> T deserialize(@NotNull Element element, @NotNull Class<T> aClass) throws SerializationException {
        Object object;
        if (element == null) {
            XmlSerializer.$$$reportNull$$$0(3);
        }
        if (aClass == null) {
            XmlSerializer.$$$reportNull$$$0(4);
        }
        try {
            Binding binding = XmlSerializerImpl.serializer.getRootBinding(aClass, aClass);
            object = Objects.requireNonNull(binding.deserialize(null, element, JdomAdapter.INSTANCE));
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException("Cannot deserialize class " + aClass.getName(), e);
        }
        if (object == null) {
            XmlSerializer.$$$reportNull$$$0(5);
        }
        return (T)object;
    }

    @NotNull
    public static <T> T deserialize(@NotNull URL url, Class<T> aClass) throws SerializationException {
        if (url == null) {
            XmlSerializer.$$$reportNull$$$0(6);
        }
        try {
            return XmlSerializer.deserialize(JDOMUtil.load(url), aClass);
        }
        catch (IOException | JDOMException e) {
            throw new XmlSerializationException(e);
        }
    }

    public static void deserializeInto(@NotNull Object bean, @NotNull Element element) {
        if (bean == null) {
            XmlSerializer.$$$reportNull$$$0(7);
        }
        if (element == null) {
            XmlSerializer.$$$reportNull$$$0(8);
        }
        try {
            Class<?> aClass = bean.getClass();
            ((BeanBinding)XmlSerializerImpl.serializer.getRootBinding(aClass, aClass)).deserializeInto(bean, element);
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException(e);
        }
    }

    @ApiStatus.Internal
    @ApiStatus.Obsolete
    @NotNull
    public static BeanBinding getBeanBinding(@NotNull Class<?> aClass) {
        if (aClass == null) {
            XmlSerializer.$$$reportNull$$$0(9);
        }
        BeanBinding beanBinding = (BeanBinding)XmlSerializerImpl.serializer.getRootBinding(aClass, aClass);
        if (beanBinding == null) {
            XmlSerializer.$$$reportNull$$$0(10);
        }
        return beanBinding;
    }

    public static void serializeInto(@NotNull Object bean, @NotNull Element element) {
        if (bean == null) {
            XmlSerializer.$$$reportNull$$$0(11);
        }
        if (element == null) {
            XmlSerializer.$$$reportNull$$$0(12);
        }
        XmlSerializer.serializeInto(bean, element, null);
    }

    public static void serializeInto(@NotNull Object bean, @NotNull Element element, @Nullable SerializationFilter filter) {
        if (bean == null) {
            XmlSerializer.$$$reportNull$$$0(13);
        }
        if (element == null) {
            XmlSerializer.$$$reportNull$$$0(14);
        }
        try {
            Class<?> aClass = bean.getClass();
            ((BeanBinding)XmlSerializerImpl.serializer.getRootBinding(aClass, aClass)).serializeProperties(bean, element, filter);
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xmlb/XmlSerializer";
                break;
            }
            case 3: 
            case 8: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 7: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xmlb/XmlSerializer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "serialize";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeanBinding";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deserializeInto";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getBeanBinding";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "serializeInto";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

