/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.impl.shared.ui;

import com.intellij.idea.AppMode;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.platform.vcs.impl.shared.CaseSensitivityInfoHolder;
import com.intellij.platform.vcs.impl.shared.ProjectBasePathHolder;
import com.intellij.platform.vcs.impl.shared.VcsMappingsHolder;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007J.\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007J,\u0010\u0010\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J4\u0010\u0012\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u000fH\u0001\u00a2\u0006\u0002\b\u0018J'\u0010\u0019\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00132\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J.\u0010\u001b\u001a\u000e\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00132\u000b\u0010\u001c\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00132\u000b\u0010\n\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0013H\u0002J.\u0010\u001d\u001a\u000e\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00132\u000b\u0010\u001c\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00132\u000b\u0010\n\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0013H\u0002J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\tH\u0002J\u001a\u0010\u001f\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010\r\u001a\u00020\tH\u0002J\u001a\u0010 \u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0002\u00a8\u0006!"}, d2={"Lcom/intellij/platform/vcs/impl/shared/ui/VcsPresentablePath;", "", "<init>", "()V", "getPresentablePath", "", "Lcom/intellij/openapi/util/NlsSafe;", "Lorg/jetbrains/annotations/SystemDependent;", "parentPath", "Lcom/intellij/openapi/vcs/FilePath;", "path", "project", "Lcom/intellij/openapi/project/Project;", "filePath", "forceRelativePath", "", "getPresentablePathOrEmpty", "canBeEmpty", "getRelativePathToSingleVcsRootOrProjectDir", "Lorg/jetbrains/annotations/SystemIndependent;", "vcsMappingsHolder", "Lcom/intellij/platform/vcs/impl/shared/VcsMappingsHolder;", "projectBaseDir", "acceptEmptyPath", "getRelativePathToSingleVcsRootOrProjectDir$intellij_platform_vcs_impl_shared", "getRelativePathToSingleRoot", "vcsRootForFile", "relativizeSystemIndependentPaths", "ancestor", "getRelativePathIfSuccessor", "shouldHandleAsNonLocal", "getRelativePathToUserHome", "getSystemDependentPath", "intellij.platform.vcs.impl.shared"})
@SourceDebugExtension(value={"SMAP\nVcsPresentablePath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsPresentablePath.kt\ncom/intellij/platform/vcs/impl/shared/ui/VcsPresentablePath\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,108:1\n30#2,2:109\n*S KotlinDebug\n*F\n+ 1 VcsPresentablePath.kt\ncom/intellij/platform/vcs/impl/shared/ui/VcsPresentablePath\n*L\n37#1:109,2\n*E\n"})
public final class VcsPresentablePath {
    @NotNull
    public static final VcsPresentablePath INSTANCE = new VcsPresentablePath();

    private VcsPresentablePath() {
    }

    @JvmStatic
    @NotNull
    public static final String getPresentablePath(@NotNull FilePath parentPath, @NotNull FilePath path) {
        Intrinsics.checkNotNullParameter((Object)parentPath, (String)"parentPath");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = parentPath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String string2 = path.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        String string3 = INSTANCE.relativizeSystemIndependentPaths(string, string2);
        if (string3 == null) {
            String string4 = path.getPath();
            string3 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
        }
        String prettyPath = string3;
        return INSTANCE.shouldHandleAsNonLocal(path) ? prettyPath : INSTANCE.getSystemDependentPath(prettyPath);
    }

    @JvmStatic
    @NotNull
    public static final String getPresentablePath(@Nullable Project project, @NotNull FilePath filePath, boolean forceRelativePath) {
        String string;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (!forceRelativePath && INSTANCE.shouldHandleAsNonLocal(filePath)) {
            String string2 = filePath.getPath();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        } else {
            string = INSTANCE.getPresentablePathOrEmpty(project, filePath, !forceRelativePath);
        }
        return string;
    }

    public static /* synthetic */ String getPresentablePath$default(Project project, FilePath filePath, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return VcsPresentablePath.getPresentablePath(project, filePath, bl);
    }

    /*
     * Unable to fully structure code
     */
    private final String getPresentablePathOrEmpty(Project project, FilePath filePath, boolean canBeEmpty) {
        block4: {
            if (project != null && project.isDisposed()) break block4;
            v0 = project;
            if (v0 == null) ** GOTO lbl-1000
            $this$service$iv = (ComponentManager)v0;
            $i$f$service = false;
            serviceClass$iv = ProjectBasePathHolder.class;
            v1 = $this$service$iv.getService(serviceClass$iv);
            if (v1 == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            v0 = (ProjectBasePathHolder)v1;
            if (v0 != null) {
                v2 = v0.getPresentablePath();
            } else lbl-1000:
            // 2 sources

            {
                v2 = projectDir = null;
            }
            if (projectDir != null && (relativePath = this.getRelativePathToSingleVcsRootOrProjectDir$intellij_platform_vcs_impl_shared(VcsMappingsHolder.Companion.getInstance(project), projectDir, filePath, canBeEmpty)) != null) {
                return this.getSystemDependentPath(relativePath);
            }
        }
        return this.getRelativePathToUserHome(filePath);
    }

    @VisibleForTesting
    @Nullable
    public final String getRelativePathToSingleVcsRootOrProjectDir$intellij_platform_vcs_impl_shared(@NotNull VcsMappingsHolder vcsMappingsHolder, @NotNull FilePath projectBaseDir, @NotNull FilePath filePath, boolean acceptEmptyPath) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)vcsMappingsHolder, (String)"vcsMappingsHolder");
        Intrinsics.checkNotNullParameter((Object)projectBaseDir, (String)"projectBaseDir");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        FilePath vcsRootForFile = vcsMappingsHolder.getRootFor(filePath);
        if (vcsRootForFile == null) {
            String string = projectBaseDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String string2 = filePath.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            String string3 = this.getRelativePathIfSuccessor(string, string2);
            if (string3 == null) {
                return null;
            }
            String relativePathToProjectDir = string3;
            Object[] objectArray = new Object[]{relativePathToProjectDir};
            object = VcsBundle.message((String)"label.relative.project.path.presentation", (Object[])objectArray);
        } else if (vcsMappingsHolder.getAllRoots().size() == 1) {
            object = this.getRelativePathToSingleRoot(vcsRootForFile, filePath, acceptEmptyPath);
        } else if (Intrinsics.areEqual((Object)projectBaseDir, (Object)filePath)) {
            object = vcsRootForFile.getName();
        } else {
            String string = projectBaseDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String string4 = filePath.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
            String string5 = this.getRelativePathIfSuccessor(string, string4);
            if (string5 == null) {
                return null;
            }
            String relativePathToProjectDir = string5;
            object = Intrinsics.areEqual((Object)projectBaseDir, (Object)vcsRootForFile) ? projectBaseDir.getName() + "/" + relativePathToProjectDir : relativePathToProjectDir;
        }
        return object;
    }

    private final String getRelativePathToSingleRoot(FilePath vcsRootForFile, FilePath filePath, boolean acceptEmptyPath) {
        String string;
        if (!Intrinsics.areEqual((Object)vcsRootForFile, (Object)filePath)) {
            String string2 = vcsRootForFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            String string3 = filePath.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
            string = this.getRelativePathIfSuccessor(string2, string3);
        } else {
            string = acceptEmptyPath ? "" : vcsRootForFile.getName();
        }
        return string;
    }

    private final String relativizeSystemIndependentPaths(String ancestor, String path) {
        return FileUtil.getRelativePath((String)ancestor, (String)path, (char)'/', (boolean)CaseSensitivityInfoHolder.INSTANCE.getCaseSensitive());
    }

    private final String getRelativePathIfSuccessor(String ancestor, String path) {
        return FileUtil.isAncestor((String)ancestor, (String)path, (boolean)true) ? this.relativizeSystemIndependentPaths(ancestor, path) : null;
    }

    private final boolean shouldHandleAsNonLocal(FilePath filePath) {
        return AppMode.isMonolith() && filePath.isNonLocal();
    }

    private final String getRelativePathToUserHome(FilePath filePath) {
        String string;
        if (AppMode.isMonolith()) {
            String string2 = filePath.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            String string3 = FileUtil.getLocationRelativeToUserHome((String)this.getSystemDependentPath(string2));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getLocationRelativeToUserHome(...)");
        } else {
            String string4 = filePath.getPath();
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
        }
        return string;
    }

    private final String getSystemDependentPath(String path) {
        String string;
        if (AppMode.isMonolith()) {
            String string2 = FileUtil.toSystemDependentName((String)path);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemDependentName(...)");
        } else {
            string = path;
        }
        return string;
    }
}

