/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.impl.shared.ui;

import com.intellij.idea.AppModeAssertions;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.platform.vcs.impl.shared.CaseSensitivityInfoHolder;
import com.intellij.platform.vcs.impl.shared.ProjectBasePathHolder;
import com.intellij.platform.vcs.impl.shared.VcsMappingsHolder;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007J$\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\tH\u0007J$\u0010\u000e\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\tH\u0007J,\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J/\u0010\u0011\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J$\u0010\u0014\u001a\u000e\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00122\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\tH\u0002J\u001a\u0010\u0017\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010\r\u001a\u00020\tH\u0002J\u001a\u0010\u0018\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/vcs/impl/shared/ui/VcsPresentablePath;", "", "<init>", "()V", "getPresentablePath", "", "Lcom/intellij/openapi/util/NlsSafe;", "Lorg/jetbrains/annotations/SystemDependent;", "parentPath", "Lcom/intellij/openapi/vcs/FilePath;", "path", "project", "Lcom/intellij/openapi/project/Project;", "filePath", "getPresentablePathAsParent", "acceptEmptyPath", "", "getRootRelativePath", "Lorg/jetbrains/annotations/SystemIndependent;", "projectBaseDir", "getRelativePathIfSuccessor", "ancestor", "shouldHandleAsNonLocal", "getRelativePathToUserHome", "getSystemDependentPath", "intellij.platform.vcs.impl.shared"})
@SourceDebugExtension(value={"SMAP\nVcsPresentablePath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsPresentablePath.kt\ncom/intellij/platform/vcs/impl/shared/ui/VcsPresentablePath\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,91:1\n30#2,2:92\n*S KotlinDebug\n*F\n+ 1 VcsPresentablePath.kt\ncom/intellij/platform/vcs/impl/shared/ui/VcsPresentablePath\n*L\n38#1:92,2\n*E\n"})
public final class VcsPresentablePath {
    @NotNull
    public static final VcsPresentablePath INSTANCE = new VcsPresentablePath();

    private VcsPresentablePath() {
    }

    @JvmStatic
    @NotNull
    public static final String getPresentablePath(@NotNull FilePath parentPath, @NotNull FilePath path) {
        Intrinsics.checkNotNullParameter((Object)parentPath, (String)"parentPath");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = parentPath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String string2 = path.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        String string3 = INSTANCE.getRelativePathIfSuccessor(string, string2);
        if (string3 == null) {
            String string4 = path.getPath();
            string3 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
        }
        String prettyPath = string3;
        return INSTANCE.shouldHandleAsNonLocal(path) ? prettyPath : INSTANCE.getSystemDependentPath(prettyPath);
    }

    @JvmStatic
    @NotNull
    public static final String getPresentablePath(@Nullable Project project, @NotNull FilePath filePath) {
        String string;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (INSTANCE.shouldHandleAsNonLocal(filePath)) {
            String string2 = filePath.getPath();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        } else {
            string = INSTANCE.getPresentablePath(project, filePath, false);
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String getPresentablePathAsParent(@Nullable Project project, @NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return INSTANCE.getPresentablePath(project, filePath, true);
    }

    /*
     * Unable to fully structure code
     */
    private final String getPresentablePath(Project project, FilePath filePath, boolean acceptEmptyPath) {
        v0 = project;
        if (v0 == null) ** GOTO lbl-1000
        $this$service$iv = (ComponentManager)v0;
        $i$f$service = false;
        serviceClass$iv = ProjectBasePathHolder.class;
        v1 = $this$service$iv.getService(serviceClass$iv);
        if (v1 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        v0 = (ProjectBasePathHolder)v1;
        if (v0 != null) {
            v2 = v0.getPresentablePath();
        } else lbl-1000:
        // 2 sources

        {
            v2 = projectDir = null;
        }
        if (projectDir != null) {
            rootRelativePath = this.getRootRelativePath(project, projectDir, filePath, acceptEmptyPath);
            if (rootRelativePath != null) {
                return this.getSystemDependentPath(rootRelativePath);
            }
            v3 = filePath.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getPath(...)");
            projectRelativePath = this.getRelativePathIfSuccessor(projectDir, v3);
            if (projectRelativePath != null) {
                var8_6 = new Object[]{projectRelativePath};
                v4 = VcsBundle.message((String)"label.relative.project.path.presentation", (Object[])var8_6);
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"message(...)");
                return this.getSystemDependentPath(v4);
            }
        }
        return this.getRelativePathToUserHome(filePath);
    }

    private final String getRootRelativePath(Project project, String projectBaseDir, FilePath filePath, boolean acceptEmptyPath) {
        if (project.isDisposed()) {
            return null;
        }
        String string = filePath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String path = string;
        VcsMappingsHolder vcsMappingsHolder = VcsMappingsHolder.Companion.getInstance(project);
        FilePath filePath2 = vcsMappingsHolder.getRootFor(filePath);
        if (filePath2 == null) {
            return null;
        }
        FilePath root = filePath2;
        String string2 = root.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        String rootPath = string2;
        List<FilePath> roots = vcsMappingsHolder.getAllRoots();
        if (roots.size() == 1) {
            if (Intrinsics.areEqual((Object)rootPath, (Object)path)) {
                return acceptEmptyPath ? "" : root.getName();
            }
            return this.getRelativePathIfSuccessor(rootPath, path);
        }
        if (Intrinsics.areEqual((Object)projectBaseDir, (Object)path)) {
            return root.getName();
        }
        String string3 = this.getRelativePathIfSuccessor(projectBaseDir, path);
        if (string3 == null) {
            return null;
        }
        String relativePath = string3;
        return Intrinsics.areEqual((Object)projectBaseDir, (Object)rootPath) ? root.getName() + "/" + relativePath : relativePath;
    }

    private final String getRelativePathIfSuccessor(String ancestor, String path) {
        return FileUtil.getRelativePath((String)ancestor, (String)path, (char)'/', (boolean)CaseSensitivityInfoHolder.INSTANCE.getCaseSensitive());
    }

    private final boolean shouldHandleAsNonLocal(FilePath filePath) {
        return AppModeAssertions.isMonolith() && filePath.isNonLocal();
    }

    private final String getRelativePathToUserHome(FilePath filePath) {
        String string;
        if (AppModeAssertions.isMonolith()) {
            String string2 = filePath.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            String string3 = FileUtil.getLocationRelativeToUserHome((String)this.getSystemDependentPath(string2));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getLocationRelativeToUserHome(...)");
        } else {
            String string4 = filePath.getPath();
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
        }
        return string;
    }

    private final String getSystemDependentPath(String path) {
        String string;
        if (AppModeAssertions.isMonolith()) {
            String string2 = FileUtil.toSystemDependentName((String)path);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemDependentName(...)");
        } else {
            string = path;
        }
        return string;
    }
}

