/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.vfs.ContentRevisionVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0014\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u00d6\u0081\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/openapi/vcs/actions/AnnotationData;", "", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "revisionNumber", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "<init>", "(Lcom/intellij/openapi/vcs/AbstractVcs;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;)V", "getVcs", "()Lcom/intellij/openapi/vcs/AbstractVcs;", "getFilePath", "()Lcom/intellij/openapi/vcs/FilePath;", "getRevisionNumber", "()Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
public final class AnnotationData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AbstractVcs vcs;
    @NotNull
    private final FilePath filePath;
    @NotNull
    private final VcsRevisionNumber revisionNumber;

    public AnnotationData(@NotNull AbstractVcs vcs, @NotNull FilePath filePath, @NotNull VcsRevisionNumber revisionNumber) {
        Intrinsics.checkNotNullParameter((Object)vcs, (String)"vcs");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)revisionNumber, (String)"revisionNumber");
        this.vcs = vcs;
        this.filePath = filePath;
        this.revisionNumber = revisionNumber;
    }

    @NotNull
    public final AbstractVcs getVcs() {
        return this.vcs;
    }

    @NotNull
    public final FilePath getFilePath() {
        return this.filePath;
    }

    @NotNull
    public final VcsRevisionNumber getRevisionNumber() {
        return this.revisionNumber;
    }

    @NotNull
    public final AbstractVcs component1() {
        return this.vcs;
    }

    @NotNull
    public final FilePath component2() {
        return this.filePath;
    }

    @NotNull
    public final VcsRevisionNumber component3() {
        return this.revisionNumber;
    }

    @NotNull
    public final AnnotationData copy(@NotNull AbstractVcs vcs, @NotNull FilePath filePath, @NotNull VcsRevisionNumber revisionNumber) {
        Intrinsics.checkNotNullParameter((Object)vcs, (String)"vcs");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)revisionNumber, (String)"revisionNumber");
        return new AnnotationData(vcs, filePath, revisionNumber);
    }

    public static /* synthetic */ AnnotationData copy$default(AnnotationData annotationData, AbstractVcs abstractVcs, FilePath filePath, VcsRevisionNumber vcsRevisionNumber, int n, Object object) {
        if ((n & 1) != 0) {
            abstractVcs = annotationData.vcs;
        }
        if ((n & 2) != 0) {
            filePath = annotationData.filePath;
        }
        if ((n & 4) != 0) {
            vcsRevisionNumber = annotationData.revisionNumber;
        }
        return annotationData.copy(abstractVcs, filePath, vcsRevisionNumber);
    }

    @NotNull
    public String toString() {
        return "AnnotationData(vcs=" + this.vcs + ", filePath=" + this.filePath + ", revisionNumber=" + this.revisionNumber + ")";
    }

    public int hashCode() {
        int result2 = this.vcs.hashCode();
        result2 = result2 * 31 + this.filePath.hashCode();
        result2 = result2 * 31 + this.revisionNumber.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnnotationData)) {
            return false;
        }
        AnnotationData annotationData = (AnnotationData)other;
        if (!Intrinsics.areEqual((Object)this.vcs, (Object)annotationData.vcs)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.filePath, (Object)annotationData.filePath)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.revisionNumber, (Object)annotationData.revisionNumber);
    }

    @JvmStatic
    @Nullable
    public static final AnnotationData extractFrom(@NotNull Project project, @NotNull VirtualFile file) {
        return Companion.extractFrom(project, file);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/actions/AnnotationData$Companion;", "", "<init>", "()V", "extractFrom", "Lcom/intellij/openapi/vcs/actions/AnnotationData;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final AnnotationData extractFrom(@NotNull Project project, @NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            FilePath filePath = null;
            VcsRevisionNumber revisionNumber = null;
            VirtualFile virtualFile = file;
            if (virtualFile instanceof VcsVirtualFile) {
                FilePath filePath2;
                VcsFileRevision vcsFileRevision = ((VcsVirtualFile)file).getFileRevision();
                if (vcsFileRevision == null) {
                    return null;
                }
                VcsFileRevision revision = vcsFileRevision;
                if (revision instanceof VcsFileRevisionEx) {
                    FilePath filePath3 = ((VcsFileRevisionEx)revision).getPath();
                    filePath2 = filePath3;
                    Intrinsics.checkNotNullExpressionValue((Object)filePath3, (String)"getPath(...)");
                } else {
                    FilePath filePath4 = VcsUtil.getFilePath((VirtualFile)file);
                    filePath2 = filePath4;
                    Intrinsics.checkNotNullExpressionValue((Object)filePath4, (String)"getFilePath(...)");
                }
                filePath = filePath2;
                VcsRevisionNumber vcsRevisionNumber = revision.getRevisionNumber();
                Intrinsics.checkNotNullExpressionValue((Object)vcsRevisionNumber, (String)"getRevisionNumber(...)");
                revisionNumber = vcsRevisionNumber;
            } else if (virtualFile instanceof ContentRevisionVirtualFile) {
                ContentRevision contentRevision = ((ContentRevisionVirtualFile)file).getContentRevision();
                Intrinsics.checkNotNullExpressionValue((Object)contentRevision, (String)"getContentRevision(...)");
                ContentRevision revision = contentRevision;
                FilePath filePath5 = revision.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)filePath5, (String)"getFile(...)");
                filePath = filePath5;
                VcsRevisionNumber vcsRevisionNumber = revision.getRevisionNumber();
                Intrinsics.checkNotNullExpressionValue((Object)vcsRevisionNumber, (String)"getRevisionNumber(...)");
                revisionNumber = vcsRevisionNumber;
            } else {
                return null;
            }
            if (revisionNumber instanceof TextRevisionNumber || revisionNumber == VcsRevisionNumber.NULL) {
                return null;
            }
            AbstractVcs abstractVcs = VcsUtil.getVcsFor((Project)project, (FilePath)filePath);
            if (abstractVcs == null) {
                return null;
            }
            AbstractVcs vcs = abstractVcs;
            return new AnnotationData(vcs, filePath, revisionNumber);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

