/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.editor.SpellCheckingEditorCustomizationProvider;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.EditChangelistSupport;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldProvider;
import com.intellij.ui.HorizontalScrollBarEditorCustomization;
import com.intellij.ui.OneLineEditorCustomization;
import com.intellij.ui.SoftWrapsEditorCustomization;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.reflect.KProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u0000 82\u00020\u0001:\u000278B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001c\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0016H\u0014J\u000e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0016J\b\u00100\u001a\u00020\u0018H\u0016J\u0017\u00103\u001a\u00020\u00182\r\u00104\u001a\t\u0018\u00010 \u00a2\u0006\u0002\b5H$J\u0010\u00106\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\t8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b&\u0010'\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R(\u0010)\u001a\u0004\u0018\u00010 2\b\u0010(\u001a\u0004\u0018\u00010 8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010#\"\u0004\b+\u0010%R\u0011\u0010,\u001a\u00020-8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0011\u00101\u001a\u00020-8F\u00a2\u0006\u0006\u001a\u0004\b2\u0010/\u00a8\u00069"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/NewEditChangelistPanel;", "Lcom/intellij/ui/components/panels/Wrapper;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "nameTextField", "Lcom/intellij/ui/EditorTextField;", "nameComponent", "Lcom/intellij/openapi/vcs/changes/ui/NewEditChangelistPanel$ComponentWithTextFieldWrapper;", "descriptionTextArea", "additionalControlsPanel", "Ljavax/swing/JPanel;", "makeActiveCheckBox", "Ljavax/swing/JCheckBox;", "getMakeActiveCheckBox", "()Ljavax/swing/JCheckBox;", "consumers", "", "Lcom/intellij/util/Consumer;", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "init", "", "initial", "buildMainPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "nameChangedImpl", "changelistCreatedOrChanged", "list", "<set-?>", "", "changeListName", "getChangeListName", "()Ljava/lang/String;", "setChangeListName", "(Ljava/lang/String;)V", "changeListName$delegate", "Lkotlin/reflect/KMutableProperty0;", "s", "description", "getDescription", "setDescription", "content", "Ljavax/swing/JComponent;", "getContent", "()Ljavax/swing/JComponent;", "requestFocus", "preferredFocusedComponent", "getPreferredFocusedComponent", "nameChanged", "errorMessage", "Lorg/jetbrains/annotations/Nls;", "createComponentWithTextField", "ComponentWithTextFieldWrapper", "Companion", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nNewEditChangelistPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewEditChangelistPanel.kt\ncom/intellij/openapi/vcs/changes/ui/NewEditChangelistPanel\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,173:1\n14060#2,2:174\n*S KotlinDebug\n*F\n+ 1 NewEditChangelistPanel.kt\ncom/intellij/openapi/vcs/changes/ui/NewEditChangelistPanel\n*L\n96#1:174,2\n*E\n"})
public abstract class NewEditChangelistPanel
extends Wrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final EditorTextField nameTextField;
    @NotNull
    private final ComponentWithTextFieldWrapper nameComponent;
    @JvmField
    @NotNull
    protected final EditorTextField descriptionTextArea;
    @NotNull
    private final JPanel additionalControlsPanel;
    @NotNull
    private final JCheckBox makeActiveCheckBox;
    @NotNull
    private final List<Consumer<LocalChangeList>> consumers;
    @NotNull
    private final KMutableProperty0 changeListName$delegate;

    public NewEditChangelistPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.additionalControlsPanel = new JPanel(null);
        this.consumers = new ArrayList();
        this.nameComponent = this.createComponentWithTextField(this.project);
        this.nameTextField = this.nameComponent.getEditorTextField();
        this.nameTextField.setOneLineMode(true);
        String string = VcsBundle.message((String)"changes.new.changelist", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String generateUniqueName = ChangeListUtil.createNameForChangeList(this.project, string);
        this.nameTextField.setText(generateUniqueName);
        this.nameTextField.selectAll();
        this.descriptionTextArea = NewEditChangelistPanel.Companion.createEditorField(this.project, 4);
        this.descriptionTextArea.setOneLineMode(false);
        this.makeActiveCheckBox = new JCheckBox(VcsBundle.message((String)"new.changelist.make.active.checkbox", (Object[])new Object[0]));
        this.additionalControlsPanel.add(this.makeActiveCheckBox);
        this.changeListName$delegate = (KMutableProperty0)new MutablePropertyReference0Impl(this.nameTextField){

            public Object get() {
                return ((EditorTextField)this.receiver).getText();
            }

            public void set(Object value) {
                ((EditorTextField)this.receiver).setText((String)value);
            }
        };
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    public final JCheckBox getMakeActiveCheckBox() {
        return this.makeActiveCheckBox;
    }

    public void init(@Nullable LocalChangeList initial) {
        this.makeActiveCheckBox.setSelected(VcsConfiguration.getInstance((Project)this.project).MAKE_NEW_CHANGELIST_ACTIVE);
        for (EditChangelistSupport support : EditChangelistSupport.EP_NAME.getExtensionList((AreaInstance)this.project)) {
            support.installSearch(this.nameTextField, this.descriptionTextArea);
            ContainerUtil.addIfNotNull((Collection)this.consumers, support.addControls(this.additionalControlsPanel, initial));
        }
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(this, initial){
            final /* synthetic */ NewEditChangelistPanel this$0;
            final /* synthetic */ LocalChangeList $initial;
            {
                this.this$0 = $receiver;
                this.$initial = $initial;
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.nameChangedImpl(this.$initial);
            }
        });
        this.nameChangedImpl(initial);
        this.setContent((JComponent)this.buildMainPanel());
        this.validate();
        this.repaint();
    }

    private final DialogPanel buildMainPanel() {
        return BuilderKt.panel(arg_0 -> NewEditChangelistPanel.buildMainPanel$lambda$0(this, arg_0));
    }

    protected void nameChangedImpl(@Nullable LocalChangeList initial) {
        String name = this.getChangeListName();
        if (StringsKt.isBlank((CharSequence)name)) {
            this.nameChanged(VcsBundle.message((String)"new.changelist.empty.name.error", (Object[])new Object[0]));
        } else if (!(initial != null && Intrinsics.areEqual((Object)name, (Object)initial.getName()) || ChangeListManager.getInstance((Project)this.project).findChangeList(name) == null)) {
            this.nameChanged(VcsBundle.message((String)"new.changelist.duplicate.name.error", (Object[])new Object[0]));
        } else {
            this.nameChanged(null);
        }
    }

    public final void changelistCreatedOrChanged(@NotNull LocalChangeList list) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        for (Consumer<LocalChangeList> consumer : this.consumers) {
            consumer.consume((Object)list);
        }
    }

    @NotNull
    public final String getChangeListName() {
        KProperty0 kProperty0 = (KProperty0)this.changeListName$delegate;
        Object object = kProperty0.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (String)object;
    }

    public final void setChangeListName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        KMutableProperty0 kMutableProperty0 = this.changeListName$delegate;
        kMutableProperty0.set((Object)string);
    }

    @Nullable
    public final String getDescription() {
        return this.descriptionTextArea.getText();
    }

    public final void setDescription(@Nullable String s) {
        this.descriptionTextArea.setText(s);
    }

    @NotNull
    public final JComponent getContent() {
        return (JComponent)((Object)this);
    }

    public void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> NewEditChangelistPanel.requestFocus$lambda$0(this));
    }

    @NotNull
    public final JComponent getPreferredFocusedComponent() {
        return (JComponent)this.nameTextField;
    }

    protected abstract void nameChanged(@Nullable String var1);

    @NotNull
    protected ComponentWithTextFieldWrapper createComponentWithTextField(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        EditorTextField editorTextField = NewEditChangelistPanel.Companion.createEditorField(project, 1);
        return new ComponentWithTextFieldWrapper(editorTextField){
            final /* synthetic */ EditorTextField $editorTextField;
            {
                this.$editorTextField = $editorTextField;
                super((JComponent)$editorTextField);
            }

            public EditorTextField getEditorTextField() {
                return this.$editorTextField;
            }
        };
    }

    private static final Unit buildMainPanel$lambda$0$0$0(int $gap, JComponent $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.putClientProperty(DslComponentProperty.VISUAL_PADDINGS, UnscaledGapsKt.UnscaledGaps((int)$gap));
        return Unit.INSTANCE;
    }

    private static final Unit buildMainPanel$lambda$0$0(NewEditChangelistPanel this$0, int $gap, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell(this$0.nameComponent.getMyComponent()).resizableColumn().align((Align)AlignX.FILL.INSTANCE).applyToComponent(arg_0 -> NewEditChangelistPanel.buildMainPanel$lambda$0$0$0($gap, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit buildMainPanel$lambda$0$1(NewEditChangelistPanel this$0, int $gap, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = VcsBundle.message((String)"edit.changelist.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string).align((Align)AlignY.TOP.INSTANCE).gap(RightGap.SMALL);
        $this$row.cell((JComponent)this$0.descriptionTextArea).resizableColumn().align(Align.FILL).customize(UnscaledGapsKt.UnscaledGaps$default((int)0, (int)$gap, (int)0, (int)$gap, (int)5, null));
        return Unit.INSTANCE;
    }

    private static final Unit buildMainPanel$lambda$0$2(NewEditChangelistPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Component[] componentArray = this$0.additionalControlsPanel.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Object[] $this$forEach$iv = componentArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Component it = (Component)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type javax.swing.JComponent");
            $this$row.cell((JComponent)it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit buildMainPanel$lambda$0(NewEditChangelistPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        int gap = 3;
        String string = VcsBundle.message((String)"edit.changelist.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> NewEditChangelistPanel.buildMainPanel$lambda$0$0(this$0, gap, arg_0)).bottomGap(BottomGap.SMALL);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> NewEditChangelistPanel.buildMainPanel$lambda$0$1(this$0, gap, arg_0), (int)1, null).resizableRow().layout(RowLayout.PARENT_GRID).bottomGap(BottomGap.SMALL);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> NewEditChangelistPanel.buildMainPanel$lambda$0$2(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final void requestFocus$lambda$0(NewEditChangelistPanel this$0) {
        IdeFocusManager.getGlobalInstance().requestFocus((Component)this$0.nameTextField, true);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/NewEditChangelistPanel$Companion;", "", "<init>", "()V", "createEditorField", "Lcom/intellij/ui/EditorTextField;", "project", "Lcom/intellij/openapi/project/Project;", "defaultLines", "", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final EditorTextField createEditorField(Project project, int defaultLines) {
            Set editorFeatures = new HashSet();
            ContainerUtil.addIfNotNull((Collection)editorFeatures, (Object)SpellCheckingEditorCustomizationProvider.getInstance().getEnabledCustomization());
            if (defaultLines == 1) {
                HorizontalScrollBarEditorCustomization horizontalScrollBarEditorCustomization = HorizontalScrollBarEditorCustomization.DISABLED;
                Intrinsics.checkNotNullExpressionValue((Object)horizontalScrollBarEditorCustomization, (String)"DISABLED");
                editorFeatures.add(horizontalScrollBarEditorCustomization);
                OneLineEditorCustomization oneLineEditorCustomization = OneLineEditorCustomization.ENABLED;
                Intrinsics.checkNotNullExpressionValue((Object)oneLineEditorCustomization, (String)"ENABLED");
                v2 = editorFeatures.add(oneLineEditorCustomization);
            } else {
                SoftWrapsEditorCustomization softWrapsEditorCustomization = SoftWrapsEditorCustomization.ENABLED;
                Intrinsics.checkNotNullExpressionValue((Object)softWrapsEditorCustomization, (String)"ENABLED");
                v2 = editorFeatures.add(softWrapsEditorCustomization);
            }
            EditorTextField editorTextField = EditorTextFieldProvider.getInstance().getEditorField(FileTypes.PLAIN_TEXT.getLanguage(), project, (Iterable)editorFeatures);
            Intrinsics.checkNotNullExpressionValue((Object)editorTextField, (String)"getEditorField(...)");
            EditorTextField editorField = editorTextField;
            if (defaultLines > 1) {
                editorField.addSettingsProvider(Companion::createEditorField$lambda$0);
                editorField.setMinimumSize((Dimension)new JBDimension(200, 1));
                editorField.setPreferredSize((Dimension)new JBDimension(200, 1));
            }
            return editorField;
        }

        private static final void createEditorField$lambda$0(EditorEx editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            editor.getContentComponent().setBorder((Border)JBUI.Borders.empty((int)3, (int)5));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b$\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/NewEditChangelistPanel$ComponentWithTextFieldWrapper;", "", "myComponent", "Ljavax/swing/JComponent;", "<init>", "(Ljavax/swing/JComponent;)V", "getMyComponent", "()Ljavax/swing/JComponent;", "editorTextField", "Lcom/intellij/ui/EditorTextField;", "getEditorTextField", "()Lcom/intellij/ui/EditorTextField;", "intellij.platform.vcs.impl"})
    protected static abstract class ComponentWithTextFieldWrapper {
        @NotNull
        private final JComponent myComponent;

        public ComponentWithTextFieldWrapper(@NotNull JComponent myComponent) {
            Intrinsics.checkNotNullParameter((Object)myComponent, (String)"myComponent");
            this.myComponent = myComponent;
        }

        @NotNull
        public final JComponent getMyComponent() {
            return this.myComponent;
        }

        @NotNull
        public abstract EditorTextField getEditorTextField();
    }
}

