/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.ChangesViewWorkflowManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.FakeRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.UnversionedDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffTool;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.vcsUtil.VcsImplUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ShowDiffFromLocalChangesActionProvider
implements AnActionExtensionProvider {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public boolean isActive(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(1);
        }
        return e.getData(ChangesListView.DATA_KEY) != null;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(2);
        }
        ShowDiffFromLocalChangesActionProvider.updateAvailability(e);
    }

    public static void updateAvailability(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(3);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Presentation presentation = e.getPresentation();
        String place = e.getPlace();
        if (e.getData(ChangesListView.DATA_KEY) == null) {
            presentation.setEnabled(false);
            return;
        }
        JBIterable changes = JBIterable.of((Object[])((Change[])e.getData(VcsDataKeys.CHANGES)));
        JBIterable unversionedFiles = JBIterable.from((Iterable)((Iterable)e.getData(ChangesListView.UNVERSIONED_FILE_PATHS_DATA_KEY)));
        if ("MainMenu".equals(place)) {
            presentation.setEnabled(project != null && (changes.isNotEmpty() || unversionedFiles.isNotEmpty()));
        } else {
            presentation.setEnabled(project != null && ShowDiffFromLocalChangesActionProvider.canShowDiff(project, (JBIterable<? extends Change>)changes, (JBIterable<? extends FilePath>)unversionedFiles));
        }
        if ("ChangesViewToolbar".equals(place)) {
            presentation.setVisible(!ExperimentalUI.isNewUI());
        }
    }

    private static boolean canShowDiff(@Nullable Project project, @NotNull JBIterable<? extends Change> changes, @NotNull JBIterable<? extends FilePath> paths) {
        if (changes == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(4);
        }
        if (paths == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(5);
        }
        return paths.isNotEmpty() || changes.filter(it -> ChangeDiffRequestProducer.canCreate(project, it)).isNotEmpty();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        GoToChangePopupBuilder.Chain chain;
        Project project;
        if (e == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(6);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        ChangesListView view = (ChangesListView)e.getData(ChangesListView.DATA_KEY);
        if (view == null) {
            return;
        }
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return;
        }
        List changes = view.getSelectedChanges().toList();
        List unversioned = view.getSelectedUnversionedFiles().toList();
        boolean needsConversion = ShowDiffFromLocalChangesActionProvider.checkIfThereAreFakeRevisions(project, changes);
        if (needsConversion) {
            final CompletableFuture resultRef = new CompletableFuture();
            ChangeListManager.getInstance((Project)project).invokeAfterUpdate(true, () -> ChangesViewManager.getInstanceEx(project).scheduleRefresh(() -> {
                try {
                    List<? extends Change> actualChanges = ShowDiffFromLocalChangesActionProvider.loadFakeRevisions(project, changes);
                    resultRef.complete(ShowDiffFromLocalChangesActionProvider.collectRequestProducers(project, actualChanges, unversioned, view));
                }
                catch (Throwable err) {
                    resultRef.completeExceptionally(err);
                }
            }));
            chain = new ChangeDiffRequestChain.Async(){

                @Override
                @NotNull
                protected ListSelection<? extends ChangeDiffRequestChain.Producer> loadRequestProducers() throws DiffRequestProducerException {
                    ListSelection listSelection;
                    try {
                        listSelection = (ListSelection)resultRef.get();
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        throw new DiffRequestProducerException((Throwable)ex);
                    }
                    if (listSelection == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return listSelection;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffFromLocalChangesActionProvider$1", "loadRequestProducers"));
                }
            };
        } else {
            ListSelection<ChangeDiffRequestChain.Producer> producers = ShowDiffFromLocalChangesActionProvider.collectRequestProducers(project, changes, unversioned, view);
            if (producers.isEmpty()) {
                return;
            }
            chain = new ChangeDiffRequestChain(producers);
        }
        chain.putUserData(DiffUserDataKeysEx.LAST_REVISION_WITH_LOCAL, (Object)true);
        ShowDiffFromLocalChangesActionProvider.setAllowExcludeFromCommit(project, (DiffRequestChain)chain);
        DiffManager.getInstance().showDiff(project, (DiffRequestChain)chain, DiffDialogHints.DEFAULT);
    }

    private static boolean checkIfThereAreFakeRevisions(@NotNull Project project, @NotNull List<? extends Change> changes) {
        if (project == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(7);
        }
        if (changes == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(8);
        }
        boolean needsConversion = false;
        for (Change change : changes) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (beforeRevision instanceof FakeRevision) {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(beforeRevision.getFile());
                needsConversion = true;
            }
            if (!(afterRevision instanceof FakeRevision)) continue;
            VcsDirtyScopeManager.getInstance((Project)project).fileDirty(afterRevision.getFile());
            needsConversion = true;
        }
        return needsConversion;
    }

    @NotNull
    private static List<? extends Change> loadFakeRevisions(@NotNull Project project, @NotNull List<? extends Change> changes) {
        if (project == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(9);
        }
        if (changes == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(10);
        }
        Collection allChanges = ChangeListManager.getInstance((Project)project).getAllChanges();
        List list = VcsImplUtil.filterChangesUnder(allChanges, ChangesUtil.getPaths(changes)).toList();
        if (list == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public static ListSelection<ChangeDiffRequestChain.Producer> collectRequestProducers(@NotNull Project project, @NotNull List<? extends Change> changes, @NotNull List<? extends FilePath> unversioned, @NotNull ChangesListView changesView) {
        if (project == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(12);
        }
        if (changes == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(13);
        }
        if (unversioned == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(14);
        }
        if (changesView == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(15);
        }
        if (changes.size() == 1 && unversioned.isEmpty()) {
            Change selectedChange = changes.get(0);
            List selectedChanges = changesView.getAllChangesFromSameChangelist(selectedChange);
            if (selectedChanges == null) {
                selectedChanges = changesView.getAllChangesFromSameAmendNode(selectedChange);
            }
            if (selectedChanges != null) {
                int selectedIndex = ContainerUtil.indexOf((List)selectedChanges, it -> ChangeListChange.HASHING_STRATEGY.equals((Object)selectedChange, it));
                if (selectedIndex == -1) {
                    selectedIndex = selectedChanges.indexOf(selectedChange);
                }
                ListSelection<ChangeDiffRequestChain.Producer> listSelection = ShowDiffFromLocalChangesActionProvider.createChangeProducers(project, selectedChanges, selectedIndex);
                if (listSelection == null) {
                    ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(16);
                }
                return listSelection;
            }
        }
        if (unversioned.size() == 1 && changes.isEmpty()) {
            FilePath selectedFile = unversioned.get(0);
            List allUnversioned = changesView.getUnversionedFiles().toList();
            int selectedIndex = allUnversioned.indexOf(selectedFile);
            ListSelection<ChangeDiffRequestChain.Producer> listSelection = ShowDiffFromLocalChangesActionProvider.createUnversionedProducers(project, allUnversioned, selectedIndex);
            if (listSelection == null) {
                ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(17);
            }
            return listSelection;
        }
        ListSelection<ChangeDiffRequestChain.Producer> changeProducers = ShowDiffFromLocalChangesActionProvider.createChangeProducers(project, changes, 0);
        ListSelection<ChangeDiffRequestChain.Producer> unversionedProducers = ShowDiffFromLocalChangesActionProvider.createUnversionedProducers(project, unversioned, 0);
        ListSelection listSelection = ListSelection.createAt((List)ContainerUtil.concat((List)changeProducers.getList(), (List)unversionedProducers.getList()), (int)0).asExplicitSelection();
        if (listSelection == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(18);
        }
        return listSelection;
    }

    private static ListSelection<ChangeDiffRequestChain.Producer> createChangeProducers(@NotNull Project project, @NotNull List<? extends Change> changes, int selected) {
        if (project == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(19);
        }
        if (changes == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(20);
        }
        return ListSelection.createAt(changes, (int)selected).map(change -> ChangeDiffRequestProducer.create(project, change));
    }

    private static ListSelection<ChangeDiffRequestChain.Producer> createUnversionedProducers(@NotNull Project project, @NotNull List<? extends FilePath> unversioned, int selected) {
        if (project == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(21);
        }
        if (unversioned == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(22);
        }
        return ListSelection.createAt(unversioned, (int)selected).map(path -> UnversionedDiffRequestProducer.create(project, path));
    }

    private static void setAllowExcludeFromCommit(@NotNull Project project, @NotNull DiffRequestChain chain) {
        if (project == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(23);
        }
        if (chain == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(24);
        }
        boolean allowExcludeFromCommit = (Boolean)ChangesViewWorkflowManager.getInstance(project).getAllowExcludeFromCommit().getValue();
        chain.putUserData(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT, (Object)allowExcludeFromCommit);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 19, 20, 21, 22, 23, 24 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffFromLocalChangesActionProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unversioned";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changesView";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chain";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffFromLocalChangesActionProvider";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFakeRevisions";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRequestProducers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateAvailability";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canShowDiff";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkIfThereAreFakeRevisions";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadFakeRevisions";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectRequestProducers";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createChangeProducers";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createUnversionedProducers";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setAllowExcludeFromCommit";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 19, 20, 21, 22, 23, 24 -> new IllegalArgumentException(string);
        };
    }
}

