/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.diff.editor.DiffEditorTabFilesManager;
import com.intellij.diff.editor.DiffEditorTabFilesUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.changes.EditorTabDiffPreview;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowType;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0007J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0003\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/CommitToolWindowUtil;", "", "<init>", "()V", "isInWindow", "", "twType", "Lcom/intellij/openapi/wm/ToolWindowType;", "openDiff", "sourceTwId", "", "diffPreview", "Lcom/intellij/openapi/vcs/changes/EditorTabDiffPreview;", "requestFocus", "forceDiffInEditor", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
public final class CommitToolWindowUtil {
    @NotNull
    public static final CommitToolWindowUtil INSTANCE = new CommitToolWindowUtil();

    private CommitToolWindowUtil() {
    }

    @JvmStatic
    public static final boolean isInWindow(@NotNull ToolWindowType twType) {
        Intrinsics.checkNotNullParameter((Object)twType, (String)"twType");
        return twType == ToolWindowType.WINDOWED || twType == ToolWindowType.FLOATING;
    }

    @JvmStatic
    public static final boolean openDiff(@NotNull String sourceTwId, @NotNull EditorTabDiffPreview diffPreview, boolean requestFocus) {
        Intrinsics.checkNotNullParameter((Object)sourceTwId, (String)"sourceTwId");
        Intrinsics.checkNotNullParameter((Object)diffPreview, (String)"diffPreview");
        if (!diffPreview.hasContent()) {
            return false;
        }
        Project project = diffPreview.getProject();
        VirtualFile diffFile = diffPreview.getPreviewFile();
        if (CommitToolWindowUtil.forceDiffInEditor(project, sourceTwId)) {
            DiffEditorTabFilesUtil.forceOpenInNewWindow((Project)project, (VirtualFile)diffFile, (boolean)requestFocus);
        } else {
            DiffEditorTabFilesManager.Companion.getInstance(project).showDiffFile(diffFile, requestFocus);
        }
        return true;
    }

    @JvmStatic
    private static final boolean forceDiffInEditor(Project project, String sourceTwId) {
        ToolWindow toolWindow = ChangesViewContentManager.Companion.getToolWindowFor(project, sourceTwId);
        if (toolWindow == null) {
            return false;
        }
        ToolWindow tw = toolWindow;
        boolean isCommitTw = Intrinsics.areEqual((Object)tw.getId(), (Object)"Commit");
        ToolWindowType toolWindowType = tw.getType();
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowType, (String)"getType(...)");
        boolean isInWindow = CommitToolWindowUtil.isInWindow(toolWindowType);
        boolean isForcedDiffInWindow = Registry.Companion.is("vcs.commit.dialog.force.diff.in.window");
        return isCommitTw && isInWindow && isForcedDiffInWindow;
    }
}

