/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.changes.viewModel;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesViewWorkflowManager;
import com.intellij.openapi.vcs.changes.CommitChangesViewWithToolbarPanel;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesViewDnDSupport;
import com.intellij.platform.vcs.impl.shared.changes.ChangesViewSettings;
import com.intellij.problems.ProblemListener;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.changes.viewModel.OnChangeListsUpdate;
import com.intellij.vcs.changes.viewModel.OnProblemsUpdate;
import com.intellij.vcs.commit.ChangesViewCommitWorkflowHandler;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/vcs/changes/viewModel/BackendCommitChangesViewWithToolbarPanel;", "Lcom/intellij/openapi/vcs/changes/CommitChangesViewWithToolbarPanel;", "changesView", "Lcom/intellij/openapi/vcs/changes/ui/ChangesListView;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesListView;Lkotlinx/coroutines/CoroutineScope;)V", "initPanel", "", "getModelData", "Lcom/intellij/openapi/vcs/changes/CommitChangesViewWithToolbarPanel$ModelData;", "synchronizeInclusion", "changeLists", "", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "unversionedFiles", "Lcom/intellij/openapi/vcs/FilePath;", "intellij.platform.vcs.impl"})
public final class BackendCommitChangesViewWithToolbarPanel
extends CommitChangesViewWithToolbarPanel {
    public BackendCommitChangesViewWithToolbarPanel(@NotNull ChangesListView changesView, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)changesView, (String)"changesView");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        super(changesView, cs);
    }

    public void initPanel() {
        SimpleMessageBusConnection busConnection = this.getProject().getMessageBus().connect(this.getCs());
        Topic topic = ProblemListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        busConnection.subscribe(topic, (Object)new OnProblemsUpdate(this.getCs(), this));
        Topic<Runnable> topic2 = RemoteRevisionsCache.REMOTE_VERSION_CHANGED;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"REMOTE_VERSION_CHANGED");
        busConnection.subscribe(topic2, () -> BackendCommitChangesViewWithToolbarPanel.initPanel$lambda$0(this));
        Topic topic3 = ChangeListListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic3, (String)"TOPIC");
        busConnection.subscribe(topic3, (Object)new OnChangeListsUpdate(this));
        ChangesViewDnDSupport.install(this.getProject(), (ChangesTree)this.getChangesView(), CoroutineScopeKt.asDisposable((CoroutineScope)this.getCs()));
        super.initPanel();
    }

    @NotNull
    public CommitChangesViewWithToolbarPanel.ModelData getModelData() {
        List<FilePath> list;
        ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(this.getProject());
        List<LocalChangeList> list2 = changeListManager.getChangeLists();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getChangeLists(...)");
        List<LocalChangeList> changeLists2 = list2;
        List<FilePath> list3 = changeListManager.getUnversionedFilesPaths();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"getUnversionedFilesPaths(...)");
        List<FilePath> unversionedFiles = list3;
        if (ChangesViewSettings.Companion.getInstance(this.getProject()).getShowIgnored()) {
            List<FilePath> list4 = changeListManager.getIgnoredFilePaths();
            list = list4;
            Intrinsics.checkNotNullExpressionValue(list4, (String)"getIgnoredFilePaths(...)");
        } else {
            list = CollectionsKt.emptyList();
        }
        List<FilePath> ignoredFiles = list;
        return new CommitChangesViewWithToolbarPanel.ModelData(changeLists2, unversionedFiles, ignoredFiles, () -> BackendCommitChangesViewWithToolbarPanel.getModelData$lambda$0(this));
    }

    public void synchronizeInclusion(@NotNull List<? extends LocalChangeList> changeLists2, @NotNull List<? extends FilePath> unversionedFiles) {
        block0: {
            Intrinsics.checkNotNullParameter(changeLists2, (String)"changeLists");
            Intrinsics.checkNotNullParameter(unversionedFiles, (String)"unversionedFiles");
            ChangesViewCommitWorkflowHandler changesViewCommitWorkflowHandler = ChangesViewWorkflowManager.Companion.getInstance(this.getProject()).getCommitWorkflowHandler();
            if (changesViewCommitWorkflowHandler == null) break block0;
            changesViewCommitWorkflowHandler.synchronizeInclusion(changeLists2, unversionedFiles);
        }
    }

    private static final void initPanel$lambda$0(BackendCommitChangesViewWithToolbarPanel this$0) {
        this$0.scheduleRefresh();
    }

    private static final boolean getModelData$lambda$0(BackendCommitChangesViewWithToolbarPanel this$0) {
        ChangesViewCommitWorkflowHandler changesViewCommitWorkflowHandler = ChangesViewWorkflowManager.Companion.getInstance(this$0.getProject()).getCommitWorkflowHandler();
        return changesViewCommitWorkflowHandler != null ? changesViewCommitWorkflowHandler.isActive() : false;
    }
}

