/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.collapsing;

import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.collapsing.CollapsedGraph;
import com.intellij.vcs.log.graph.collapsing.DottedFilterEdgesGeneratorImpl;
import com.intellij.vcs.log.graph.collapsing.InplaceFilterEdgesGenerator;
import com.intellij.vcs.log.graph.collapsing.ShiftNumber;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000f\b&\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB)\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u0005j\u0002`\u0006H$J \u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0005j\u0002`\u00062\n\u0010\u0012\u001a\u00060\u0005j\u0002`\u0006H$J\u001c\u0010\u0013\u001a\u00020\u00102\n\u0010\u000e\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u0014\u001a\u00020\rH$J\u001c\u0010\u0015\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u0014\u001a\u00020\rH$J\r\u0010\u0016\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0017J\b\u0010\u0018\u001a\u00020\u0010H\u0002J(\u0010\u0019\u001a\u00020\u00102\n\u0010\u001a\u001a\u00060\u0005j\u0002`\u00062\n\u0010\u001b\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u0014\u001a\u00020\rH\u0002J\b\u0010\u001c\u001a\u00020\u0010H\u0002J\b\u0010\u001d\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/vcs/log/graph/collapsing/DottedFilterEdgesGenerator;", "", "graph", "Lcom/intellij/vcs/log/graph/api/LiteLinearGraph;", "upIndex", "", "Lcom/intellij/vcs/log/graph/VcsLogVisibleGraphIndex;", "downIndex", "<init>", "(Lcom/intellij/vcs/log/graph/api/LiteLinearGraph;II)V", "numbers", "Lcom/intellij/vcs/log/graph/collapsing/ShiftNumber;", "nodeIsVisible", "", "nodeIndex", "addDottedEdge", "", "nodeIndex1", "nodeIndex2", "addDottedArrow", "isUp", "hasDottedEdges", "update", "update$intellij_platform_vcs_log_graph_impl", "cleanup", "addEdgeOrArrow", "currentNodeIndex", "anotherNodeIndex", "downWalk", "upWalk", "Companion", "intellij.platform.vcs.log.graph.impl"})
public abstract class DottedFilterEdgesGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LiteLinearGraph graph;
    private final int upIndex;
    private final int downIndex;
    @NotNull
    private final ShiftNumber numbers;

    public DottedFilterEdgesGenerator(@NotNull LiteLinearGraph graph, int upIndex, int downIndex) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        this.graph = graph;
        this.upIndex = upIndex;
        this.downIndex = downIndex;
        this.numbers = new ShiftNumber(this.upIndex, this.downIndex);
    }

    protected abstract boolean nodeIsVisible(int var1);

    protected abstract void addDottedEdge(int var1, int var2);

    protected abstract void addDottedArrow(int var1, boolean var2);

    protected abstract boolean hasDottedEdges(int var1, boolean var2);

    public final void update$intellij_platform_vcs_log_graph_impl() {
        this.downWalk();
        this.cleanup();
        this.upWalk();
    }

    private final void cleanup() {
        int currentNodeIndex = this.upIndex;
        int n = this.downIndex;
        if (currentNodeIndex <= n) {
            while (true) {
                this.numbers.setNumber(currentNodeIndex, Integer.MAX_VALUE);
                if (currentNodeIndex == n) break;
                ++currentNodeIndex;
            }
        }
    }

    private final void addEdgeOrArrow(int currentNodeIndex, int anotherNodeIndex, boolean isUp) {
        if (this.hasDottedEdges(currentNodeIndex, isUp)) {
            if (this.nodeIsVisible(anotherNodeIndex)) {
                this.addDottedEdge(currentNodeIndex, anotherNodeIndex);
            } else {
                this.addDottedArrow(currentNodeIndex, isUp);
            }
        }
    }

    private final void downWalk() {
        int currentNodeIndex = this.upIndex;
        int n = this.downIndex;
        if (currentNodeIndex <= n) {
            while (true) {
                if (this.nodeIsVisible(currentNodeIndex)) {
                    nearlyUp = Integer.MIN_VALUE;
                    int maxAdjNumber = Integer.MIN_VALUE;
                    for (Integer upNode : this.graph.getNodes(currentNodeIndex, LiteLinearGraph.NodeFilter.UP)) {
                        if (upNode < this.upIndex) {
                            Intrinsics.checkNotNull((Object)upNode);
                            this.addEdgeOrArrow(currentNodeIndex, upNode, true);
                            continue;
                        }
                        Intrinsics.checkNotNull((Object)upNode);
                        if (this.nodeIsVisible(upNode)) {
                            maxAdjNumber = Math.max(maxAdjNumber, this.numbers.getNumber(upNode));
                            continue;
                        }
                        nearlyUp = Math.max(nearlyUp, this.numbers.getNumber(upNode));
                    }
                    if (nearlyUp == maxAdjNumber || nearlyUp == Integer.MIN_VALUE) {
                        this.numbers.setNumber(currentNodeIndex, maxAdjNumber);
                    } else {
                        this.addDottedEdge(currentNodeIndex, nearlyUp);
                        this.numbers.setNumber(currentNodeIndex, nearlyUp);
                    }
                } else {
                    nearlyUp = Integer.MIN_VALUE;
                    for (Integer upNode : this.graph.getNodes(currentNodeIndex, LiteLinearGraph.NodeFilter.UP)) {
                        Intrinsics.checkNotNull((Object)upNode);
                        if (this.nodeIsVisible(upNode)) {
                            nearlyUp = Math.max(nearlyUp, upNode);
                            continue;
                        }
                        if (upNode < this.upIndex) continue;
                        nearlyUp = Math.max(nearlyUp, this.numbers.getNumber(upNode));
                    }
                    this.numbers.setNumber(currentNodeIndex, nearlyUp);
                }
                if (currentNodeIndex == n) break;
                ++currentNodeIndex;
            }
        }
    }

    private final void upWalk() {
        int n = this.upIndex;
        int currentNodeIndex = this.downIndex;
        if (n <= currentNodeIndex) {
            while (true) {
                if (this.nodeIsVisible(currentNodeIndex)) {
                    nearlyDown = Integer.MAX_VALUE;
                    int minAdjNumber = Integer.MAX_VALUE;
                    for (Integer downNode : this.graph.getNodes(currentNodeIndex, LiteLinearGraph.NodeFilter.DOWN)) {
                        if (downNode > this.downIndex) {
                            Intrinsics.checkNotNull((Object)downNode);
                            this.addEdgeOrArrow(currentNodeIndex, downNode, false);
                            continue;
                        }
                        Intrinsics.checkNotNull((Object)downNode);
                        if (this.nodeIsVisible(downNode)) {
                            minAdjNumber = Math.min(minAdjNumber, this.numbers.getNumber(downNode));
                            continue;
                        }
                        nearlyDown = Math.min(nearlyDown, this.numbers.getNumber(downNode));
                    }
                    if (nearlyDown == minAdjNumber || nearlyDown == Integer.MAX_VALUE) {
                        this.numbers.setNumber(currentNodeIndex, minAdjNumber);
                    } else {
                        this.addDottedEdge(currentNodeIndex, nearlyDown);
                        this.numbers.setNumber(currentNodeIndex, nearlyDown);
                    }
                } else {
                    nearlyDown = Integer.MAX_VALUE;
                    for (Integer downNode : this.graph.getNodes(currentNodeIndex, LiteLinearGraph.NodeFilter.DOWN)) {
                        Intrinsics.checkNotNull((Object)downNode);
                        if (this.nodeIsVisible(downNode)) {
                            nearlyDown = Math.min(nearlyDown, downNode);
                            continue;
                        }
                        if (downNode > this.downIndex) continue;
                        nearlyDown = Math.min(nearlyDown, this.numbers.getNumber(downNode));
                    }
                    this.numbers.setNumber(currentNodeIndex, nearlyDown);
                }
                if (currentNodeIndex == n) break;
                --currentNodeIndex;
            }
        }
    }

    @JvmStatic
    public static final void update(@NotNull CollapsedGraph collapsedGraph, int upDelegateNodeIndex, int downDelegateNodeIndex) {
        Companion.update(collapsedGraph, upDelegateNodeIndex, downDelegateNodeIndex);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tj\u0002`\n2\n\u0010\u000b\u001a\u00060\tj\u0002`\nH\u0007J \u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0010\u0010\r\u001a\f\u0012\b\u0012\u00060\tj\u0002`\n0\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/vcs/log/graph/collapsing/DottedFilterEdgesGenerator$Companion;", "", "<init>", "()V", "update", "", "collapsedGraph", "Lcom/intellij/vcs/log/graph/collapsing/CollapsedGraph;", "upDelegateNodeIndex", "", "Lcom/intellij/vcs/log/graph/VcsLogVisibleGraphIndex;", "downDelegateNodeIndex", "hideInplace", "toHide", "", "intellij.platform.vcs.log.graph.impl"})
    @SourceDebugExtension(value={"SMAP\nDottedFilterEdgesGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DottedFilterEdgesGenerator.kt\ncom/intellij/vcs/log/graph/collapsing/DottedFilterEdgesGenerator$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,242:1\n1915#2,2:243\n*S KotlinDebug\n*F\n+ 1 DottedFilterEdgesGenerator.kt\ncom/intellij/vcs/log/graph/collapsing/DottedFilterEdgesGenerator$Companion\n*L\n164#1:243,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void update(@NotNull CollapsedGraph collapsedGraph, int upDelegateNodeIndex, int downDelegateNodeIndex) {
            Intrinsics.checkNotNullParameter((Object)collapsedGraph, (String)"collapsedGraph");
            CollapsedGraph.Modification modification = collapsedGraph.startModification();
            Intrinsics.checkNotNullExpressionValue((Object)modification, (String)"startModification(...)");
            CollapsedGraph.Modification modification2 = modification;
            new DottedFilterEdgesGeneratorImpl(collapsedGraph, modification2, upDelegateNodeIndex, downDelegateNodeIndex).update$intellij_platform_vcs_log_graph_impl();
            modification2.apply();
        }

        public final void hideInplace(@NotNull CollapsedGraph collapsedGraph, @NotNull Set<Integer> toHide) {
            Intrinsics.checkNotNullParameter((Object)collapsedGraph, (String)"collapsedGraph");
            Intrinsics.checkNotNullParameter(toHide, (String)"toHide");
            CollapsedGraph.Modification modification = collapsedGraph.startModification();
            Intrinsics.checkNotNullExpressionValue((Object)modification, (String)"startModification(...)");
            CollapsedGraph.Modification modification2 = modification;
            new InplaceFilterEdgesGenerator(collapsedGraph, modification2, toHide).update$intellij_platform_vcs_log_graph_impl();
            Iterable $this$forEach$iv = toHide;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                modification2.hideNode(collapsedGraph.convertToDelegateNodeIndex(it));
            }
            modification2.apply();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

