/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.telemetry.VcsBackendTelemetrySpan;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.vcs.impl.shared.telemetry.VcsScopeKt;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogAggregatedStoredRefs;
import com.intellij.vcs.log.VcsLogAggregatedStoredRefsKt;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogRootStoredRefs;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.EmptyPermanentGraph;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogGraphData;
import com.intellij.vcs.log.data.VcsLogGraphDataImpl;
import com.intellij.vcs.log.data.VcsLogGraphOverlayData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.GraphColorManagerImpl;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.HeadCommitsComparator;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.api.printer.GraphColorGetterFactory;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.graph.impl.print.GraphColorGetterByHeadFactory;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JX\u0010\u0006\u001a\u00020\u00072\u0016\u0010\b\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u000bj\u0002`\f0\n0\t2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00120\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J>\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0010\u0010\u0019\u001a\f\u0012\b\u0012\u00060\u000bj\u0002`\f0\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00120\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007JP\u0010\u001c\u001a\u00020\u001d2\u0016\u0010\b\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u000bj\u0002`\f0\n0\t2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00120\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007JN\u0010\u001e\u001a\f\u0012\b\u0012\u00060\u000bj\u0002`\f0\u001a2\u0016\u0010\b\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u000bj\u0002`\f0\n0\t2\u0006\u0010\u0017\u001a\u00020\u001f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00120\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/vcs/log/data/VcsLogGraphDataFactory;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "buildData", "Lcom/intellij/vcs/log/data/VcsLogGraphData;", "commits", "", "Lcom/intellij/vcs/log/graph/GraphCommit;", "", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "refs", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogRootStoredRefs;", "providers", "Lcom/intellij/vcs/log/VcsLogProvider;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "full", "", "refsModel", "Lcom/intellij/vcs/log/VcsLogAggregatedStoredRefs;", "permanentGraph", "Lcom/intellij/vcs/log/graph/PermanentGraph;", "logProviders", "buildOverlayData", "Lcom/intellij/vcs/log/data/VcsLogGraphData$OverlayData;", "buildPermanentGraph", "Lcom/intellij/vcs/log/data/RefsModel;", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nVcsLogGraphDataFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogGraphDataFactory.kt\ncom/intellij/vcs/log/data/VcsLogGraphDataFactory\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n*L\n1#1,109:1\n95#2:110\n135#2,3:111\n95#2:118\n135#2,3:119\n67#3,4:114\n67#3,4:122\n13#3:148\n466#4:126\n415#4:127\n1266#5,4:128\n1661#5,3:132\n27#6:135\n87#6,2:136\n28#6,3:138\n98#6:141\n90#6,6:142\n*S KotlinDebug\n*F\n+ 1 VcsLogGraphDataFactory.kt\ncom/intellij/vcs/log/data/VcsLogGraphDataFactory\n*L\n38#1:110\n38#1:111,3\n40#1:118\n40#1:119,3\n39#1:114,4\n41#1:122,4\n28#1:148\n74#1:126\n74#1:127\n74#1:128,4\n77#1:132,3\n80#1:135\n80#1:136,2\n80#1:138,3\n80#1:141\n80#1:142,6\n*E\n"})
public final class VcsLogGraphDataFactory {
    @NotNull
    public static final VcsLogGraphDataFactory INSTANCE = new VcsLogGraphDataFactory();
    @NotNull
    private static final Logger LOG;

    private VcsLogGraphDataFactory() {
    }

    @JvmStatic
    @NotNull
    public static final VcsLogGraphData buildData(@NotNull List<? extends GraphCommit<Integer>> commits, @NotNull Map<VirtualFile, ? extends VcsLogRootStoredRefs> refs, @NotNull Map<VirtualFile, ? extends VcsLogProvider> providers, @NotNull VcsLogStorage storage, boolean full) {
        Logger logger;
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        Intrinsics.checkNotNullParameter(refs, (String)"refs");
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        RefsModel result$iv$iv = RefsModel.Companion.create(refs, storage, providers);
        TimedValue timedValue = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        RefsModel refsModel = (RefsModel)timedValue.component1();
        long refsModelCreationTime = timedValue.component2-UwyO8pc();
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl2 = false;
            logger.trace("Refs model created in " + Duration.getInWholeMilliseconds-impl((long)refsModelCreationTime) + " ms");
        }
        boolean $i$f$measureTimedValue3 = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv2 = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue4 = false;
        long mark$iv$iv2 = $this$measureTimedValue$iv$iv2.markNow-z9LOYto();
        boolean bl3 = false;
        PermanentGraph<Integer> result$iv$iv2 = INSTANCE.buildPermanentGraph(commits, refsModel, providers, storage);
        TimedValue timedValue2 = new TimedValue(result$iv$iv2, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv2), null);
        PermanentGraph permanentGraph = (PermanentGraph)timedValue2.component1();
        long permanentGraphBuildTime = timedValue2.component2-UwyO8pc();
        Logger $this$trace$iv2 = LOG;
        boolean $i$f$trace2 = false;
        if ($this$trace$iv2.isTraceEnabled()) {
            logger = $this$trace$iv2;
            boolean bl4 = false;
            logger.trace("Permanent graph created in " + Duration.getInWholeMilliseconds-impl((long)permanentGraphBuildTime) + " ms");
        }
        return VcsLogGraphDataFactory.buildData(refsModel, (PermanentGraph<Integer>)permanentGraph, providers, full);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogGraphData buildData(@NotNull VcsLogAggregatedStoredRefs refsModel, @NotNull PermanentGraph<Integer> permanentGraph, @NotNull Map<VirtualFile, ? extends VcsLogProvider> logProviders, boolean full) {
        Intrinsics.checkNotNullParameter((Object)refsModel, (String)"refsModel");
        Intrinsics.checkNotNullParameter(permanentGraph, (String)"permanentGraph");
        Intrinsics.checkNotNullParameter(logProviders, (String)"logProviders");
        return new VcsLogGraphDataImpl(refsModel, permanentGraph, logProviders, full);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogGraphData.OverlayData buildOverlayData(@NotNull List<? extends GraphCommit<Integer>> commits, @NotNull Map<VirtualFile, ? extends VcsLogRootStoredRefs> refs, @NotNull Map<VirtualFile, ? extends VcsLogProvider> providers, @NotNull VcsLogStorage storage) {
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        Intrinsics.checkNotNullParameter(refs, (String)"refs");
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        RefsModel refsModel = RefsModel.Companion.create(refs, storage, providers);
        PermanentGraph<Integer> permanentGraph = INSTANCE.buildPermanentGraph(commits, refsModel, providers, storage);
        return new VcsLogGraphOverlayData(refsModel, permanentGraph, providers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final PermanentGraph<Integer> buildPermanentGraph(List<? extends GraphCommit<Integer>> commits, RefsModel refsModel, Map<VirtualFile, ? extends VcsLogProvider> providers, VcsLogStorage storage) {
        Map.Entry entry;
        void $this$mapTo$iv;
        Map.Entry entry2;
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        if (commits.isEmpty()) {
            PermanentGraph<Integer> permanentGraph = EmptyPermanentGraph.getInstance();
            Intrinsics.checkNotNullExpressionValue(permanentGraph, (String)"getInstance(...)");
            return permanentGraph;
        }
        Map<VirtualFile, ? extends VcsLogProvider> map = providers;
        VcsLogAggregatedStoredRefs vcsLogAggregatedStoredRefs = refsModel;
        boolean $i$f$mapValues22 = false;
        void var8_9 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            entry2 = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            VcsLogRefManager vcsLogRefManager = ((VcsLogProvider)it.getValue()).getReferenceManager();
            map3.put(k, vcsLogRefManager);
        }
        Function<Object, Hash> function = arg_0 -> VcsLogGraphDataFactory.buildPermanentGraph$lambda$2(arg_0 -> VcsLogGraphDataFactory.buildPermanentGraph$lambda$1(storage, arg_0), arg_0);
        Map map4 = destination$iv$iv$iv;
        VcsLogAggregatedStoredRefs vcsLogAggregatedStoredRefs2 = vcsLogAggregatedStoredRefs;
        HeadCommitsComparator headCommitsComparator = new HeadCommitsComparator(vcsLogAggregatedStoredRefs2, map4, function);
        Iterable $i$f$mapValues22 = VcsLogAggregatedStoredRefsKt.getBranches((VcsLogAggregatedStoredRefs)refsModel);
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            destination$iv$iv$iv = (VcsRef)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            Hash hash = it.getCommitHash();
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getCommitHash(...)");
            VirtualFile virtualFile = it.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
            collection.add(storage.getCommitIndex(hash, virtualFile));
        }
        HashSet branches = (HashSet)destination$iv;
        IJTracer tracer = TelemetryManager.Companion.getInstance().getTracer(VcsScopeKt.VcsScope);
        SpanBuilder spanBuilder = tracer.spanBuilder(VcsBackendTelemetrySpan.LogData.BuildingGraph.getName());
        Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"spanBuilder(...)");
        SpanBuilder $this$use$iv = spanBuilder;
        boolean $i$f$use = false;
        Span span = $this$use$iv.startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
        Span $this$useWithoutActiveScope$iv$iv = span;
        boolean $i$f$useWithoutActiveScope = false;
        try {
            Span span$iv = $this$useWithoutActiveScope$iv$iv;
            boolean bl = false;
            AutoCloseable autoCloseable = (AutoCloseable)span$iv.makeCurrent();
            Throwable throwable = null;
            try {
                Scope it$iv = (Scope)autoCloseable;
                boolean bl3 = false;
                Span span2 = span$iv;
                boolean bl4 = false;
                entry2 = PermanentGraphImpl.Companion.newInstance(commits, (GraphColorGetterFactory)new GraphColorGetterByHeadFactory((GraphColorManager)new GraphColorManagerImpl(refsModel)), (Comparator)headCommitsComparator, (Set)branches);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            entry = entry2;
        }
        catch (CancellationException e$iv$iv) {
            throw e$iv$iv;
        }
        catch (Throwable e$iv$iv) {
            $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
            throw e$iv$iv;
        }
        finally {
            $this$useWithoutActiveScope$iv$iv.end();
        }
        return (PermanentGraph)entry;
    }

    private static final Hash buildPermanentGraph$lambda$1(VcsLogStorage $storage, Integer commitIndex) {
        Intrinsics.checkNotNull((Object)commitIndex);
        CommitId commitId = $storage.getCommitId(commitIndex);
        return commitId != null ? commitId.getHash() : null;
    }

    private static final Hash buildPermanentGraph$lambda$2(Function1 $tmp0, Object p0) {
        return (Hash)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VcsLogGraphDataFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

