/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ui.BranchPresentation;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Range;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UpdateScaleHelper;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.DetachedHeadRefGroup;
import com.intellij.vcs.log.ui.VcsBookmarkRef;
import com.intellij.vcs.log.ui.render.BookmarkIcon;
import com.intellij.vcs.log.ui.render.GraphCommitCellRenderer;
import com.intellij.vcs.log.ui.render.LabelIcon;
import com.intellij.vcs.log.ui.render.LabelIconCache;
import com.intellij.vcs.log.ui.render.TooltipReferencesPanel;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LabelPainter {
    private static final JBValue.JBValueGroup JBVG = new JBValue.JBValueGroup();
    public static final JBValue TOP_TEXT_PADDING = JBVG.value(1.0f);
    public static final JBValue BOTTOM_TEXT_PADDING = JBVG.value(2.0f);
    public static final JBValue RIGHT_PADDING = JBVG.value(4.0f);
    public static final JBValue LEFT_PADDING = JBVG.value(4.0f);
    public static final JBValue COMPACT_MIDDLE_PADDING = JBVG.value(6.0f);
    public static final JBValue MIDDLE_PADDING = JBVG.value(12.0f);
    public static final JBValue ICON_TEXT_PADDING = JBVG.value(1.0f);
    public static final JBValue ICON_ADDITIONAL_PADDING = JBVG.value(3.0f);
    public static final JBValue LABEL_ARC = JBVG.value(6.0f);
    private static final int MAX_LENGTH = 22;
    private static final String TWO_DOTS = "..";
    private static final String SEPARATOR = "/";
    @NotNull
    private final JComponent myComponent;
    @NotNull
    private final LabelIconCache myIconCache;
    @NotNull
    private final UpdateScaleHelper myUpdateScaleHelper;
    @NotNull
    private List<Presentation> myLabels;
    private int myHeight;
    private int myWidth;
    @NotNull
    protected Color myBackground;
    @Nullable
    private Color myGreyBackground;
    @NotNull
    private Color myForeground;
    private boolean myIsOpaque;
    private boolean myCompact;
    private boolean myLeftAligned;
    @Nullable
    private Range<Integer> myWarningRange;

    @ApiStatus.Internal
    public LabelPainter(@NotNull JComponent component, @NotNull LabelIconCache iconCache) {
        if (component == null) {
            LabelPainter.$$$reportNull$$$0(0);
        }
        if (iconCache == null) {
            LabelPainter.$$$reportNull$$$0(1);
        }
        this.myUpdateScaleHelper = new UpdateScaleHelper();
        this.myLabels = new ArrayList<Presentation>();
        this.myHeight = JBUIScale.scale((int)22);
        this.myWidth = 0;
        this.myBackground = UIUtil.getTableBackground();
        this.myGreyBackground = null;
        this.myForeground = UIUtil.getTableForeground();
        this.myIsOpaque = true;
        this.myComponent = component;
        this.myIconCache = iconCache;
    }

    public void updateHeight() {
        FontMetrics metrics = this.myComponent.getFontMetrics(LabelPainter.getReferenceFont());
        this.myHeight = metrics.getHeight() + TOP_TEXT_PADDING.get() + BOTTOM_TEXT_PADDING.get();
    }

    public void customizePainter(@NotNull Color background, @NotNull Color foreground, boolean isSelected, int availableWidth, @NotNull List<? extends RefGroup> refGroups) {
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(2);
        }
        if (foreground == null) {
            LabelPainter.$$$reportNull$$$0(3);
        }
        if (refGroups == null) {
            LabelPainter.$$$reportNull$$$0(4);
        }
        this.customizePainter(background, foreground, isSelected, availableWidth, refGroups, Collections.emptyList());
    }

    public void customizePainter(@NotNull Color background, @NotNull Color foreground, boolean isSelected, int availableWidth, @NotNull List<? extends RefGroup> refGroups, @NotNull List<VcsBookmarkRef> bookmarks) {
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(5);
        }
        if (foreground == null) {
            LabelPainter.$$$reportNull$$$0(6);
        }
        if (refGroups == null) {
            LabelPainter.$$$reportNull$$$0(7);
        }
        if (bookmarks == null) {
            LabelPainter.$$$reportNull$$$0(8);
        }
        this.myBackground = background;
        this.myForeground = foreground;
        this.updateHeight();
        FontMetrics metrics = this.myComponent.getFontMetrics(LabelPainter.getReferenceFont());
        this.myGreyBackground = ExperimentalUI.isNewUI() ? null : LabelPainter.calculateGreyBackground(refGroups, background, isSelected, this.myCompact);
        this.myWarningRange = null;
        Presentations presentation = this.calculatePresentation(refGroups, bookmarks, metrics, this.myGreyBackground != null ? this.myGreyBackground : this.myBackground, availableWidth, this.myCompact);
        this.myLabels = presentation.list;
        this.myWidth = presentation.width;
    }

    @NotNull
    private Presentations calculatePresentation(@NotNull List<? extends RefGroup> refGroups, @NotNull List<VcsBookmarkRef> bookmarks, @NotNull FontMetrics fontMetrics, @NotNull Color background, int availableWidth, boolean compact) {
        if (refGroups == null) {
            LabelPainter.$$$reportNull$$$0(9);
        }
        if (bookmarks == null) {
            LabelPainter.$$$reportNull$$$0(10);
        }
        if (fontMetrics == null) {
            LabelPainter.$$$reportNull$$$0(11);
        }
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(12);
        }
        if (refGroups.isEmpty() && bookmarks.isEmpty()) {
            return new Presentations(Collections.emptyList(), 0);
        }
        int height = fontMetrics.getHeight();
        int sidePaddingsWidth = LEFT_PADDING.get() + RIGHT_PADDING.get();
        int middlePadding = compact ? COMPACT_MIDDLE_PADDING.get() : MIDDLE_PADDING.get();
        List<Presentation> bookmarkLabels = this.processBookmarkLabels(bookmarks, background, height);
        if (refGroups.isEmpty()) {
            int width = LabelPainter.getPresentationsWidth(bookmarkLabels, middlePadding);
            return new Presentations(bookmarkLabels, width > 0 ? width + sidePaddingsWidth : 0);
        }
        Presentation detachedHeadLabel = LabelPainter.processDetachedHead(refGroups, fontMetrics);
        int detachedHeadWidth = detachedHeadLabel != null ? detachedHeadLabel.width + middlePadding : 0;
        int remainingWidth = availableWidth - LabelPainter.getCurrentWidth(bookmarkLabels, middlePadding) - detachedHeadWidth - sidePaddingsWidth;
        List<Presentation> referenceLabels = this.processReferenceLabels(refGroups, fontMetrics, remainingWidth, background, height, compact);
        List<Presentation> result = this.getPresentations(bookmarkLabels, referenceLabels, detachedHeadLabel, middlePadding);
        int width = LabelPainter.getPresentationsWidth(result, middlePadding);
        return new Presentations(result, width > 0 ? width + sidePaddingsWidth : 0);
    }

    @NotNull
    private List<Presentation> getPresentations(@NotNull List<Presentation> bookmarkLabels, @NotNull List<Presentation> referenceLabels, @Nullable Presentation detachedHeadLabel, int middlePadding) {
        if (bookmarkLabels == null) {
            LabelPainter.$$$reportNull$$$0(13);
        }
        if (referenceLabels == null) {
            LabelPainter.$$$reportNull$$$0(14);
        }
        if (bookmarkLabels.isEmpty() && detachedHeadLabel == null) {
            List<Presentation> list = referenceLabels;
            if (list == null) {
                LabelPainter.$$$reportNull$$$0(15);
            }
            return list;
        }
        int detachedHeadCount = detachedHeadLabel != null ? 1 : 0;
        ArrayList<Presentation> result = new ArrayList<Presentation>(bookmarkLabels.size() + referenceLabels.size() + detachedHeadCount);
        if (this.isLeftAligned()) {
            result.addAll(bookmarkLabels);
        }
        if (detachedHeadLabel != null) {
            this.myWarningRange = LabelPainter.getSectionRange(result, middlePadding, detachedHeadLabel);
            result.add(detachedHeadLabel);
        }
        result.addAll(referenceLabels);
        if (!this.isLeftAligned()) {
            result.addAll(bookmarkLabels);
        }
        ArrayList<Presentation> arrayList = result;
        if (arrayList == null) {
            LabelPainter.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    private static Range<Integer> getSectionRange(List<Presentation> addedLabels, int middlePadding, Presentation section) {
        int currentWidth = LabelPainter.getCurrentWidth(addedLabels, middlePadding) + LEFT_PADDING.get();
        return new Range((Comparable)Integer.valueOf(currentWidth), (Comparable)Integer.valueOf(currentWidth + section.width));
    }

    private static int getCurrentWidth(@NotNull List<Presentation> result, int middlePadding) {
        int presentationsWidth;
        if (result == null) {
            LabelPainter.$$$reportNull$$$0(17);
        }
        return presentationsWidth + ((presentationsWidth = LabelPainter.getPresentationsWidth(result, middlePadding)) > 0 ? middlePadding : 0);
    }

    private static int getPresentationsWidth(@NotNull List<Presentation> presentations, int middlePadding) {
        if (presentations == null) {
            LabelPainter.$$$reportNull$$$0(18);
        }
        if (presentations.isEmpty()) {
            return 0;
        }
        return presentations.stream().mapToInt(Presentation::width).sum() + middlePadding * (presentations.size() - 1);
    }

    @Nullable
    private static Presentation processDetachedHead(@NotNull List<? extends RefGroup> refGroups, @NotNull FontMetrics fontMetrics) {
        if (refGroups == null) {
            LabelPainter.$$$reportNull$$$0(19);
        }
        if (fontMetrics == null) {
            LabelPainter.$$$reportNull$$$0(20);
        }
        if (refGroups.isEmpty()) {
            return null;
        }
        RefGroup firstRef = refGroups.getFirst();
        if (firstRef instanceof DetachedHeadRefGroup) {
            return LabelPainter.getIconTextPresentation(fontMetrics, firstRef.getName(), AllIcons.General.Warning, JBUI.CurrentTheme.Label.warningForeground(), ICON_ADDITIONAL_PADDING.get());
        }
        return null;
    }

    @NotNull
    private List<Presentation> processBookmarkLabels(@NotNull List<VcsBookmarkRef> bookmarks, @NotNull Color background, int height) {
        if (bookmarks == null) {
            LabelPainter.$$$reportNull$$$0(21);
        }
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(22);
        }
        List<Presentation> list = bookmarks.stream().map(it -> new BookmarkIcon(this.myComponent, height, background, (VcsBookmarkRef)it)).map(icon -> new Presentation("", (Icon)icon, icon.getIconWidth(), 0, null)).toList();
        if (list == null) {
            LabelPainter.$$$reportNull$$$0(23);
        }
        return list;
    }

    @NotNull
    private List<Presentation> processReferenceLabels(@NotNull List<? extends RefGroup> refGroups, @NotNull FontMetrics fontMetrics, int availableWidth, @NotNull Color background, int height, boolean compact) {
        if (refGroups == null) {
            LabelPainter.$$$reportNull$$$0(24);
        }
        if (fontMetrics == null) {
            LabelPainter.$$$reportNull$$$0(25);
        }
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(26);
        }
        ArrayList<Presentation> labels = new ArrayList<Presentation>();
        int referencesWidth = 0;
        int middlePadding = compact ? COMPACT_MIDDLE_PADDING.get() : MIDDLE_PADDING.get();
        for (int i = 0; i < refGroups.size(); ++i) {
            RefGroup group = refGroups.get(i);
            if (group instanceof DetachedHeadRefGroup) continue;
            int doNotFitWidth = 0;
            if (!compact && i < refGroups.size() - 1) {
                LabelIcon lastIcon = this.getIcon(height, background, LabelPainter.getColors(refGroups.subList(i + 1, refGroups.size())));
                doNotFitWidth = lastIcon.getIconWidth();
            }
            List colors = group.getColors();
            LabelIcon labelIcon = this.getIcon(height, background, colors);
            boolean isLast = i == refGroups.size() - 1;
            int newWidth = referencesWidth + labelIcon.getIconWidth() + (isLast ? 0 : middlePadding);
            String text = LabelPainter.getGroupText(group, fontMetrics, availableWidth - newWidth - doNotFitWidth);
            if (!compact && availableWidth - (newWidth += LabelPainter.getTextWidth(fontMetrics, text)) - doNotFitWidth < 0) {
                LabelIcon lastIcon = this.getIcon(height, background, LabelPainter.getColors(refGroups.subList(i, refGroups.size())));
                String name = labels.isEmpty() ? text : "";
                labels.add(LabelPainter.getIconTextPresentation(fontMetrics, name, lastIcon));
                break;
            }
            labels.add(LabelPainter.getIconTextPresentation(fontMetrics, text, labelIcon));
            referencesWidth = newWidth;
        }
        ArrayList<Presentation> arrayList = labels;
        if (arrayList == null) {
            LabelPainter.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    @NotNull
    private static Presentation getIconTextPresentation(@NotNull FontMetrics fontMetrics, @NotNull String text, @NotNull Icon icon) {
        if (fontMetrics == null) {
            LabelPainter.$$$reportNull$$$0(28);
        }
        if (text == null) {
            LabelPainter.$$$reportNull$$$0(29);
        }
        if (icon == null) {
            LabelPainter.$$$reportNull$$$0(30);
        }
        return LabelPainter.getIconTextPresentation(fontMetrics, text, icon, null, 0);
    }

    @NotNull
    private static Presentation getIconTextPresentation(@NotNull FontMetrics fontMetrics, @NotNull String text, @NotNull Icon icon, @Nullable Color color, int iconPadding) {
        if (fontMetrics == null) {
            LabelPainter.$$$reportNull$$$0(31);
        }
        if (text == null) {
            LabelPainter.$$$reportNull$$$0(32);
        }
        if (icon == null) {
            LabelPainter.$$$reportNull$$$0(33);
        }
        int iconTextWidth = icon.getIconWidth() + iconPadding + LabelPainter.getTextWidth(fontMetrics, text);
        return new Presentation(text, icon, iconTextWidth, iconPadding, color);
    }

    private static int getTextWidth(@NotNull FontMetrics fontMetrics, @NotNull String name) {
        int textWidth;
        if (fontMetrics == null) {
            LabelPainter.$$$reportNull$$$0(34);
        }
        if (name == null) {
            LabelPainter.$$$reportNull$$$0(35);
        }
        return (textWidth = fontMetrics.stringWidth(name)) > 0 ? LabelPainter.getIconTextPadding() + textWidth : 0;
    }

    @NotNull
    private LabelIcon getIcon(int height, @NotNull Color background, @NotNull List<? extends Color> colors) {
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(36);
        }
        if (colors == null) {
            LabelPainter.$$$reportNull$$$0(37);
        }
        LabelIcon labelIcon = this.myIconCache.getIcon(this.myComponent, height, background, colors);
        if (labelIcon == null) {
            LabelPainter.$$$reportNull$$$0(38);
        }
        return labelIcon;
    }

    @NotNull
    private static List<Color> getColors(@NotNull Collection<? extends RefGroup> groups) {
        if (groups == null) {
            LabelPainter.$$$reportNull$$$0(39);
        }
        LinkedHashMap<Color, Integer> usedColors = new LinkedHashMap<Color, Integer>();
        for (RefGroup refGroup : groups) {
            List colors = refGroup.getColors();
            for (Color color : colors) {
                Integer count = (Integer)usedColors.get(color);
                if (count == null) {
                    count = 0;
                }
                usedColors.put(color, count + 1);
            }
        }
        ArrayList<Color> result = new ArrayList<Color>();
        for (Map.Entry entry : usedColors.entrySet()) {
            result.add((Color)entry.getKey());
            if ((Integer)entry.getValue() <= 1) continue;
            result.add((Color)entry.getKey());
        }
        ArrayList<Color> arrayList = result;
        if (arrayList == null) {
            LabelPainter.$$$reportNull$$$0(40);
        }
        return arrayList;
    }

    @NotNull
    private static String getGroupText(@NotNull RefGroup group, @NotNull FontMetrics fontMetrics, int availableWidth) {
        if (group == null) {
            LabelPainter.$$$reportNull$$$0(41);
        }
        if (fontMetrics == null) {
            LabelPainter.$$$reportNull$$$0(42);
        }
        return LabelPainter.shortenRefName(group.getName(), fontMetrics, availableWidth);
    }

    @Nullable
    private static Color calculateGreyBackground(@NotNull List<? extends RefGroup> refGroups, @NotNull Color background, boolean isSelected, boolean isCompact) {
        if (refGroups == null) {
            LabelPainter.$$$reportNull$$$0(43);
        }
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(44);
        }
        if (isSelected) {
            return null;
        }
        if (!isCompact) {
            return BranchPresentation.getBranchPresentationBackground((Color)background);
        }
        for (RefGroup refGroup : refGroups) {
            if (refGroup.getName().isEmpty()) continue;
            return BranchPresentation.getBranchPresentationBackground((Color)background);
        }
        return null;
    }

    @NotNull
    private static String shortenRefName(@NotNull @NlsSafe String refName, @NotNull FontMetrics fontMetrics, int availableWidth) {
        if (refName == null) {
            LabelPainter.$$$reportNull$$$0(45);
        }
        if (fontMetrics == null) {
            LabelPainter.$$$reportNull$$$0(46);
        }
        if (fontMetrics.stringWidth((String)refName) > availableWidth && ((String)refName).length() > 22) {
            int separatorIndex = ((String)refName).indexOf(SEPARATOR);
            if (separatorIndex > TWO_DOTS.length()) {
                refName = TWO_DOTS + ((String)refName).substring(separatorIndex);
            }
            if (availableWidth > 0) {
                String string = VcsLogUiUtil.shortenTextToFit((String)refName, fontMetrics, availableWidth, 22, "\u2026");
                if (string == null) {
                    LabelPainter.$$$reportNull$$$0(47);
                }
                return string;
            }
            String string = StringUtil.shortenTextWithEllipsis((String)refName, (int)22, (int)0, (String)"\u2026");
            if (string == null) {
                LabelPainter.$$$reportNull$$$0(48);
            }
            return string;
        }
        String string = refName;
        if (string == null) {
            LabelPainter.$$$reportNull$$$0(49);
        }
        return string;
    }

    public void paint(@NotNull Graphics2D g2, int x, int y, int height) {
        if (g2 == null) {
            LabelPainter.$$$reportNull$$$0(50);
        }
        if (this.myLabels.isEmpty()) {
            return;
        }
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g2).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, this.getFractionalMetricsValue()).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.getTextAntiAliasingValue());
        g2.setFont(LabelPainter.getReferenceFont());
        g2.setStroke(new BasicStroke(1.5f));
        FontMetrics fontMetrics = g2.getFontMetrics();
        int baseLine = SimpleColoredComponent.getTextBaseLine((FontMetrics)fontMetrics, (int)height);
        if (this.myIsOpaque) {
            g2.setColor(this.myBackground);
            g2.fillRect(x, y, this.myWidth, height);
        }
        if (this.myGreyBackground != null && this.myCompact) {
            g2.setColor(this.myGreyBackground);
            g2.fillRect(x, y + baseLine - fontMetrics.getAscent() - TOP_TEXT_PADDING.get(), this.myWidth, fontMetrics.getHeight() + TOP_TEXT_PADDING.get() + BOTTOM_TEXT_PADDING.get());
        }
        x += LEFT_PADDING.get();
        for (Presentation label : this.myLabels) {
            Icon icon = label.icon;
            String text = label.text;
            if (this.myGreyBackground != null && !this.myCompact) {
                g2.setColor(this.myGreyBackground);
                g2.fill(new RoundRectangle2D.Double(x - MIDDLE_PADDING.get() / 3, y + baseLine - fontMetrics.getAscent() - TOP_TEXT_PADDING.get(), icon.getIconWidth() + fontMetrics.stringWidth(text) + 2 * MIDDLE_PADDING.get() / 3, fontMetrics.getHeight() + TOP_TEXT_PADDING.get() + BOTTOM_TEXT_PADDING.get(), LABEL_ARC.get(), LABEL_ARC.get()));
            }
            icon.paintIcon(null, g2, x, y + (height - icon.getIconHeight()) / 2);
            x += icon.getIconWidth();
            x += LabelPainter.getIconTextPadding();
            g2.setColor(label.textColor != null ? label.textColor : this.myForeground);
            g2.drawString(text, x += label.iconPadding, y + baseLine);
            x += fontMetrics.stringWidth(text) + (this.myCompact ? COMPACT_MIDDLE_PADDING.get() : MIDDLE_PADDING.get());
        }
        config.restore();
    }

    private static int getIconTextPadding() {
        return ExperimentalUI.isNewUI() ? ICON_TEXT_PADDING.get() : 0;
    }

    private Object getTextAntiAliasingValue() {
        return Objects.requireNonNullElse(this.myComponent.getClientProperty(RenderingHints.KEY_TEXT_ANTIALIASING), AntialiasingType.getKeyForCurrentScope((boolean)false));
    }

    private Object getFractionalMetricsValue() {
        return Objects.requireNonNullElse(this.myComponent.getClientProperty(RenderingHints.KEY_FRACTIONALMETRICS), UISettings.Companion.getPreferredFractionalMetricsValue());
    }

    public Dimension getSize() {
        if (this.myLabels.isEmpty()) {
            return new Dimension();
        }
        this.myUpdateScaleHelper.saveScaleAndRunIfChanged(this::updateHeight);
        return new Dimension(this.myWidth, this.myHeight);
    }

    public boolean isLeftAligned() {
        return this.myLeftAligned;
    }

    public static Font getReferenceFont() {
        Font font = GraphCommitCellRenderer.getLabelFont();
        return font.deriveFont((float)font.getSize() - 1.0f);
    }

    public boolean isCompact() {
        return this.myCompact;
    }

    public void setCompact(boolean compact) {
        this.myCompact = compact;
    }

    public void setLeftAligned(boolean leftAligned) {
        this.myLeftAligned = leftAligned;
    }

    public void setOpaque(boolean isOpaque) {
        this.myIsOpaque = isOpaque;
    }

    public void clear() {
        this.myLabels.clear();
    }

    public JComponent createTooltip(VcsLogData logData, Collection<VcsRef> refs, Collection<VcsBookmarkRef> bookmarks, double x) {
        if (this.myWarningRange != null && x >= (double)((Integer)this.myWarningRange.getFrom()).intValue() && x < (double)((Integer)this.myWarningRange.getTo()).intValue()) {
            JBLabel label = new JBLabel(String.format("<html><body><div style='width: %s;'>%s</div></body></html>", JBUI.scale((int)250), VcsLogBundle.message("vcs.log.references.detached.head.tooltip", new Object[0])));
            label.setForeground(UIUtil.getToolTipForeground());
            label.setFont(UIUtil.getToolTipFont());
            return label;
        }
        return new TooltipReferencesPanel(logData, refs, bookmarks);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 16, 23, 27, 38, 40, 47, 48, 49 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconCache";
                break;
            }
            case 2: 
            case 5: 
            case 12: 
            case 22: 
            case 26: 
            case 36: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "background";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foreground";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 19: 
            case 24: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refGroups";
                break;
            }
            case 8: 
            case 10: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bookmarks";
                break;
            }
            case 11: 
            case 20: 
            case 25: 
            case 28: 
            case 31: 
            case 34: 
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontMetrics";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bookmarkLabels";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceLabels";
                break;
            }
            case 15: 
            case 16: 
            case 23: 
            case 27: 
            case 38: 
            case 40: 
            case 47: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/render/LabelPainter";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentations";
                break;
            }
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colors";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refName";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/render/LabelPainter";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentations";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "processBookmarkLabels";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "processReferenceLabels";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getColors";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenRefName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "customizePainter";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "calculatePresentation";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPresentations";
                break;
            }
            case 15: 
            case 16: 
            case 23: 
            case 27: 
            case 38: 
            case 40: 
            case 47: 
            case 48: 
            case 49: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentWidth";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPresentationsWidth";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processDetachedHead";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processBookmarkLabels";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processReferenceLabels";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getIconTextPresentation";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getTextWidth";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getColors";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getGroupText";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "calculateGreyBackground";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "shortenRefName";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 16, 23, 27, 38, 40, 47, 48, 49 -> new IllegalStateException(string);
        };
    }

    private record Presentations(@NotNull List<Presentation> list, int width) {
        @NotNull
        private final List<Presentation> list;

        private Presentations(@NotNull List<Presentation> list, int width) {
            if (list == null) {
                Presentations.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public List<Presentation> list() {
            List<Presentation> list = this.list;
            if (list == null) {
                Presentations.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/render/LabelPainter$Presentations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/render/LabelPainter$Presentations";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "list";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private record Presentation(@NotNull String text, @NotNull Icon icon, int width, int iconPadding, @Nullable Color textColor) {
        @NotNull
        private final String text;
        @NotNull
        private final Icon icon;

        private Presentation(@NotNull String text, @NotNull Icon icon, int width, int iconPadding, @Nullable Color textColor) {
            if (text == null) {
                Presentation.$$$reportNull$$$0(0);
            }
            if (icon == null) {
                Presentation.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public String text() {
            String string = this.text;
            if (string == null) {
                Presentation.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public Icon icon() {
            Icon icon = this.icon;
            if (icon == null) {
                Presentation.$$$reportNull$$$0(3);
            }
            return icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/render/LabelPainter$Presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/render/LabelPainter$Presentation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "text";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "icon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

