/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.java.workspace.entities.ArchivePackagingElementEntity;
import com.intellij.java.workspace.entities.ArtifactEntity;
import com.intellij.java.workspace.entities.ArtifactId;
import com.intellij.java.workspace.entities.ArtifactKt;
import com.intellij.java.workspace.entities.ArtifactOutputPackagingElementEntity;
import com.intellij.java.workspace.entities.ArtifactPropertiesEntity;
import com.intellij.java.workspace.entities.ArtifactRootElementEntity;
import com.intellij.java.workspace.entities.ArtifactsOrderEntity;
import com.intellij.java.workspace.entities.CompositePackagingElementEntity;
import com.intellij.java.workspace.entities.CustomPackagingElementEntity;
import com.intellij.java.workspace.entities.DirectoryCopyPackagingElementEntity;
import com.intellij.java.workspace.entities.DirectoryPackagingElementEntity;
import com.intellij.java.workspace.entities.ExtractedDirectoryPackagingElementEntity;
import com.intellij.java.workspace.entities.FileCopyPackagingElementEntity;
import com.intellij.java.workspace.entities.LibraryFilesPackagingElementEntity;
import com.intellij.java.workspace.entities.ModuleOutputPackagingElementEntity;
import com.intellij.java.workspace.entities.ModuleSourcePackagingElementEntity;
import com.intellij.java.workspace.entities.ModuleTestOutputPackagingElementEntity;
import com.intellij.java.workspace.entities.PackagingElementEntity;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.diagnostic.telemetry.helpers.MillisecondsMeasurer;
import com.intellij.platform.workspace.jps.JpsFileEntitySource;
import com.intellij.platform.workspace.jps.JpsImportedEntitySource;
import com.intellij.platform.workspace.jps.JpsMetrics;
import com.intellij.platform.workspace.jps.entities.LibraryId;
import com.intellij.platform.workspace.jps.entities.LibraryTableId;
import com.intellij.platform.workspace.jps.entities.ModuleId;
import com.intellij.platform.workspace.jps.serialization.impl.ErrorReporter;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentReader;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentWriter;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileEntitiesSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.LibraryNameGenerator;
import com.intellij.platform.workspace.jps.serialization.impl.LoadingResult;
import com.intellij.platform.workspace.jps.serialization.impl.UtilsKt;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;
import org.jetbrains.jps.model.serialization.artifact.ArtifactPropertiesState;
import org.jetbrains.jps.model.serialization.artifact.ArtifactState;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0010\u0018\u0000 >2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001>B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJH\u0010\u0017\u001a*\u0012&\u0012$\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0014\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u001c0\u001b0\u00190\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\t\u001a\u00020\nH\u0016JB\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2(\u0010&\u001a$\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0014\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u001c0\u001b0\u0019H\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0014J \u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020-0,2\u0006\u0010.\u001a\u00020*2\u0006\u0010/\u001a\u00020(H\u0002JH\u00100\u001a\u00020\"2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00020\u001b2 \u00102\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a030\u00192\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020*2\u0006\u00109\u001a\u00020\u0002H\u0002J\u0010\u0010:\u001a\u00020*2\u0006\u0010.\u001a\u00020-H\u0002J\b\u0010;\u001a\u00020<H\u0016J\f\u0010=\u001a\u00020<*\u00020<H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006?"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/JpsArtifactEntitiesSerializer;", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileEntitiesSerializer;", "Lcom/intellij/java/workspace/entities/ArtifactEntity;", "fileUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "internalEntitySource", "Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "preserveOrder", "", "virtualFileManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "<init>", "(Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;ZLcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;)V", "getFileUrl", "()Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "getInternalEntitySource", "()Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "isExternalStorage", "()Z", "mainEntityClass", "Ljava/lang/Class;", "getMainEntityClass", "()Ljava/lang/Class;", "loadEntities", "Lcom/intellij/platform/workspace/jps/serialization/impl/LoadingResult;", "", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity$Builder;", "reader", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentReader;", "errorReporter", "Lcom/intellij/platform/workspace/jps/serialization/impl/ErrorReporter;", "checkAndAddToBuilder", "", "builder", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "orphanage", "newEntities", "createEntitySource", "Lcom/intellij/platform/workspace/storage/EntitySource;", "artifactTag", "Lorg/jdom/Element;", "loadPackagingElement", "Lcom/intellij/java/workspace/entities/PackagingElementEntity$Builder;", "Lcom/intellij/java/workspace/entities/PackagingElementEntity;", "element", "source", "saveEntities", "mainEntities", "entities", "", "storage", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "writer", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentWriter;", "saveArtifact", "artifact", "savePackagingElement", "toString", "", "toPathWithScheme", "Companion", "intellij.platform.workspace.jps"})
@SourceDebugExtension(value={"SMAP\nJpsArtifactEntitiesSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpsArtifactEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/JpsArtifactEntitiesSerializer\n+ 2 MillisecondsMeasurer.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer\n+ 3 Timing.kt\nkotlin/system/TimingKt\n+ 4 LoadingResult.kt\ncom/intellij/platform/workspace/jps/serialization/impl/LoadingResultKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 8 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,438:1\n44#2,2:439\n46#2:497\n44#2,2:502\n46#2:522\n29#3,2:441\n31#3:496\n29#3,2:504\n31#3:521\n24#4,8:443\n24#4,8:452\n24#4,8:470\n1#5:451\n1#5:478\n1#5:491\n1#5:528\n1617#6,9:460\n1869#6:469\n1870#6:479\n1626#6:480\n1617#6,9:481\n1869#6:490\n1870#6:492\n1626#6:493\n295#6,2:494\n1869#6,2:499\n1516#6,3:506\n1519#6,3:516\n1869#6,2:519\n774#6:523\n865#6,2:524\n1625#6:526\n1869#6:527\n1870#6:529\n1626#6:530\n1869#6,2:531\n1634#6,3:533\n1869#6,2:536\n216#7:498\n217#7:501\n382#8,7:509\n*S KotlinDebug\n*F\n+ 1 JpsArtifactEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/JpsArtifactEntitiesSerializer\n*L\n157#1:439,2\n157#1:497\n294#1:502,2\n294#1:522\n157#1:441,2\n157#1:496\n294#1:504,2\n294#1:521\n158#1:443,8\n164#1:452,8\n168#1:470,8\n167#1:478\n196#1:491\n313#1:528\n167#1:460,9\n167#1:469\n167#1:479\n167#1:480\n196#1:481,9\n196#1:490\n196#1:492\n196#1:493\n198#1:494,2\n221#1:499,2\n299#1:506,3\n299#1:516,3\n300#1:519,2\n312#1:523\n312#1:524,2\n313#1:526\n313#1:527\n313#1:529\n313#1:530\n404#1:531,2\n232#1:533,3\n339#1:536,2\n218#1:498\n218#1:501\n299#1:509,7\n*E\n"})
public class JpsArtifactEntitiesSerializer
implements JpsFileEntitiesSerializer<ArtifactEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VirtualFileUrl fileUrl;
    @NotNull
    private final JpsFileEntitySource internalEntitySource;
    private final boolean preserveOrder;
    @NotNull
    private final VirtualFileUrlManager virtualFileManager;
    @NotNull
    private static final AtomicLong loadEntitiesTimeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
    @NotNull
    private static final AtomicLong saveEntitiesTimeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);

    public JpsArtifactEntitiesSerializer(@NotNull VirtualFileUrl fileUrl, @NotNull JpsFileEntitySource internalEntitySource, boolean preserveOrder, @NotNull VirtualFileUrlManager virtualFileManager) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)internalEntitySource, (String)"internalEntitySource");
        Intrinsics.checkNotNullParameter((Object)virtualFileManager, (String)"virtualFileManager");
        this.fileUrl = fileUrl;
        this.internalEntitySource = internalEntitySource;
        this.preserveOrder = preserveOrder;
        this.virtualFileManager = virtualFileManager;
    }

    @Override
    @NotNull
    public VirtualFileUrl getFileUrl() {
        return this.fileUrl;
    }

    @Override
    @NotNull
    public JpsFileEntitySource getInternalEntitySource() {
        return this.internalEntitySource;
    }

    public boolean isExternalStorage() {
        return false;
    }

    @Override
    @NotNull
    public Class<ArtifactEntity> getMainEntityClass() {
        return ArtifactEntity.class;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LoadingResult<Map<Class<? extends WorkspaceEntity>, Collection<WorkspaceEntity.Builder<? extends WorkspaceEntity>>>> loadEntities(@NotNull JpsFileContentReader reader, @NotNull ErrorReporter errorReporter, @NotNull VirtualFileUrlManager virtualFileManager) {
        LoadingResult<Pair[]> loadingResult;
        Object object;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        Intrinsics.checkNotNullParameter((Object)virtualFileManager, (String)"virtualFileManager");
        AtomicLong atomicLong = loadEntitiesTimeMs;
        boolean bl = false;
        LoadingResult<Pair[]> value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong2 = atomicLong;
        boolean bl2 = false;
        boolean bl3 = false;
        Object $this$runCatchingXmlIssues$iv = this;
        boolean $i$f$runCatchingXmlIssues = false;
        try {
            boolean bl4 = false;
            String string = this.getFileUrl().getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            object = Result.constructor-impl((Object)JpsFileContentReader.loadComponent$default(reader, string, "ArtifactManager", null, 4, null));
        }
        catch (JDOMException e$iv) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv));
        }
        catch (IOException e$iv) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv));
        }
        $this$runCatchingXmlIssues$iv = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)$this$runCatchingXmlIssues$iv);
        if (throwable != null) {
            Throwable it = $i$f$runCatchingXmlIssues = throwable;
            boolean bl5 = false;
            loadingResult = new LoadingResult<Pair[]>((Pair[])MapsKt.emptyMap(), it);
        } else {
            ResultKt.throwOnFailure((Object)$this$runCatchingXmlIssues$iv);
            Element artifactListElement = (Element)$this$runCatchingXmlIssues$iv;
            if (artifactListElement == null) {
                loadingResult = new LoadingResult<Pair[]>((Pair[])MapsKt.emptyMap(), null);
            } else {
                Object object2;
                ArrayList orderOfItems = new ArrayList();
                Object $this$runCatchingXmlIssues$iv2 = this;
                boolean $i$f$runCatchingXmlIssues22 = false;
                try {
                    boolean bl6 = false;
                    object2 = Result.constructor-impl((Object)artifactListElement.getChildren("artifact"));
                }
                catch (JDOMException e$iv) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv));
                }
                catch (IOException e$iv) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv));
                }
                $this$runCatchingXmlIssues$iv2 = object2;
                Throwable throwable2 = Result.exceptionOrNull-impl((Object)$this$runCatchingXmlIssues$iv2);
                if (throwable2 != null) {
                    Throwable it = $i$f$runCatchingXmlIssues22 = throwable2;
                    boolean bl7 = false;
                    loadingResult = new LoadingResult<Pair[]>((Pair[])MapsKt.emptyMap(), it);
                } else {
                    Object v12;
                    Object object3;
                    block23: {
                        void $this$firstOrNull$iv;
                        void $this$mapNotNullTo$iv$iv;
                        Iterable $this$mapNotNull$iv;
                        void $this$mapNotNullTo$iv$iv2;
                        void $this$mapNotNull$iv2;
                        ResultKt.throwOnFailure((Object)$this$runCatchingXmlIssues$iv2);
                        Object object4 = $this$runCatchingXmlIssues$iv2;
                        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"getOrThrow(...)");
                        Iterable it = (Iterable)object4;
                        boolean $i$f$mapNotNull22 = false;
                        void $i$f$runCatchingXmlIssues22 = $this$mapNotNull$iv2;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                        boolean $i$f$forEach = false;
                        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            Result result;
                            block22: {
                                Object object5;
                                Object element$iv$iv$iv;
                                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                                boolean bl8 = false;
                                Element artifactElement = (Element)element$iv$iv;
                                boolean bl9 = false;
                                JpsFileEntitiesSerializer $this$runCatchingXmlIssues$iv3 = this;
                                boolean $i$f$runCatchingXmlIssues3 = false;
                                try {
                                    EntitySource entitySource;
                                    VirtualFileUrl virtualFileUrl;
                                    boolean bl10 = false;
                                    Intrinsics.checkNotNull((Object)artifactElement);
                                    if (this.createEntitySource(artifactElement) == null) {
                                        result = null;
                                        break block22;
                                    }
                                    Object object6 = XmlSerializer.deserialize((Element)artifactElement, ArtifactState.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"deserialize(...)");
                                    ArtifactState state = (ArtifactState)object6;
                                    if (state.getOutputPath() != null) {
                                        String path;
                                        boolean bl11 = false;
                                        virtualFileUrl = ((CharSequence)path).length() > 0 ? virtualFileManager.getOrCreateFromUrl(this.toPathWithScheme(path)) : null;
                                    } else {
                                        virtualFileUrl = null;
                                    }
                                    VirtualFileUrl outputUrl = virtualFileUrl;
                                    Element element = state.getRootElement();
                                    Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getRootElement(...)");
                                    PackagingElementEntity.Builder<? extends PackagingElementEntity> rootElement = this.loadPackagingElement(element, entitySource);
                                    String string = state.getName();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                                    String string2 = state.getArtifactType();
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getArtifactType(...)");
                                    ArtifactEntity.Builder artifactEntity = ArtifactEntity.Companion.create(string, string2, state.isBuildOnMake(), entitySource, (Function1<? super ArtifactEntity.Builder, Unit>)((Function1)arg_0 -> JpsArtifactEntitiesSerializer.loadEntities$lambda$0$4$0$1(outputUrl, rootElement, arg_0)));
                                    for (ArtifactPropertiesState propertiesState : state.getPropertiesList()) {
                                        String string3 = propertiesState.getId();
                                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getId(...)");
                                        ArtifactPropertiesEntity.Companion.create(string3, entitySource, (Function1<? super ArtifactPropertiesEntity.Builder, Unit>)((Function1)arg_0 -> JpsArtifactEntitiesSerializer.loadEntities$lambda$0$4$0$2(artifactEntity, propertiesState, arg_0)));
                                    }
                                    ((Collection)orderOfItems).add(state.getName());
                                    object5 = Result.constructor-impl((Object)artifactEntity);
                                }
                                catch (JDOMException e$iv) {
                                    object5 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv));
                                }
                                catch (IOException e$iv) {
                                    object5 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv));
                                }
                                result = Result.box-impl((Object)object5);
                            }
                            if (result == null) continue;
                            Result it$iv$iv = result;
                            boolean bl12 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        List artifactEntities = (List)destination$iv$iv;
                        Pair[] pairArray = new Pair[2];
                        pairArray[0] = TuplesKt.to(ArtifactsOrderEntity.class, (Object)CollectionsKt.listOf((Object)ArtifactsOrderEntity.Companion.create$default(ArtifactsOrderEntity.Companion, orderOfItems, this.getInternalEntitySource(), null, 4, null)));
                        Iterable $i$f$mapNotNull22 = artifactEntities;
                        Class<ArtifactEntity> clazz = ArtifactEntity.class;
                        int n = 1;
                        object3 = pairArray;
                        boolean $i$f$mapNotNull = false;
                        destination$iv$iv = $this$mapNotNull$iv;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$mapNotNullTo2 = false;
                        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach2 = false;
                        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
                        while (iterator2.hasNext()) {
                            ArtifactEntity.Builder it$iv$iv;
                            Object element$iv$iv$iv;
                            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                            boolean bl13 = false;
                            Object it2 = ((Result)element$iv$iv).unbox-impl();
                            boolean bl14 = false;
                            if ((ArtifactEntity.Builder)(Result.isFailure-impl((Object)it2) ? null : it2) == null) continue;
                            boolean bl15 = false;
                            destination$iv$iv2.add(it$iv$iv);
                        }
                        List list = (List)destination$iv$iv2;
                        object3[n] = TuplesKt.to(clazz, (Object)list);
                        $this$mapNotNull$iv = artifactEntities;
                        object3 = MapsKt.mapOf((Pair[])pairArray);
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            Object it3 = ((Result)element$iv).unbox-impl();
                            boolean bl16 = false;
                            if (!Result.isFailure-impl((Object)it3)) continue;
                            v12 = element$iv;
                            break block23;
                        }
                        v12 = null;
                    }
                    Result result = v12;
                    Throwable throwable3 = result != null ? Result.exceptionOrNull-impl((Object)result.unbox-impl()) : null;
                    Object object7 = object3;
                    loadingResult = new LoadingResult<Pair[]>((Pair[])object7, throwable3);
                }
            }
        }
        value$iv = loadingResult;
        atomicLong2.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return value$iv;
    }

    @Override
    public void checkAndAddToBuilder(@NotNull MutableEntityStorage builder, @NotNull MutableEntityStorage orphanage, @NotNull Map<Class<? extends WorkspaceEntity>, ? extends Collection<? extends WorkspaceEntity.Builder<? extends WorkspaceEntity>>> newEntities) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)orphanage, (String)"orphanage");
        Intrinsics.checkNotNullParameter(newEntities, (String)"newEntities");
        if (this.preserveOrder) {
            ArtifactsOrderEntity.Builder order;
            Collection<? extends WorkspaceEntity.Builder<? extends WorkspaceEntity>> collection = newEntities.get(ArtifactsOrderEntity.class);
            WorkspaceEntity.Builder builder2 = collection != null ? (WorkspaceEntity.Builder)CollectionsKt.singleOrNull((Iterable)collection) : null;
            ArtifactsOrderEntity.Builder builder3 = order = builder2 instanceof ArtifactsOrderEntity.Builder ? (ArtifactsOrderEntity.Builder)builder2 : null;
            if (order != null) {
                ArtifactsOrderEntity entity = (ArtifactsOrderEntity)SequencesKt.firstOrNull((Sequence)builder.entities(ArtifactsOrderEntity.class));
                ArtifactsOrderEntity artifactsOrderEntity = entity != null ? ArtifactKt.modifyArtifactsOrderEntity(builder, entity, (Function1<? super ArtifactsOrderEntity.Builder, Unit>)((Function1)arg_0 -> JpsArtifactEntitiesSerializer.checkAndAddToBuilder$lambda$0(order, arg_0))) : (ArtifactsOrderEntity)builder.addEntity((WorkspaceEntity.Builder)order);
            }
        }
        Map<Class<? extends WorkspaceEntity>, ? extends Collection<? extends WorkspaceEntity.Builder<? extends WorkspaceEntity>>> $this$forEach$iv = newEntities;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Class<? extends WorkspaceEntity>, ? extends Collection<? extends WorkspaceEntity.Builder<? extends WorkspaceEntity>>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Class<? extends WorkspaceEntity>, ? extends Collection<? extends WorkspaceEntity.Builder<? extends WorkspaceEntity>>> element$iv;
            Map.Entry<Class<? extends WorkspaceEntity>, ? extends Collection<? extends WorkspaceEntity.Builder<? extends WorkspaceEntity>>> entry = element$iv = iterator.next();
            boolean bl = false;
            Class<? extends WorkspaceEntity> key = entry.getKey();
            Collection<? extends WorkspaceEntity.Builder<? extends WorkspaceEntity>> value = entry.getValue();
            if (Intrinsics.areEqual(key, ArtifactsOrderEntity.class)) continue;
            Iterable $this$forEach$iv2 = value;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                WorkspaceEntity.Builder it = (WorkspaceEntity.Builder)element$iv2;
                boolean bl2 = false;
                builder.addEntity(it);
            }
        }
    }

    @Nullable
    protected EntitySource createEntitySource(@NotNull Element artifactTag) {
        Intrinsics.checkNotNullParameter((Object)artifactTag, (String)"artifactTag");
        String externalSystemId = artifactTag.getAttributeValue("external-system-id");
        return externalSystemId == null ? (EntitySource)this.getInternalEntitySource() : (EntitySource)new JpsImportedEntitySource(this.getInternalEntitySource(), externalSystemId, false);
    }

    private final PackagingElementEntity.Builder<? extends PackagingElementEntity> loadPackagingElement(Element element, EntitySource source) {
        PackagingElementEntity.Builder builder;
        switch (JpsArtifactEntitiesSerializer.loadPackagingElement$getAttribute(element, "id")) {
            case "root": {
                builder = ArtifactRootElementEntity.Companion.create(source, (Function1<? super ArtifactRootElementEntity.Builder, Unit>)((Function1)arg_0 -> JpsArtifactEntitiesSerializer.loadPackagingElement$lambda$2(element, this, source, arg_0)));
                break;
            }
            case "directory": {
                builder = DirectoryPackagingElementEntity.Companion.create(JpsArtifactEntitiesSerializer.loadPackagingElement$getAttribute(element, "name"), source, (Function1<? super DirectoryPackagingElementEntity.Builder, Unit>)((Function1)arg_0 -> JpsArtifactEntitiesSerializer.loadPackagingElement$lambda$3(element, this, source, arg_0)));
                break;
            }
            case "archive": {
                builder = ArchivePackagingElementEntity.Companion.create(JpsArtifactEntitiesSerializer.loadPackagingElement$getAttribute(element, "name"), source, (Function1<? super ArchivePackagingElementEntity.Builder, Unit>)((Function1)arg_0 -> JpsArtifactEntitiesSerializer.loadPackagingElement$lambda$4(element, this, source, arg_0)));
                break;
            }
            case "dir-copy": {
                builder = DirectoryCopyPackagingElementEntity.Companion.create$default(DirectoryCopyPackagingElementEntity.Companion, JpsArtifactEntitiesSerializer.loadPackagingElement$getPathAttribute(element, this, "path"), source, null, 4, null);
                break;
            }
            case "file-copy": {
                builder = FileCopyPackagingElementEntity.Companion.create(JpsArtifactEntitiesSerializer.loadPackagingElement$getPathAttribute(element, this, "path"), source, (Function1<? super FileCopyPackagingElementEntity.Builder, Unit>)((Function1)arg_0 -> JpsArtifactEntitiesSerializer.loadPackagingElement$lambda$5(element, arg_0)));
                break;
            }
            case "extracted-dir": {
                builder = ExtractedDirectoryPackagingElementEntity.Companion.create$default(ExtractedDirectoryPackagingElementEntity.Companion, JpsArtifactEntitiesSerializer.loadPackagingElement$getPathAttribute(element, this, "path"), JpsArtifactEntitiesSerializer.loadPackagingElement$getAttribute(element, "path-in-jar"), source, null, 8, null);
                break;
            }
            case "artifact": {
                builder = ArtifactOutputPackagingElementEntity.Companion.create(source, (Function1<? super ArtifactOutputPackagingElementEntity.Builder, Unit>)((Function1)arg_0 -> JpsArtifactEntitiesSerializer.loadPackagingElement$lambda$6(element, arg_0)));
                break;
            }
            case "module-output": {
                builder = ModuleOutputPackagingElementEntity.Companion.create(source, (Function1<? super ModuleOutputPackagingElementEntity.Builder, Unit>)((Function1)arg_0 -> JpsArtifactEntitiesSerializer.loadPackagingElement$lambda$7(element, arg_0)));
                break;
            }
            case "module-test-output": {
                builder = ModuleTestOutputPackagingElementEntity.Companion.create(source, (Function1<? super ModuleTestOutputPackagingElementEntity.Builder, Unit>)((Function1)arg_0 -> JpsArtifactEntitiesSerializer.loadPackagingElement$lambda$8(element, arg_0)));
                break;
            }
            case "module-source": {
                builder = ModuleSourcePackagingElementEntity.Companion.create(source, (Function1<? super ModuleSourcePackagingElementEntity.Builder, Unit>)((Function1)arg_0 -> JpsArtifactEntitiesSerializer.loadPackagingElement$lambda$9(element, arg_0)));
                break;
            }
            case "library": {
                LibraryFilesPackagingElementEntity.Builder builder2;
                String level = JpsArtifactEntitiesSerializer.loadPackagingElement$getOptionalAttribute(element, "level");
                String name = JpsArtifactEntitiesSerializer.loadPackagingElement$getOptionalAttribute(element, "name");
                if (level != null && name != null) {
                    String moduleName = JpsArtifactEntitiesSerializer.loadPackagingElement$getOptionalAttribute(element, "module-name");
                    LibraryTableId parentId = moduleName != null ? (LibraryTableId)new LibraryTableId.ModuleLibraryTableId(new ModuleId(moduleName)) : LibraryNameGenerator.INSTANCE.getLibraryTableId(level);
                    builder2 = LibraryFilesPackagingElementEntity.Companion.create(source, (Function1<? super LibraryFilesPackagingElementEntity.Builder, Unit>)((Function1)arg_0 -> JpsArtifactEntitiesSerializer.loadPackagingElement$lambda$10(name, parentId, arg_0)));
                } else {
                    builder2 = LibraryFilesPackagingElementEntity.Companion.create$default(LibraryFilesPackagingElementEntity.Companion, source, null, 2, null);
                }
                builder = builder2;
                break;
            }
            default: {
                String typeId;
                Element element2 = element.clone();
                Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"clone(...)");
                Element cloned = element2;
                cloned.removeContent();
                String string = JDOMUtil.write((Element)cloned);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"write(...)");
                builder = CustomPackagingElementEntity.Companion.create(typeId, string, source, (Function1<? super CustomPackagingElementEntity.Builder, Unit>)((Function1)arg_0 -> JpsArtifactEntitiesSerializer.loadPackagingElement$lambda$11(element, this, source, arg_0)));
            }
        }
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveEntities(@NotNull Collection<? extends ArtifactEntity> mainEntities, @NotNull Map<Class<? extends WorkspaceEntity>, ? extends List<? extends WorkspaceEntity>> entities, @NotNull EntityStorage storage, @NotNull JpsFileContentWriter writer) {
        Intrinsics.checkNotNullParameter(mainEntities, (String)"mainEntities");
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        AtomicLong atomicLong = saveEntitiesTimeMs;
        boolean bl = false;
        Unit value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong2 = atomicLong;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!mainEntities.isEmpty()) {
            void destination$iv;
            void $this$groupByTo$iv;
            List<String> list;
            Iterable iterable;
            Element componentTag2 = JDomSerializationUtil.createComponentElement((String)"ArtifactManager");
            if (this.preserveOrder) {
                List<? extends WorkspaceEntity> list2 = entities.get(ArtifactsOrderEntity.class);
                iterable = list2 != null ? (WorkspaceEntity)CollectionsKt.firstOrNull(list2) : null;
                ArtifactsOrderEntity artifactsOrderEntity = iterable instanceof ArtifactsOrderEntity ? (ArtifactsOrderEntity)((Object)iterable) : null;
                list = artifactsOrderEntity != null ? artifactsOrderEntity.getOrderOfArtifacts() : null;
            } else {
                list = null;
            }
            List<String> orderOfItems = list;
            iterable = mainEntities;
            Map map = new HashMap();
            List<String> list3 = orderOfItems;
            boolean $i$f$groupByTo = false;
            for (Object element$iv : $this$groupByTo$iv) {
                Object object;
                void $this$getOrPut$iv$iv;
                ArtifactEntity it = (ArtifactEntity)element$iv;
                boolean bl4 = false;
                String key$iv = it.getName();
                void var25_27 = destination$iv;
                String key$iv$iv = key$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
                if (value$iv$iv == null) {
                    boolean bl5 = false;
                    List answer$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
                    object = answer$iv$iv;
                } else {
                    object = value$iv$iv;
                }
                List list$iv = (List)object;
                list$iv.add(element$iv);
            }
            ArrayList sorted = UtilsKt.sortByOrderEntity$default(list3, MapsKt.toMutableMap((Map)destination$iv), null, 4, null);
            Iterable $this$forEach$iv = sorted;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ArtifactEntity it = (ArtifactEntity)element$iv;
                boolean bl6 = false;
                componentTag2.addContent(this.saveArtifact(it));
            }
            String string = this.getFileUrl().getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            writer.saveComponent(string, "ArtifactManager", componentTag2);
        }
        value$iv = Unit.INSTANCE;
        atomicLong2.addAndGet(System.currentTimeMillis() - start$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final Element saveArtifact(ArtifactEntity artifact) {
        String externalSystemId;
        void destination$iv;
        void $this$mapNotNullTo$iv;
        void $this$filterTo$iv$iv;
        ArtifactState artifactState = new ArtifactState();
        artifactState.setName(artifact.getName());
        artifactState.setArtifactType(artifact.getArtifactType());
        artifactState.setBuildOnMake(artifact.getIncludeInProjectBuild());
        VirtualFileUrl virtualFileUrl = artifact.getOutputUrl();
        artifactState.setOutputPath(JpsPathUtil.urlToPath((String)(virtualFileUrl != null ? virtualFileUrl.getUrl() : null)));
        Iterable $this$filter$iv = artifact.getCustomProperties();
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ArtifactPropertiesEntity it = (ArtifactPropertiesEntity)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getEntitySource(), (Object)artifact.getEntitySource())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List customProperties = (List)destination$iv$iv;
        $this$filter$iv = customProperties;
        Collection $i$f$filter22 = new ArrayList();
        ArtifactState artifactState2 = artifactState;
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            ArtifactPropertiesState artifactPropertiesState;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            ArtifactPropertiesEntity it = (ArtifactPropertiesEntity)element$iv;
            boolean bl2 = false;
            if (it.getPropertiesXmlTag() == null) {
                artifactPropertiesState = null;
            } else {
                Element element;
                ArtifactPropertiesState artifactPropertiesState2;
                ArtifactPropertiesState $this$saveArtifact_u24lambda_u241_u240 = artifactPropertiesState2 = new ArtifactPropertiesState();
                boolean bl3 = false;
                $this$saveArtifact_u24lambda_u241_u240.setId(it.getProviderType());
                ArtifactPropertiesState artifactPropertiesState3 = $this$saveArtifact_u24lambda_u241_u240;
                if (it.getPropertiesXmlTag() != null) {
                    void it2;
                    ArtifactPropertiesState artifactPropertiesState4 = artifactPropertiesState3;
                    boolean bl4 = false;
                    element = JDOMUtil.load((CharSequence)((CharSequence)it2));
                    artifactPropertiesState3 = artifactPropertiesState4;
                } else {
                    element = null;
                }
                artifactPropertiesState3.setOptions(element);
                artifactPropertiesState = artifactPropertiesState2;
            }
            if (artifactPropertiesState == null) continue;
            ArtifactPropertiesState it$iv = artifactPropertiesState;
            boolean bl5 = false;
            destination$iv.add(it$iv);
        }
        artifactState2.setPropertiesList((List)destination$iv);
        CompositePackagingElementEntity compositePackagingElementEntity = artifact.getRootElement();
        Intrinsics.checkNotNull((Object)compositePackagingElementEntity);
        artifactState.setRootElement(this.savePackagingElement(compositePackagingElementEntity));
        EntitySource entitySource = artifact.getEntitySource();
        JpsImportedEntitySource jpsImportedEntitySource = entitySource instanceof JpsImportedEntitySource ? (JpsImportedEntitySource)entitySource : null;
        String string = externalSystemId = jpsImportedEntitySource != null ? jpsImportedEntitySource.getExternalSystemId() : null;
        if (externalSystemId != null) {
            if (this.isExternalStorage()) {
                artifactState.setExternalSystemId(externalSystemId);
            } else {
                artifactState.setExternalSystemIdInInternalStorage(externalSystemId);
            }
        }
        Element element = XmlSerializer.serialize((Object)artifactState, (SerializationFilter)((SerializationFilter)new SkipDefaultsSerializationFilter()));
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"serialize(...)");
        return element;
    }

    private final Element savePackagingElement(PackagingElementEntity element) {
        Element tag = new Element("element");
        PackagingElementEntity packagingElementEntity = element;
        if (packagingElementEntity instanceof ArtifactRootElementEntity) {
            JpsArtifactEntitiesSerializer.savePackagingElement$setId(tag, "root");
            JpsArtifactEntitiesSerializer.savePackagingElement$saveElementChildren(tag, this, (CompositePackagingElementEntity)element);
        } else if (packagingElementEntity instanceof DirectoryPackagingElementEntity) {
            JpsArtifactEntitiesSerializer.savePackagingElement$setId(tag, "directory");
            JpsArtifactEntitiesSerializer.savePackagingElement$setAttribute(tag, "name", ((DirectoryPackagingElementEntity)element).getDirectoryName());
            JpsArtifactEntitiesSerializer.savePackagingElement$saveElementChildren(tag, this, (CompositePackagingElementEntity)element);
        } else if (packagingElementEntity instanceof ArchivePackagingElementEntity) {
            JpsArtifactEntitiesSerializer.savePackagingElement$setId(tag, "archive");
            JpsArtifactEntitiesSerializer.savePackagingElement$setAttribute(tag, "name", ((ArchivePackagingElementEntity)element).getFileName());
            JpsArtifactEntitiesSerializer.savePackagingElement$saveElementChildren(tag, this, (CompositePackagingElementEntity)element);
        } else if (packagingElementEntity instanceof DirectoryCopyPackagingElementEntity) {
            JpsArtifactEntitiesSerializer.savePackagingElement$setId(tag, "dir-copy");
            JpsArtifactEntitiesSerializer.savePackagingElement$setPathAttribute(tag, "path", ((DirectoryCopyPackagingElementEntity)element).getFilePath());
        } else if (packagingElementEntity instanceof FileCopyPackagingElementEntity) {
            JpsArtifactEntitiesSerializer.savePackagingElement$setId(tag, "file-copy");
            JpsArtifactEntitiesSerializer.savePackagingElement$setPathAttribute(tag, "path", ((FileCopyPackagingElementEntity)element).getFilePath());
            String string = ((FileCopyPackagingElementEntity)element).getRenamedOutputFileName();
            if (string != null) {
                String it = string;
                boolean bl = false;
                JpsArtifactEntitiesSerializer.savePackagingElement$setAttribute(tag, "output-file-name", it);
            }
        } else if (packagingElementEntity instanceof ExtractedDirectoryPackagingElementEntity) {
            JpsArtifactEntitiesSerializer.savePackagingElement$setId(tag, "extracted-dir");
            JpsArtifactEntitiesSerializer.savePackagingElement$setPathAttribute(tag, "path", ((ExtractedDirectoryPackagingElementEntity)element).getFilePath());
            JpsArtifactEntitiesSerializer.savePackagingElement$setAttribute(tag, "path-in-jar", ((ExtractedDirectoryPackagingElementEntity)element).getPathInArchive());
        } else if (packagingElementEntity instanceof ArtifactOutputPackagingElementEntity) {
            JpsArtifactEntitiesSerializer.savePackagingElement$setId(tag, "artifact");
            ArtifactId artifactId = ((ArtifactOutputPackagingElementEntity)element).getArtifact();
            if (artifactId != null) {
                ArtifactId it = artifactId;
                boolean bl = false;
                JpsArtifactEntitiesSerializer.savePackagingElement$setAttribute(tag, "artifact-name", it.getName());
            }
        } else if (packagingElementEntity instanceof ModuleOutputPackagingElementEntity) {
            JpsArtifactEntitiesSerializer.savePackagingElement$setId(tag, "module-output");
            ModuleId moduleId = ((ModuleOutputPackagingElementEntity)element).getModule();
            if (moduleId != null) {
                ModuleId it = moduleId;
                boolean bl = false;
                JpsArtifactEntitiesSerializer.savePackagingElement$setAttribute(tag, "name", it.getName());
            }
        } else if (packagingElementEntity instanceof ModuleTestOutputPackagingElementEntity) {
            JpsArtifactEntitiesSerializer.savePackagingElement$setId(tag, "module-test-output");
            ModuleId moduleId = ((ModuleTestOutputPackagingElementEntity)element).getModule();
            if (moduleId != null) {
                ModuleId it = moduleId;
                boolean bl = false;
                JpsArtifactEntitiesSerializer.savePackagingElement$setAttribute(tag, "name", it.getName());
            }
        } else if (packagingElementEntity instanceof ModuleSourcePackagingElementEntity) {
            JpsArtifactEntitiesSerializer.savePackagingElement$setId(tag, "module-source");
            ModuleId moduleId = ((ModuleSourcePackagingElementEntity)element).getModule();
            if (moduleId != null) {
                ModuleId it = moduleId;
                boolean bl = false;
                JpsArtifactEntitiesSerializer.savePackagingElement$setAttribute(tag, "name", it.getName());
            }
        } else if (packagingElementEntity instanceof LibraryFilesPackagingElementEntity) {
            JpsArtifactEntitiesSerializer.savePackagingElement$setId(tag, "library");
            LibraryId library = ((LibraryFilesPackagingElementEntity)element).getLibrary();
            if (library != null) {
                LibraryTableId tableId = library.getTableId();
                JpsArtifactEntitiesSerializer.savePackagingElement$setAttribute(tag, "level", tableId.getLevel());
                JpsArtifactEntitiesSerializer.savePackagingElement$setAttribute(tag, "name", library.getName());
                if (tableId instanceof LibraryTableId.ModuleLibraryTableId) {
                    JpsArtifactEntitiesSerializer.savePackagingElement$setAttribute(tag, "module-name", ((LibraryTableId.ModuleLibraryTableId)tableId).getModuleId().getName());
                }
            }
        } else if (packagingElementEntity instanceof CustomPackagingElementEntity) {
            JpsArtifactEntitiesSerializer.savePackagingElement$setId(tag, ((CustomPackagingElementEntity)element).getTypeId());
            Element element2 = JDOMUtil.load((CharSequence)((CustomPackagingElementEntity)element).getPropertiesXmlTag());
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"load(...)");
            Element customElement = element2;
            List list = customElement.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAttributes(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Attribute attribute = (Attribute)element$iv;
                boolean bl = false;
                String string = attribute.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String string2 = attribute.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
                JpsArtifactEntitiesSerializer.savePackagingElement$setAttribute(tag, string, string2);
            }
            JpsArtifactEntitiesSerializer.savePackagingElement$saveElementChildren(tag, this, (CompositePackagingElementEntity)element);
        }
        return tag;
    }

    @NotNull
    public String toString() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null) + "(" + this.getFileUrl() + ")";
    }

    private final String toPathWithScheme(String $this$toPathWithScheme) {
        return "file://" + FileUtil.toSystemIndependentName((String)$this$toPathWithScheme);
    }

    private static final Unit loadEntities$lambda$0$4$0$1(VirtualFileUrl $outputUrl, PackagingElementEntity.Builder $rootElement, ArtifactEntity.Builder $this$ArtifactEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$ArtifactEntity, (String)"$this$ArtifactEntity");
        $this$ArtifactEntity.setOutputUrl($outputUrl);
        Intrinsics.checkNotNull((Object)$rootElement, (String)"null cannot be cast to non-null type com.intellij.java.workspace.entities.CompositePackagingElementEntity.Builder<out com.intellij.java.workspace.entities.CompositePackagingElementEntity>");
        $this$ArtifactEntity.setRootElement((CompositePackagingElementEntity.Builder)$rootElement);
        return Unit.INSTANCE;
    }

    private static final Unit loadEntities$lambda$0$4$0$2(ArtifactEntity.Builder $artifactEntity, ArtifactPropertiesState $propertiesState, ArtifactPropertiesEntity.Builder $this$ArtifactPropertiesEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$ArtifactPropertiesEntity, (String)"$this$ArtifactPropertiesEntity");
        $this$ArtifactPropertiesEntity.setArtifact($artifactEntity);
        $this$ArtifactPropertiesEntity.setPropertiesXmlTag(JDOMUtil.write((Element)$propertiesState.getOptions()));
        return Unit.INSTANCE;
    }

    private static final Unit checkAndAddToBuilder$lambda$0(ArtifactsOrderEntity.Builder $order, ArtifactsOrderEntity.Builder $this$modifyArtifactsOrderEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$modifyArtifactsOrderEntity, (String)"$this$modifyArtifactsOrderEntity");
        $this$modifyArtifactsOrderEntity.getOrderOfArtifacts().addAll((Collection<String>)$order.getOrderOfArtifacts());
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final ArrayList<PackagingElementEntity.Builder<? extends PackagingElementEntity>> loadPackagingElement$loadElementChildren(Element $element, JpsArtifactEntitiesSerializer this$0, EntitySource $source) {
        void $this$mapTo$iv;
        List list = $element.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
        Iterable iterable = list;
        Collection destination$iv = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Element element = (Element)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this$0.loadPackagingElement((Element)it, $source));
        }
        return (ArrayList)destination$iv;
    }

    private static final String loadPackagingElement$getAttribute(Element $element, String name) {
        String string = $element.getAttributeValue(name);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private static final String loadPackagingElement$getOptionalAttribute(Element $element, String name) {
        return $element.getAttributeValue(name);
    }

    private static final VirtualFileUrl loadPackagingElement$getPathAttribute(Element $element, JpsArtifactEntitiesSerializer this$0, String name) {
        String string = $element.getAttributeValue(name);
        Intrinsics.checkNotNull((Object)string);
        String it = string;
        boolean bl = false;
        return this$0.virtualFileManager.getOrCreateFromUrl(this$0.toPathWithScheme(it));
    }

    private static final Unit loadPackagingElement$lambda$2(Element $element, JpsArtifactEntitiesSerializer this$0, EntitySource $source, ArtifactRootElementEntity.Builder $this$ArtifactRootElementEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$ArtifactRootElementEntity, (String)"$this$ArtifactRootElementEntity");
        $this$ArtifactRootElementEntity.setChildren((List<? extends PackagingElementEntity.Builder<? extends PackagingElementEntity>>)JpsArtifactEntitiesSerializer.loadPackagingElement$loadElementChildren($element, this$0, $source));
        return Unit.INSTANCE;
    }

    private static final Unit loadPackagingElement$lambda$3(Element $element, JpsArtifactEntitiesSerializer this$0, EntitySource $source, DirectoryPackagingElementEntity.Builder $this$DirectoryPackagingElementEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$DirectoryPackagingElementEntity, (String)"$this$DirectoryPackagingElementEntity");
        $this$DirectoryPackagingElementEntity.setChildren((List<? extends PackagingElementEntity.Builder<? extends PackagingElementEntity>>)JpsArtifactEntitiesSerializer.loadPackagingElement$loadElementChildren($element, this$0, $source));
        return Unit.INSTANCE;
    }

    private static final Unit loadPackagingElement$lambda$4(Element $element, JpsArtifactEntitiesSerializer this$0, EntitySource $source, ArchivePackagingElementEntity.Builder $this$ArchivePackagingElementEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$ArchivePackagingElementEntity, (String)"$this$ArchivePackagingElementEntity");
        $this$ArchivePackagingElementEntity.setChildren((List<? extends PackagingElementEntity.Builder<? extends PackagingElementEntity>>)JpsArtifactEntitiesSerializer.loadPackagingElement$loadElementChildren($element, this$0, $source));
        return Unit.INSTANCE;
    }

    private static final Unit loadPackagingElement$lambda$5(Element $element, FileCopyPackagingElementEntity.Builder $this$FileCopyPackagingElementEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$FileCopyPackagingElementEntity, (String)"$this$FileCopyPackagingElementEntity");
        $this$FileCopyPackagingElementEntity.setRenamedOutputFileName(JpsArtifactEntitiesSerializer.loadPackagingElement$getOptionalAttribute($element, "output-file-name"));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit loadPackagingElement$lambda$6(Element $element, ArtifactOutputPackagingElementEntity.Builder $this$ArtifactOutputPackagingElementEntity) {
        ArtifactId artifactId;
        Intrinsics.checkNotNullParameter((Object)$this$ArtifactOutputPackagingElementEntity, (String)"$this$ArtifactOutputPackagingElementEntity");
        ArtifactOutputPackagingElementEntity.Builder builder = $this$ArtifactOutputPackagingElementEntity;
        String string = JpsArtifactEntitiesSerializer.loadPackagingElement$getOptionalAttribute($element, "artifact-name");
        if (string != null) {
            void it;
            String string2 = string;
            ArtifactOutputPackagingElementEntity.Builder builder2 = builder;
            boolean bl = false;
            artifactId = new ArtifactId((String)it);
            builder = builder2;
        } else {
            artifactId = null;
        }
        builder.setArtifact(artifactId);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit loadPackagingElement$lambda$7(Element $element, ModuleOutputPackagingElementEntity.Builder $this$ModuleOutputPackagingElementEntity) {
        ModuleId moduleId;
        Intrinsics.checkNotNullParameter((Object)$this$ModuleOutputPackagingElementEntity, (String)"$this$ModuleOutputPackagingElementEntity");
        ModuleOutputPackagingElementEntity.Builder builder = $this$ModuleOutputPackagingElementEntity;
        String string = JpsArtifactEntitiesSerializer.loadPackagingElement$getOptionalAttribute($element, "name");
        if (string != null) {
            void it;
            String string2 = string;
            ModuleOutputPackagingElementEntity.Builder builder2 = builder;
            boolean bl = false;
            moduleId = new ModuleId((String)it);
            builder = builder2;
        } else {
            moduleId = null;
        }
        builder.setModule(moduleId);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit loadPackagingElement$lambda$8(Element $element, ModuleTestOutputPackagingElementEntity.Builder $this$ModuleTestOutputPackagingElementEntity) {
        ModuleId moduleId;
        Intrinsics.checkNotNullParameter((Object)$this$ModuleTestOutputPackagingElementEntity, (String)"$this$ModuleTestOutputPackagingElementEntity");
        ModuleTestOutputPackagingElementEntity.Builder builder = $this$ModuleTestOutputPackagingElementEntity;
        String string = JpsArtifactEntitiesSerializer.loadPackagingElement$getOptionalAttribute($element, "name");
        if (string != null) {
            void it;
            String string2 = string;
            ModuleTestOutputPackagingElementEntity.Builder builder2 = builder;
            boolean bl = false;
            moduleId = new ModuleId((String)it);
            builder = builder2;
        } else {
            moduleId = null;
        }
        builder.setModule(moduleId);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit loadPackagingElement$lambda$9(Element $element, ModuleSourcePackagingElementEntity.Builder $this$ModuleSourcePackagingElementEntity) {
        ModuleId moduleId;
        Intrinsics.checkNotNullParameter((Object)$this$ModuleSourcePackagingElementEntity, (String)"$this$ModuleSourcePackagingElementEntity");
        ModuleSourcePackagingElementEntity.Builder builder = $this$ModuleSourcePackagingElementEntity;
        String string = JpsArtifactEntitiesSerializer.loadPackagingElement$getOptionalAttribute($element, "name");
        if (string != null) {
            void it;
            String string2 = string;
            ModuleSourcePackagingElementEntity.Builder builder2 = builder;
            boolean bl = false;
            moduleId = new ModuleId((String)it);
            builder = builder2;
        } else {
            moduleId = null;
        }
        builder.setModule(moduleId);
        return Unit.INSTANCE;
    }

    private static final Unit loadPackagingElement$lambda$10(String $name, LibraryTableId $parentId, LibraryFilesPackagingElementEntity.Builder $this$LibraryFilesPackagingElementEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$LibraryFilesPackagingElementEntity, (String)"$this$LibraryFilesPackagingElementEntity");
        $this$LibraryFilesPackagingElementEntity.setLibrary(new LibraryId($name, $parentId));
        return Unit.INSTANCE;
    }

    private static final Unit loadPackagingElement$lambda$11(Element $element, JpsArtifactEntitiesSerializer this$0, EntitySource $source, CustomPackagingElementEntity.Builder $this$CustomPackagingElementEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$CustomPackagingElementEntity, (String)"$this$CustomPackagingElementEntity");
        $this$CustomPackagingElementEntity.setChildren((List<? extends PackagingElementEntity.Builder<? extends PackagingElementEntity>>)JpsArtifactEntitiesSerializer.loadPackagingElement$loadElementChildren($element, this$0, $source));
        return Unit.INSTANCE;
    }

    private static final Element savePackagingElement$setId(Element tag, String typeId) {
        return tag.setAttribute("id", typeId);
    }

    private static final Element savePackagingElement$setAttribute(Element tag, String name, String value) {
        return tag.setAttribute(name, value);
    }

    private static final Element savePackagingElement$setPathAttribute(Element tag, String name, VirtualFileUrl value) {
        return tag.setAttribute(name, JpsPathUtil.urlToPath((String)value.getUrl()));
    }

    private static final void savePackagingElement$saveElementChildren(Element tag, JpsArtifactEntitiesSerializer this$0, CompositePackagingElementEntity composite) {
        Iterable $this$forEach$iv = composite.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PackagingElementEntity it = (PackagingElementEntity)element$iv;
            boolean bl = false;
            tag.addContent(this$0.savePackagingElement(it));
        }
    }

    static {
        Meter meter = JpsMetrics.getInstance().getMeter();
        Intrinsics.checkNotNullExpressionValue((Object)meter, (String)"getMeter(...)");
        JpsArtifactEntitiesSerializer.Companion.setupOpenTelemetryReporting(meter);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/JpsArtifactEntitiesSerializer$Companion;", "", "<init>", "()V", "loadEntitiesTimeMs", "Lcom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer;", "Ljava/util/concurrent/atomic/AtomicLong;", "saveEntitiesTimeMs", "setupOpenTelemetryReporting", "", "meter", "Lio/opentelemetry/api/metrics/Meter;", "intellij.platform.workspace.jps"})
    public static final class Companion {
        private Companion() {
        }

        private final void setupOpenTelemetryReporting(Meter meter) {
            ObservableLongMeasurement loadEntitiesTimeCounter = meter.counterBuilder("jps.artifact.entities.serializer.load.entities.ms").buildObserver();
            ObservableLongMeasurement saveEntitiesTimeCounter = meter.counterBuilder("jps.artifact.entities.serializer.save.entities.ms").buildObserver();
            ObservableMeasurement[] observableMeasurementArray = new ObservableMeasurement[]{saveEntitiesTimeCounter};
            meter.batchCallback(() -> Companion.setupOpenTelemetryReporting$lambda$0(loadEntitiesTimeCounter, saveEntitiesTimeCounter), (ObservableMeasurement)loadEntitiesTimeCounter, observableMeasurementArray);
        }

        private static final void setupOpenTelemetryReporting$lambda$0(ObservableLongMeasurement $loadEntitiesTimeCounter, ObservableLongMeasurement $saveEntitiesTimeCounter) {
            $loadEntitiesTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)loadEntitiesTimeMs));
            $saveEntitiesTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)saveEntitiesTimeMs));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

