/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.platform.workspace.jps.JpsImportedEntitySource;
import com.intellij.platform.workspace.jps.entities.FacetEntity;
import com.intellij.platform.workspace.jps.entities.FacetEntityTypeId;
import com.intellij.platform.workspace.jps.entities.FacetId;
import com.intellij.platform.workspace.jps.entities.FacetKt;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleId;
import com.intellij.platform.workspace.jps.serialization.impl.CustomFacetRelatedEntitySerializer;
import com.intellij.platform.workspace.jps.serialization.impl.DefaultFacetEntitySerializerKt;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.serialization.facet.FacetState;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 52\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00015B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J,\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J<\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J \u0010\u001d\u001a\u0004\u0018\u00010\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002J$\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00140\u001a2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a2\u0006\u0010#\u001a\u00020$H\u0016J:\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u00022\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00140(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00140*2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0002H\u0016J \u0010.\u001a\u00020,2\u000e\u0010-\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020/2\u0006\u00100\u001a\u000201H\u0016J\u0018\u00102\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00022\u0006\u00103\u001a\u00020,H\u0016J(\u00104\u001a\u00020,2\u000e\u0010-\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00103\u001a\u00020,H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/DefaultFacetEntitySerializer;", "Lcom/intellij/platform/workspace/jps/serialization/impl/CustomFacetRelatedEntitySerializer;", "Lcom/intellij/platform/workspace/jps/entities/FacetEntity;", "<init>", "()V", "rootEntityType", "Ljava/lang/Class;", "getRootEntityType", "()Ljava/lang/Class;", "supportedFacetType", "", "getSupportedFacetType", "()Ljava/lang/String;", "configurationStringInterner", "Ljava/util/concurrent/ConcurrentHashMap;", "loadEntitiesFromFacetState", "", "moduleEntity", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity$Builder;", "facetState", "Lorg/jetbrains/jps/model/serialization/facet/FacetState;", "evaluateEntitySource", "Lkotlin/Function1;", "Lcom/intellij/platform/workspace/storage/EntitySource;", "loadFacetEntities", "facetStates", "", "underlyingFacet", "Lcom/intellij/platform/workspace/jps/entities/FacetEntity$Builder;", "findFacetById", "facets", "id", "Lcom/intellij/platform/workspace/jps/entities/FacetId;", "createFacetStateFromEntities", "entities", "storeExternally", "", "getOrCreateFacetState", "facetEntity", "existingFacetStates", "", "rootFacets", "", "serializeIntoXml", "Lorg/jdom/Element;", "entity", "serializeIntoXmlBuilder", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity$Builder;", "module", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "serialize", "rootElement", "serializeBuilder", "Companion", "intellij.platform.workspace.jps"})
@SourceDebugExtension(value={"SMAP\nDefaultFacetEntitySerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultFacetEntitySerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/DefaultFacetEntitySerializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n1869#2:134\n1870#2:136\n1869#2,2:137\n1#3:135\n*S KotlinDebug\n*F\n+ 1 DefaultFacetEntitySerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/DefaultFacetEntitySerializer\n*L\n38#1:134\n38#1:136\n83#1:137,2\n*E\n"})
public final class DefaultFacetEntitySerializer
implements CustomFacetRelatedEntitySerializer<FacetEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, String> configurationStringInterner = new ConcurrentHashMap();
    @NotNull
    public static final String ALL_FACETS_TYPES_MARKER = "<all types of facets>";

    @Override
    @NotNull
    public Class<FacetEntity> getRootEntityType() {
        return FacetEntity.class;
    }

    @Override
    @NotNull
    public String getSupportedFacetType() {
        return ALL_FACETS_TYPES_MARKER;
    }

    @Override
    public void loadEntitiesFromFacetState(@NotNull ModuleEntity.Builder moduleEntity, @NotNull FacetState facetState, @NotNull Function1<? super FacetState, ? extends EntitySource> evaluateEntitySource) {
        Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
        Intrinsics.checkNotNullParameter((Object)facetState, (String)"facetState");
        Intrinsics.checkNotNullParameter(evaluateEntitySource, (String)"evaluateEntitySource");
        this.loadFacetEntities(moduleEntity, CollectionsKt.listOf((Object)facetState), null, evaluateEntitySource);
    }

    private final void loadFacetEntities(ModuleEntity.Builder moduleEntity, List<FacetState> facetStates, FacetEntity.Builder underlyingFacet, Function1<? super FacetState, ? extends EntitySource> evaluateEntitySource) {
        Iterable $this$forEach$iv = facetStates;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            String configurationXmlTagRaw;
            String string2;
            Object it;
            FacetState facetState = (FacetState)element$iv;
            boolean bl = false;
            EntitySource entitySource = (EntitySource)evaluateEntitySource.invoke((Object)facetState);
            if (facetState.getConfiguration() != null) {
                boolean bl2 = false;
                string2 = JDOMUtil.write((Element)it);
            } else {
                string2 = configurationXmlTagRaw = null;
            }
            if (configurationXmlTagRaw != null) {
                boolean bl3 = false;
                string = this.configurationStringInterner.computeIfAbsent((String)it, Function.identity());
            } else {
                string = null;
            }
            String configurationXmlTag = string;
            Object v = DefaultFacetEntitySerializerKt.access$getFacetEntityTypes$p().get(facetState.getFacetType());
            Intrinsics.checkNotNull(v);
            FacetEntityTypeId facetEntityTypeId = (FacetEntityTypeId)v;
            String string3 = facetState.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            FacetId newFacetId = new FacetId(string3, facetEntityTypeId, new ModuleId(moduleEntity.getName()));
            FacetEntity.Builder facetEntity = null;
            FacetEntity.Builder existingFacet = this.findFacetById(moduleEntity.getFacets(), newFacetId);
            if (existingFacet != null && configurationXmlTag != null && existingFacet.getConfigurationXmlTag() == null) {
                FacetEntity.Builder builder;
                FacetEntity.Builder $this$loadFacetEntities_u24lambda_u240_u242 = builder = existingFacet;
                boolean bl4 = false;
                $this$loadFacetEntities_u24lambda_u240_u242.setEntitySource(entitySource);
                $this$loadFacetEntities_u24lambda_u240_u242.setConfigurationXmlTag(configurationXmlTag);
                facetEntity = existingFacet;
            }
            if (existingFacet == null) {
                ModuleId moduleId = new ModuleId(moduleEntity.getName());
                String string4 = facetState.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                facetEntity = FacetEntity.Companion.create(moduleId, string4, facetEntityTypeId, entitySource, (Function1<? super FacetEntity.Builder, Unit>)((Function1)arg_0 -> DefaultFacetEntitySerializer.loadFacetEntities$lambda$0$3(configurationXmlTag, moduleEntity, underlyingFacet, arg_0)));
            }
            List list = facetState.subFacets;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"subFacets");
            this.loadFacetEntities(moduleEntity, list, facetEntity, evaluateEntitySource);
        }
    }

    private final FacetEntity.Builder findFacetById(List<? extends FacetEntity.Builder> facets, FacetId id) {
        for (FacetEntity.Builder builder : facets) {
            if (Intrinsics.areEqual((Object)new FacetId(builder.getName(), builder.getTypeId(), new ModuleId(builder.getModule().getName())), (Object)id)) {
                return builder;
            }
            FacetEntity.Builder subs = this.findFacetById(FacetKt.getChildrenFacets(builder), id);
            if (subs == null) continue;
            return subs;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FacetState> createFacetStateFromEntities(@NotNull List<? extends FacetEntity> entities, boolean storeExternally) {
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        HashMap existingFacetStates = new HashMap();
        ArrayList resultFacetStates = new ArrayList();
        Iterable $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element element;
            FacetState state;
            FacetEntity facetEntity = (FacetEntity)element$iv;
            boolean bl = false;
            FacetState facetState = state = this.getOrCreateFacetState(facetEntity, existingFacetStates, resultFacetStates, storeExternally);
            if (facetEntity.getConfigurationXmlTag() != null) {
                void it;
                FacetState facetState2 = facetState;
                boolean bl2 = false;
                element = JDOMUtil.load((CharSequence)((CharSequence)it));
                facetState = facetState2;
            } else {
                element = null;
            }
            facetState.setConfiguration(element);
        }
        return resultFacetStates;
    }

    private final FacetState getOrCreateFacetState(FacetEntity facetEntity, Map<String, FacetState> existingFacetStates, List<FacetState> rootFacets, boolean storeExternally) {
        String externalSystemIdValue;
        FacetState facetState;
        FacetState existing;
        FacetState facetState2 = existing = existingFacetStates.get(facetEntity.getName());
        if (facetState2 != null) {
            return facetState2;
        }
        FacetState $this$getOrCreateFacetState_u24lambda_u240 = facetState = new FacetState();
        boolean bl = false;
        $this$getOrCreateFacetState_u24lambda_u240.setName(facetEntity.getName());
        $this$getOrCreateFacetState_u24lambda_u240.setFacetType(facetEntity.getTypeId().getName());
        EntitySource entitySource = facetEntity.getEntitySource();
        JpsImportedEntitySource jpsImportedEntitySource = entitySource instanceof JpsImportedEntitySource ? (JpsImportedEntitySource)entitySource : null;
        String string = externalSystemIdValue = jpsImportedEntitySource != null ? jpsImportedEntitySource.getExternalSystemId() : null;
        if (storeExternally) {
            $this$getOrCreateFacetState_u24lambda_u240.setExternalSystemId(externalSystemIdValue);
        } else {
            $this$getOrCreateFacetState_u24lambda_u240.setExternalSystemIdInInternalStorage(externalSystemIdValue);
        }
        FacetState state = facetState;
        existingFacetStates.put(state.getName(), state);
        FacetEntity underlyingFacet = facetEntity.getUnderlyingFacet();
        boolean bl2 = underlyingFacet != null ? this.getOrCreateFacetState((FacetEntity)underlyingFacet, existingFacetStates, rootFacets, (boolean)storeExternally).subFacets.add(state) : rootFacets.add(state);
        return state;
    }

    @Override
    @NotNull
    public Element serializeIntoXml(@NotNull FacetEntity entity) {
        String string;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                string = entity.getConfigurationXmlTag();
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                Element element = JDOMUtil.load((CharSequence)it);
                string = element;
                if (element != null) break block3;
            }
            string = new Element("configuration");
        }
        return string;
    }

    @Override
    @NotNull
    public Element serializeIntoXmlBuilder(@NotNull WorkspaceEntity.Builder<? extends FacetEntity> entity, @NotNull ModuleEntity module) {
        String string;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(entity, (String)"entity");
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                FacetEntity.Builder cfr_ignored_0 = (FacetEntity.Builder)entity;
                string = ((FacetEntity.Builder)entity).getConfigurationXmlTag();
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                Element element = JDOMUtil.load((CharSequence)it);
                string = element;
                if (element != null) break block3;
            }
            string = new Element("configuration");
        }
        return string;
    }

    @Override
    @NotNull
    public Element serialize(@NotNull FacetEntity entity, @NotNull Element rootElement) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)rootElement, (String)"rootElement");
        throw new IllegalStateException("Unsupported operation".toString());
    }

    @Override
    @NotNull
    public Element serializeBuilder(@NotNull WorkspaceEntity.Builder<? extends FacetEntity> entity, @NotNull ModuleEntity module, @NotNull Element rootElement) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)rootElement, (String)"rootElement");
        throw new IllegalStateException("Unsupported operation".toString());
    }

    private static final Unit loadFacetEntities$lambda$0$3(String $configurationXmlTag, ModuleEntity.Builder $moduleEntity, FacetEntity.Builder $underlyingFacet, FacetEntity.Builder $this$invoke) {
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
        $this$invoke.setConfigurationXmlTag($configurationXmlTag);
        $this$invoke.setModule($moduleEntity);
        $this$invoke.setUnderlyingFacet($underlyingFacet);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/DefaultFacetEntitySerializer$Companion;", "", "<init>", "()V", "ALL_FACETS_TYPES_MARKER", "", "intellij.platform.workspace.jps"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

