/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl.sync;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.execution.wsl.AbstractWslDistribution;
import com.intellij.execution.wsl.sync.FilePathRelativeToDir;
import com.intellij.execution.wsl.sync.FileStorage;
import com.intellij.execution.wsl.sync.LinuxFileStorage;
import com.intellij.execution.wsl.sync.WindowsFileStorage;
import com.intellij.execution.wsl.sync.WslHashFilters;
import com.intellij.execution.wsl.sync.WslHashRecord;
import com.intellij.execution.wsl.sync.WslSyncData;
import com.intellij.execution.wsl.sync.WslSyncKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.ExecutorsKt;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0005\u0018\u0000 \u001d*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0002\u001d\u001eBK\b\u0002\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ2\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00112\u0014\b\u0002\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J&\u0010\u0014\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u000fH\u0002J\u0016\u0010\u0018\u001a\u00020\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u001aH\u0002J\u0016\u0010\u001b\u001a\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u001aH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/execution/wsl/sync/WslSync;", "SourceFile", "DestFile", "", "source", "Lcom/intellij/execution/wsl/sync/FileStorage;", "dest", "filters", "Lcom/intellij/execution/wsl/sync/WslHashFilters;", "useStubs", "", "retainUnmatchedFiles", "<init>", "(Lcom/intellij/execution/wsl/sync/FileStorage;Lcom/intellij/execution/wsl/sync/FileStorage;Lcom/intellij/execution/wsl/sync/WslHashFilters;ZZ)V", "syncLinks", "", "sourceLinks", "", "Lcom/intellij/execution/wsl/sync/FilePathRelativeToDir;", "destStubs", "syncStubs", "sourceStubs", "", "syncFoldersInternal", "copyFilesInParallel", "filesToCopy", "", "copyFilesToOtherSide", "files", "Companion", "CoroutineScopeService", "intellij.platform.wsl.impl"})
@SourceDebugExtension(value={"SMAP\nWslSync.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WslSync.kt\ncom/intellij/execution/wsl/sync/WslSync\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,193:1\n1586#2:194\n1661#2,3:195\n1220#2,2:220\n1249#2,4:222\n1586#2:226\n1661#2,3:227\n1915#2,2:233\n566#3:198\n551#3,6:199\n566#3:205\n551#3,6:206\n37#4,2:212\n42#5,3:214\n42#5,3:217\n42#5,3:230\n*S KotlinDebug\n*F\n+ 1 WslSync.kt\ncom/intellij/execution/wsl/sync/WslSync\n*L\n80#1:194\n80#1:195,3\n122#1:220,2\n122#1:222,4\n143#1:226\n143#1:227,3\n181#1:233,2\n91#1:198\n91#1:199,6\n92#1:205\n92#1:206,6\n95#1:212,2\n110#1:214,3\n115#1:217,3\n175#1:230,3\n*E\n"})
public final class WslSync<SourceFile, DestFile> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileStorage<SourceFile, DestFile> source;
    @NotNull
    private final FileStorage<DestFile, SourceFile> dest;
    @NotNull
    private final WslHashFilters filters;
    private final boolean useStubs;
    private final boolean retainUnmatchedFiles;

    /*
     * WARNING - void declaration
     */
    private WslSync(FileStorage<SourceFile, DestFile> source, FileStorage<DestFile, SourceFile> dest, WslHashFilters filters, boolean useStubs, boolean retainUnmatchedFiles) {
        this.source = source;
        this.dest = dest;
        this.filters = filters;
        this.useStubs = useStubs;
        this.retainUnmatchedFiles = retainUnmatchedFiles;
        if (this.dest.isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            WslSyncKt.access$getLOGGER$p().info("Destination folder is empty, will copy all files");
            WslSyncData syncData = this.source.calculateSyncData(this.filters, true, this.useStubs);
            Iterable iterable = syncData.getHashes();
            WslSync wslSync = this;
            boolean $i$f$map = false;
            void var9_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                WslHashRecord wslHashRecord = (WslHashRecord)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getFile());
            }
            wslSync.copyFilesInParallel((List)destination$iv$iv);
            WslSync.syncLinks$default(this, syncData.getLinks(), null, 2, null);
            WslSync.syncStubs$default(this, syncData.getStubs(), null, 2, null);
        } else {
            this.syncFoldersInternal();
        }
    }

    /* synthetic */ WslSync(FileStorage fileStorage, FileStorage fileStorage2, WslHashFilters wslHashFilters, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        this(fileStorage, fileStorage2, wslHashFilters, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    private final void syncLinks(Map<FilePathRelativeToDir, FilePathRelativeToDir> sourceLinks, Map<FilePathRelativeToDir, FilePathRelativeToDir> destStubs) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNotTo$iv$iv2;
        Map<FilePathRelativeToDir, FilePathRelativeToDir> $this$filterNot$iv = sourceLinks;
        boolean $i$f$filterNot = false;
        Map<FilePathRelativeToDir, FilePathRelativeToDir> map = $this$filterNot$iv;
        Map<FilePathRelativeToDir, FilePathRelativeToDir> destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterNotTo = false;
        Iterator iterator = $this$filterNotTo$iv$iv2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (Intrinsics.areEqual((Object)destStubs.get(it.getKey()), it.getValue())) continue;
            destination$iv$iv.put((FilePathRelativeToDir)element$iv$iv.getKey(), (FilePathRelativeToDir)element$iv$iv.getValue());
        }
        Map<FilePathRelativeToDir, FilePathRelativeToDir> linksToCreate = destination$iv$iv;
        Map<FilePathRelativeToDir, FilePathRelativeToDir> $this$filterNot$iv2 = destStubs;
        boolean $i$f$filterNot2 = false;
        destination$iv$iv = $this$filterNot$iv2;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterNotTo2 = false;
        Iterator iterator2 = $this$filterNotTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (Intrinsics.areEqual((Object)sourceLinks.get(it.getKey()), it.getValue())) continue;
            destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Set linksToRemove = destination$iv$iv2.keySet();
        WslSyncKt.access$getLOGGER$p().info("Will create " + linksToCreate.size() + " links and remove " + linksToRemove.size());
        Collection $this$toTypedArray$iv = linksToRemove;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        FilePathRelativeToDir[] filePathRelativeToDirArray = thisCollection$iv.toArray(new FilePathRelativeToDir[0]);
        this.dest.removeLinks(Arrays.copyOf(filePathRelativeToDirArray, filePathRelativeToDirArray.length));
        this.dest.createSymLinks(linksToCreate);
    }

    static /* synthetic */ void syncLinks$default(WslSync wslSync, Map map, Map map2, int n, Object object) {
        if ((n & 2) != 0) {
            map2 = MapsKt.emptyMap();
        }
        wslSync.syncLinks(map, map2);
    }

    private final void syncStubs(Set<FilePathRelativeToDir> sourceStubs, Set<FilePathRelativeToDir> destStubs) {
        Set stubsToCreate = SetsKt.minus(sourceStubs, (Iterable)destStubs);
        Set stubsToRemove = SetsKt.minus(destStubs, (Iterable)sourceStubs);
        WslSyncKt.access$getLOGGER$p().info("Will create " + stubsToCreate.size() + " links and remove " + stubsToRemove.size());
        this.dest.createStubs(stubsToCreate);
        this.dest.removeFiles(stubsToRemove);
    }

    static /* synthetic */ void syncStubs$default(WslSync wslSync, Set set, Set set2, int n, Object object) {
        if ((n & 2) != 0) {
            set2 = SetsKt.emptySet();
        }
        wslSync.syncStubs(set, set2);
    }

    /*
     * WARNING - void declaration
     */
    private final void syncFoldersInternal() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        WslHashRecord sourceHashAndName;
        Object object;
        void $this$associateByTo$iv$iv;
        boolean $i$f$service = false;
        Class<CoroutineScopeService> serviceClass$iv = CoroutineScopeService.class;
        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object2 == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        CoroutineScope coroutineScope = (CoroutineScope)object2;
        ExecutorService executorService = ProcessIOExecutorService.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"INSTANCE");
        CompletableFuture sourceSyncDataFuture2 = FutureKt.asCompletableFuture((Deferred)BuildersKt.async$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)ExecutorsKt.from((ExecutorService)executorService)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super WslSyncData>, Object>(this, null){
            int label;
            final /* synthetic */ WslSync<SourceFile, DestFile> this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        return WslSync.access$getSource$p(this.this$0).calculateSyncData(WslSync.access$getFilters$p(this.this$0), false, WslSync.access$getUseStubs$p(this.this$0));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super WslSyncData> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null));
        boolean $i$f$service2 = false;
        Class<CoroutineScopeService> serviceClass$iv2 = CoroutineScopeService.class;
        Object object3 = ApplicationManager.getApplication().getService(serviceClass$iv2);
        if (object3 == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv2.getName() + " (classloader=" + serviceClass$iv2.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        CoroutineScope coroutineScope2 = (CoroutineScope)object3;
        ExecutorService executorService2 = ProcessIOExecutorService.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)executorService2, (String)"INSTANCE");
        CompletableFuture destSyncDataFuture2 = FutureKt.asCompletableFuture((Deferred)BuildersKt.async$default((CoroutineScope)coroutineScope2, (CoroutineContext)((CoroutineContext)ExecutorsKt.from((ExecutorService)executorService2)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super WslSyncData>, Object>(this, null){
            int label;
            final /* synthetic */ WslSync<SourceFile, DestFile> this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        return WslSync.access$getDest$p(this.this$0).calculateSyncData(WslSync.access$getFilters$p(this.this$0), false, WslSync.access$getUseStubs$p(this.this$0));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super WslSyncData> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null));
        WslSyncData sourceSyncData = (WslSyncData)sourceSyncDataFuture2.get();
        Iterable $this$associateBy$iv = sourceSyncData.getHashes();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            WslHashRecord wslHashRecord = (WslHashRecord)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.put(it.getFileLowerCase(), element$iv$iv);
        }
        Map sourceHashes = MapsKt.toMutableMap((Map)destination$iv$iv);
        WslSyncData destSyncData = (WslSyncData)destSyncDataFuture2.get();
        List<WslHashRecord> destHashes = destSyncData.getHashes();
        List filesToCopy = new ArrayList();
        List destFilesToRemove = new ArrayList();
        for (WslHashRecord destRecord : destHashes) {
            sourceHashAndName = (WslHashRecord)sourceHashes.get(destRecord.getFileLowerCase());
            if (sourceHashAndName != null) {
                if (sourceHashAndName.getHash() != destRecord.getHash()) {
                    filesToCopy.add(sourceHashAndName.getFile());
                }
                sourceHashes.remove(destRecord.getFileLowerCase());
                continue;
            }
            if (this.retainUnmatchedFiles) continue;
            destFilesToRemove.add(destRecord.getFile());
        }
        destination$iv$iv = sourceHashes.values();
        object = filesToCopy;
        boolean $i$f$map = false;
        sourceHashAndName = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            WslHashRecord wslHashRecord = (WslHashRecord)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getFile());
        }
        object.addAll((List)destination$iv$iv2);
        this.copyFilesInParallel(filesToCopy);
        if (!this.retainUnmatchedFiles) {
            this.dest.removeFiles(destFilesToRemove);
        }
        this.syncLinks(sourceSyncData.getLinks(), destSyncData.getLinks());
        this.syncStubs(sourceSyncData.getStubs(), destSyncData.getStubs());
    }

    private final void copyFilesInParallel(Collection<FilePathRelativeToDir> filesToCopy) {
        if (filesToCopy.isEmpty()) {
            WslSyncKt.access$getLOGGER$p().info("Nothing to copy: all files are same");
        }
        WslSyncKt.access$getLOGGER$p().info("Will copy " + filesToCopy.size() + " files");
        int chunkSize = RangesKt.coerceAtLeast((int)(filesToCopy.size() / 4), (int)1000);
        int parts = filesToCopy.size() / chunkSize;
        if (parts == 0) {
            this.copyFilesToOtherSide(filesToCopy);
        } else {
            WslSyncKt.access$getLOGGER$p().info("Split to " + parts + " chunks");
            ArrayList futures = new ArrayList(parts);
            for (List chunk : CollectionsKt.chunked((Iterable)filesToCopy, (int)chunkSize)) {
                Collection collection = futures;
                boolean $i$f$service22 = false;
                Class<CoroutineScopeService> serviceClass$iv = CoroutineScopeService.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                CoroutineScope coroutineScope = (CoroutineScope)object;
                ExecutorService executorService = ProcessIOExecutorService.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"INSTANCE");
                CompletableFuture $i$f$service22 = FutureKt.asCompletableFuture((Deferred)BuildersKt.async$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)ExecutorsKt.from((ExecutorService)executorService)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (List<FilePathRelativeToDir>)chunk, null){
                    int label;
                    final /* synthetic */ WslSync<SourceFile, DestFile> this$0;
                    final /* synthetic */ List<FilePathRelativeToDir> $chunk;
                    {
                        this.this$0 = $receiver;
                        this.$chunk = $chunk;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                WslSync.access$copyFilesToOtherSide(this.this$0, this.$chunk);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null));
                collection.add($i$f$service22);
            }
            Iterable $this$forEach$iv = futures;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Future it = (Future)element$iv;
                boolean bl = false;
                it.get();
            }
        }
        WslSyncKt.access$getLOGGER$p().info("Copied");
    }

    private final void copyFilesToOtherSide(Collection<FilePathRelativeToDir> files) {
        DestFile destTar = this.dest.createTempFile();
        this.source.tarAndCopyTo(files, destTar);
        this.dest.unTar(destTar);
        this.dest.removeTempFile(destTar);
    }

    public /* synthetic */ WslSync(FileStorage source, FileStorage dest, WslHashFilters filters, boolean useStubs, boolean retainUnmatchedFiles, DefaultConstructorMarker $constructor_marker) {
        this(source, dest, filters, useStubs, retainUnmatchedFiles);
    }

    public static final /* synthetic */ FileStorage access$getSource$p(WslSync $this) {
        return $this.source;
    }

    public static final /* synthetic */ WslHashFilters access$getFilters$p(WslSync $this) {
        return $this.filters;
    }

    public static final /* synthetic */ boolean access$getUseStubs$p(WslSync $this) {
        return $this.useStubs;
    }

    public static final /* synthetic */ FileStorage access$getDest$p(WslSync $this) {
        return $this.dest;
    }

    public static final /* synthetic */ void access$copyFilesToOtherSide(WslSync $this, Collection files) {
        $this.copyFilesToOtherSide(files);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JH\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\r2\b\b\u0002\u0010\u0011\u001a\u00020\rH\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/execution/wsl/sync/WslSync$Companion;", "", "<init>", "()V", "syncWslFolders", "", "linuxDir", "", "windowsDir", "Ljava/nio/file/Path;", "distro", "Lcom/intellij/execution/wsl/AbstractWslDistribution;", "linToWinCopy", "", "filters", "Lcom/intellij/execution/wsl/sync/WslHashFilters;", "useStubs", "retainUnmatchedFiles", "intellij.platform.wsl.impl"})
    @SourceDebugExtension(value={"SMAP\nWslSync.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WslSync.kt\ncom/intellij/execution/wsl/sync/WslSync$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n1586#2:194\n1661#2,3:195\n*S KotlinDebug\n*F\n+ 1 WslSync.kt\ncom/intellij/execution/wsl/sync/WslSync$Companion\n*L\n65#1:194\n65#1:195,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmOverloads
        public final void syncWslFolders(@NotNull String linuxDir, @NotNull Path windowsDir, @NotNull AbstractWslDistribution distro, boolean linToWinCopy, @NotNull WslHashFilters filters, boolean useStubs, boolean retainUnmatchedFiles) {
            Intrinsics.checkNotNullParameter((Object)linuxDir, (String)"linuxDir");
            Intrinsics.checkNotNullParameter((Object)windowsDir, (String)"windowsDir");
            Intrinsics.checkNotNullParameter((Object)distro, (String)"distro");
            Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
            WslSyncKt.access$getLOGGER$p().info("Sync " + (linToWinCopy ? linuxDir + " -> " + windowsDir : windowsDir + " -> " + linuxDir));
            WindowsFileStorage win = new WindowsFileStorage(windowsDir, distro);
            LinuxFileStorage lin = new LinuxFileStorage(linuxDir, distro);
            if (linToWinCopy) {
                v0 = new WslSync(lin, win, filters, useStubs, retainUnmatchedFiles, null);
            } else {
                new WslSync(win, lin, filters, useStubs, retainUnmatchedFiles, null);
                Path execFile = windowsDir.resolve("exec.txt");
                Intrinsics.checkNotNull((Object)execFile);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.exists(execFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Object object = PathsKt.readText$default((Path)execFile, null, (int)1, null);
                    Regex regex = new Regex("\\s+");
                    int n = 0;
                    object = regex.split((CharSequence)object, n);
                    boolean $i$f$map = false;
                    void var14_15 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
                    }
                    for (String fileToMarkExec : (List)destination$iv$iv) {
                        lin.markExec(fileToMarkExec);
                    }
                }
                v0 = Unit.INSTANCE;
            }
        }

        public static /* synthetic */ void syncWslFolders$default(Companion companion, String string, Path path, AbstractWslDistribution abstractWslDistribution, boolean bl, WslHashFilters wslHashFilters, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 8) != 0) {
                bl = true;
            }
            if ((n & 0x10) != 0) {
                wslHashFilters = WslHashFilters.Companion.getEMPTY_FILTERS();
            }
            if ((n & 0x20) != 0) {
                bl2 = false;
            }
            if ((n & 0x40) != 0) {
                bl3 = false;
            }
            companion.syncWslFolders(string, path, abstractWslDistribution, bl, wslHashFilters, bl2, bl3);
        }

        @JvmOverloads
        public final void syncWslFolders(@NotNull String linuxDir, @NotNull Path windowsDir, @NotNull AbstractWslDistribution distro, boolean linToWinCopy, @NotNull WslHashFilters filters, boolean useStubs) {
            Intrinsics.checkNotNullParameter((Object)linuxDir, (String)"linuxDir");
            Intrinsics.checkNotNullParameter((Object)windowsDir, (String)"windowsDir");
            Intrinsics.checkNotNullParameter((Object)distro, (String)"distro");
            Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
            com.intellij.execution.wsl.sync.WslSync$Companion.syncWslFolders$default(this, linuxDir, windowsDir, distro, linToWinCopy, filters, useStubs, false, 64, null);
        }

        @JvmOverloads
        public final void syncWslFolders(@NotNull String linuxDir, @NotNull Path windowsDir, @NotNull AbstractWslDistribution distro, boolean linToWinCopy, @NotNull WslHashFilters filters) {
            Intrinsics.checkNotNullParameter((Object)linuxDir, (String)"linuxDir");
            Intrinsics.checkNotNullParameter((Object)windowsDir, (String)"windowsDir");
            Intrinsics.checkNotNullParameter((Object)distro, (String)"distro");
            Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
            com.intellij.execution.wsl.sync.WslSync$Companion.syncWslFolders$default(this, linuxDir, windowsDir, distro, linToWinCopy, filters, false, false, 96, null);
        }

        @JvmOverloads
        public final void syncWslFolders(@NotNull String linuxDir, @NotNull Path windowsDir, @NotNull AbstractWslDistribution distro, boolean linToWinCopy) {
            Intrinsics.checkNotNullParameter((Object)linuxDir, (String)"linuxDir");
            Intrinsics.checkNotNullParameter((Object)windowsDir, (String)"windowsDir");
            Intrinsics.checkNotNullParameter((Object)distro, (String)"distro");
            com.intellij.execution.wsl.sync.WslSync$Companion.syncWslFolders$default(this, linuxDir, windowsDir, distro, linToWinCopy, null, false, false, 112, null);
        }

        @JvmOverloads
        public final void syncWslFolders(@NotNull String linuxDir, @NotNull Path windowsDir, @NotNull AbstractWslDistribution distro) {
            Intrinsics.checkNotNullParameter((Object)linuxDir, (String)"linuxDir");
            Intrinsics.checkNotNullParameter((Object)windowsDir, (String)"windowsDir");
            Intrinsics.checkNotNullParameter((Object)distro, (String)"distro");
            com.intellij.execution.wsl.sync.WslSync$Companion.syncWslFolders$default(this, linuxDir, windowsDir, distro, false, null, false, false, 120, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Service
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u0012\u0010\u0005\u001a\u00020\u0006X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/execution/wsl/sync/WslSync$CoroutineScopeService;", "Lkotlinx/coroutines/CoroutineScope;", "coroutineScope", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "intellij.platform.wsl.impl"})
    private static final class CoroutineScopeService
    implements CoroutineScope {
        private final /* synthetic */ CoroutineScope $$delegate_0;

        public CoroutineScopeService(@NotNull CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            this.$$delegate_0 = coroutineScope;
        }

        @NotNull
        public CoroutineContext getCoroutineContext() {
            return this.$$delegate_0.getCoroutineContext();
        }
    }
}

