/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl.sync;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.processTools.ExecutionResult;
import com.intellij.execution.processTools.ProcessExtKt;
import com.intellij.execution.wsl.AbstractWslDistribution;
import com.intellij.execution.wsl.AbstractWslDistributionKt;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WslProcessToolsKt;
import com.intellij.execution.wsl.WslToolsKt;
import com.intellij.execution.wsl.sync.FilePathRelativeToDir;
import com.intellij.execution.wsl.sync.FileStorage;
import com.intellij.execution.wsl.sync.LinuxFileStorageKt;
import com.intellij.execution.wsl.sync.PrefixCutter;
import com.intellij.execution.wsl.sync.WslHashFilters;
import com.intellij.execution.wsl.sync.WslHashRecord;
import com.intellij.execution.wsl.sync.WslSyncData;
import com.intellij.execution.wsl.sync.WslSyncSharedKt;
import com.intellij.openapi.util.Ref;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u0016\u0012\b\u0012\u00060\u0002j\u0002`\u0003\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0001B\u001b\u0012\n\u0010\u0006\u001a\u00060\u0002j\u0002`\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001c\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u0002H\u0016J\u0016\u0010\u001e\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150 H\u0016J!\u0010!\u001a\u00020\u00122\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150#\"\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020\u001bH\u0016J\u0016\u0010&\u001a\u00020\u00122\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150 H\u0016J\u0014\u0010(\u001a\u00020\u00122\n\u0010)\u001a\u00060\u0002j\u0002`\u0003H\u0016J\"\u0010*\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150 2\n\u0010+\u001a\u00060\u0004j\u0002`\u0005H\u0016J\u0014\u0010,\u001a\u00020\u00122\n\u0010-\u001a\u00060\u0002j\u0002`\u0003H\u0016J\u0010\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u000200H\u0002J\u001e\u00104\u001a\f0\u0002\u00a2\u0006\u0002\b5\u00a2\u0006\u0002\b62\n\u00107\u001a\u00060\u0002j\u0002`\u0003H\u0002J-\u00108\u001a\u00020\u00122\u001e\u00109\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00020#0#\"\b\u0012\u0004\u0012\u00020\u00020#H\u0002\u00a2\u0006\u0002\u0010:J\u000e\u0010;\u001a\u00020\u00122\u0006\u0010<\u001a\u00020\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u0018\u00101\u001a\u00020\u0002*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103\u00a8\u0006="}, d2={"Lcom/intellij/execution/wsl/sync/LinuxFileStorage;", "Lcom/intellij/execution/wsl/sync/FileStorage;", "", "Lcom/intellij/execution/wsl/sync/LinuxFilePath;", "Ljava/nio/file/Path;", "Lcom/intellij/execution/wsl/sync/WindowsFilePath;", "dir", "distro", "Lcom/intellij/execution/wsl/AbstractWslDistribution;", "<init>", "(Ljava/lang/String;Lcom/intellij/execution/wsl/AbstractWslDistribution;)V", "CHARSET", "Ljava/nio/charset/Charset;", "FILE_SEPARATOR", "", "LINK_SEPARATOR", "STUB_SEPARATOR", "createSymLinks", "", "links", "", "Lcom/intellij/execution/wsl/sync/FilePathRelativeToDir;", "calculateSyncData", "Lcom/intellij/execution/wsl/sync/WslSyncData;", "filters", "Lcom/intellij/execution/wsl/sync/WslHashFilters;", "skipHash", "", "useStubs", "createTempFile", "createStubs", "files", "", "removeLinks", "linksToRemove", "", "([Lcom/intellij/execution/wsl/sync/FilePathRelativeToDir;)V", "isEmpty", "removeFiles", "filesToRemove", "removeTempFile", "file", "tarAndCopyTo", "destTar", "unTar", "tarFile", "calculateSyncDataInternal", "toolStdout", "Ljava/io/InputStream;", "escapedWithDir", "getEscapedWithDir", "(Lcom/intellij/execution/wsl/sync/FilePathRelativeToDir;)Ljava/lang/String;", "escapePath", "Lcom/intellij/openapi/util/NlsSafe;", "Lorg/jetbrains/annotations/NotNull;", "path", "runCommands", "commands", "([[Ljava/lang/String;)V", "markExec", "fileToMarkExec", "intellij.platform.wsl.impl"})
@SourceDebugExtension(value={"SMAP\nLinuxFileStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinuxFileStorage.kt\ncom/intellij/execution/wsl/sync/LinuxFileStorage\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,214:1\n129#2:215\n158#2,3:216\n1586#3:219\n1661#3,3:220\n37#4,2:223\n37#4,2:225\n37#4,2:227\n*S KotlinDebug\n*F\n+ 1 LinuxFileStorage.kt\ncom/intellij/execution/wsl/sync/LinuxFileStorage\n*L\n40#1:215\n40#1:216,3\n110#1:219\n110#1:220,3\n110#1:223,2\n53#1:225,2\n55#1:227,2\n*E\n"})
public final class LinuxFileStorage
extends FileStorage<String, Path> {
    @NotNull
    private final Charset CHARSET;
    private final byte FILE_SEPARATOR;
    private final byte LINK_SEPARATOR;
    private final byte STUB_SEPARATOR;

    public LinuxFileStorage(@NotNull String dir, @NotNull AbstractWslDistribution distro) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)distro, (String)"distro");
        char[] cArray = new char[]{'/'};
        super(StringsKt.trimEnd((String)dir, (char[])cArray) + "/", distro);
        this.CHARSET = Charsets.UTF_8;
        this.LINK_SEPARATOR = 1;
        this.STUB_SEPARATOR = (byte)2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void createSymLinks(@NotNull Map<FilePathRelativeToDir, FilePathRelativeToDir> links) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(links, (String)"links");
        Pair<Path, String> script = WslSyncSharedKt.createTmpWinFile(this.getDistro());
        Map<FilePathRelativeToDir, FilePathRelativeToDir> map = links;
        Path path = (Path)script.getFirst();
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)this.getEscapedWithDir((FilePathRelativeToDir)it.getKey()), (Object)this.getEscapedWithDir((FilePathRelativeToDir)it.getValue())));
        }
        PathsKt.writeText$default((Path)path, (CharSequence)CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, LinuxFileStorage::createSymLinks$lambda$1, (int)30, null), null, (OpenOption[])new OpenOption[0], (int)2, null);
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ExecutionResult>, Object>(this, script, null){
            int label;
            final /* synthetic */ LinuxFileStorage this$0;
            final /* synthetic */ Pair<Path, String> $script;
            {
                this.this$0 = $receiver;
                this.$script = $script;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        String[] stringArray = new String[]{"sh", this.$script.getSecond()};
                        this.label = 1;
                        Object object2 = ProcessExtKt.getBareExecutionResult((Process)WslProcessToolsKt.createProcess$default(this.this$0.getDistro(), stringArray, null, 2, null), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super ExecutionResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        PathKt.delete$default((Path)((Path)script.getFirst()), (boolean)false, (int)1, null);
    }

    @Override
    @NotNull
    public WslSyncData calculateSyncData(@NotNull WslHashFilters filters, boolean skipHash, boolean useStubs) {
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        Ref dataRef = new Ref();
        long time2 = TimeoutUtil.measureExecutionTime(() -> LinuxFileStorage.calculateSyncData$lambda$0(skipHash, useStubs, filters, this, dataRef));
        LinuxFileStorageKt.access$getLOGGER$p().info("Linux files calculated in " + time2);
        Object object = dataRef.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (WslSyncData)object;
    }

    @Override
    @NotNull
    public String createTempFile() {
        Object object = new String[]{"mktemp", "-u"};
        object = WslProcessToolsKt.runCommand$default(this.getDistro(), object, null, 2, null);
        ResultKt.throwOnFailure((Object)object);
        return (String)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createStubs(@NotNull Collection<FilePathRelativeToDir> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Pair<Path, String> script = WslSyncSharedKt.createTmpWinFile(this.getDistro());
        try {
            String scriptContent = CollectionsKt.joinToString$default((Iterable)files, (CharSequence)"\n", null, null, (int)0, null, arg_0 -> LinuxFileStorage.createStubs$lambda$0(this, arg_0), (int)30, null);
            PathsKt.writeText$default((Path)((Path)script.getFirst()), (CharSequence)scriptContent, null, (OpenOption[])new OpenOption[0], (int)2, null);
            ExecutionResult cfr_ignored_0 = (ExecutionResult)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ExecutionResult>, Object>(this, script, null){
                int label;
                final /* synthetic */ LinuxFileStorage this$0;
                final /* synthetic */ Pair<Path, String> $script;
                {
                    this.this$0 = $receiver;
                    this.$script = $script;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            String[] stringArray = new String[]{"sh", this.$script.getSecond()};
                            this.label = 1;
                            Object object2 = ProcessExtKt.getBareExecutionResult((Process)WslProcessToolsKt.createProcess$default(this.this$0.getDistro(), stringArray, null, 2, null), (Continuation)((Continuation)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super ExecutionResult> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }
        finally {
            PathKt.delete$default((Path)((Path)script.getFirst()), (boolean)false, (int)1, null);
        }
    }

    @Override
    public void removeLinks(FilePathRelativeToDir ... linksToRemove) {
        Intrinsics.checkNotNullParameter((Object)linksToRemove, (String)"linksToRemove");
        this.removeFiles(ArraysKt.asList((Object[])linksToRemove));
    }

    @Override
    public boolean isEmpty() {
        String[] stringArray;
        PrefixCutter prefixCutter = new PrefixCutter();
        String[] $this$isEmpty_u24lambda_u240 = stringArray = new WSLCommandLineOptions();
        boolean bl = false;
        $this$isEmpty_u24lambda_u240.addInitCommand("[ -e " + this.escapePath((String)this.getDir()) + " ]");
        $this$isEmpty_u24lambda_u240.addInitCommand("echo " + prefixCutter.getToken() + " >&2");
        String[] options = stringArray;
        $this$isEmpty_u24lambda_u240 = new String[]{"ls", "-A", this.getDir()};
        ProcessOutput process = new CapturingProcessHandler(this.getDistro().patchCommandLine(new GeneralCommandLine($this$isEmpty_u24lambda_u240), null, (WSLCommandLineOptions)options)).runProcess(5000, true);
        if (process.isTimeout()) {
            throw new Exception("Process didn't finish: WSL frozen?");
        }
        if (process.getExitCode() == 0) {
            String string = process.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
            return ((CharSequence)string).length() == 0;
        }
        String string = process.getStderr();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStderr(...)");
        String error = ((Object)StringsKt.trim((CharSequence)prefixCutter.getAfterToken(string))).toString();
        if (((CharSequence)error).length() == 0) {
            return true;
        }
        throw new Exception("Error checking folder: " + error);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeFiles(@NotNull Collection<FilePathRelativeToDir> filesToRemove) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(filesToRemove, (String)"filesToRemove");
        LinuxFileStorageKt.access$getLOGGER$p().info("Removing files");
        Iterable iterable = filesToRemove;
        LinuxFileStorage linuxFileStorage = this;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FilePathRelativeToDir filePathRelativeToDir = (FilePathRelativeToDir)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{"rm", this.getEscapedWithDir((FilePathRelativeToDir)it)};
            collection.add(stringArray);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[][] stringArray = (String[][])thisCollection$iv.toArray((T[])new String[0][]);
        linuxFileStorage.runCommands((String[][])Arrays.copyOf((Object[])stringArray, ((Object[])stringArray).length));
    }

    @Override
    public void removeTempFile(@NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String[] stringArray = new String[]{"rm", file};
        WslProcessToolsKt.runCommand$default(this.getDistro(), stringArray, null, 2, null);
    }

    @Override
    public void tarAndCopyTo(@NotNull Collection<FilePathRelativeToDir> files, @NotNull Path destTar) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)destTar, (String)"destTar");
        String linuxTarFile = this.createTempFile();
        Pair<Path, String> listFile = WslSyncSharedKt.createTmpWinFile(this.getDistro());
        PathsKt.writeText$default((Path)((Path)listFile.getFirst()), (CharSequence)CollectionsKt.joinToString$default((Iterable)files, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (OpenOption[])new OpenOption[0], (int)2, null);
        LinuxFileStorageKt.access$getLOGGER$p().info("Creating tar");
        String[] stringArray = new String[]{"tar", "cf", linuxTarFile, "-m", "-h", "-O", "-C", this.getDir(), "-T", listFile.getSecond()};
        WslProcessToolsKt.runCommand$default(this.getDistro(), stringArray, null, 2, null);
        PathKt.delete$default((Path)((Path)listFile.getFirst()), (boolean)false, (int)1, null);
        LinuxFileStorageKt.access$getLOGGER$p().info("Copying tar");
        stringArray = new String[]{"cp", linuxTarFile, AbstractWslDistributionKt.getWslPathSafe((AbstractWslDistribution)this.getDistro(), (Path)destTar)};
        WslProcessToolsKt.runCommand$default(this.getDistro(), stringArray, null, 2, null);
        stringArray = new String[]{"rm", linuxTarFile};
        WslProcessToolsKt.runCommand$default(this.getDistro(), stringArray, null, 2, null);
    }

    @Override
    public void unTar(@NotNull String tarFile) {
        Intrinsics.checkNotNullParameter((Object)tarFile, (String)"tarFile");
        LinuxFileStorageKt.access$getLOGGER$p().info("Unpacking");
        String[] stringArray = new String[]{"mkdir", "-p", this.getDir()};
        WslProcessToolsKt.runCommand$default(this.getDistro(), stringArray, null, 2, null);
        stringArray = new String[]{"tar", "xf", tarFile, "-C", this.getDir()};
        WslProcessToolsKt.runCommand$default(this.getDistro(), stringArray, null, 2, null);
    }

    private final WslSyncData calculateSyncDataInternal(InputStream toolStdout) {
        ArrayList hashes = new ArrayList(10000);
        Map links = new LinkedHashMap();
        Set stubs = new LinkedHashSet();
        ByteBuffer fileOutput = ByteBuffer.wrap(toolStdout.readAllBytes()).order(ByteOrder.LITTLE_ENDIAN);
        int fileStarted = 0;
        int outputLimit = fileOutput.limit();
        while (fileOutput.position() < outputLimit) {
            String name;
            byte by = fileOutput.get();
            if (by == this.FILE_SEPARATOR) {
                String name2;
                long hash = fileOutput.getLong();
                int prevPos = fileOutput.position();
                Intrinsics.checkNotNullExpressionValue((Object)this.CHARSET.decode(fileOutput.limit(prevPos - 9).position(fileStarted)).toString(), (String)"toString(...)");
                fileOutput.limit(outputLimit).position(prevPos);
                ((Collection)hashes).add(new WslHashRecord(new FilePathRelativeToDir(name2), hash, null, 4, null));
                fileStarted = prevPos;
                continue;
            }
            if (by == this.LINK_SEPARATOR) {
                String link;
                int length = fileOutput.getInt();
                int prevPos = fileOutput.position();
                Intrinsics.checkNotNullExpressionValue((Object)this.CHARSET.decode(fileOutput.limit(prevPos - 5).position(fileStarted)).toString(), (String)"toString(...)");
                Intrinsics.checkNotNullExpressionValue((Object)this.CHARSET.decode(fileOutput.limit(prevPos + length).position(prevPos)).toString(), (String)"toString(...)");
                fileOutput.limit(outputLimit).position(prevPos + length);
                if (StringsKt.startsWith$default((String)link, (String)((String)this.getDir()), (boolean)false, (int)2, null)) {
                    String file;
                    FilePathRelativeToDir filePathRelativeToDir = new FilePathRelativeToDir(file);
                    String string = link.substring(((String)this.getDir()).length());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    links.put(filePathRelativeToDir, new FilePathRelativeToDir(string));
                }
                fileStarted = prevPos + length;
                continue;
            }
            if (by != this.STUB_SEPARATOR) continue;
            int prevPos = fileOutput.position();
            Intrinsics.checkNotNullExpressionValue((Object)this.CHARSET.decode(fileOutput.limit(prevPos - 1).position(fileStarted)).toString(), (String)"toString(...)");
            fileOutput.limit(outputLimit).position(prevPos);
            ((Collection)stubs).add(new FilePathRelativeToDir(name));
            fileStarted = prevPos;
        }
        return new WslSyncData(hashes, links, stubs);
    }

    private final String getEscapedWithDir(FilePathRelativeToDir $this$escapedWithDir) {
        return this.escapePath(this.getDir() + $this$escapedWithDir.getAsUnixPath());
    }

    private final String escapePath(String path) {
        String[] stringArray = new String[]{path};
        String string = new GeneralCommandLine(stringArray).getCommandLineString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommandLineString(...)");
        return string;
    }

    private final void runCommands(String[] ... commands) {
        if (((Object[])commands).length < 3) {
            int n = ((Object[])commands).length;
            for (int i = 0; i < n; ++i) {
                String[] command = commands[i];
                WslProcessToolsKt.runCommand$default(this.getDistro(), Arrays.copyOf(command, command.length), null, 2, null);
            }
        } else {
            Pair<Path, String> script = WslSyncSharedKt.createTmpWinFile(this.getDistro());
            PathsKt.writeText$default((Path)((Path)script.getFirst()), (CharSequence)ArraysKt.joinToString$default((Object[])((Object[])commands), (CharSequence)"\n", null, null, (int)0, null, LinuxFileStorage::runCommands$lambda$0, (int)30, null), null, (OpenOption[])new OpenOption[0], (int)2, null);
            String[] stringArray = new String[]{"sh", script.getSecond()};
            WslProcessToolsKt.runCommand$default(this.getDistro(), stringArray, null, 2, null);
            PathKt.delete$default((Path)((Path)script.getFirst()), (boolean)false, (int)1, null);
        }
    }

    public final void markExec(@NotNull String fileToMarkExec) {
        Intrinsics.checkNotNullParameter((Object)fileToMarkExec, (String)"fileToMarkExec");
        Object object = new String[]{"chmod", "+x", this.getDir() + "/" + fileToMarkExec};
        object = WslProcessToolsKt.runCommand$default(this.getDistro(), object, null, 2, null);
        ResultKt.throwOnFailure((Object)object);
    }

    private static final CharSequence createSymLinks$lambda$1(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "[ -e $(dirname " + it.getFirst() + ") ] && ln -s " + it.getSecond() + " " + it.getFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void calculateSyncData$lambda$0(boolean $skipHash, boolean $useStubs, WslHashFilters $filters, LinuxFileStorage this$0, Ref $dataRef) {
        SpreadBuilder spreadBuilder = new SpreadBuilder(4);
        spreadBuilder.add((Object)($skipHash ? "-n" : null));
        spreadBuilder.add((Object)($useStubs ? "-s" : null));
        String[] $this$toTypedArray$iv = (String[])$filters.toArgs();
        boolean $i$f$toTypedArray = false;
        String[] thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new String[0]));
        spreadBuilder.add(this$0.getDir());
        List wslHashArgs = CollectionsKt.listOfNotNull((Object[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
        Collection $this$toTypedArray$iv2 = wslHashArgs;
        boolean $i$f$toTypedArray2 = false;
        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
        $this$toTypedArray$iv = thisCollection$iv2.toArray(new String[0]);
        GeneralCommandLine tool = WslToolsKt.getTool(this$0.getDistro(), "wslhash", Arrays.copyOf($this$toTypedArray$iv, $this$toTypedArray$iv.length));
        Process process = tool.createProcess();
        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"createProcess(...)");
        Process process2 = process;
        Closeable closeable = process2.getInputStream();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            $dataRef.set((Object)this$0.calculateSyncDataInternal(it));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(process2, null){
            int label;
            final /* synthetic */ Process $process;
            {
                this.$process = $process;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = ProcessExtKt.getResultStdoutStr((Process)this.$process, (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = ((Result)$result).unbox-impl();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private static final CharSequence createStubs$lambda$0(LinuxFileStorage this$0, FilePathRelativeToDir it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "mkdir -p \"$(dirname " + this$0.getEscapedWithDir(it) + ")\" && touch " + this$0.getEscapedWithDir(it);
    }

    private static final CharSequence runCommands$lambda$0(String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ArraysKt.joinToString$default((Object[])it, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }
}

