/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl.sync;

import com.intellij.execution.wsl.sync.FilePathRelativeToDir;
import com.intellij.execution.wsl.sync.WslHashFilters;
import com.intellij.execution.wsl.sync.WslHashRecord;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.util.io.ByteBufferUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.jpountz.xxhash.XXHash64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00022\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0018\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020)H\u0016J\u001e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u00022\u0006\u0010(\u001a\u00020)J\u0018\u0010.\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00022\u0006\u0010(\u001a\u00020)H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006/"}, d2={"Lcom/intellij/execution/wsl/sync/MyFileVisitor;", "Ljava/nio/file/SimpleFileVisitor;", "Ljava/nio/file/Path;", "filters", "Lcom/intellij/execution/wsl/sync/WslHashFilters;", "rootDir", "hashTool", "Lnet/jpountz/xxhash/XXHash64;", "skipHash", "", "useStubs", "<init>", "(Lcom/intellij/execution/wsl/sync/WslHashFilters;Ljava/nio/file/Path;Lnet/jpountz/xxhash/XXHash64;ZZ)V", "_hashes", "", "Lcom/intellij/execution/wsl/sync/WslHashRecord;", "_dirLinks", "", "Lcom/intellij/execution/wsl/sync/FilePathRelativeToDir;", "_stubs", "", "hashes", "", "getHashes", "()Ljava/util/List;", "dirLinks", "", "getDirLinks", "()Ljava/util/Map;", "stubs", "", "getStubs", "()Ljava/util/Set;", "postVisitDirectory", "Ljava/nio/file/FileVisitResult;", "dir", "exc", "Ljava/io/IOException;", "visitFile", "path", "attrs", "Ljava/nio/file/attribute/BasicFileAttributes;", "processFile", "", "relativeToDir", "file", "preVisitDirectory", "intellij.platform.wsl.impl"})
@SourceDebugExtension(value={"SMAP\nWindowsFileStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsFileStorage.kt\ncom/intellij/execution/wsl/sync/MyFileVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,184:1\n1#2:185\n*E\n"})
final class MyFileVisitor
extends SimpleFileVisitor<Path> {
    @NotNull
    private final WslHashFilters filters;
    @NotNull
    private final Path rootDir;
    @NotNull
    private final XXHash64 hashTool;
    private final boolean skipHash;
    private final boolean useStubs;
    @NotNull
    private final List<WslHashRecord> _hashes;
    @NotNull
    private final Map<FilePathRelativeToDir, FilePathRelativeToDir> _dirLinks;
    @NotNull
    private final Set<FilePathRelativeToDir> _stubs;

    public MyFileVisitor(@NotNull WslHashFilters filters, @NotNull Path rootDir, @NotNull XXHash64 hashTool, boolean skipHash, boolean useStubs) {
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        Intrinsics.checkNotNullParameter((Object)hashTool, (String)"hashTool");
        this.filters = filters;
        this.rootDir = rootDir;
        this.hashTool = hashTool;
        this.skipHash = skipHash;
        this.useStubs = useStubs;
        this._hashes = new ArrayList(10000);
        this._dirLinks = new LinkedHashMap();
        this._stubs = new LinkedHashSet();
    }

    @NotNull
    public final List<WslHashRecord> getHashes() {
        return this._hashes;
    }

    @NotNull
    public final Map<FilePathRelativeToDir, FilePathRelativeToDir> getDirLinks() {
        return this._dirLinks;
    }

    @NotNull
    public final Set<FilePathRelativeToDir> getStubs() {
        return this._stubs;
    }

    @Override
    @NotNull
    public FileVisitResult postVisitDirectory(@NotNull Path dir, @Nullable IOException exc) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        FileVisitResult fileVisitResult = super.postVisitDirectory(dir, exc);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)fileVisitResult), (String)"postVisitDirectory(...)");
        return fileVisitResult;
    }

    @Override
    @NotNull
    public FileVisitResult visitFile(@NotNull Path path, @NotNull BasicFileAttributes attrs) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        if (!attrs.isRegularFile()) {
            return FileVisitResult.CONTINUE;
        }
        Path path2 = this.rootDir.relativize(path);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"relativize(...)");
        String string = CollectionsKt.joinToString$default((Iterable)path2, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        this.processFile(new FilePathRelativeToDir(string), path, attrs);
        return FileVisitResult.CONTINUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processFile(@NotNull FilePathRelativeToDir relativeToDir, @NotNull Path file, @NotNull BasicFileAttributes attrs) {
        Intrinsics.checkNotNullParameter((Object)relativeToDir, (String)"relativeToDir");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        if (!this.filters.isFileNameOk(((Object)file.getFileName()).toString())) {
            if (this.useStubs) {
                this._stubs.add(relativeToDir);
            }
        } else if (this.skipHash || attrs.size() == 0L) {
            this._hashes.add(new WslHashRecord(relativeToDir, 0L, null, 4, null));
        } else {
            Object object = new OpenOption[]{StandardOpenOption.READ};
            object = FileChannel.open(file, object);
            Throwable throwable = null;
            try {
                boolean bl;
                FileChannel it = (FileChannel)object;
                boolean bl2 = false;
                MappedByteBuffer buf = it.map(FileChannel.MapMode.READ_ONLY, 0L, attrs.size());
                try {
                    bl = this._hashes.add(new WslHashRecord(relativeToDir, this.hashTool.hash((ByteBuffer)buf, 0L), null, 4, null));
                }
                finally {
                    ByteBufferUtil.cleanBuffer((ByteBuffer)buf);
                }
                Boolean bl3 = bl;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
    }

    @Override
    @NotNull
    public FileVisitResult preVisitDirectory(@NotNull Path dir, @NotNull BasicFileAttributes attrs) {
        FileVisitResult fileVisitResult;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        FileAttributes fileAttributes = FileSystemUtil.getAttributes((File)dir.toFile());
        boolean bl = fileAttributes != null ? fileAttributes.isSymLink() : false;
        if (bl) {
            Path target;
            String string = FileSystemUtil.resolveSymLink((File)dir.toFile());
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                v2 = this.rootDir.resolve(it);
            } else {
                v2 = target = null;
            }
            if (target != null) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.isDirectory(target, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && target.startsWith(this.rootDir)) {
                    this._dirLinks.put(new FilePathRelativeToDir(((Object)this.rootDir.relativize(dir)).toString()), new FilePathRelativeToDir(((Object)this.rootDir.relativize(target)).toString()));
                }
            }
            fileVisitResult = FileVisitResult.SKIP_SUBTREE;
        } else {
            fileVisitResult = FileVisitResult.CONTINUE;
        }
        return fileVisitResult;
    }
}

