/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.react.fix;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.react.ReactBundle;
import com.intellij.react.refactoring.extractComponent.ReactCreateComponentHandler;
import com.intellij.react.refactoring.extractComponent.ReactExtractComponentHandlerBase;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactCreateComponentFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    private final String myComponentName;
    private final ReactExtractComponentHandlerBase.ComponentType myComponentType;

    public ReactCreateComponentFix(@NotNull JSXmlLiteralExpression element, @NotNull ReactExtractComponentHandlerBase.ComponentType componentType) {
        if (element == null) {
            ReactCreateComponentFix.$$$reportNull$$$0(0);
        }
        if (componentType == null) {
            ReactCreateComponentFix.$$$reportNull$$$0(1);
        }
        super((PsiElement)element);
        this.myComponentName = element.getName();
        this.myComponentType = componentType;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        JSXmlLiteralExpression element;
        if (project == null) {
            ReactCreateComponentFix.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            ReactCreateComponentFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            ReactCreateComponentFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            ReactCreateComponentFix.$$$reportNull$$$0(5);
        }
        if ((element = (JSXmlLiteralExpression)ObjectUtils.tryCast((Object)startElement, JSXmlLiteralExpression.class)) == null) {
            return;
        }
        ReactCreateComponentHandler handler = new ReactCreateComponentHandler(element, this.myComponentName, this.myComponentType);
        handler.invoke(project, editor, psiFile, DataContext.EMPTY_CONTEXT);
    }

    @IntentionName
    @NotNull
    public String getText() {
        String string = this.myComponentType == ReactExtractComponentHandlerBase.ComponentType.Class ? ReactBundle.message("javascript.fix.create.class.component.jsx.name", this.myComponentName) : ReactBundle.message("javascript.fix.create.function.component.jsx.name", this.myComponentName);
        if (string == null) {
            ReactCreateComponentFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = this.myComponentType == ReactExtractComponentHandlerBase.ComponentType.Class ? ReactBundle.message("javascript.fix.create.class.component.jsx.family", new Object[0]) : ReactBundle.message("javascript.fix.create.function.component.jsx.family", new Object[0]);
        if (string == null) {
            ReactCreateComponentFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        PriorityAction.Priority priority = this.myComponentType == ReactExtractComponentHandlerBase.ComponentType.Function ? PriorityAction.Priority.HIGH : PriorityAction.Priority.NORMAL;
        if (priority == null) {
            ReactCreateComponentFix.$$$reportNull$$$0(8);
        }
        return priority;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/react/fix/ReactCreateComponentFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/react/fix/ReactCreateComponentFix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPriority";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

