/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.assemble;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.formatting.string.StringFormat;
import org.jetbrains.letsPlot.commons.intern.datetime.TimeZone;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.PlotContext;
import org.jetbrains.letsPlot.core.plot.base.Scale;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PlotGeomTiles;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.TooltipFormatting;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\"\u0010\u0016\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u0014\u0010\u0017\u001a\u00020\u00182\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u0014\u0010\u0019\u001a\u00020\u001a2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\rH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u000b\u001a \u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotAssemblerPlotContext;", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "geomTiles", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotGeomTiles;", "expFormat", "Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat$ExponentFormat;", "tz", "Lorg/jetbrains/letsPlot/commons/intern/datetime/TimeZone;", "(Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotGeomTiles;Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat$ExponentFormat;Lorg/jetbrains/letsPlot/commons/intern/datetime/TimeZone;)V", "getExpFormat", "()Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat$ExponentFormat;", "tooltipFormatters", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lkotlin/Function1;", "", "", "getTz", "()Lorg/jetbrains/letsPlot/commons/intern/datetime/TimeZone;", "getScale", "Lorg/jetbrains/letsPlot/core/plot/base/Scale;", "aes", "getTooltipFormatter", "hasScale", "", "overallTransformedDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "Companion", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nPlotAssemblerPlotContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotAssemblerPlotContext.kt\norg/jetbrains/letsPlot/core/plot/builder/assemble/PlotAssemblerPlotContext\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,51:1\n372#2,7:52\n*S KotlinDebug\n*F\n+ 1 PlotAssemblerPlotContext.kt\norg/jetbrains/letsPlot/core/plot/builder/assemble/PlotAssemblerPlotContext\n*L\n37#1:52,7\n*E\n"})
public final class PlotAssemblerPlotContext
implements PlotContext {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final PlotGeomTiles geomTiles;
    @NotNull
    private final StringFormat.ExponentFormat expFormat;
    @Nullable
    private final TimeZone tz;
    @NotNull
    private final Map<Aes<?>, Function1<Object, String>> tooltipFormatters;

    public PlotAssemblerPlotContext(@NotNull PlotGeomTiles geomTiles, @NotNull StringFormat.ExponentFormat expFormat, @Nullable TimeZone tz) {
        Intrinsics.checkNotNullParameter((Object)geomTiles, (String)"geomTiles");
        Intrinsics.checkNotNullParameter((Object)expFormat, (String)"expFormat");
        this.geomTiles = geomTiles;
        this.expFormat = expFormat;
        this.tz = tz;
        this.tooltipFormatters = new HashMap();
    }

    @Override
    @NotNull
    public StringFormat.ExponentFormat getExpFormat() {
        return this.expFormat;
    }

    @Override
    @Nullable
    public TimeZone getTz() {
        return this.tz;
    }

    @Override
    public boolean hasScale(@NotNull Aes<?> aes2) {
        Intrinsics.checkNotNullParameter(aes2, (String)"aes");
        return this.geomTiles.getScalesBeforeFacets().containsKey(aes2);
    }

    @Override
    @NotNull
    public Scale getScale(@NotNull Aes<?> aes2) {
        Intrinsics.checkNotNullParameter(aes2, (String)"aes");
        Companion.checkPositionalAes(aes2);
        return (Scale)MapsKt.getValue(this.geomTiles.getScalesBeforeFacets(), aes2);
    }

    @Override
    @NotNull
    public DoubleSpan overallTransformedDomain(@NotNull Aes<?> aes2) {
        Intrinsics.checkNotNullParameter(aes2, (String)"aes");
        return this.geomTiles.overallTransformedDomain(aes2);
    }

    @Override
    @NotNull
    public Function1<Object, String> getTooltipFormatter(@NotNull Aes<?> aes2) {
        Function1<Object, String> function1;
        Intrinsics.checkNotNullParameter(aes2, (String)"aes");
        Companion.checkPositionalAes(aes2);
        Map<Aes<?>, Function1<Object, String>> $this$getOrPut$iv = this.tooltipFormatters;
        boolean $i$f$getOrPut = false;
        Function1<Object, String> value$iv = $this$getOrPut$iv.get(aes2);
        if (value$iv == null) {
            boolean bl = false;
            Function1<Object, String> answer$iv = TooltipFormatting.INSTANCE.fromScale(aes2, this);
            $this$getOrPut$iv.put(aes2, answer$iv);
            function1 = answer$iv;
        } else {
            function1 = value$iv;
        }
        return function1;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotAssemblerPlotContext$Companion;", "", "()V", "checkPositionalAes", "", "aes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "plot-builder"})
    private static final class Companion {
        private Companion() {
        }

        public final void checkPositionalAes(@NotNull Aes<?> aes2) {
            Intrinsics.checkNotNullParameter(aes2, (String)"aes");
            if (!(!Aes.Companion.isPositionalXY(aes2) || Intrinsics.areEqual(aes2, Aes.Companion.getX()) || Intrinsics.areEqual(aes2, Aes.Companion.getY()))) {
                boolean bl = false;
                String string = "Positional aesthetic should be either X or Y but was " + aes2;
                throw new IllegalStateException(string.toString());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

