/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.documentation.PythonDocumentationLinkProvider;
import com.jetbrains.python.documentation.PythonDocumentationMap;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.pyi.PyiFile;
import java.io.IOException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jsoup.HttpStatusException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public final class PythonExternalDocumentationProvider
extends PythonDocumentationProvider
implements ExternalDocumentationProvider {
    private static final Logger LOG = Logger.getInstance(PythonExternalDocumentationProvider.class);

    @Nls
    public String fetchExternalDocumentation(Project project, PsiElement element, List<String> docUrls, boolean onHover) {
        PsiNamedElement namedElement = (PsiNamedElement)ApplicationManager.getApplication().runReadAction(() -> {
            Object moduleAnchor = element instanceof PsiDirectory ? element : element.getContainingFile();
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)moduleAnchor);
            if (module2 != null && !PyDocumentationSettings.getInstance((Module)module2).isRenderExternalDocumentation()) {
                return null;
            }
            PsiFileSystemItem file = PythonDocumentationProvider.getFile((PsiElement)element);
            if (file == null) {
                return null;
            }
            if (file instanceof PyiFile) {
                return null;
            }
            return PythonDocumentationProvider.getNamedElement((PsiElement)element);
        });
        if (namedElement != null) {
            PythonDocumentationMap documentationMap = PythonDocumentationMap.getInstance();
            for (String url : docUrls) {
                Supplier documentSupplier = Suppliers.memoize(() -> {
                    try {
                        return Jsoup.parse((URL)new URL(url), (int)1000);
                    }
                    catch (IOException e) {
                        String message = "Can't read external doc URL: " + url;
                        if ((e instanceof HttpStatusException || e instanceof UnknownHostException) && !documentationMap.isUserDefinedUrl(url)) {
                            LOG.error(message, (Throwable)e);
                        } else {
                            LOG.warn(message, (Throwable)e);
                        }
                        return null;
                    }
                });
                for (PythonDocumentationLinkProvider documentationLinkProvider : PythonDocumentationLinkProvider.EP_NAME.getExtensionList()) {
                    String quickDoc;
                    Document document;
                    Function quickDocExtractor;
                    String providedUrl = (String)ReadAction.compute(() -> documentationLinkProvider.getExternalDocumentationUrl((PsiElement)namedElement, (PsiElement)namedElement));
                    if (!url.equals(providedUrl) || (quickDocExtractor = documentationLinkProvider.quickDocExtractor(namedElement)) == null || (document = (Document)documentSupplier.get()) == null || !StringUtil.isNotEmpty((String)(quickDoc = (String)ReadAction.compute(() -> (String)quickDocExtractor.apply(document))))) continue;
                    return quickDoc;
                }
            }
        }
        return null;
    }

    public boolean hasDocumentationFor(PsiElement element, PsiElement originalElement) {
        return PythonDocumentationProvider.getOnlyUrlFor((PsiElement)element, (PsiElement)originalElement) != null;
    }

    public boolean canPromptToConfigureDocumentation(@NotNull PsiElement element) {
        PsiFile containingFile;
        if (element == null) {
            PythonExternalDocumentationProvider.$$$reportNull$$$0(0);
        }
        if ((containingFile = element.getContainingFile()) instanceof PyFile) {
            QualifiedName qName;
            Project project = element.getProject();
            VirtualFile vFile = containingFile.getVirtualFile();
            if (vFile != null && ProjectRootManager.getInstance((Project)project).getFileIndex().isInLibraryClasses(vFile) && (qName = QualifiedNameFinder.findCanonicalImportPath((PsiElement)element, (PsiElement)element)) != null && qName.getComponentCount() > 0) {
                return true;
            }
        }
        return false;
    }

    public void promptToConfigureDocumentation(@NotNull PsiElement element) {
        if (element == null) {
            PythonExternalDocumentationProvider.$$$reportNull$$$0(1);
        }
        Project project = element.getProject();
        QualifiedName qName = QualifiedNameFinder.findCanonicalImportPath((PsiElement)element, (PsiElement)element);
        if (qName != null && qName.getComponentCount() > 0) {
            PythonExternalDocumentationProvider.showNoExternalDocumentationDialog(project, qName);
        }
    }

    private static void showNoExternalDocumentationDialog(Project project, QualifiedName qName) {
        ApplicationManager.getApplication().invokeLater(() -> {
            int rc = Messages.showOkCancelDialog((Project)project, (String)PyBundle.message("external.documentation.configure.description", qName.getComponents().get(0)), (String)PyBundle.message("external.documentation.title", new Object[0]), (Icon)Messages.getQuestionIcon());
            if (rc == 0) {
                ShowSettingsUtilImpl.showSettingsDialog((Project)project, (String)"com.jetbrains.python.documentation.PythonDocumentationConfigurable", (String)"");
            }
        }, ModalityState.nonModal());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/jetbrains/python/documentation/PythonExternalDocumentationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canPromptToConfigureDocumentation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "promptToConfigureDocumentation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

