/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.markdown.rendering;

import androidx.compose.runtime.internal.StabilityInferred;
import java.net.URI;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jewel.foundation.util.JewelLogger;
import org.jetbrains.jewel.markdown.rendering.ImageSourceResolver;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/jewel/markdown/rendering/DefaultImageSourceResolver;", "Lorg/jetbrains/jewel/markdown/rendering/ImageSourceResolver;", "<init>", "()V", "resolve", "", "rawDestination", "intellij.platform.jewel.markdown.core"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nImageSourceResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageSourceResolver.kt\norg/jetbrains/jewel/markdown/rendering/DefaultImageSourceResolver\n+ 2 JewelLogger.kt\norg/jetbrains/jewel/foundation/util/JewelLoggerKt\n*L\n1#1,89:1\n9#2:90\n*S KotlinDebug\n*F\n+ 1 ImageSourceResolver.kt\norg/jetbrains/jewel/markdown/rendering/DefaultImageSourceResolver\n*L\n50#1:90\n*E\n"})
public final class DefaultImageSourceResolver
implements ImageSourceResolver {
    @NotNull
    public static final DefaultImageSourceResolver INSTANCE = new DefaultImageSourceResolver();
    public static final int $stable;

    private DefaultImageSourceResolver() {
    }

    @Override
    @NotNull
    public String resolve(@NotNull String rawDestination) {
        Intrinsics.checkNotNullParameter((Object)rawDestination, (String)"rawDestination");
        URI uri = URI.create(rawDestination);
        if (uri.getScheme() != null) {
            return rawDestination;
        }
        URL resourceUrl = this.getClass().getClassLoader().getResource(StringsKt.removePrefix((String)rawDestination, (CharSequence)"/"));
        if (resourceUrl == null) {
            DefaultImageSourceResolver $this$myLogger$iv = this;
            boolean $i$f$myLogger = false;
            JewelLogger.Companion.getInstance(DefaultImageSourceResolver.class).warn("Markdown image '" + rawDestination + "' expected at classpath '" + rawDestination + "' but not found. Please ensure it's in your 'src/main/resources/' folder.");
            return rawDestination;
        }
        String string = resourceUrl.toExternalForm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toExternalForm(...)");
        return string;
    }
}

