/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.components;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.builder.CustomGraphUpdater;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.components.BasicGraphPresentationModel;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.services.GraphSelectionService;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DSelectionEvent;
import com.intellij.openapi.graph.view.Graph2DSelectionListener;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SelectionDependenciesPresentationModel<N, E>
extends BasicGraphPresentationModel<N, E> {
    private boolean myFilterDependenciesMode;

    public SelectionDependenciesPresentationModel(@NotNull Graph graph) {
        if (graph == null) {
            SelectionDependenciesPresentationModel.$$$reportNull$$$0(0);
        }
        super(graph);
        this.myFilterDependenciesMode = true;
    }

    public SelectionDependenciesPresentationModel(@NotNull Graph graph, boolean filterDependencies) {
        if (graph == null) {
            SelectionDependenciesPresentationModel.$$$reportNull$$$0(1);
        }
        super(graph);
        this.myFilterDependenciesMode = true;
        this.myFilterDependenciesMode = filterDependencies;
    }

    @Override
    public void setGraphBuilder(@NotNull GraphBuilder<N, E> builder) {
        if (builder == null) {
            SelectionDependenciesPresentationModel.$$$reportNull$$$0(2);
        }
        super.setGraphBuilder(builder);
        this.addGraph2DSelectionListener(builder);
    }

    protected void addGraph2DSelectionListener(@NotNull GraphBuilder<N, E> builder) {
        if (builder == null) {
            SelectionDependenciesPresentationModel.$$$reportNull$$$0(3);
        }
        builder.getGraph().addGraph2DSelectionListener(new MyGraph2DSelectionListener(builder));
    }

    public boolean isFilterDependenciesMode() {
        return this.myFilterDependenciesMode;
    }

    public void setFilterDependenciesMode(boolean filterDependenciesMode) {
        this.myFilterDependenciesMode = filterDependenciesMode;
        this.getGraphBuilder().queryGraphUpdate().withDataReload().withRelayout().run();
    }

    public static <N, E> void filterSelectedNodesDependencies(GraphBuilder<N, E> builder, boolean updateGraph) {
        List selectedNodes = GraphSelectionService.getInstance().getSelectedModelNodes(builder);
        if (selectedNodes.isEmpty()) {
            return;
        }
        if (updateGraph) {
            builder.queryGraphUpdate().withDataReload().withRelayout().run();
        }
        HashSet edgesToShow = new HashSet();
        GraphDataModel dataModel = builder.getGraphDataModel();
        for (N selectedNode : selectedNodes) {
            for (E edge : builder.getEdgeObjects()) {
                if (!selectedNode.equals(dataModel.getSourceNode(edge)) && !selectedNode.equals(dataModel.getTargetNode(edge))) continue;
                edgesToShow.add(edge);
            }
        }
        builder.getActionExecutor().runGraphActionAsync(() -> {
            Collection edgeObjects = builder.getEdgeObjects();
            for (Object currentEdgeObject : ArrayUtil.toObjectArray(edgeObjects)) {
                if (edgesToShow.contains(currentEdgeObject)) continue;
                builder.removeEdge(currentEdgeObject);
            }
            Collection nodeObjects = builder.getNodeObjects();
            for (Object currentNodeObject : ArrayUtil.toObjectArray(nodeObjects)) {
                if (selectedNodes.contains(currentNodeObject)) continue;
                boolean toDelete = true;
                for (Object edgeObject : edgesToShow) {
                    if (!currentNodeObject.equals(dataModel.getSourceNode(edgeObject)) && !currentNodeObject.equals(dataModel.getTargetNode(edgeObject))) continue;
                    toDelete = false;
                    break;
                }
                if (!toDelete) continue;
                builder.removeNode(currentNodeObject);
            }
        });
        GraphLayoutService.getInstance().queryLayout(builder).run();
        builder.getView().fitContent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/graph/builder/components/SelectionDependenciesPresentationModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setGraphBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addGraph2DSelectionListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyGraph2DSelectionListener
    implements Graph2DSelectionListener {
        @NotNull
        private final GraphBuilder<N, E> myBuilder;

        MyGraph2DSelectionListener(GraphBuilder<N, E> builder) {
            if (builder == null) {
                MyGraph2DSelectionListener.$$$reportNull$$$0(0);
            }
            this.myBuilder = builder;
            builder.addCustomUpdater(new CustomGraphUpdater(){

                @Override
                public void update(@NotNull Graph2D graph, @NotNull Graph2DView view, @NotNull Collection<?> nodesForSizeUpdate) {
                    if (graph == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (view == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (nodesForSizeUpdate == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (SelectionDependenciesPresentationModel.this.isFilterDependenciesMode()) {
                        MyGraph2DSelectionListener.this.updateDependencies(false);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "graph";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "view";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "nodesForSizeUpdate";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/graph/builder/components/SelectionDependenciesPresentationModel$MyGraph2DSelectionListener$1";
                    objectArray[2] = "update";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        protected void updateDependencies(boolean updateGraph) {
            ApplicationManager.getApplication().invokeLater(() -> SelectionDependenciesPresentationModel.filterSelectedNodesDependencies(this.myBuilder, updateGraph));
        }

        @Override
        public void onGraph2DSelectionEvent(@NotNull Graph2DSelectionEvent e) {
            if (e == null) {
                MyGraph2DSelectionListener.$$$reportNull$$$0(1);
            }
            if (SelectionDependenciesPresentationModel.this.isFilterDependenciesMode() && e.isNodeSelection()) {
                this.updateDependencies(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/graph/builder/components/SelectionDependenciesPresentationModel$MyGraph2DSelectionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onGraph2DSelectionEvent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

