/*
 * Decompiled with CFR 0.152.
 */
package ru.adelf.idea.dotenv.docker;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiRecursiveElementVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;
import ru.adelf.idea.dotenv.models.EnvironmentKeyValue;
import ru.adelf.idea.dotenv.models.KeyValuePsiElement;
import ru.adelf.idea.dotenv.util.EnvironmentVariablesUtil;

class DockerComposeYamlPsiElementsVisitor
extends PsiRecursiveElementVisitor {
    private final Collection<KeyValuePsiElement> collectedItems = new HashSet<KeyValuePsiElement>();

    DockerComposeYamlPsiElementsVisitor() {
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            DockerComposeYamlPsiElementsVisitor.$$$reportNull$$$0(0);
        }
        if (element instanceof YAMLKeyValue) {
            this.visitKeyValue((YAMLKeyValue)element);
        }
        super.visitElement(element);
    }

    Collection<KeyValuePsiElement> getCollectedItems() {
        return this.collectedItems;
    }

    private void visitKeyValue(YAMLKeyValue yamlKeyValue) {
        if ("environment".equals(yamlKeyValue.getKeyText())) {
            for (YAMLSequenceItem yamlSequenceItem : this.getSequenceItems(yamlKeyValue)) {
                EnvironmentKeyValue keyValue;
                YAMLValue el = yamlSequenceItem.getValue();
                if (!(el instanceof YAMLScalar) || (keyValue = EnvironmentVariablesUtil.getKeyValueFromString(((YAMLScalar)el).getTextValue())).getKey().isBlank()) continue;
                this.collectedItems.add(new KeyValuePsiElement(keyValue.getKey(), keyValue.getValue(), (PsiElement)el));
            }
            for (YAMLKeyValue keyValue : this.getMappingItems(yamlKeyValue)) {
                this.collectedItems.add(new KeyValuePsiElement(keyValue.getKeyText(), keyValue.getValueText(), (PsiElement)keyValue));
            }
        }
    }

    @NotNull
    private Collection<YAMLSequenceItem> getSequenceItems(@NotNull YAMLKeyValue yamlKeyValue) {
        PsiElement yamlSequence;
        if (yamlKeyValue == null) {
            DockerComposeYamlPsiElementsVisitor.$$$reportNull$$$0(1);
        }
        if ((yamlSequence = yamlKeyValue.getLastChild()) instanceof YAMLSequence) {
            List list = ((YAMLSequence)yamlSequence).getItems();
            if (list == null) {
                DockerComposeYamlPsiElementsVisitor.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<YAMLSequenceItem> list = Collections.emptyList();
        if (list == null) {
            DockerComposeYamlPsiElementsVisitor.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private Collection<YAMLKeyValue> getMappingItems(@NotNull YAMLKeyValue yamlKeyValue) {
        PsiElement yamlMapping;
        if (yamlKeyValue == null) {
            DockerComposeYamlPsiElementsVisitor.$$$reportNull$$$0(4);
        }
        if ((yamlMapping = yamlKeyValue.getLastChild()) instanceof YAMLMapping) {
            Collection collection = ((YAMLMapping)yamlMapping).getKeyValues();
            if (collection == null) {
                DockerComposeYamlPsiElementsVisitor.$$$reportNull$$$0(5);
            }
            return collection;
        }
        List<YAMLKeyValue> list = Collections.emptyList();
        if (list == null) {
            DockerComposeYamlPsiElementsVisitor.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yamlKeyValue";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ru/adelf/idea/dotenv/docker/DockerComposeYamlPsiElementsVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ru/adelf/idea/dotenv/docker/DockerComposeYamlPsiElementsVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSequenceItems";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSequenceItems";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMappingItems";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

