/*
 * Decompiled with CFR 0.152.
 */
package ru.adelf.idea.dotenv.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.adelf.idea.dotenv.DotEnvBundle;
import ru.adelf.idea.dotenv.DotEnvFactory;
import ru.adelf.idea.dotenv.inspections.IncorrectDelimiterInspection;
import ru.adelf.idea.dotenv.psi.DotEnvFile;
import ru.adelf.idea.dotenv.psi.DotEnvTypes;
import ru.adelf.idea.dotenv.psi.DotEnvValue;
import ru.adelf.idea.dotenv.psi.impl.DotEnvValueImpl;

public class TrailingWhitespaceInspection
extends LocalInspectionTool {
    @NotNull
    public String getDisplayName() {
        String string = DotEnvBundle.message("inspection.name.value.has.trailing.whitespace", new Object[0]);
        if (string == null) {
            TrailingWhitespaceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            TrailingWhitespaceInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            TrailingWhitespaceInspection.$$$reportNull$$$0(2);
        }
        if (!(file instanceof DotEnvFile)) {
            return null;
        }
        return TrailingWhitespaceInspection.analyzeFile(file, manager, isOnTheFly).getResultsArray();
    }

    @NotNull
    private static ProblemsHolder analyzeFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            TrailingWhitespaceInspection.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            TrailingWhitespaceInspection.$$$reportNull$$$0(4);
        }
        ProblemsHolder problemsHolder = new ProblemsHolder(manager, file, isOnTheFly);
        PsiTreeUtil.findChildrenOfType((PsiElement)file, DotEnvValue.class).forEach(dotEnvValue -> {
            if (dotEnvValue.getText().matches(".*[ \\t]+")) {
                problemsHolder.registerProblem((PsiElement)dotEnvValue, new TextRange(dotEnvValue.getText().stripTrailing().length(), dotEnvValue.getText().length()), DotEnvBundle.message("inspection.message.line.has.trailing.whitespace", new Object[0]), new LocalQuickFix[]{new RemoveTrailingWhitespaceQuickFix()});
            }
        });
        PsiTreeUtil.findChildrenOfType((PsiElement)file, PsiWhiteSpaceImpl.class).forEach(whiteSpace -> {
            if (whiteSpace.getText().matches("\\s*[ \\t]\\n\\s*")) {
                problemsHolder.registerProblem((PsiElement)whiteSpace, DotEnvBundle.message("inspection.message.line.has.trailing.whitespace", new Object[0]), new LocalQuickFix[]{new RemoveTrailingWhitespaceQuickFix()});
            }
        });
        ProblemsHolder problemsHolder2 = problemsHolder;
        if (problemsHolder2 == null) {
            TrailingWhitespaceInspection.$$$reportNull$$$0(5);
        }
        return problemsHolder2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ru/adelf/idea/dotenv/inspections/TrailingWhitespaceInspection";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "ru/adelf/idea/dotenv/inspections/TrailingWhitespaceInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "analyzeFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "analyzeFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }

    private static class RemoveTrailingWhitespaceQuickFix
    implements LocalQuickFix {
        private RemoveTrailingWhitespaceQuickFix() {
        }

        @NotNull
        public String getName() {
            String string = DotEnvBundle.message("intention.name.remove.trailing.whitespace", new Object[0]);
            if (string == null) {
                RemoveTrailingWhitespaceQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                RemoveTrailingWhitespaceQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RemoveTrailingWhitespaceQuickFix.$$$reportNull$$$0(2);
            }
            try {
                PsiElement psiElement = descriptor.getPsiElement();
                if (psiElement instanceof DotEnvValueImpl) {
                    PsiElement newPsiElement = DotEnvFactory.createFromText(project, DotEnvTypes.VALUE, "DUMMY_KEY=" + psiElement.getText().stripTrailing());
                    psiElement.replace(newPsiElement);
                } else if (psiElement instanceof PsiWhiteSpaceImpl) {
                    PsiElement newPsiElement = DotEnvFactory.createFromText(project, TokenType.WHITE_SPACE, "DUMMY_KEY='VALUE'" + psiElement.getText().replaceAll("[ \\t]*\\n", "\n"));
                    psiElement.replace(newPsiElement);
                }
            }
            catch (IncorrectOperationException e) {
                Logger.getInstance(IncorrectDelimiterInspection.class).error((Throwable)e);
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                RemoveTrailingWhitespaceQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ru/adelf/idea/dotenv/inspections/TrailingWhitespaceInspection$RemoveTrailingWhitespaceQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ru/adelf/idea/dotenv/inspections/TrailingWhitespaceInspection$RemoveTrailingWhitespaceQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

