/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.lsp.core;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.jetbrains.python.externaltools.configuration.ExecutableDiscoveryMode;
import com.jetbrains.python.externaltools.configuration.PyLspToolConfiguration;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkExtensionsKt;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/python/lsp/core/PyLspToolUtil;", "", "<init>", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "findExecutable", "Ljava/nio/file/Path;", "config", "Lcom/jetbrains/python/externaltools/configuration/PyLspToolConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "executableNames", "", "", "intellij.python.lsp.core"})
@SourceDebugExtension(value={"SMAP\nPyLspToolSupportProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyLspToolSupportProvider.kt\ncom/intellij/python/lsp/core/PyLspToolUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,390:1\n1#2:391\n13#3:392\n*S KotlinDebug\n*F\n+ 1 PyLspToolSupportProvider.kt\ncom/intellij/python/lsp/core/PyLspToolUtil\n*L\n364#1:392\n*E\n"})
public final class PyLspToolUtil {
    @NotNull
    public static final PyLspToolUtil INSTANCE = new PyLspToolUtil();
    @NotNull
    private static final Logger LOGGER;

    private PyLspToolUtil() {
    }

    @Nullable
    public final Path findExecutable(@NotNull PyLspToolConfiguration<?> config, @NotNull Project project, @NotNull Iterable<String> executableNames) {
        Object object;
        block10: {
            Intrinsics.checkNotNullParameter(config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(executableNames, (String)"executableNames");
            if (config.getExecutableDiscoveryMode() == ExecutableDiscoveryMode.INTERPRETER) {
                Sdk sdk;
                Sdk sdk2 = sdk = Intrinsics.areEqual((Object)config.getSdkName(), (Object)"Project Default") ? PySdkExtKt.getPythonSdk((Project)project) : PythonSdkUtil.findSdkByKey((String)config.getSdkName());
                if (sdk != null) {
                    for (String string : executableNames) {
                        boolean bl = false;
                        Path path2 = PySdkExtensionsKt.getExecutablePath((Sdk)sdk, (String)string);
                        if (path2 == null) continue;
                        object = path2;
                        break block10;
                    }
                    object = null;
                } else {
                    object = null;
                }
            } else if (config.getExecutablePath() == null) {
                for (String string : executableNames) {
                    boolean bl = false;
                    File file = PathEnvironmentVariableUtil.findExecutableInPathOnAnyOS((String)string);
                    Path path3 = file != null ? file.toPath() : null;
                    if (path3 == null) continue;
                    object = path3;
                    break block10;
                }
                object = null;
            } else {
                Path path4 = config.getExecutablePath();
                if (path4 != null) {
                    Object object2;
                    Object object3 = object2 = path4;
                    boolean bl = false;
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    object = Files.exists((Path)object3, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? object2 : null;
                } else {
                    object = null;
                }
            }
        }
        Object result = object;
        LOGGER.info(result != null ? "Found path for " + CollectionsKt.first(executableNames) + " executable: " + result : "Path for " + CollectionsKt.first(executableNames) + " executable not found");
        return result;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PyLspToolUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOGGER = logger;
    }
}

