/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.statistics;

import com.intellij.database.run.ui.table.statisticsPanel.types.StatisticsDescriptionUnit;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\fJ\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/scientific/py/tables/statistics/PyStatisticsTableStatisticsDataParsingUtils;", "", "<init>", "()V", "formatDescriptionPair", "Lcom/intellij/database/run/ui/table/statisticsPanel/types/StatisticsDescriptionUnit;", "statisticsName", "", "rawValue", "integerStatistics", "", "statisticsNamesMap", "", "shortenTextWithEllipsis", "isEFormat", "", "number", "", "intellij.scientific.py.tables"})
@SourceDebugExtension(value={"SMAP\nPyStatisticsTableStatisticsDataParsingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyStatisticsTableStatisticsDataParsingUtils.kt\ncom/intellij/scientific/py/tables/statistics/PyStatisticsTableStatisticsDataParsingUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1#2:45\n*E\n"})
public final class PyStatisticsTableStatisticsDataParsingUtils {
    @NotNull
    public static final PyStatisticsTableStatisticsDataParsingUtils INSTANCE = new PyStatisticsTableStatisticsDataParsingUtils();

    private PyStatisticsTableStatisticsDataParsingUtils() {
    }

    @Nullable
    public final StatisticsDescriptionUnit formatDescriptionPair(@NotNull String statisticsName, @NotNull String rawValue, @NotNull Set<String> integerStatistics, @NotNull Map<String, String> statisticsNamesMap) {
        StatisticsDescriptionUnit statisticsDescriptionUnit;
        Object object;
        block11: {
            block10: {
                String string;
                Double parsedValue;
                String trimmedValue;
                int decimalNumber;
                Intrinsics.checkNotNullParameter((Object)statisticsName, (String)"statisticsName");
                Intrinsics.checkNotNullParameter((Object)rawValue, (String)"rawValue");
                Intrinsics.checkNotNullParameter(integerStatistics, (String)"integerStatistics");
                Intrinsics.checkNotNullParameter(statisticsNamesMap, (String)"statisticsNamesMap");
                if (Intrinsics.areEqual((Object)rawValue, (Object)"NaN") || Intrinsics.areEqual((Object)rawValue, (Object)"null")) {
                    return null;
                }
                int n = decimalNumber = integerStatistics.contains(statisticsName) ? 0 : 1;
                if (StringsKt.startsWith$default((String)rawValue, (String)"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)rawValue, (String)"\"", (boolean)false, (int)2, null)) {
                    String string2 = rawValue.substring(1, rawValue.length() - 1);
                    v2 = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                } else {
                    v2 = trimmedValue = rawValue;
                }
                if ((object = (parsedValue = StringsKt.toDoubleOrNull((String)trimmedValue))) == null) break block10;
                double it = ((Number)object).doubleValue();
                boolean bl = false;
                if (INSTANCE.isEFormat(it)) {
                    string = trimmedValue;
                } else {
                    Locale locale = Locale.US;
                    String string3 = "%." + decimalNumber + "f";
                    Object[] objectArray = new Object[]{it};
                    String string4 = String.format(locale, string3, Arrays.copyOf(objectArray, objectArray.length));
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
                }
                object = string;
                if (string != null) break block11;
            }
            object = this.shortenTextWithEllipsis(rawValue);
        }
        Object formattedValue = object;
        String string = statisticsNamesMap.get(statisticsName);
        if (string != null) {
            String displayName = string;
            boolean bl = false;
            statisticsDescriptionUnit = new StatisticsDescriptionUnit(displayName, (String)formattedValue);
        } else {
            statisticsDescriptionUnit = null;
        }
        return statisticsDescriptionUnit;
    }

    private final String shortenTextWithEllipsis(String rawValue) {
        if (rawValue.length() <= 50) {
            return rawValue;
        }
        String string = StringUtil.firstLast((String)rawValue, (int)48);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"firstLast(...)");
        return string;
    }

    private final boolean isEFormat(double number) {
        String string = String.valueOf(number).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return StringsKt.contains$default((CharSequence)string, (char)'e', (boolean)false, (int)2, null);
    }
}

