/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.rider.cpp;

import com.intellij.ml.inline.completion.features.correctness.CorrectnessError;
import com.intellij.ml.inline.completion.features.correctness.EnrichmentTool;
import com.intellij.ml.inline.completion.features.correctness.Severity;
import com.intellij.ml.inline.completion.features.correctness.SuggestionEnricher;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionSessionEventsReporter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.ide.model.AbstractFullLineContext;
import com.jetbrains.rd.ide.model.CheckSemanticArgs;
import com.jetbrains.rd.ide.model.CheckSemanticResult;
import com.jetbrains.rd.ide.model.CorrectnessErrorModel;
import com.jetbrains.rd.ide.model.CppContext;
import com.jetbrains.rd.ide.model.CppFullLineModel;
import com.jetbrains.rd.ide.model.CppFullLineModel_PregeneratedKt;
import com.jetbrains.rd.ide.model.IntRangeModel;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.SemanticErrorSeverity;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.ide.model.SpecialRangeModel;
import com.jetbrains.rd.platform.util.RdTaskUtilKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rider.model.RdFrontendDocumentId;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JX\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0010H\u0016J(\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u000bH\u0002JP\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\tH\u0002J@\u0010$\u001a\u00020\t2\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00102\u0006\u0010%\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\f\u0010&\u001a\u00020'*\u00020(H\u0002\u00a8\u0006)"}, d2={"Lcom/intellij/ml/inline/completion/rider/cpp/CppSuggestionEnricher;", "Lcom/intellij/ml/inline/completion/features/correctness/SuggestionEnricher;", "<init>", "()V", "enrich", "Lcom/intellij/ml/inline/completion/features/correctness/SuggestionEnricher$Enrichment;", "editor", "Lcom/intellij/openapi/editor/Editor;", "originalFile", "Lcom/intellij/psi/PsiFile;", "suggestionOffset", "", "suggestion", "", "suffix", "aspectsToEnrich", "", "Lcom/intellij/ml/inline/completion/features/correctness/EnrichmentTool$Aspect;", "sessionLogger", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionSessionEventsReporter;", "matchedEnclosuresIndices", "createCheckResult", "result", "Lcom/jetbrains/rd/ide/model/CheckSemanticResult;", "fileWithSuggestion", "suggestionRange", "Lcom/jetbrains/rd/ide/model/IntRangeModel;", "extraPrefixLen", "createContext", "Lcom/jetbrains/rd/ide/model/CppContext;", "file", "offset", "doSemaCheck", "documentId", "Lcom/jetbrains/rider/model/RdFrontendDocumentId;", "extraPrefix", "createFileWithSuggestionApplied", "originalText", "toIdea", "Lcom/intellij/ml/inline/completion/features/correctness/Severity;", "Lcom/jetbrains/rd/ide/model/SemanticErrorSeverity;", "intellij.fullLine.rider.cpp"})
@SourceDebugExtension(value={"SMAP\nCppSuggestionEnricher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CppSuggestionEnricher.kt\ncom/intellij/ml/inline/completion/rider/cpp/CppSuggestionEnricher\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n11879#2,9:153\n13805#2:162\n13806#2:164\n11888#2:165\n1#3:163\n1563#4:166\n1634#4,3:167\n*S KotlinDebug\n*F\n+ 1 CppSuggestionEnricher.kt\ncom/intellij/ml/inline/completion/rider/cpp/CppSuggestionEnricher\n*L\n71#1:153,9\n71#1:162\n71#1:164\n71#1:165\n71#1:163\n71#1:166\n71#1:167,3\n*E\n"})
public final class CppSuggestionEnricher
implements SuggestionEnricher {
    @Override
    @NotNull
    public SuggestionEnricher.Enrichment enrich(@NotNull Editor editor2, @NotNull PsiFile originalFile, int suggestionOffset, @NotNull String suggestion2, @NotNull String suffix, @NotNull Set<? extends EnrichmentTool.Aspect> aspectsToEnrich, @Nullable MLCompletionSessionEventsReporter sessionLogger, @Nullable Set<Integer> matchedEnclosuresIndices) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)suggestion2, (String)"suggestion");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter(aspectsToEnrich, (String)"aspectsToEnrich");
        List errors = new ArrayList();
        TextRange errorRange = new TextRange(suggestionOffset, suggestionOffset);
        Document document = FileDocumentManager.getInstance().getDocument(originalFile.getVirtualFile());
        if (document == null) {
            return new SuggestionEnricher.Enrichment(errors, originalFile, errorRange);
        }
        Document document2 = document;
        Project project2 = originalFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        RdDocumentId rdDocumentId = DocumentExKt.getDocumentId((Document)document2, (Project)project2);
        RdFrontendDocumentId rdFrontendDocumentId = rdDocumentId instanceof RdFrontendDocumentId ? (RdFrontendDocumentId)rdDocumentId : null;
        if (rdFrontendDocumentId == null) {
            return new SuggestionEnricher.Enrichment(errors, originalFile, errorRange);
        }
        RdFrontendDocumentId documentId = rdFrontendDocumentId;
        String extraPrefix = "";
        int lineIndex = document2.getLineNumber(suggestionOffset);
        String text2 = originalFile.getText();
        Intrinsics.checkNotNull((Object)text2);
        String string = text2.substring(document2.getLineStartOffset(lineIndex), document2.getLineEndOffset(lineIndex));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        if (StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)string)).toString(), (String)"#", (boolean)false, (int)2, null)) {
            int ppDirectiveIndex = StringsKt.indexOf$default((CharSequence)text2, (String)"#", (int)document2.getLineStartOffset(lineIndex), (boolean)false, (int)4, null);
            if (ppDirectiveIndex < suggestionOffset) {
                String string2 = text2.substring(ppDirectiveIndex, suggestionOffset);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                extraPrefix = string2;
            }
        } else if (!CharsKt.isWhitespace((char)text2.charAt(suggestionOffset - 1))) {
            int extraPrefixOffset;
            for (extraPrefixOffset = suggestionOffset - 1; extraPrefixOffset > 0 && !CharsKt.isWhitespace((char)text2.charAt(extraPrefixOffset - 1)); --extraPrefixOffset) {
            }
            String string3 = text2.substring(extraPrefixOffset, suggestionOffset);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            extraPrefix = string3;
        }
        IntRangeModel suggestionRange = new IntRangeModel(suggestionOffset, suggestionOffset + suggestion2.length());
        CheckSemanticResult semanticCheck = this.doSemaCheck(documentId, extraPrefix, suggestion2, suffix, suggestionOffset, suggestionRange, matchedEnclosuresIndices, originalFile);
        String string4 = originalFile.getFileDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
        String originalText = string4;
        PsiFile fileWithSuggestion = this.createFileWithSuggestionApplied(matchedEnclosuresIndices, originalText, suggestionOffset, suggestion2, suffix, originalFile);
        return this.createCheckResult(semanticCheck, fileWithSuggestion, suggestionRange, extraPrefix.length());
    }

    /*
     * WARNING - void declaration
     */
    private final SuggestionEnricher.Enrichment createCheckResult(CheckSemanticResult result2, PsiFile fileWithSuggestion, IntRangeModel suggestionRange, int extraPrefixLen) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Object $this$mapNotNull$iv = result2.getSpecialRanges();
        boolean $i$f$mapNotNull = false;
        SpecialRangeModel[] specialRangeModelArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            CorrectnessErrorModel it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if ((it instanceof CorrectnessErrorModel ? (CorrectnessErrorModel)it : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CorrectnessErrorModel correctnessErrorModel = (CorrectnessErrorModel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TextRange errorRange = new TextRange(RangesKt.coerceAtLeast((int)(it.getRange().getStartRange() - extraPrefixLen), (int)0), RangesKt.coerceAtLeast((int)(it.getRange().getEndRange() - extraPrefixLen), (int)0));
            collection.add(new CorrectnessError(errorRange, this.toIdea(it.getSeverity()), it.getDebugName()));
        }
        List errors = (List)destination$iv$iv;
        return new SuggestionEnricher.Enrichment(errors, fileWithSuggestion, new TextRange(suggestionRange.getStartRange(), suggestionRange.getEndRange()));
    }

    private final CppContext createContext(PsiFile file, int offset) {
        int lineNumber2 = file.getFileDocument().getLineNumber(offset);
        TextRange lineRange = new TextRange(file.getFileDocument().getLineStartOffset(lineNumber2), file.getFileDocument().getLineEndOffset(lineNumber2));
        String string = file.getFileDocument().getText(lineRange);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String lineText = string;
        CppContext context2 = new CppContext(lineNumber2, lineText);
        return context2;
    }

    private final CheckSemanticResult doSemaCheck(RdFrontendDocumentId documentId, String extraPrefix, String suggestion2, String suffix, int suggestionOffset, IntRangeModel suggestionRange, Set<Integer> matchedEnclosuresIndices, PsiFile originalFile) {
        Set<Integer> set = matchedEnclosuresIndices;
        CheckSemanticArgs cppFullLineContext = new CheckSemanticArgs(documentId, extraPrefix + suggestion2, suffix, suggestionOffset - extraPrefix.length(), suggestionRange, set != null ? CollectionsKt.toList((Iterable)set) : null, (AbstractFullLineContext)this.createContext(originalFile, suggestionOffset), null);
        Project project2 = originalFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        CppFullLineModel fullLineModel = CppFullLineModel_PregeneratedKt.getCppFullLineModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project2));
        return (CheckSemanticResult)RdTaskUtilKt.callWithCancellation$default((IRdCall)((IRdCall)fullLineModel.getCheckSemantic()), (Object)cppFullLineContext, (long)0L, (int)2, null);
    }

    private final PsiFile createFileWithSuggestionApplied(Set<Integer> matchedEnclosuresIndices, String originalText, int suggestionOffset, String suggestion2, String suffix, PsiFile originalFile) {
        PsiFile psiFile2;
        StringBuilder stringBuilder;
        StringBuilder $this$createFileWithSuggestionApplied_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Set<Integer> set = matchedEnclosuresIndices;
        int matchedSize = set != null ? set.size() : 0;
        $this$createFileWithSuggestionApplied_u24lambda_u240.append(originalText, 0, suggestionOffset);
        $this$createFileWithSuggestionApplied_u24lambda_u240.append(suggestion2);
        $this$createFileWithSuggestionApplied_u24lambda_u240.append(' ');
        $this$createFileWithSuggestionApplied_u24lambda_u240.append(suffix);
        $this$createFileWithSuggestionApplied_u24lambda_u240.append(originalText, suggestionOffset + matchedSize, originalText.length());
        String textWithSuggestion = stringBuilder.toString();
        PsiFile $this$createFileWithSuggestionApplied_u24lambda_u241 = psiFile2 = PsiFileFactory.getInstance((Project)originalFile.getProject()).createFileFromText(originalFile.getName(), originalFile.getLanguage(), (CharSequence)textWithSuggestion, true, true, false, originalFile.getVirtualFile());
        boolean bl2 = false;
        $this$createFileWithSuggestionApplied_u24lambda_u241.putUserData(PsiFileFactory.ORIGINAL_FILE, (Object)originalFile);
        PsiFile fileWithSuggestion = psiFile2;
        Intrinsics.checkNotNull((Object)fileWithSuggestion);
        return fileWithSuggestion;
    }

    private final Severity toIdea(SemanticErrorSeverity $this$toIdea) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toIdea.ordinal()]) {
            case 1 -> Severity.CRITICAL;
            case 2 -> Severity.ACCEPTABLE;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SemanticErrorSeverity.values().length];
            try {
                nArray[SemanticErrorSeverity.CRITICAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SemanticErrorSeverity.ACCEPTABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

