/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hierarchy.method;

import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.lang.javascript.hierarchy.method.JSMethodHierarchyNodeDescriptor;
import com.intellij.lang.javascript.hierarchy.method.JSMethodHierarchyUtil;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSMethodHierarchyTreeStructure
extends HierarchyTreeStructure {
    private final SmartPsiElementPointer<JSFunctionItem> myMethod;

    public JSMethodHierarchyTreeStructure(Project project, JSFunctionItem method) {
        super(project, null);
        this.myBaseDescriptor = this.buildHierarchyElement(project, method);
        ((JSMethodHierarchyNodeDescriptor)this.myBaseDescriptor).setTreeStructure(this);
        this.myMethod = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)method);
        this.setBaseElement(this.myBaseDescriptor);
    }

    private HierarchyNodeDescriptor buildHierarchyElement(Project project, JSFunctionItem method) {
        List<JSPsiElementBase> classesToShow = JSMethodHierarchyTreeStructure.getSuperClassesToShow(method);
        JSMethodHierarchyNodeDescriptor descriptor = null;
        for (int i = classesToShow.size() - 1; i >= 0; --i) {
            JSPsiElementBase jsClass = classesToShow.get(i);
            JSMethodHierarchyNodeDescriptor newDescriptor = new JSMethodHierarchyNodeDescriptor(project, descriptor, jsClass, false, this);
            if (descriptor != null) {
                descriptor.setCachedChildren(new HierarchyNodeDescriptor[]{newDescriptor});
            }
            descriptor = newDescriptor;
        }
        JSPsiElementBase aClass = JSInheritanceUtil.getContainingClass((JSPsiElementBase)method);
        if (aClass == null) {
            throw new IllegalArgumentException("Class for " + String.valueOf(method.getClass()) + " is null.");
        }
        JSMethodHierarchyNodeDescriptor newDescriptor = new JSMethodHierarchyNodeDescriptor(project, descriptor, aClass, true, this);
        if (descriptor != null) {
            descriptor.setCachedChildren(new HierarchyNodeDescriptor[]{newDescriptor});
        }
        return newDescriptor;
    }

    private static List<JSPsiElementBase> getSuperClassesToShow(@NotNull JSFunctionItem method) {
        Collection interfaceMethods;
        JSPsiElementBase upperNonInterfaceClass;
        JSFunctionItem jsFunction;
        JSPsiElementBase[] superClasses;
        JSPsiElementBase jsClass;
        if (method == null) {
            JSMethodHierarchyTreeStructure.$$$reportNull$$$0(0);
        }
        if ((jsClass = JSInheritanceUtil.getContainingClass((JSPsiElementBase)method)) == null) {
            throw new IllegalArgumentException("Class for " + String.valueOf(method.getClass()) + " is null.");
        }
        ArrayList<JSPsiElementBase> superClassesToShow = new ArrayList<JSPsiElementBase>();
        JSPsiElementBase superClass = jsClass;
        while ((superClasses = JSMethodHierarchyUtil.getSuperClasses(superClass)).length > 0 && !superClassesToShow.contains(superClass = superClasses[0])) {
            superClassesToShow.add(superClass);
            if (!JSResolveUtil.isObjectClass((JSPsiElementBase)superClass)) continue;
        }
        for (int i = superClassesToShow.size() - 1; i >= 0 && JSMethodHierarchyUtil.findMethodInClass(method, (JSPsiElementBase)superClassesToShow.get(i), false) == null; --i) {
            superClassesToShow.remove(i);
        }
        if (jsClass.isClassOrInterface() == JSElementBase.ClassOrInterface.CLASS && (jsFunction = JSMethodHierarchyUtil.findMethodInClass(method, upperNonInterfaceClass = superClassesToShow.isEmpty() ? jsClass : (JSPsiElementBase)superClassesToShow.get(superClassesToShow.size() - 1), false)) instanceof JSQualifiedNamedElement && !(interfaceMethods = JSInheritanceUtil.findImplementedMembers((JSQualifiedNamedElement)((JSQualifiedNamedElement)jsFunction))).isEmpty()) {
            superClassesToShow.add(JSInheritanceUtil.getContainingClass((JSPsiElementBase)((JSPsiElementBase)interfaceMethods.iterator().next())));
        }
        return superClassesToShow;
    }

    @Nullable
    public JSFunction getBaseMethod() {
        PsiElement element2 = this.myMethod.getElement();
        return element2 instanceof JSFunction ? (JSFunction)element2 : null;
    }

    protected Object @NotNull [] buildChildren(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            JSMethodHierarchyTreeStructure.$$$reportNull$$$0(1);
        }
        JSPsiElementBase jsClass = ((JSMethodHierarchyNodeDescriptor)descriptor).getJSClass();
        Collection subclasses = JSInheritanceUtil.findDirectSubClasses((JSPsiElementBase)jsClass);
        ArrayList<JSMethodHierarchyNodeDescriptor> descriptors = new ArrayList<JSMethodHierarchyNodeDescriptor>(subclasses.size());
        for (JSPsiElementBase aClass : subclasses) {
            if (HierarchyBrowserManager.getInstance((Project)this.myProject).getState().HIDE_CLASSES_WHERE_METHOD_NOT_IMPLEMENTED && this.shouldHideClass(aClass)) continue;
            JSMethodHierarchyNodeDescriptor d = new JSMethodHierarchyNodeDescriptor(this.myProject, descriptor, aClass, false, this);
            descriptors.add(d);
        }
        Object[] objectArray = descriptors.toArray(HierarchyNodeDescriptor.EMPTY_ARRAY);
        if (objectArray == null) {
            JSMethodHierarchyTreeStructure.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    private boolean shouldHideClass(JSPsiElementBase jsClass) {
        if (JSMethodHierarchyUtil.findMethodInClass((JSFunctionItem)this.getBaseMethod(), jsClass, false) != null) {
            return false;
        }
        if (this.hasBaseClassMethod(jsClass)) {
            for (JSPsiElementBase subclass : JSInheritanceUtil.findDirectSubClasses((JSPsiElementBase)jsClass)) {
                if (this.shouldHideClass(subclass)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean hasBaseClassMethod(JSPsiElementBase jsClass) {
        JSFunctionItem baseClassMethod = JSMethodHierarchyUtil.findMethodInClass((JSFunctionItem)this.getBaseMethod(), jsClass, true);
        return baseClassMethod != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/hierarchy/method/JSMethodHierarchyTreeStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/hierarchy/method/JSMethodHierarchyTreeStructure";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassesToShow";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildChildren";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

